/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityFactor;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseHostileActivityFactor
extends BaseEventFactor
implements HostileActivityFactor {
    protected HostileActivityEventIntel intel;
    protected List<HostileActivityCause2> causes = new ArrayList<HostileActivityCause2>();
    protected long seed;

    public BaseHostileActivityFactor(HostileActivityEventIntel intel) {
        this.intel = intel;
    }

    @Override
    public int getProgress(BaseEventIntel intel) {
        int total = 0;
        for (HostileActivityCause2 cause : this.getCauses()) {
            total += cause.getProgress();
        }
        return total;
    }

    @Override
    public void addExtraRows(TooltipMakerAPI info, BaseEventIntel intel) {
        for (HostileActivityCause2 cause : this.getCauses()) {
            if (!cause.shouldShow()) continue;
            String desc = cause.getDesc();
            if (desc != null) {
                info.addRowWithGlow(new Object[]{Alignment.LMID, cause.getDescColor(intel), "    " + desc, Alignment.RMID, cause.getProgressColor(intel), cause.getProgressStr()});
                TooltipMakerAPI.TooltipCreator t = cause.getTooltip();
                if (t != null) {
                    info.addTooltipToAddedRow(t, TooltipMakerAPI.TooltipLocation.RIGHT, false);
                }
            }
            cause.addExtraRows(info, intel);
        }
    }

    @Override
    public String getId() {
        return this.getClass().getSimpleName();
    }

    @Override
    public float getSpawnFrequency(StarSystemAPI system) {
        return this.getEffectMagnitude(system);
    }

    @Override
    public float getSpawnInHyperProbability(StarSystemAPI system) {
        return 0.25f;
    }

    @Override
    public float getStayInHyperProbability(StarSystemAPI system) {
        return 0.25f;
    }

    @Override
    public int getMaxNumFleets(StarSystemAPI system) {
        return 1000;
    }

    @Override
    public float getEffectMagnitude(StarSystemAPI system) {
        float mag = 0.0f;
        for (HostileActivityCause2 cause : this.causes) {
            mag += cause.getMagnitudeContribution(system);
        }
        return mag;
    }

    public void addCause(HostileActivityCause2 cause) {
        this.causes.add(cause);
    }

    public List<HostileActivityCause2> getCauses() {
        return this.causes;
    }

    public void removeCauseOfClass(Class c) {
        Iterator<HostileActivityCause2> iter = this.causes.iterator();
        while (iter.hasNext()) {
            HostileActivityCause2 curr = iter.next();
            if (curr.getClass() != c) continue;
            iter.remove();
        }
    }

    public HostileActivityCause2 getCauseOfClass(Class c) {
        for (HostileActivityCause2 curr : this.causes) {
            if (curr.getClass() != c) continue;
            return curr;
        }
        return null;
    }

    @Override
    public CampaignFleetAPI createFleet(StarSystemAPI system, Random random) {
        return null;
    }

    @Override
    public String getNameForThreatList(boolean first) {
        return this.getDesc(this.intel);
    }

    @Override
    public Color getNameColorForThreatList() {
        return this.getDescColor(this.intel);
    }

    @Override
    public float getEventFrequency(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        return 0.0f;
    }

    @Override
    public void rollEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
    }

    @Override
    public void addBulletPointForEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
    }

    @Override
    public void addStageDescriptionForEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info) {
    }

    @Override
    public String getEventStageIcon(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        return null;
    }

    @Override
    public TooltipMakerAPI.TooltipCreator getStageTooltipImpl(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        return null;
    }

    public TooltipMakerAPI.TooltipCreator getDefaultEventTooltip(final String title, HostileActivityEventIntel intel, final BaseEventIntel.EventStageData stage) {
        return new BaseFactorTooltip(){

            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                tooltip.addTitle(title);
                stage.endResetReqList(tooltip, true, "crisis", HostileActivityEventIntel.RESET_MIN, HostileActivityEventIntel.RESET_MAX);
            }
        };
    }

    @Override
    public void resetEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        HostileActivityEventIntel.HAERandomEventData data = (HostileActivityEventIntel.HAERandomEventData)stage.rollData;
        intel.sendUpdateIfPlayerHasIntel((Object)data, false);
        stage.rollData = null;
    }

    @Override
    public void addBulletPointForEventReset(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
    }

    @Override
    public boolean fireEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        return false;
    }

    @Override
    public void setRandomizedStageSeed(long seed) {
        this.seed = seed;
    }

    public long getRandomizedStageSeed() {
        return this.seed;
    }

    public Random getRandomizedStageRandom(int level) {
        return Misc.getRandom(this.seed, level);
    }

    public Random getRandomizedStageRandom() {
        return new Random(this.seed);
    }

    @Override
    public String getEventStageSound(HostileActivityEventIntel.HAERandomEventData data) {
        return "colony_threat";
    }

    public static boolean checkFactionExists(String factionId, boolean requireMilitary) {
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (!market.getFactionId().equals(factionId)) continue;
            Industry b = market.getIndustry("militarybase");
            if (b == null) {
                b = market.getIndustry("highcommand");
            }
            if (b == null && requireMilitary) continue;
            return true;
        }
        return false;
    }
}

