/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.intel.SystemBountyIntel;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;

public class CommerceBountyManager
implements EveryFrameScript {
    protected IntervalUtil tracker = new IntervalUtil(0.5f, 1.5f);

    public boolean isDone() {
        return false;
    }

    public boolean runWhilePaused() {
        return false;
    }

    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        this.tracker.advance(days);
        if (this.tracker.intervalElapsed()) {
            boolean haLevelSufficient = true;
            for (StarSystemAPI system : Misc.getPlayerSystems(false)) {
                SystemBountyIntel bounty = CommerceBountyManager.getCommerceBounty(system);
                if (bounty != null && bounty.isEnding()) continue;
                boolean hasFunctionalCommerce = CommerceBountyManager.doesStarSystemHavePlayerCommerceIndustry(system, true);
                boolean hasCommerce = CommerceBountyManager.doesStarSystemHavePlayerCommerceIndustry(system, false);
                if (!(bounty == null || hasCommerce && haLevelSufficient)) {
                    bounty.endAfterDelay();
                    continue;
                }
                MarketAPI market = CommerceBountyManager.getPlayerCommerceMarket(system);
                if (market == null || bounty != null || !hasFunctionalCommerce || !haLevelSufficient) continue;
                float reward = Global.getSettings().getFloat("baseCommerceSystemBounty");
                new SystemBountyIntel(market, (int)reward, true);
            }
        }
    }

    public static SystemBountyIntel getCommerceBounty(StarSystemAPI system) {
        for (IntelInfoPlugin curr : Global.getSector().getIntelManager().getIntel(SystemBountyIntel.class)) {
            SystemBountyIntel intel = (SystemBountyIntel)curr;
            if (intel.getLocation() != system || !intel.isCommerceMode()) continue;
            return intel;
        }
        return null;
    }

    public static boolean doesStarSystemHavePlayerCommerceIndustry(StarSystemAPI system, boolean requireFunctional) {
        for (MarketAPI market : Misc.getMarketsInLocation(system, "player")) {
            if (requireFunctional && market.hasFunctionalIndustry("commerce")) {
                return true;
            }
            if (requireFunctional || !market.hasIndustry("commerce")) continue;
            return true;
        }
        return false;
    }

    public static MarketAPI getPlayerCommerceMarket(StarSystemAPI system) {
        MarketAPI best = null;
        for (MarketAPI market : Misc.getMarketsInLocation(system, "player")) {
            if (!market.hasIndustry("commerce") || best != null && best.getSize() >= market.getSize()) continue;
            best = market;
        }
        return best;
    }
}

