/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;

public class HAColonyDefensesFactor
extends BaseEventFactor {
    public static float PATROL_HQ_MULT = 0.9f;
    public static float MILITARY_BASE_MULT = 0.7f;
    public static float HIGH_COMMAND_MULT = 0.5f;

    public TooltipMakerAPI.TooltipCreator getMainRowTooltip(BaseEventIntel intel) {
        return new BaseFactorTooltip(){

            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                Color h = Misc.getHighlightColor();
                float opad = 10.0f;
                tooltip.addPara("\u519b\u4e8b\u8bbe\u65bd\u7684\u5b58\u5728\u5c06\u51cf\u7f13\u4e8b\u4ef6\u7684\u8fdb\u5c55\uff0c\u4f46\u65e0\u6cd5\u5f7b\u5e95\u963b\u6b62\u6216\u4f7f\u8fdb\u5c55\u6d88\u9000\u3002\u4f60\u7684\u6240\u6709\u6b96\u6c11\u5730\u4e4b\u4e2d\u7684\u6700\u9ad8\u7ea7\u519b\u4e8b\u8bbe\u65bd\u51b3\u5b9a\u4e86\u5177\u4f53\u7684\u51cf\u7f13\u7cfb\u6570\u3002", 0.0f);
                HAColonyDefenseData data = HAColonyDefensesFactor.this.getDefenseData(null);
                tooltip.beginTable(Misc.getBasePlayerColor(), Misc.getDarkPlayerColor(), Misc.getBrightPlayerColor(), 20.0f, "\u8bbe\u65bd", Float.valueOf(200.0f), "\u7cfb\u6570", Float.valueOf(100.0f));
                Color c = Misc.getGrayColor();
                Color c2 = Misc.getGrayColor();
                if (data.industry != null && data.industry.getId().equals("patrolhq")) {
                    c = Misc.getHighlightColor();
                    c2 = Misc.getPositiveHighlightColor();
                }
                tooltip.addRow(c, "\u5de1\u903b\u961f\u603b\u90e8", c2, "\u00d7" + Misc.getRoundedValueMaxOneAfterDecimal(PATROL_HQ_MULT));
                c = Misc.getGrayColor();
                c2 = Misc.getGrayColor();
                if (data.industry != null && data.industry.getId().equals("militarybase")) {
                    c = Misc.getHighlightColor();
                    c2 = Misc.getPositiveHighlightColor();
                }
                tooltip.addRow(c, "\u519b\u4e8b\u57fa\u5730", c2, "\u00d7" + Misc.getRoundedValueMaxOneAfterDecimal(MILITARY_BASE_MULT));
                c = Misc.getGrayColor();
                c2 = Misc.getGrayColor();
                if (data.industry != null && data.industry.getId().equals("highcommand")) {
                    c = Misc.getHighlightColor();
                    c2 = Misc.getPositiveHighlightColor();
                }
                tooltip.addRow(c, "\u6700\u9ad8\u6307\u6325\u90e8", c2, "\u00d7" + Misc.getRoundedValueMaxOneAfterDecimal(HIGH_COMMAND_MULT));
                tooltip.addTable("\u65e0", 0, opad);
                tooltip.addSpacer(5.0f);
                if (data.industry != null && data.market != null) {
                    tooltip.addPara("\u4f60\u6709 %s \u4f4d\u4e8e %s}\u3002", opad, h, data.industry.getCurrentName(), data.market.getName());
                }
            }
        };
    }

    public boolean shouldShow(BaseEventIntel intel) {
        return true;
    }

    public float getAllProgressMult(BaseEventIntel intel) {
        HAColonyDefenseData data = this.getDefenseData(intel);
        return data.mult;
    }

    public Color getProgressColor(BaseEventIntel intel) {
        HAColonyDefenseData data = this.getDefenseData(intel);
        if (data.mult < 1.0f) {
            return Misc.getPositiveHighlightColor();
        }
        if (data.mult > 1.0f) {
            return Misc.getNegativeHighlightColor();
        }
        return Misc.getHighlightColor();
    }

    public String getProgressStr(BaseEventIntel intel) {
        HAColonyDefenseData data = this.getDefenseData(intel);
        if (data.mult != 1.0f) {
            return "\u00d7" + Misc.getRoundedValueMaxOneAfterDecimal(data.mult);
        }
        return "";
    }

    public String getDesc(BaseEventIntel intel) {
        HAColonyDefenseData data = this.getDefenseData(intel);
        if (data.industry == null) {
            return "\u519b\u4e8b\u8bbe\u65bd";
        }
        return data.industry.getCurrentName();
    }

    public Color getDescColor(BaseEventIntel intel) {
        if (this.getDefenseData((BaseEventIntel)intel).market == null) {
            return Misc.getGrayColor();
        }
        return super.getDescColor(intel);
    }

    public HAColonyDefenseData getDefenseData(BaseEventIntel intel) {
        HAColonyDefenseData best = new HAColonyDefenseData();
        List<MarketAPI> markets = Misc.getPlayerMarkets(false);
        for (MarketAPI market : markets) {
            float mult = 1.0f;
            Industry industry = null;
            if (market.hasFunctionalIndustry("patrolhq")) {
                mult = PATROL_HQ_MULT;
                industry = market.getIndustry("patrolhq");
            }
            if (Misc.isMilitary(market)) {
                if (market.hasFunctionalIndustry("highcommand")) {
                    mult = HIGH_COMMAND_MULT;
                    industry = market.getIndustry("highcommand");
                } else {
                    mult = MILITARY_BASE_MULT;
                    industry = market.getIndustry("militarybase");
                }
            }
            if (industry == null || !(mult < best.mult)) continue;
            best.market = market;
            best.industry = industry;
            best.mult = mult;
        }
        return best;
    }

    public static class HAColonyDefenseData {
        public MarketAPI market;
        public Industry industry;
        public float mult = 1.0f;
    }
}

