/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.intel.PerseanLeagueMembership;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseHostileActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.events.HegemonyHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;

public class HegemonyAICoresActivityCause
extends BaseHostileActivityCause2 {
    public static int IGNORE_COLONY_THRESHOLD = 3;

    public HegemonyAICoresActivityCause(HostileActivityEventIntel intel) {
        super(intel);
    }

    public TooltipMakerAPI.TooltipCreator getTooltip() {
        return new BaseFactorTooltip(){

            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                float opad = 10.0f;
                tooltip.addPara("\u9738\u4e3b\u8ba4\u4e3a\u4f7f\u7528 %s \u662f\u975e\u6cd5\u7684\uff0c\u4e0d\u8fc7\u5b83\u4e0d\u592a\u53ef\u80fd\u53bb\u6ce8\u610f %s \u6216\u66f4\u5c0f\u89c4\u6a21\u7684\u6b96\u6c11\u5730\u7684\u60c5\u51b5\u3002", 0.0f, Misc.getHighlightColor(), "AI \u6838\u5fc3", "" + IGNORE_COLONY_THRESHOLD);
                if (HegemonyAICoresActivityCause.this.isNegatedByPLMembership()) {
                    Color c = Global.getSector().getFaction("persean").getBaseUIColor();
                    LabelAPI label = tooltip.addPara("\u7136\u800c\uff0c\u4f60\u7684 \u82f1\u4ed9\u5ea7\u8054\u76df \u6210\u5458\u8eab\u4efd\u4f7f\u9738\u4e3b\u96be\u4ee5 \u653f\u6cbb\u5408\u7406\u5730 \u8fdb\u4e00\u6b65\u8ffd\u67e5\u3002", opad);
                    label.setHighlight("\u82f1\u4ed9\u5ea7\u8054\u76df", "\u653f\u6cbb\u5408\u7406\u5730");
                    label.setHighlightColors(c, Misc.getPositiveHighlightColor());
                }
            }
        };
    }

    public boolean isNegatedByPLMembership() {
        return PerseanLeagueMembership.isLeagueMember() && this.getProgress(false) > 0;
    }

    public String getProgressStr() {
        if (this.isNegatedByPLMembership()) {
            return "---";
        }
        return super.getProgressStr();
    }

    public Color getProgressColor(BaseEventIntel intel) {
        if (this.isNegatedByPLMembership()) {
            return Misc.getPositiveHighlightColor();
        }
        return super.getProgressColor(intel);
    }

    public boolean shouldShow() {
        return this.getProgress() != 0 || this.isNegatedByPLMembership();
    }

    public int getProgress() {
        return this.getProgress(true);
    }

    public int getProgress(boolean checkNegated) {
        if (HegemonyHostileActivityFactor.isPlayerDefeatedHegemony()) {
            return 0;
        }
        if (checkNegated && this.isNegatedByPLMembership()) {
            return 0;
        }
        int progress = Math.round(this.getTotalAICorePoints());
        float unit = Global.getSettings().getFloat("hegemonyProgressUnit");
        float mult = Global.getSettings().getFloat("hegemonyProgressMult");
        int rem = progress;
        float adjusted = 0.0f;
        while ((float)rem > unit) {
            adjusted += unit;
            rem = (int)((float)rem - unit);
            rem = (int)((float)rem * mult);
        }
        int reduced = Math.round(adjusted += (float)rem);
        if (progress > 0 && reduced < 1) {
            reduced = 1;
        }
        progress = reduced;
        return progress;
    }

    public String getDesc() {
        return "\u4f7f\u7528 AI \u6838\u5fc3";
    }

    public float getTotalAICorePoints() {
        float total = 0.0f;
        for (StarSystemAPI system : Misc.getPlayerSystems(false)) {
            total += HegemonyAICoresActivityCause.getAICorePoints(system);
        }
        return total;
    }

    public static float getAICorePoints(StarSystemAPI system) {
        float total = 0.0f;
        List<MarketAPI> markets = Misc.getMarketsInLocation(system, "player");
        for (MarketAPI market : markets) {
            if (market.getSize() <= IGNORE_COLONY_THRESHOLD) continue;
            float interest = HegemonyAICoresActivityCause.getAICorePoints(market);
            total += interest;
        }
        return total;
    }

    public static float getAICorePoints(MarketAPI market) {
        float total = 0.0f;
        float admin = Global.getSettings().getFloat("hegemonyPointsAdmin");
        float alpha = Global.getSettings().getFloat("hegemonyPointsAlpha");
        float beta = Global.getSettings().getFloat("hegemonyPointsBeta");
        float gamma = Global.getSettings().getFloat("hegemonyPointsGamma");
        String aiCoreId = market.getAdmin().getAICoreId();
        if (aiCoreId != null) {
            total += admin;
        }
        for (Industry ind : market.getIndustries()) {
            String core = ind.getAICoreId();
            if ("alpha_core".equals(core)) {
                total += alpha;
                continue;
            }
            if ("beta_core".equals(core)) {
                total += beta;
                continue;
            }
            if (!"gamma_core".equals(core)) continue;
            total += gamma;
        }
        return total;
    }

    public float getMagnitudeContribution(StarSystemAPI system) {
        if (HegemonyHostileActivityFactor.isPlayerDefeatedHegemony()) {
            return 0.0f;
        }
        if (this.isNegatedByPLMembership()) {
            return 0.0f;
        }
        if (this.getProgress() <= 0) {
            return 0.0f;
        }
        List<MarketAPI> markets = Misc.getMarketsInLocation(system, "player");
        float perAICorePoint = Global.getSettings().getFloat("hegemonyPerAICorePoint");
        float total = 0.0f;
        for (MarketAPI market : markets) {
            float points = HegemonyAICoresActivityCause.getAICorePoints(market);
            total += points;
        }
        total = (float)Math.round(total * 100.0f) / 100.0f;
        return total;
    }
}

