/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.NPCHassler;
import com.fs.starfarer.api.impl.campaign.ids.Sounds;
import com.fs.starfarer.api.impl.campaign.intel.MessageIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HegemonyAICoresActivityCause;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.inspection.HegemonyInspectionIntel;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.DelayedActionScript;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class HegemonyHostileActivityFactor
extends BaseHostileActivityFactor
implements HegemonyInspectionIntel.InspectionEndedListener {
    public static final String HASSLE_REASON = "hegemonyInvestigator";
    public static String DEFEATED_HEGEMONY = "$defeatedHegemony";
    public static String INSPECTION_ATTEMPTS = "$hegemonyInspectionAttempts";
    public static String INSPECTIONS_DEFEATED = "$hegemonyInspectionsDefeated";
    public static int INSPECTIONS_TO_DEFEAT = 3;
    public static float INSPECTION_STRENGTH_FIRST = 150.0f;
    public static float INSPECTION_STRENGTH_SECOND = 600.0f;
    public static float INSPECTION_STRENGTH_FINAL = 1400.0f;

    public static boolean isPlayerDefeatedHegemony() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(DEFEATED_HEGEMONY);
    }

    public static void setPlayerDefeatedHegemony() {
        Global.getSector().getPlayerMemoryWithoutUpdate().set(DEFEATED_HEGEMONY, true);
    }

    public static int getInspectionAttempts() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getInt(INSPECTION_ATTEMPTS);
    }

    public static void incrInspectionAttempts() {
        Global.getSector().getPlayerMemoryWithoutUpdate().set(INSPECTION_ATTEMPTS, HegemonyHostileActivityFactor.getInspectionAttempts() + 1);
    }

    public static int getInspectionsDefeated() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getInt(INSPECTIONS_DEFEATED);
    }

    public static void incrInspectionsDefeated() {
        Global.getSector().getPlayerMemoryWithoutUpdate().set(INSPECTIONS_DEFEATED, HegemonyHostileActivityFactor.getInspectionsDefeated() + 1);
    }

    public HegemonyHostileActivityFactor(HostileActivityEventIntel intel) {
        super(intel);
    }

    public String getProgressStr(BaseEventIntel intel) {
        return "";
    }

    public int getProgress(BaseEventIntel intel) {
        if (!HegemonyHostileActivityFactor.checkFactionExists("hegemony", true)) {
            return 0;
        }
        return super.getProgress(intel);
    }

    public String getDesc(BaseEventIntel intel) {
        return "\u9738\u4e3b";
    }

    public String getNameForThreatList(boolean first) {
        return "\u9738\u4e3b";
    }

    public Color getDescColor(BaseEventIntel intel) {
        if (this.getProgress(intel) <= 0) {
            return Misc.getGrayColor();
        }
        return Global.getSector().getFaction("hegemony").getBaseUIColor();
    }

    public TooltipMakerAPI.TooltipCreator getMainRowTooltip(BaseEventIntel intel) {
        return new BaseFactorTooltip(){

            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                float opad = 10.0f;
                tooltip.addPara("\u9738\u4e3b\u8ba4\u4e3a\u4f7f\u7528 AI \u6838\u5fc3\u662f\u975e\u6cd5\u7684\uff0c\u5373\u4f7f\u662f\u5728\u6838\u5fc3\u4e16\u754c\u8303\u56f4\u4ee5\u5916\u4e5f\u4e0d\u53ef\u5bb9\u5fcd\u3002", 0.0f);
                tooltip.addPara("\u8c03\u67e5\u4f60\u4f7f\u7528 AI \u6838\u5fc3\u60c5\u51b5\u7684\u8230\u961f\u5c06\u5076\u5c14\u5730\u51fa\u73b0\u5728\u4f60\u7684\u9886\u5730\u5185\uff0c\u5b83\u4eec\u53ef\u80fd\u4e0d\u4f1a\u4e0e\u4f60\u516c\u5f00\u654c\u5bf9\uff0c\u4f46\u4f1a\u9a9a\u6270\u4f60\u7684\u8fd0\u8f93\u8230\u961f\uff0c\u4e14\u901a\u5e38\u4f1a\u4ee5\u9ad8\u538b\u59ff\u6001\u884c\u4e8b\u3002", opad);
            }
        };
    }

    public boolean shouldShow(BaseEventIntel intel) {
        boolean shouldShowDueToCause = false;
        for (HostileActivityCause2 cause : this.getCauses()) {
            shouldShowDueToCause |= cause.shouldShow();
        }
        return this.getProgress(intel) > 0 || shouldShowDueToCause;
    }

    public int getMaxNumFleets(StarSystemAPI system) {
        return Global.getSettings().getInt("hegemonyMaxFleets");
    }

    public CampaignFleetAPI createFleet(StarSystemAPI system, Random random) {
        float f = 0.0f;
        if ((f += this.intel.getMarketPresenceFactor(system)) > 1.0f) {
            f = 1.0f;
        }
        boolean recon = false;
        int difficulty = 0;
        if (recon) {
            difficulty = 1 + random.nextInt(2);
        } else {
            difficulty = 3;
            difficulty += Math.round(f * 5.0f);
            difficulty += random.nextInt(4);
        }
        FleetCreatorMission m = new FleetCreatorMission(random);
        m.beginFleet();
        Vector2f loc = system.getLocation();
        String factionId = "hegemony";
        if (recon) {
            m.createStandardFleet(difficulty, factionId, loc);
        } else {
            m.createStandardFleet(difficulty, factionId, loc);
        }
        m.triggerSetFleetType("investigators");
        m.triggerSetPatrol();
        if (!recon) {
            m.triggerSetFleetHasslePlayer(HASSLE_REASON);
            m.triggerSetFleetFlag("$hegemonyInvestigator");
            m.triggerFleetAllowLongPursuit();
        }
        m.triggerMakeLowRepImpact();
        CampaignFleetAPI fleet = m.createFleet();
        if (fleet != null && !recon) {
            fleet.addScript(new NPCHassler(fleet, system));
        }
        return fleet;
    }

    public void notifyFactorRemoved() {
    }

    public void notifyEventEnding() {
        this.notifyFactorRemoved();
    }

    public void addBulletPointForEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        if (!(stage.rollData instanceof HostileActivityEventIntel.HAERandomEventData)) {
            return;
        }
        HostileActivityEventIntel.HAERandomEventData data = (HostileActivityEventIntel.HAERandomEventData)stage.rollData;
        MarketAPI target = (MarketAPI)data.custom;
        if (target == null) {
            return;
        }
        MarketAPI from = this.pickSourceMarket();
        if (from == null) {
            return;
        }
        Color c = Global.getSector().getFaction("hegemony").getBaseUIColor();
        LabelAPI label = info.addPara("\u4e0b\u4e00\u4e2a\u9738\u4e3b AI \u5ba1\u67e5\u76ee\u6807\u662f %s", initPad, tc, tc, target.getName());
        label.setHighlight("\u9738\u4e3b", target.getName());
        label.setHighlightColors(c, Misc.getBasePlayerColor());
    }

    public void addBulletPointForEventReset(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        info.addPara("\u9738\u4e3b AI \u5ba1\u67e5 \u5df2\u907f\u514d", tc, initPad);
    }

    public void addStageDescriptionForEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info) {
        if (!(stage.rollData instanceof HostileActivityEventIntel.HAERandomEventData)) {
            return;
        }
        HostileActivityEventIntel.HAERandomEventData data = (HostileActivityEventIntel.HAERandomEventData)stage.rollData;
        MarketAPI target = (MarketAPI)data.custom;
        if (target == null) {
            return;
        }
        MarketAPI from = this.pickSourceMarket();
        if (from == null) {
            return;
        }
        Color c = Global.getSector().getFaction("hegemony").getBaseUIColor();
        float small = 0.0f;
        float opad = 10.0f;
        small = 8.0f;
        LabelAPI label = info.addPara("\u4f60\u83b7\u77e5\u7684\u60c5\u62a5\u8868\u660e\uff0c\u9738\u4e3b\u6b63\u8ba1\u5212\u4e8e %s \u5b9e\u65bd\u4e00\u6b21 AI \u5ba1\u67e5\u3002\u5982\u679c\u5ba1\u67e5\u56e2\u987a\u5229\u62b5\u8fbe\u4f60\u7684\u6b96\u6c11\u5730\uff0c\u4f60\u5c06\u4e0e\u9738\u4e3b \u516c\u5f00\u654c\u5bf9 \u6216 \u5931\u53bb\u81f3\u5c11\u4e00\u90e8\u5206 AI \u6838\u5fc3\u3002", small, c, target.getName());
        label.setHighlight(target.getName(), "\u516c\u5f00\u654c\u5bf9", "\u5931\u53bb\u81f3\u5c11\u4e00\u90e8\u5206 AI \u6838\u5fc3");
        label.setHighlightColors(Misc.getBasePlayerColor(), Misc.getNegativeHighlightColor(), Misc.getNegativeHighlightColor());
        int defeated = HegemonyHostileActivityFactor.getInspectionsDefeated();
        if (defeated < INSPECTIONS_TO_DEFEAT) {
            label = info.addPara("\u5982\u679c\u5ba1\u67e5\u56e2\u88ab\u4ee5\u519b\u4e8b\u624b\u6bb5\u51fb\u8d25\uff0c\u9738\u4e3b\u5f88\u53ef\u80fd\u4f1a \u53d1\u8d77\u66f4\u5927\u7684\u51b2\u7a81\uff0c\u4e0d\u8fc7\u51b2\u7a81\u5347\u7ea7 \u4e0d\u662f\u65e0\u9650\u5236 \u7684\u3002", opad, Misc.getNegativeHighlightColor(), "\u53d1\u8d77\u66f4\u5927\u7684\u51b2\u7a81");
            label.setHighlight("\u53d1\u8d77\u66f4\u5927\u7684\u51b2\u7a81", "\u4e0d\u662f\u65e0\u9650\u5236");
            label.setHighlightColors(Misc.getNegativeHighlightColor(), Misc.getPositiveHighlightColor());
        } else {
            info.addPara("\u5982\u679c\u8fd9\u4e00\u89c4\u6a21\u5e9e\u5927\u7684\u5ba1\u67e5\u529b\u91cf \u2014\u2014 \u9664\u540d\u4e49\u4ee5\u5916\u672c\u8d28\u4e0a\u5c31\u662f\u5ba3\u6218 \u2014\u2014 \u88ab\u51fb\u8d25\uff0c\u9738\u4e3b\u5f88\u53ef\u80fd\u4f1a \u91cd\u65b0\u8003\u8651 \u8fd9\u4e00\u5904\u7406\u65b9\u5f0f\u7684\u53ef\u884c\u6027\u3002", opad, Misc.getPositiveHighlightColor(), "\u91cd\u65b0\u8003\u8651");
        }
        stage.beginResetReqList(info, true, "crisis", opad);
        info.addPara("%s \u7684\u6240\u6709\u519b\u4e8b\u8bbe\u65bd\u5747\u5df2\u5931\u53bb\u6216\u88ab\u65e0\u6548\u5316", 0.0f, c, "\u9738\u4e3b");
        stage.endResetReqList(info, false, "crisis", -1, -1);
        this.addBorder(info, Global.getSector().getFaction("hegemony").getBaseUIColor());
    }

    public String getEventStageIcon(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        return Global.getSector().getFaction("hegemony").getCrest();
    }

    public TooltipMakerAPI.TooltipCreator getStageTooltipImpl(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        if (stage.id == HostileActivityEventIntel.Stage.HA_EVENT) {
            return this.getDefaultEventTooltip("\u9738\u4e3b AI \u5ba1\u67e5", intel, stage);
        }
        return null;
    }

    public float getEventFrequency(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        if (stage.id == HostileActivityEventIntel.Stage.HA_EVENT && this.pickTargetMarket() != null && this.pickSourceMarket() != null) {
            return 10.0f;
        }
        return 0.0f;
    }

    public MarketAPI pickTargetMarket() {
        WeightedRandomPicker<MarketAPI> picker = new WeightedRandomPicker<MarketAPI>(this.getRandomizedStageRandom());
        float alpha = Global.getSettings().getFloat("hegemonyPointsAlpha");
        float beta = Global.getSettings().getFloat("hegemonyPointsBeta");
        float gamma = Global.getSettings().getFloat("hegemonyPointsGamma");
        float threshold = alpha + beta + gamma;
        for (MarketAPI market : Misc.getPlayerMarkets(false)) {
            float w;
            if (market.getDaysInExistence() < 180.0f && !Global.getSettings().isDevMode() || (w = HegemonyAICoresActivityCause.getAICorePoints(market)) <= threshold) continue;
            picker.add(market, w * w);
        }
        return (MarketAPI)picker.pick();
    }

    public MarketAPI pickSourceMarket() {
        WeightedRandomPicker<MarketAPI> picker = new WeightedRandomPicker<MarketAPI>(this.getRandomizedStageRandom(7));
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (!market.getFactionId().equals("hegemony")) continue;
            Industry b = market.getIndustry("militarybase");
            if (b == null) {
                b = market.getIndustry("highcommand");
            }
            if (b == null || b.isDisrupted() || !b.isFunctional()) continue;
            picker.add(market, market.getSize());
        }
        MarketAPI from = (MarketAPI)picker.pick();
        return from;
    }

    public void rollEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        if (HegemonyHostileActivityFactor.isPlayerDefeatedHegemony()) {
            return;
        }
        MarketAPI market = this.pickTargetMarket();
        if (market == null) {
            return;
        }
        MarketAPI from = this.pickSourceMarket();
        if (from == null) {
            return;
        }
        HostileActivityEventIntel.HAERandomEventData data = new HostileActivityEventIntel.HAERandomEventData(this, stage);
        data.custom = market;
        stage.rollData = data;
        intel.sendUpdateIfPlayerHasIntel((Object)data, false);
    }

    public boolean fireEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        if (HegemonyHostileActivityFactor.isPlayerDefeatedHegemony()) {
            return false;
        }
        if (!(stage.rollData instanceof HostileActivityEventIntel.HAERandomEventData)) {
            return false;
        }
        HostileActivityEventIntel.HAERandomEventData data = (HostileActivityEventIntel.HAERandomEventData)stage.rollData;
        MarketAPI market = (MarketAPI)data.custom;
        if (market == null) {
            return false;
        }
        if (!market.isInEconomy()) {
            return false;
        }
        MarketAPI from = this.pickSourceMarket();
        if (from == null) {
            return false;
        }
        StarSystemAPI system = market.getStarSystem();
        if (system == null) {
            return false;
        }
        return this.createInspection(market, null);
    }

    public boolean createInspection(MarketAPI target, Integer fpOverride) {
        HegemonyInspectionIntel inspection;
        MarketAPI from = this.pickSourceMarket();
        if (from == null) {
            return false;
        }
        int defeated = HegemonyHostileActivityFactor.getInspectionsDefeated();
        float fp = defeated <= 0 ? INSPECTION_STRENGTH_FIRST : (defeated == 1 ? INSPECTION_STRENGTH_SECOND : INSPECTION_STRENGTH_FINAL);
        if (fpOverride != null) {
            fp = fpOverride.intValue();
        }
        if ((inspection = new HegemonyInspectionIntel(from, target, fp)).isDone()) {
            inspection = null;
            return false;
        }
        inspection.setListener(this);
        HegemonyHostileActivityFactor.incrInspectionAttempts();
        return true;
    }

    public void advance(float amount) {
        super.advance(amount);
        BaseEventIntel.EventStageData stage = this.intel.getDataFor((Object)HostileActivityEventIntel.Stage.HA_EVENT);
        if (stage != null && stage.rollData instanceof HostileActivityEventIntel.HAERandomEventData && ((HostileActivityEventIntel.HAERandomEventData)stage.rollData).factor == this && this.pickSourceMarket() == null) {
            this.intel.resetHA_EVENT();
        }
    }

    public static void avertInspectionIfNotInProgress() {
        HostileActivityEventIntel intel = HostileActivityEventIntel.get();
        if (intel == null) {
            return;
        }
        HostileActivityEventIntel.HAERandomEventData data = intel.getRollDataForEvent();
        if (data != null && data.factor instanceof HegemonyHostileActivityFactor) {
            intel.resetHA_EVENT();
        }
    }

    public void notifyInspectionEnded(HegemonyInspectionIntel.HegemonyInspectionOutcome outcome) {
        if (outcome == HegemonyInspectionIntel.HegemonyInspectionOutcome.TASK_FORCE_DESTROYED) {
            HegemonyHostileActivityFactor.incrInspectionsDefeated();
            int defeated = HegemonyHostileActivityFactor.getInspectionsDefeated();
            if (defeated >= INSPECTIONS_TO_DEFEAT) {
                HegemonyHostileActivityFactor.setPlayerDefeatedHegemony();
                Global.getSector().addScript(new DelayedActionScript(0.1f){

                    public void doAction() {
                        MessageIntel msg = new MessageIntel();
                        msg.addLine("\u9738\u4e3b \u5df2\u51fb\u8d25\uff01", Misc.getBasePlayerColor());
                        msg.addLine("    - \u4f60\u53ef\u4e0e\u4f4d\u4e8e Chicomoztoc \u7684 \u81f3\u9ad8\u9738\u4e3b \u8fdb\u884c\u5546\u8ba8");
                        msg.setIcon(Global.getSector().getFaction("hegemony").getCrest());
                        msg.setSound(Sounds.REP_GAIN);
                        Global.getSector().getCampaignUI().addMessage(msg, CommMessageAPI.MessageClickAction.NOTHING);
                    }
                });
            }
        }
    }
}

