/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.EconomyAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.combat.MutableStatWithTempMods;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.command.WarSimScript;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathBaseIntel;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.EventFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HABlowbackFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HAColonyDefensesFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HAPatherBaseDestroyedFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HAPirateBaseDestroyedFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HAShipsDestroyedFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HAShipsDestroyedFactorHint;
import com.fs.starfarer.api.impl.campaign.intel.events.HegemonyAICoresActivityCause;
import com.fs.starfarer.api.impl.campaign.intel.events.HegemonyHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.KantasProtectionPirateActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.events.KantasWrathPirateActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.events.LuddicChurchHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.LuddicChurchStandardActivityCause;
import com.fs.starfarer.api.impl.campaign.intel.events.LuddicPathAgreementHostileActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.events.LuddicPathHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.PerseanLeagueHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.PirateBasePirateActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.events.PirateHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.RemnantHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.RemnantNexusActivityCause;
import com.fs.starfarer.api.impl.campaign.intel.events.SindrianDiktatHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.SindrianDiktatStandardActivityCause;
import com.fs.starfarer.api.impl.campaign.intel.events.StandardLuddicPathActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.events.StandardPerseanLeagueActivityCause;
import com.fs.starfarer.api.impl.campaign.intel.events.StandardPirateActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.events.TriTachyonHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.TriTachyonStandardActivityCause;
import com.fs.starfarer.api.impl.campaign.rulecmd.HA_CMD;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.IntelUIAPI;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostileActivityEventIntel
extends BaseEventIntel
implements EconomyAPI.EconomyUpdateListener,
FleetEventListener {
    public static String KEY = "$hae_ref";
    public static float FP_PER_POINT = Global.getSettings().getFloat("HA_fleetPointsPerPoint");
    public static int MAX_PROGRESS = 600;
    public static int RESET_MIN = 0;
    public static int RESET_MAX = 400;
    protected int blowback;
    protected Map<String, MutableStatWithTempMods> systemSpawnMults = new LinkedHashMap<String, MutableStatWithTempMods>();
    protected HostileActivityFactor prevMajorEventPick = null;

    public static HostileActivityEventIntel get() {
        return (HostileActivityEventIntel)Global.getSector().getMemoryWithoutUpdate().get(KEY);
    }

    public HostileActivityEventIntel() {
        Global.getSector().getMemoryWithoutUpdate().set(KEY, this);
        this.setup();
        Global.getSector().getIntelManager().addIntel(this);
    }

    protected void setup() {
        boolean minorCompleted = false;
        BaseEventIntel.EventStageData minor = this.getDataFor((Object)Stage.MINOR_EVENT);
        if (minor != null) {
            minorCompleted = minor.wasEverReached;
        }
        this.factors.clear();
        this.stages.clear();
        this.setMaxProgress(MAX_PROGRESS);
        this.addStage((Object)Stage.START, 0);
        this.addStage((Object)Stage.MINOR_EVENT, 300, BaseEventIntel.StageIconSize.MEDIUM);
        this.addStage((Object)Stage.HA_EVENT, 600, true, BaseEventIntel.StageIconSize.LARGE);
        this.setRandomized((Object)Stage.MINOR_EVENT, BaseEventIntel.RandomizedStageType.BAD, 200, 250, false, false);
        this.setRandomized((Object)Stage.HA_EVENT, BaseEventIntel.RandomizedStageType.BAD, 425, 500, false);
        minor = this.getDataFor((Object)Stage.MINOR_EVENT);
        if (minor != null) {
            minor.wasEverReached = minorCompleted;
        }
        Global.getSector().getListenerManager().removeListenerOfClass(PirateHostileActivityFactor.class);
        Global.getSector().getListenerManager().removeListenerOfClass(LuddicPathHostileActivityFactor.class);
        Global.getSector().getListenerManager().removeListenerOfClass(PerseanLeagueHostileActivityFactor.class);
        Global.getSector().getListenerManager().removeListenerOfClass(TriTachyonHostileActivityFactor.class);
        Global.getSector().getListenerManager().removeListenerOfClass(LuddicChurchHostileActivityFactor.class);
        Global.getSector().getListenerManager().removeListenerOfClass(SindrianDiktatHostileActivityFactor.class);
        Global.getSector().getListenerManager().removeListenerOfClass(HegemonyHostileActivityFactor.class);
        Global.getSector().getListenerManager().removeListenerOfClass(RemnantHostileActivityFactor.class);
        this.addFactor(new HAColonyDefensesFactor());
        this.addFactor(new HAShipsDestroyedFactorHint());
        this.addFactor(new HABlowbackFactor());
        PirateHostileActivityFactor pirate = new PirateHostileActivityFactor(this);
        this.addActivity(pirate, new KantasProtectionPirateActivityCause2(this));
        this.addActivity(pirate, new StandardPirateActivityCause2(this));
        this.addActivity(pirate, new PirateBasePirateActivityCause2(this));
        this.addActivity(pirate, new KantasWrathPirateActivityCause2(this));
        LuddicPathHostileActivityFactor path = new LuddicPathHostileActivityFactor(this);
        this.addActivity(path, new LuddicPathAgreementHostileActivityCause2(this));
        this.addActivity(path, new StandardLuddicPathActivityCause2(this));
        this.addActivity(new PerseanLeagueHostileActivityFactor(this), new StandardPerseanLeagueActivityCause(this));
        this.addActivity(new TriTachyonHostileActivityFactor(this), new TriTachyonStandardActivityCause(this));
        this.addActivity(new LuddicChurchHostileActivityFactor(this), new LuddicChurchStandardActivityCause(this));
        this.addActivity(new SindrianDiktatHostileActivityFactor(this), new SindrianDiktatStandardActivityCause(this));
        this.addActivity(new HegemonyHostileActivityFactor(this), new HegemonyAICoresActivityCause(this));
        this.addActivity(new RemnantHostileActivityFactor(this), new RemnantNexusActivityCause(this));
    }

    protected Object readResolve() {
        if (this.systemSpawnMults == null) {
            this.systemSpawnMults = new LinkedHashMap<String, MutableStatWithTempMods>();
        }
        return this;
    }

    public void redoSetupIfNeeded() {
        if (this.getDataFor((Object)Stage.INCREASED_DEFENSES) != null || this.getMaxProgress() == 500) {
            this.setup();
        }
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        Global.getSector().getEconomy().removeUpdateListener(this);
        this.cleanUpHostileActivityConditions();
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
        Global.getSector().getMemoryWithoutUpdate().unset(KEY);
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        if (this.addEventFactorBulletPoints(info, mode, isUpdate, tc, initPad)) {
            return;
        }
        if (isUpdate && this.getListInfoParam() instanceof HAERandomEventData) {
            HAERandomEventData data = (HAERandomEventData)this.getListInfoParam();
            if (data.isReset) {
                data.factor.addBulletPointForEventReset(this, data.stage, info, mode, isUpdate, tc, initPad);
            } else {
                data.factor.addBulletPointForEvent(this, data.stage, info, mode, isUpdate, tc, initPad);
            }
            return;
        }
        for (BaseEventIntel.EventStageData stage : this.stages) {
            if (!(stage.rollData instanceof HAERandomEventData)) continue;
            HAERandomEventData data = (HAERandomEventData)stage.rollData;
            data.factor.addBulletPointForEvent(this, stage, info, mode, isUpdate, tc, initPad);
            return;
        }
    }

    public HAERandomEventData getRollDataForEvent() {
        BaseEventIntel.EventStageData stage = this.getDataFor((Object)Stage.HA_EVENT);
        if (stage == null) {
            return null;
        }
        if (stage.rollData instanceof HAERandomEventData) {
            HAERandomEventData data = (HAERandomEventData)stage.rollData;
            return data;
        }
        return null;
    }

    @Override
    public void addStageDescriptionText(TooltipMakerAPI info, float width, Object stageId) {
        float opad = 10.0f;
        float small = 0.0f;
        Color h = Misc.getHighlightColor();
        List<HAEStarSystemDangerData> systemData = this.computePlayerSystemDangerData();
        BaseEventIntel.EventStageData stage = this.getDataFor(stageId);
        if (stage == null) {
            return;
        }
        if (stage.rollData instanceof HAERandomEventData) {
            HAERandomEventData data = (HAERandomEventData)stage.rollData;
            data.factor.addStageDescriptionForEvent(this, stage, info);
            return;
        }
        if (this.isStageActiveAndLast(stageId)) {
            if (stageId == Stage.START) {
                float delta = this.getMonthlyProgress();
                if (delta <= 0.0f) {
                    info.addPara("\u5c0f\u89c4\u6a21\u6d77\u76d7\u6d3b\u52a8\u5c06\u7ee7\u7eed\u53d1\u751f\uff0c\u4f46\u9664\u6b64\u4e4b\u5916\uff0c\u9884\u8ba1\u77ed\u671f\u5185\u4e0d\u4f1a\u51fa\u73b0\u91cd\u5927\u5371\u673a\u3002", small);
                } else {
                    info.addPara("\u53ef\u4ee5\u9884\u8ba1\u7684\u662f\uff0c\u4e00\u573a\u51e0\u4e4e\u4e0d\u53ef\u907f\u514d\u7684\u5371\u673a\u5c06\u5728\u67d0\u4e2a\u65f6\u523b\u53d1\u751f\u3002\u654c\u5bf9\u8230\u961f\u6b63\u6301\u7eed\u4e0d\u65ad\u5730\u63a2\u6d4b\u4f60\u7684\u9632\u5fa1\u3002\u4f46\u98ce\u9669\u5f80\u5f80\u4f34\u968f\u7740\u673a\u9047\u3002", small);
                }
            }
            float systemW = 230.0f;
            float threatW = 300.0f;
            info.beginTable(this.getFactionForUIColors(), 20.0f, "\u6052\u661f\u661f\u7cfb", Float.valueOf(systemW), "\u5371\u9669\u5ea6", Float.valueOf(100.0f), "\u4e3b\u8981\u5a01\u80c1", Float.valueOf(threatW));
            info.makeTableItemsClickable();
            int maxSystemsToList = 4;
            int numListed = 0;
            info.addTableHeaderTooltip(0, "\u5b58\u5728\u654c\u5bf9\u6d3b\u52a8\u7684\u661f\u7cfb\uff0c\u4ee5\u53ca\u4f60\u4f4d\u4e8e\u8be5\u5904\u7684\u6b96\u6c11\u5730\u7684\u540d\u79f0 (\u6216\u6570\u91cf)\u3002\n\n\u8fd9\u91cc\u6700\u591a\u53ef\u5217\u51fa\u56db\u4e2a\u53d7\u5f71\u54cd\u6700\u4e25\u91cd\u7684\u661f\u7cfb\u3002");
            info.addTableHeaderTooltip(1, "\u8fd9\u4e2a\u661f\u7cfb\u4e2d\u8f83\u5f3a\u8230\u961f\u7684\u5927\u81f4\u5371\u9669\u5ea6\u4f30\u7b97\u3002\u53ef\u80fd\u6709\u4f8b\u5916\u60c5\u51b5\u5b58\u5728\u3002\u4e0d\u8003\u8651\u53ef\u80fd\u56e0\u4e3a\u5176\u4ed6\u539f\u56e0\u51fa\u73b0\u5728\u6b64\u7684\u654c\u65b9\u8230\u961f\u3002");
            info.addTableHeaderTooltip(2, "\u5728\u8be5\u661f\u7cfb\u53ef\u80fd\u5b58\u5728\u7684\u6700\u5371\u9669\u5a01\u80c1\u3002\u4e0d\u662f\u5b8c\u5168\u5217\u8868\uff0c\u5e76\u4e14\u4e0d\u8003\u8651\u53ef\u80fd\u56e0\u4e3a\u5176\u4ed6\u539f\u56e0\u51fa\u73b0\u5728\u6b64\u5904\u7684\u654c\u65b9\u8230\u961f\u3002");
            for (final HAEStarSystemDangerData sys : systemData) {
                if (sys.sortMag <= 0.0f) continue;
                float mag = sys.sortMag;
                String danger = this.getDangerString(mag);
                int maxThreats = 3;
                int count = 0;
                ArrayList<String> threats = new ArrayList<String>();
                ArrayList<Color> colors = new ArrayList<Color>();
                for (HAEFactorDangerData data : sys.factorData) {
                    if (data.mag <= 0.0f) continue;
                    threats.add(data.factor.getNameForThreatList(count == 0));
                    colors.add(data.factor.getNameColorForThreatList());
                    if (++count >= maxThreats) break;
                }
                String threatStr = Misc.getJoined("", threats);
                LabelAPI label = info.createLabel(threatStr, Misc.getTextColor(), threatW);
                label.setHighlightColors(colors.toArray(new Color[0]));
                label.setHighlight(threats.toArray(new String[0]));
                String systemName = sys.system.getNameWithNoType();
                List<MarketAPI> colonies = Misc.getMarketsInLocation(sys.system, "player");
                String colStr = "";
                colStr = colonies.size() == 1 ? colonies.get(0).getName() : colonies.size() + "\u6b96\u6c11\u5730";
                systemName = String.valueOf(systemName) + " - " + colStr;
                info.addRowWithGlow(new Object[]{Alignment.LMID, Misc.getBasePlayerColor(), systemName, Alignment.MID, this.getDangerColor(mag), danger, Alignment.MID, null, label});
                info.addTooltipToAddedRow(new BaseFactorTooltip(){

                    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                        float w = tooltip.getWidthSoFar();
                        float h = Math.round(w / 1.6f);
                        tooltip.addSectorMap(w, h, sys.system, 0.0f);
                        tooltip.addPara("\u70b9\u51fb\u6253\u5f00\u5730\u56fe", Misc.getGrayColor(), 5.0f);
                    }
                }, TooltipMakerAPI.TooltipLocation.LEFT, false);
                info.setIdForAddedRow(sys);
                if (++numListed >= maxSystemsToList) break;
            }
            info.addTable("\u65e0", -1, opad);
            info.addSpacer(3.0f);
        }
    }

    @Override
    public void tableRowClicked(IntelUIAPI ui, IntelInfoPlugin.TableRowClickData data) {
        if (data.rowId instanceof HAEStarSystemDangerData) {
            HAEStarSystemDangerData d = (HAEStarSystemDangerData)data.rowId;
            List<MarketAPI> m = Misc.getMarketsInLocation(d.system, "player");
            if (m.size() == 1) {
                ui.showOnMap(m.get(0).getPrimaryEntity());
            } else {
                ui.showOnMap(d.system.getHyperspaceAnchor());
            }
        }
    }

    @Override
    public TooltipMakerAPI.TooltipCreator getStageTooltipImpl(Object stageId) {
        BaseEventIntel.EventStageData esd = this.getDataFor(stageId);
        if (esd != null && esd.rollData instanceof HAERandomEventData) {
            HAERandomEventData data = (HAERandomEventData)esd.rollData;
            return data.factor.getStageTooltipImpl(this, esd);
        }
        return null;
    }

    @Override
    public String getIcon() {
        return Global.getSettings().getSpriteName("events", "hostile_activity");
    }

    @Override
    protected String getStageIcon(Object stageId) {
        BaseEventIntel.EventStageData esd = this.getDataFor(stageId);
        if (esd != null && esd.id == Stage.HA_EVENT && esd.rollData != null && "random_event_none".equals(esd.rollData)) {
            return Global.getSettings().getSpriteName("events", "stage_unknown_neutral");
        }
        return super.getStageIcon(stageId);
    }

    @Override
    public TooltipMakerAPI.TooltipCreator getStageTooltip(Object stageId) {
        BaseEventIntel.EventStageData esd = this.getDataFor(stageId);
        if (esd != null && esd.id == Stage.HA_EVENT && esd.rollData != null && "random_event_none".equals(esd.rollData)) {
            return new TooltipMakerAPI.TooltipCreator(){

                public boolean isTooltipExpandable(Object tooltipParam) {
                    return false;
                }

                public float getTooltipWidth(Object tooltipParam) {
                    return BaseEventFactor.TOOLTIP_WIDTH;
                }

                public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                    Color h = Misc.getHighlightColor();
                    tooltip.addPara("\u9884\u8ba1\u77ed\u671f\u5185\u4e0d\u4f1a\u51fa\u73b0\u5371\u673a\u3002\u8fbe\u6210\u6b64\u9636\u6bb5\u65f6\uff0c\u4e8b\u4ef6\u8fdb\u5ea6\u4f1a\u88ab\u91cd\u7f6e\u5230\u4e00\u4e2a\u76f8\u5bf9\u8f83\u4f4e\u7684\u6570\u503c\u3002", 0.0f);
                }
            };
        }
        return super.getStageTooltip(stageId);
    }

    @Override
    protected String getStageIconImpl(Object stageId) {
        BaseEventIntel.EventStageData esd = this.getDataFor(stageId);
        if (esd == null) {
            return null;
        }
        if (esd.rollData instanceof HAERandomEventData) {
            HAERandomEventData data = (HAERandomEventData)esd.rollData;
            return data.factor.getEventStageIcon(this, esd);
        }
        if (esd.id == Stage.START) {
            return Global.getSettings().getSpriteName("events", "hostile_activity_" + ((Stage)((Object)esd.id)).name());
        }
        return Global.getSettings().getSpriteName("events", "hostile_activity");
    }

    @Override
    public Color getBarColor() {
        Color color = Misc.getNegativeHighlightColor();
        color = Misc.interpolateColor(color, Color.black, 0.25f);
        return color;
    }

    @Override
    public Color getBarProgressIndicatorColor() {
        return super.getBarProgressIndicatorColor();
    }

    @Override
    protected int getStageImportance(Object stageId) {
        return super.getStageImportance(stageId);
    }

    @Override
    protected String getName() {
        return "\u6b96\u6c11\u5730\u5371\u673a";
    }

    @Override
    public boolean isEventProgressANegativeThingForThePlayer() {
        return true;
    }

    public void addActivity(BaseHostileActivityFactor factor, HostileActivityCause2 cause) {
        BaseHostileActivityFactor curr = this.getActivityOfClass(factor.getClass());
        if (curr == null) {
            this.addFactor(factor);
            curr = factor;
        }
        curr.addCause(cause);
    }

    public void removeActivityCause(Class activityClass, Class causeClass) {
        BaseHostileActivityFactor curr = this.getActivityOfClass(activityClass);
        if (curr == null) {
            return;
        }
        HostileActivityCause2 cause = curr.getCauseOfClass(causeClass);
        if (cause == null) {
            return;
        }
        curr.getCauses().remove(cause);
        if (curr.getCauses().isEmpty()) {
            this.removeActivity(curr);
        }
    }

    public HostileActivityCause2 getActivityCause(Class activityClass, Class causeClass) {
        BaseHostileActivityFactor curr = this.getActivityOfClass(activityClass);
        if (curr == null) {
            return null;
        }
        HostileActivityCause2 cause = curr.getCauseOfClass(causeClass);
        if (cause == null) {
            return null;
        }
        return cause;
    }

    public void removeActivity(BaseHostileActivityFactor plugin) {
        this.factors.remove(plugin);
    }

    public void removeActivityOfClass(Class c) {
        Iterator iter = this.factors.iterator();
        while (iter.hasNext()) {
            EventFactor curr = (EventFactor)iter.next();
            if (curr.getClass() != c) continue;
            iter.remove();
        }
    }

    public BaseHostileActivityFactor getActivityOfClass(Class c) {
        for (EventFactor curr : this.factors) {
            if (curr.getClass() != c) continue;
            return (BaseHostileActivityFactor)curr;
        }
        return null;
    }

    public List<HAEStarSystemDangerData> computePlayerSystemDangerData() {
        ArrayList<HAEStarSystemDangerData> systemData = new ArrayList<HAEStarSystemDangerData>();
        for (StarSystemAPI system : Misc.getPlayerSystems(false)) {
            HAEStarSystemDangerData data = this.computeDangerData(system);
            systemData.add(data);
        }
        Collections.sort(systemData, new Comparator<HAEStarSystemDangerData>(){

            @Override
            public int compare(HAEStarSystemDangerData o1, HAEStarSystemDangerData o2) {
                int result = (int)Math.signum(o2.sortMag - o1.sortMag);
                if (result == 0) {
                    result = (int)Math.signum(o2.totalMag - o1.totalMag);
                }
                if (result == 0) {
                    result = (int)Math.signum(o2.system.getId().hashCode() - o1.system.getId().hashCode());
                }
                return result;
            }
        });
        return systemData;
    }

    public HAEStarSystemDangerData computeDangerData(StarSystemAPI system) {
        HAEStarSystemDangerData data = new HAEStarSystemDangerData();
        data.system = system;
        float maxMag = 0.0f;
        float total = 0.0f;
        for (EventFactor factor : this.factors) {
            if (!(factor instanceof BaseHostileActivityFactor)) continue;
            HAEFactorDangerData curr = new HAEFactorDangerData();
            curr.factor = (HostileActivityFactor)((Object)factor);
            curr.mag = ((BaseHostileActivityFactor)factor).getEffectMagnitude(system);
            data.factorData.add(curr);
            maxMag = Math.max(maxMag, curr.mag);
            total += curr.mag;
        }
        data.maxMag = maxMag;
        data.totalMag = total;
        data.sortMag = data.maxMag * 0.75f + data.totalMag * 0.25f;
        Collections.sort(data.factorData, new Comparator<HAEFactorDangerData>(){

            @Override
            public int compare(HAEFactorDangerData o1, HAEFactorDangerData o2) {
                return (int)Math.signum(o2.mag - o1.mag);
            }
        });
        return data;
    }

    public WarSimScript.LocationDanger getDanger(float mag) {
        if (mag <= 0.0f) {
            return WarSimScript.LocationDanger.NONE;
        }
        if (mag < 0.25f) {
            return WarSimScript.LocationDanger.MINIMAL;
        }
        if (mag < 0.5f) {
            return WarSimScript.LocationDanger.LOW;
        }
        if (mag < 0.75f) {
            return WarSimScript.LocationDanger.MEDIUM;
        }
        if (mag < 1.0f) {
            return WarSimScript.LocationDanger.HIGH;
        }
        return WarSimScript.LocationDanger.EXTREME;
    }

    public String getDangerString(float mag) {
        return this.getDangerString(this.getDanger(mag));
    }

    public String getDangerString(WarSimScript.LocationDanger d) {
        switch (d) {
            case EXTREME: {
                return "\u6781\u9ad8";
            }
            case HIGH: {
                return "\u9ad8";
            }
            case MEDIUM: {
                return "\u4e2d";
            }
            case LOW: {
                return "\u4f4e";
            }
            case MINIMAL: {
                return "\u6781\u4f4e";
            }
            case NONE: {
                return "\u65e0";
            }
        }
        return "\u672a\u77e5";
    }

    public Color getDangerColor(float mag) {
        WarSimScript.LocationDanger d = this.getDanger(mag);
        if (d == WarSimScript.LocationDanger.NONE || d == WarSimScript.LocationDanger.MINIMAL) {
            return Misc.getPositiveHighlightColor();
        }
        if (d == WarSimScript.LocationDanger.EXTREME || d == WarSimScript.LocationDanger.HIGH) {
            return Misc.getNegativeHighlightColor();
        }
        return Misc.getHighlightColor();
    }

    public float getVeryApproximateFPStrength(StarSystemAPI system) {
        float mag = this.getTotalActivityMagnitude(system, true);
        return (mag *= 0.2f + this.getMarketPresenceFactor(system) * 0.8f) * 1000.0f;
    }

    public float getMarketPresenceFactor(StarSystemAPI system) {
        float maxSize = 0.0f;
        float count = 0.0f;
        for (MarketAPI market : Misc.getMarketsInLocation(system, "player")) {
            maxSize = Math.max((float)market.getSize(), maxSize);
            count += 1.0f;
        }
        float f = (maxSize - 3.0f + count - 1.0f) / 3.0f;
        float cap = 0.35f;
        cap = maxSize <= 4.0f ? 0.55f : (maxSize <= 5.0f ? 0.75f : 1.0f);
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > cap) {
            f = cap;
        }
        return f;
    }

    public float getTotalActivityMagnitude(StarSystemAPI system) {
        return this.getTotalActivityMagnitude(system, true);
    }

    public float getTotalActivityMagnitude(StarSystemAPI system, boolean capped) {
        float total = 0.0f;
        for (EventFactor factor : this.factors) {
            if (!(factor instanceof BaseHostileActivityFactor)) continue;
            total += ((BaseHostileActivityFactor)factor).getEffectMagnitude(system);
        }
        if (capped && total > 1.0f) {
            total = 1.0f;
        }
        total = (float)Math.round(total * 100.0f) / 100.0f;
        return total;
    }

    @Override
    protected void advanceImpl(float amount) {
        super.advanceImpl(amount);
        if (this.systemSpawnMults != null) {
            float days = Misc.getDays(amount);
            for (MutableStatWithTempMods stat : this.systemSpawnMults.values()) {
                stat.advance(days);
            }
        }
    }

    public MutableStatWithTempMods getNumFleetsStat(StarSystemAPI system) {
        String id;
        MutableStatWithTempMods stat;
        if (system == null) {
            return new MutableStatWithTempMods(1.0f);
        }
        if (this.systemSpawnMults == null) {
            this.systemSpawnMults = new LinkedHashMap<String, MutableStatWithTempMods>();
        }
        if ((stat = this.systemSpawnMults.get(id = system.getId())) == null) {
            stat = new MutableStatWithTempMods(1.0f);
            this.systemSpawnMults.put(id, stat);
        }
        return stat;
    }

    public float getNumFleetsMultiplier(StarSystemAPI system) {
        return this.getNumFleetsStat(system).getModifiedValue();
    }

    @Override
    public void economyUpdated() {
        this.cleanUpHostileActivityConditions();
    }

    public void cleanUpHostileActivityConditions() {
        for (MarketAPI curr : Misc.getPlayerMarkets(false)) {
            if (!curr.hasCondition("hostile_activity")) continue;
            curr.removeCondition("hostile_activity");
        }
    }

    @Override
    public boolean isEconomyListenerExpired() {
        return this.isEnding() || this.isEnded();
    }

    @Override
    public void commodityUpdated(String commodityId) {
    }

    @Override
    public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
    }

    @Override
    public void reportBattleOccurred(CampaignFleetAPI fleet, CampaignFleetAPI primaryWinner, BattleAPI battle) {
        if (this.isEnded() || this.isEnding()) {
            return;
        }
        if (!battle.isPlayerInvolved()) {
            return;
        }
        if (Global.getSector().getCurrentLocation() instanceof StarSystemAPI && battle.getPlayerSide().contains(primaryWinner)) {
            StarSystemAPI system = (StarSystemAPI)Global.getSector().getCurrentLocation();
            for (CampaignFleetAPI otherFleet : battle.getNonPlayerSideSnapshot()) {
                if (!otherFleet.isStationMode()) continue;
                BaseIntelPlugin intel = PirateBaseIntel.getIntelFor(system);
                if (intel != null && Misc.getStationFleet(((PirateBaseIntel)intel).getMarket()) == otherFleet && HA_CMD.baseInvolved(system, (PirateBaseIntel)intel)) {
                    int tier = ((PirateBaseIntel)intel).getTier().ordinal();
                    if (tier < 0) {
                        tier = 0;
                    }
                    if (tier > 4) {
                        tier = 4;
                    }
                    int points = -1 * Global.getSettings().getIntFromArray("HA_pirateBase", tier);
                    HAPirateBaseDestroyedFactor factor = new HAPirateBaseDestroyedFactor(points);
                    this.addFactor(factor);
                    return;
                }
                intel = LuddicPathBaseIntel.getIntelFor(system);
                if (intel == null || Misc.getStationFleet(((LuddicPathBaseIntel)intel).getMarket()) != otherFleet) continue;
                float totalInterest = 0.0f;
                float activeCells = 0.0f;
                for (StarSystemAPI curr : Misc.getPlayerSystems(false)) {
                    totalInterest += StandardLuddicPathActivityCause2.getPatherInterest(curr, 0.0f, 0.0f, 1.0f);
                    activeCells += StandardLuddicPathActivityCause2.getPatherInterest(curr, 0.0f, 0.0f, 1.0f, true);
                }
                if (totalInterest > 0.0f) {
                    int flat = Global.getSettings().getInt("HA_patherBaseFlat");
                    int perCell = Global.getSettings().getInt("HA_patherBasePerActiveCell");
                    int max = Global.getSettings().getInt("HA_patherBaseMax");
                    int points = -1 * Math.min(max, flat + perCell * Math.round(activeCells));
                    HAPatherBaseDestroyedFactor factor = new HAPatherBaseDestroyedFactor(points);
                    this.addFactor(factor);
                }
                return;
            }
        }
        boolean nearAny = false;
        for (StarSystemAPI system : Misc.getPlayerSystems(false)) {
            if (nearAny |= Misc.isNear(primaryWinner, system.getLocation())) break;
        }
        if (!nearAny) {
            return;
        }
        float fpDestroyed = 0.0f;
        CampaignFleetAPI first = null;
        for (CampaignFleetAPI otherFleet : battle.getNonPlayerSideSnapshot()) {
            for (FleetMemberAPI loss : Misc.getSnapshotMembersLost(otherFleet)) {
                fpDestroyed += (float)loss.getFleetPointCost();
                if (first != null) continue;
                first = otherFleet;
            }
        }
        int points = HostileActivityEventIntel.computeProgressPoints(fpDestroyed);
        if (points > 0) {
            HAShipsDestroyedFactor factor = new HAShipsDestroyedFactor(-1 * points);
            this.addFactor(factor);
        }
    }

    public static int computeProgressPoints(float fleetPointsDestroyed) {
        if (fleetPointsDestroyed <= 0.0f) {
            return 0;
        }
        int points = Math.round(fleetPointsDestroyed / FP_PER_POINT);
        if (points < 1) {
            points = 1;
        }
        return points;
    }

    @Override
    protected void notifyStageReached(BaseEventIntel.EventStageData stage) {
        if (stage.rollData instanceof HAERandomEventData) {
            HAERandomEventData data = (HAERandomEventData)stage.rollData;
            boolean fired = data.factor.fireEvent(this, stage);
            stage.rollData = null;
            if (stage.id == Stage.HA_EVENT) {
                int resetProgress = this.getResetProgress(fired);
                this.setProgress(resetProgress);
            }
        } else if (stage.id == Stage.HA_EVENT && (stage.rollData == null || "random_event_none".equals(stage.rollData))) {
            stage.rollData = null;
            int resetProgress = this.getResetProgress(false);
            this.setProgress(resetProgress);
        }
    }

    protected int getResetProgress(boolean fired) {
        if (!HABlowbackFactor.ENABLED) {
            this.blowback = 0;
        }
        int min = RESET_MIN;
        if (!fired) {
            min = RESET_MAX - 200;
        }
        int resetAdd = this.random.nextInt(RESET_MAX - min + 1);
        int resetProgress = min + (resetAdd = Math.min(resetAdd, this.random.nextInt(RESET_MAX - min + 1)));
        int add = Math.min(this.blowback, RESET_MAX - resetProgress);
        if (add > 0) {
            resetProgress += add;
            this.blowback -= add;
        }
        return resetProgress;
    }

    public void resetHA_EVENT() {
        BaseEventIntel.EventStageData stage = this.getDataFor((Object)Stage.HA_EVENT);
        int resetProgress = this.getResetProgress(false);
        this.resetRandomizedStage(stage);
        this.setProgress(resetProgress);
    }

    public void resetHA_EVENTIfFromFactor(HostileActivityFactor factor) {
        BaseEventIntel.EventStageData stage = this.getDataFor((Object)Stage.HA_EVENT);
        if (stage != null && stage.rollData instanceof HAERandomEventData && ((HAERandomEventData)stage.rollData).factor == factor) {
            this.resetHA_EVENT();
        }
    }

    @Override
    public void resetRandomizedStage(BaseEventIntel.EventStageData stage) {
        if (stage.rollData instanceof HAERandomEventData) {
            HAERandomEventData data = (HAERandomEventData)stage.rollData;
            data.isReset = true;
            data.factor.resetEvent(this, stage);
        }
        super.resetRandomizedStage(stage);
    }

    @Override
    public void rollRandomizedStage(BaseEventIntel.EventStageData stage) {
        if (stage.id == Stage.HA_EVENT || stage.id == Stage.MINOR_EVENT) {
            float total = 0.0f;
            for (EventFactor factor : this.factors) {
                if (!(factor instanceof BaseHostileActivityFactor)) continue;
                total += (float)factor.getProgress(this);
            }
            if (total < 1.0f) {
                total = 1.0f;
            }
            WeightedRandomPicker<BaseHostileActivityFactor> picker = new WeightedRandomPicker<BaseHostileActivityFactor>(this.random);
            for (EventFactor factor : this.factors) {
                if (!(factor instanceof BaseHostileActivityFactor)) continue;
                BaseHostileActivityFactor curr = (BaseHostileActivityFactor)factor;
                curr.setRandomizedStageSeed(this.random.nextLong());
                float f = curr.getEventFrequency(this, stage);
                float w = (float)factor.getProgress(this) / total;
                if (w > 0.0f) {
                    w = 0.1f + 0.9f * w;
                }
                picker.add(curr, f * w);
            }
            HostileActivityFactor pick = (HostileActivityFactor)picker.pickAndRemove();
            if (stage.id == Stage.HA_EVENT) {
                if (this.prevMajorEventPick == pick && !picker.isEmpty()) {
                    pick = (HostileActivityFactor)picker.pickAndRemove();
                }
                this.prevMajorEventPick = pick;
            }
            if (pick == null) {
                return;
            }
            stage.rollData = null;
            pick.rollEvent(this, stage);
        }
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Colony threats");
        return tags;
    }

    @Override
    public void addFactor(EventFactor factor) {
        int points;
        if (factor.isOneTime() && (points = factor.getProgress(this)) < 0) {
            int p = Math.round(-1.0f * (float)points * HABlowbackFactor.FRACTION);
            if ((p = Math.min(p, this.getProgress())) > 0) {
                this.addBlowback(p);
            }
        }
        super.addFactor(factor);
    }

    @Override
    public void reportEconomyMonthEnd() {
        super.reportEconomyMonthEnd();
        if (this.blowback > 0) {
            int amt = Math.round((float)this.blowback * HABlowbackFactor.PER_MONTH);
            float mult = 1.0f;
            for (EventFactor factor : this.factors) {
                if (factor.isOneTime()) continue;
                mult *= factor.getAllProgressMult(this);
            }
            if ((amt = Math.round((float)amt * mult)) < 1) {
                amt = 1;
            }
            this.blowback -= amt;
            if (this.blowback < 0) {
                this.blowback = 0;
            }
        }
    }

    public void addBlowback(int points) {
        if (!HABlowbackFactor.ENABLED) {
            return;
        }
        this.blowback += points;
    }

    public int getBlowback() {
        if (!HABlowbackFactor.ENABLED) {
            this.blowback = 0;
        }
        return this.blowback;
    }

    public void setBlowback(int blowback) {
        if (!HABlowbackFactor.ENABLED) {
            return;
        }
        this.blowback = blowback;
    }

    @Override
    protected String getSoundForOtherUpdate(Object param) {
        if (param instanceof HAERandomEventData) {
            HAERandomEventData data = (HAERandomEventData)param;
            if (data.isReset) {
                return null;
            }
            if (data.factor == null) {
                return null;
            }
            return data.factor.getEventStageSound(data);
        }
        return null;
    }

    @Override
    public int getMaxMonthlyProgress() {
        if (Misc.isEasy()) {
            return Global.getSettings().getInt("ha_maxMonthlyProgressEasy");
        }
        return Global.getSettings().getInt("ha_maxMonthlyProgress");
    }

    public static class HAEFactorDangerData {
        public HostileActivityFactor factor;
        public float mag;
    }

    public static class HAERandomEventData {
        public HostileActivityFactor factor;
        public BaseEventIntel.EventStageData stage;
        public boolean isReset = false;
        public Object custom;

        public HAERandomEventData(HostileActivityFactor factor, BaseEventIntel.EventStageData stage) {
            this.factor = factor;
            this.stage = stage;
        }
    }

    public static class HAEStarSystemDangerData {
        public StarSystemAPI system;
        public float maxMag;
        public float totalMag;
        public float sortMag;
        public List<HAEFactorDangerData> factorData = new ArrayList<HAEFactorDangerData>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        START,
        MINOR_EVENT,
        HA_EVENT,
        HA_1,
        HA_2,
        INCREASED_DEFENSES,
        HA_3,
        HA_4;

    }
}

