/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.People;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseHostileActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.rulecmd.KantaCMD;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Range;

public class KantasWrathPirateActivityCause2
extends BaseHostileActivityCause2 {
    public static float MAX_MAG = 0.3f;
    public static float MAX_MAG_FOR_REL = 0.15f;
    public static float MAX_MAG_FOR_BLUFFS = 0.15f;
    public static float MAG_PER_BLUFF = 0.05f;

    public KantasWrathPirateActivityCause2(HostileActivityEventIntel intel) {
        super(intel);
    }

    public TooltipMakerAPI.TooltipCreator getTooltip() {
        return new BaseFactorTooltip(){

            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                tooltip.addPara("\u519b\u9600 Kanta\uff0c\u8fd9\u4f4d\u4e3a\u4eba\u6240\u6050\u60e7\u7684\u6d77\u76d7\u5973\u738b\uff0c\u5bf9\u4f60\u611f\u5230\u4e0d\u6ee1\u3002\u67d0\u4e9b\u6d77\u76d7\u4f1a\u628a\u653b\u51fb\u4f60\u7684\u8d44\u4ea7\u4f5c\u4e3a\u8ba8\u597d\u5979\u7684\u65b9\u5f0f\u3002", 0.0f);
            }
        };
    }

    public int getProgress() {
        float mag = this.getMagnitudeContribution(null);
        if (mag <= 0.0f) {
            return 0;
        }
        if ((mag /= MAX_MAG) > 1.0f) {
            mag = 1.0f;
        }
        Range r = new Range("kantasWrathPoints");
        return r.interpInt(mag);
    }

    public String getDesc() {
        return "Kanta \u4e4b\u6012";
    }

    public float getMagnitudeContribution(StarSystemAPI system) {
        if (KantaCMD.playerHasProtection()) {
            return 0.0f;
        }
        PersonAPI kanta = People.getPerson(People.KANTA);
        if (kanta == null) {
            return 0.0f;
        }
        float rep = kanta.getRelToPlayer().getRel();
        float mag = -1.0f * rep * MAX_MAG_FOR_REL;
        int bluffs = Global.getSector().getCharacterData().getMemoryWithoutUpdate().getInt("$kantaBluffs");
        if ((mag += MAG_PER_BLUFF * (float)bluffs) > MAX_MAG) {
            mag = MAX_MAG;
        }
        mag = (float)Math.round(mag * 100.0f) / 100.0f;
        return mag;
    }
}

