/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.ColonyPlayerHostileActListener;
import com.fs.starfarer.api.campaign.listeners.ColonySizeChangeListener;
import com.fs.starfarer.api.impl.campaign.NPCHassler;
import com.fs.starfarer.api.impl.campaign.econ.LuddicMajority;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HAHersperusTacBombardmentFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.group.FGBlockadeAction;
import com.fs.starfarer.api.impl.campaign.intel.group.FleetGroupIntel;
import com.fs.starfarer.api.impl.campaign.intel.group.GenericRaidFGI;
import com.fs.starfarer.api.impl.campaign.intel.group.KnightsOfLuddTakeoverExpedition;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class LuddicChurchHostileActivityFactor
extends BaseHostileActivityFactor
implements FleetGroupIntel.FGIEventListener,
ColonyPlayerHostileActListener,
ColonySizeChangeListener {
    public static final String HASSLE_REASON = "sacredProtectors";
    public static final String DEFEATED_LUDDIC_CHURCH_EXPEDITION = "$defeatedLuddicChurchExpedition";
    public static final String MADE_IMMIGRATION_DEAL_WITH_LUDDIC_CHURCH = "$madeImmigrationDealWithLuddicChurch";
    public static final String BROKE_LUDDIC_CHURCH_DEAL = "$brokeLuddicChurchDeal";

    public static boolean isDefeatedExpedition() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(DEFEATED_LUDDIC_CHURCH_EXPEDITION);
    }

    public static void setDefeatedExpedition(boolean value) {
        Global.getSector().getPlayerMemoryWithoutUpdate().set(DEFEATED_LUDDIC_CHURCH_EXPEDITION, value);
    }

    public static boolean isMadeDeal() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(MADE_IMMIGRATION_DEAL_WITH_LUDDIC_CHURCH);
    }

    public static void setMadeDeal(boolean value) {
        Global.getSector().getPlayerMemoryWithoutUpdate().set(MADE_IMMIGRATION_DEAL_WITH_LUDDIC_CHURCH, value);
    }

    public static boolean brokeDeal() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(BROKE_LUDDIC_CHURCH_DEAL);
    }

    public static void setBrokeDeal(boolean broke) {
        Global.getSector().getPlayerMemoryWithoutUpdate().set(BROKE_LUDDIC_CHURCH_DEAL, broke);
    }

    public LuddicChurchHostileActivityFactor(HostileActivityEventIntel intel) {
        super(intel);
        Global.getSector().getListenerManager().addListener(this);
    }

    public String getProgressStr(BaseEventIntel intel) {
        return "";
    }

    public int getProgress(BaseEventIntel intel) {
        if (!LuddicChurchHostileActivityFactor.checkFactionExists("luddic_church", true)) {
            return 0;
        }
        return super.getProgress(intel);
    }

    public String getDesc(BaseEventIntel intel) {
        return "\u5362\u5fb7\u6559\u4f1a";
    }

    public String getNameForThreatList(boolean first) {
        return "\u5362\u5fb7\u9a91\u58eb\u56e2";
    }

    public Color getDescColor(BaseEventIntel intel) {
        if (this.getProgress(intel) <= 0) {
            return Misc.getGrayColor();
        }
        return Global.getSector().getFaction("luddic_church").getBaseUIColor();
    }

    public TooltipMakerAPI.TooltipCreator getMainRowTooltip(BaseEventIntel intel) {
        return new BaseFactorTooltip(){

            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                float opad = 10.0f;
                tooltip.addPara("\u4e00\u4e2a\u5e9e\u5927\u7684\u4fe1\u5f92\u7fa4\u4f53 \u2014\u2014 \u4e0d\u53d7\u76f4\u63a5\u63a7\u5236\uff0c\u4e14\u5177\u6709\u6210\u4e3a\u4e3b\u6d41\u6587\u5316\u4e2d\u5fc3\u7684\u98ce\u9669 \u2014\u2014 \u662f\u5362\u5fb7\u6559\u4f1a\u65e5\u76ca\u5173\u6ce8\u7684\u95ee\u9898\u3002\u5362\u5fb7\u9a91\u58eb\u56e2\u6240\u5c5e\u7684 \"\u4fdd\u62a4\u8005\" \u8230\u961f\u5c06\u51fa\u73b0\u5728\u4f60\u7684\u661f\u7cfb\u4e2d\uff0c\u5e76\u4ee5\u4fdd\u62a4\u5f53\u5730\u5362\u5fb7\u4fe1\u5f92\u5229\u76ca\u7684\u540d\u4e49\u884c\u5176\u6240\u6b32\u4e4b\u4e8b\u3002", 0.0f);
            }
        };
    }

    public boolean shouldShow(BaseEventIntel intel) {
        return this.getProgress(intel) > 0;
    }

    public Color getNameColor(float mag) {
        if (mag <= 0.0f) {
            return Misc.getGrayColor();
        }
        return Global.getSector().getFaction("luddic_church").getBaseUIColor();
    }

    public int getMaxNumFleets(StarSystemAPI system) {
        return Global.getSettings().getInt("luddicChurchMaxFleets");
    }

    public float getSpawnInHyperProbability(StarSystemAPI system) {
        return 0.0f;
    }

    public CampaignFleetAPI createFleet(StarSystemAPI system, Random random) {
        int maxSize = 0;
        for (MarketAPI curr : Misc.getMarketsInLocation(system, "player")) {
            maxSize = Math.max(curr.getSize(), maxSize);
        }
        int difficulty = maxSize + 1;
        if ((difficulty += random.nextInt(4)) > 10) {
            difficulty = 10;
        }
        FleetCreatorMission m = new FleetCreatorMission(random);
        m.beginFleet();
        Vector2f loc = system.getLocation();
        String factionId = "luddic_church";
        m.createStandardFleet(difficulty, factionId, loc);
        m.triggerSetFleetQuality(HubMissionWithTriggers.FleetQuality.HIGHER);
        m.triggerSetFleetType(HASSLE_REASON);
        m.triggerSetPatrol();
        m.triggerSetFleetHasslePlayer(HASSLE_REASON);
        m.triggerSetFleetFlag("$sacredProtectors");
        m.triggerFleetAllowLongPursuit();
        m.triggerMakeLowRepImpact();
        CampaignFleetAPI fleet = m.createFleet();
        if (fleet != null) {
            fleet.setName("\u5362\u5fb7\u9a91\u58eb\u56e2" + fleet.getName());
            fleet.setNoFactionInName(true);
            NPCHassler hassle = new NPCHassler(fleet, system);
            hassle.getParams().crDamageMult = 0.0f;
            fleet.addScript(hassle);
        }
        return fleet;
    }

    public void addBulletPointForEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        Color c = Global.getSector().getFaction("luddic_church").getBaseUIColor();
        info.addPara("\u8feb\u8fd1\u7684\u5362\u5fb7\u6559\u4f1a\u5ba3\u79f0\u593a\u5360", initPad, tc, c, "\u5362\u5fb7\u6559\u4f1a");
    }

    public void addBulletPointForEventReset(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        info.addPara("\u5362\u5fb7\u6559\u4f1a\u5ba3\u79f0\u593a\u5360 \u5df2\u907f\u514d", tc, initPad);
    }

    public void addStageDescriptionForEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info) {
        float small = 0.0f;
        float opad = 10.0f;
        small = 8.0f;
        LabelAPI label = info.addPara("\u4f60\u83b7\u77e5\u7684\u60c5\u62a5\u8868\u660e\uff0c\u5362\u5fb7\u6559\u4f1a\u5e87\u4e0b\u7684\u5362\u5fb7\u9a91\u58eb\u56e2\u6b63\u8ba1\u5212 \u593a\u5360\u4f60\u7684\u67d0\u4e2a\u6b96\u6c11\u5730 \uff0c\u56e0\u5176\u62e5\u6709\u5927\u91cf \u5362\u5fb7\u6559\u4f17 \u4eba\u53e3\u3002", small, Misc.getNegativeHighlightColor(), "\u593a\u5360\u4f60\u7684\u67d0\u4e2a\u6b96\u6c11\u5730");
        label.setHighlight("\u593a\u5360\u4f60\u7684\u67d0\u4e2a\u6b96\u6c11\u5730", "\u5362\u5fb7\u6559\u4f17");
        label.setHighlightColors(Misc.getNegativeHighlightColor(), Global.getSector().getFaction("luddic_church").getBaseUIColor());
        label = info.addPara("\u5982\u679c\u8fd9\u4e00\u8fdc\u5f81\u88ab\u51fb\u8d25\uff0c\u9003\u79bb\u5362\u5fb7\u6559\u4f1a\u7684\u5362\u5fb7\u4fe1\u5f92\u5c06\u611f\u5230\u66f4\u52a0\u5b89\u5168\uff0c\u81f4\u4f7f \u79fb\u6c11\u589e\u52a0\u3001\u7a33\u5b9a\u6027\u4e0e\u8bbe\u65bd\u751f\u4ea7\u529b\u63d0\u9ad8\uff0c\u4e14\u5362\u5fb7\u6559\u4f1a\u5c06\u5f88\u53ef\u80fd\u5f7b\u5e95\u653e\u5f03\u6b64\u7c7b\u884c\u52a8\u3002", opad);
        label.setHighlight("\u79fb\u6c11\u589e\u52a0\u3001\u7a33\u5b9a\u6027\u4e0e\u8bbe\u65bd\u751f\u4ea7\u529b\u63d0\u9ad8", "\u5362\u5fb7\u6559\u4f1a");
        label.setHighlightColors(Misc.getPositiveHighlightColor(), Global.getSector().getFaction("luddic_church").getBaseUIColor());
        Color c = Global.getSector().getFaction("luddic_church").getBaseUIColor();
        stage.beginResetReqList(info, true, "crisis", opad);
        info.addPara("\u4f60\u4e8e\u5362\u5fb7\u6559\u4f1a\u8fbe\u6210\u76f8\u5173\u534f\u8bae", 0.0f);
        info.addPara("\u6218\u672f\u8f70\u70b8 %s", 0.0f, c, "Hesperus");
        stage.endResetReqList(info, false, "crisis", -1, -1);
        this.addBorder(info, Global.getSector().getFaction("luddic_church").getBaseUIColor());
    }

    public String getEventStageIcon(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        return Global.getSector().getFaction("luddic_church").getCrest();
    }

    public TooltipMakerAPI.TooltipCreator getStageTooltipImpl(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        if (stage.id == HostileActivityEventIntel.Stage.HA_EVENT) {
            return this.getDefaultEventTooltip("\u5362\u5fb7\u6559\u4f1a\u8fdc\u5f81", intel, stage);
        }
        return null;
    }

    public float getEventFrequency(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        if (stage.id == HostileActivityEventIntel.Stage.HA_EVENT) {
            if (LuddicChurchHostileActivityFactor.isDefeatedExpedition() || LuddicChurchHostileActivityFactor.getHesperus(true) == null) {
                return 0.0f;
            }
            if (KnightsOfLuddTakeoverExpedition.get() != null) {
                return 0.0f;
            }
            MarketAPI target = this.findExpeditionTarget(intel, stage);
            MarketAPI source = this.getExpeditionSource(intel, stage, target);
            if (target != null && source != null) {
                return 20.0f;
            }
        }
        return 0.0f;
    }

    public void rollEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        HostileActivityEventIntel.HAERandomEventData data = new HostileActivityEventIntel.HAERandomEventData(this, stage);
        stage.rollData = data;
        intel.sendUpdateIfPlayerHasIntel((Object)data, false);
    }

    public boolean fireEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        MarketAPI target = this.findExpeditionTarget(intel, stage);
        MarketAPI source = this.getExpeditionSource(intel, stage, target);
        if (source == null || target == null) {
            return false;
        }
        stage.rollData = null;
        return this.startExpedition(source, target, stage, this.getRandomizedStageRandom(3));
    }

    public MarketAPI findExpeditionTarget(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        WeightedRandomPicker<MarketAPI> picker = new WeightedRandomPicker<MarketAPI>(this.getRandomizedStageRandom());
        for (MarketAPI market : Misc.getPlayerMarkets(false)) {
            if (market.getStarSystem() == null || !market.hasCondition("luddic_majority")) continue;
            float size = market.getSize();
            float w = Math.max(size - 3.0f, 1.0f);
            w = w * w * w;
            picker.add(market, w);
        }
        return (MarketAPI)picker.pick();
    }

    public MarketAPI getExpeditionSource(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, MarketAPI target) {
        return LuddicChurchHostileActivityFactor.getHesperus(true);
    }

    public static MarketAPI getHesperus(boolean requireMilitaryBase) {
        MarketAPI kazeron = Global.getSector().getEconomy().getMarket("hesperus");
        if (kazeron == null || kazeron.hasCondition("decivilized")) {
            return null;
        }
        if (requireMilitaryBase) {
            Industry b = kazeron.getIndustry("militarybase");
            if (b == null) {
                b = kazeron.getIndustry("highcommand");
            }
            if (b == null || b.isDisrupted() || !b.isFunctional()) {
                return null;
            }
        }
        return kazeron;
    }

    public boolean startExpedition(MarketAPI source, MarketAPI target, BaseEventIntel.EventStageData stage, Random random) {
        GenericRaidFGI.GenericRaidParams params = new GenericRaidFGI.GenericRaidParams(new Random(random.nextLong()), true);
        params.factionId = source.getFactionId();
        params.source = source;
        params.prepDays = 7.0f + random.nextFloat() * 14.0f;
        params.payloadDays = 180.0f;
        params.makeFleetsHostile = false;
        FGBlockadeAction.FGBlockadeParams bParams = new FGBlockadeAction.FGBlockadeParams();
        bParams.where = target.getStarSystem();
        bParams.targetFaction = "player";
        bParams.specificMarket = target;
        params.noun = "takeover";
        params.forcesNoun = "\u5362\u5fb7\u52bf\u529b";
        params.style = FleetCreatorMission.FleetStyle.STANDARD;
        params.fleetSizes.add(10);
        params.fleetSizes.add(4);
        params.fleetSizes.add(4);
        params.fleetSizes.add(3);
        params.fleetSizes.add(3);
        KnightsOfLuddTakeoverExpedition blockade = new KnightsOfLuddTakeoverExpedition(params, bParams);
        blockade.setListener(this);
        Global.getSector().getIntelManager().addIntel(blockade);
        return true;
    }

    public void reportFGIAborted(FleetGroupIntel intel) {
        LuddicChurchHostileActivityFactor.setDefeatedExpedition(true);
    }

    public void notifyFactorRemoved() {
        Global.getSector().getListenerManager().removeListener(this);
    }

    public void notifyEventEnding() {
        this.notifyFactorRemoved();
    }

    public void reportRaidForValuablesFinishedBeforeCargoShown(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData, CargoAPI cargo) {
    }

    public void reportRaidToDisruptFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData, Industry industry) {
    }

    public void reportTacticalBombardmentFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData) {
        BaseEventIntel.EventStageData stage;
        MarketAPI hesperus = LuddicChurchHostileActivityFactor.getHesperus(false);
        if (market != null && market == hesperus && (stage = this.intel.getDataFor((Object)HostileActivityEventIntel.Stage.HA_EVENT)) != null) {
            int points;
            boolean thisEvent;
            boolean bl = thisEvent = stage.rollData instanceof HostileActivityEventIntel.HAERandomEventData && ((HostileActivityEventIntel.HAERandomEventData)stage.rollData).factor == this;
            if (!thisEvent && (points = Global.getSettings().getInt("HA_tacBombardHesperus")) > 0) {
                this.intel.addFactor(new HAHersperusTacBombardmentFactor(-points));
            }
        }
    }

    public void reportSaturationBombardmentFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData) {
    }

    public void advance(float amount) {
        MarketAPI hesperus;
        super.advance(amount);
        BaseEventIntel.EventStageData stage = this.intel.getDataFor((Object)HostileActivityEventIntel.Stage.HA_EVENT);
        if (stage != null && stage.rollData instanceof HostileActivityEventIntel.HAERandomEventData && ((HostileActivityEventIntel.HAERandomEventData)stage.rollData).factor == this && (hesperus = LuddicChurchHostileActivityFactor.getHesperus(true)) == null) {
            this.intel.resetHA_EVENT();
        }
    }

    public void reportColonySizeChanged(MarketAPI market, int prevSize) {
        if (!market.isPlayerOwned()) {
            return;
        }
        boolean matches = LuddicMajority.matchesBonusConditions(market);
        if (market.hasCondition("luddic_majority") && !matches) {
            market.removeCondition("luddic_majority");
        } else if (!market.hasCondition("luddic_majority") && matches) {
            market.addCondition("luddic_majority");
        }
    }
}

