/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseHostileActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.LuddicChurchHostileActivityFactor;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;

public class LuddicChurchStandardActivityCause
extends BaseHostileActivityCause2 {
    public static float MAX_MAG = 0.3f;

    public LuddicChurchStandardActivityCause(HostileActivityEventIntel intel) {
        super(intel);
    }

    public TooltipMakerAPI.TooltipCreator getTooltip() {
        return new BaseFactorTooltip(){

            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                float opad = 10.0f;
                tooltip.addPara("\u4e0e\u5362\u5fb7\u6559\u4f1a\u5c31\u79fb\u6c11\u7ba1\u5236\u4e8b\u5b9c \u8fdb\u884c\u8c08\u5224 \u53ef\u80fd\u8ba9\u8fd9\u79cd\u9a9a\u6270\u505c\u6b62\u3002\u5982\u679c\u4e0d\u52a0\u4ee5\u63a7\u5236\uff0c\u8d77\u521d\u5fae\u5c0f\u7684\u51b2\u7a81\u7ec8\u5c06\u6fc0\u70c8\u7206\u53d1\uff0c\u5e76\u53ef\u80fd\u4ee5\u67d0\u79cd\u65b9\u5f0f\u5f97\u5230\u89e3\u51b3\u3002", 0.0f, Misc.getHighlightColor(), "\u8fdb\u884c\u8c08\u5224");
                FactionAPI f = Global.getSector().getFaction("luddic_church");
                tooltip.addPara("\u4e8b\u4ef6\u8fdb\u5c55\u5c06\u57fa\u4e8e\u4f60\u62e5\u6709 \"\u5362\u5fb7\u6559\u4f17\" \u7684\u6b96\u6c11\u5730\u7684\u6570\u91cf\u4e0e\u603b\u89c4\u6a21\u3002", opad, f.getBaseUIColor(), "\u5362\u5fb7\u6559\u4f17");
            }
        };
    }

    public int getProgress() {
        if (LuddicChurchHostileActivityFactor.isDefeatedExpedition()) {
            return 0;
        }
        if (LuddicChurchHostileActivityFactor.isMadeDeal()) {
            return 0;
        }
        int score = 0;
        for (MarketAPI market : Misc.getPlayerMarkets(false)) {
            if (!market.hasCondition("luddic_majority")) continue;
            int size = market.getSize();
            score += size;
        }
        int progress = score;
        return progress;
    }

    public String getDesc() {
        return "\u62e5\u6709\u5362\u5fb7\u6559\u4f17\u7684\u6b96\u6c11\u5730";
    }

    public float getMagnitudeContribution(StarSystemAPI system) {
        if (this.getProgress() <= 0) {
            return 0.0f;
        }
        float total = 0.0f;
        for (MarketAPI market : Misc.getMarketsInLocation(system, "player")) {
            if (!market.hasCondition("luddic_majority")) continue;
            total += (float)market.getSize();
        }
        float f = total / 6.0f;
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f * MAX_MAG;
    }
}

