/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.ListenerUtil;
import com.fs.starfarer.api.campaign.listeners.PatherCellListener;
import com.fs.starfarer.api.impl.campaign.ids.Sounds;
import com.fs.starfarer.api.impl.campaign.intel.MessageIntel;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathBaseIntel;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathBaseManager;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathCellsIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.group.FleetGroupIntel;
import com.fs.starfarer.api.impl.campaign.intel.group.GenericRaidFGI;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.rulecmd.HA_CMD;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.List;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class LuddicPathHostileActivityFactor
extends BaseHostileActivityFactor
implements PatherCellListener,
FleetGroupIntel.FGIEventListener {
    public static String DEFEATED_PATHER_EXPEDITION = "$defeatedPatherExpedition";
    public static String ATTACK_KEY = "$PatherAttack_ref";

    public static boolean isPlayerDefeatedPatherExpedition() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(DEFEATED_PATHER_EXPEDITION);
    }

    public static void setPlayerDefeatedPatherExpedition() {
        Global.getSector().getPlayerMemoryWithoutUpdate().set(DEFEATED_PATHER_EXPEDITION, true);
    }

    public LuddicPathHostileActivityFactor(HostileActivityEventIntel intel) {
        super(intel);
        Global.getSector().getListenerManager().addListener(this);
    }

    public String getProgressStr(BaseEventIntel intel) {
        return "";
    }

    public String getDesc(BaseEventIntel intel) {
        return "\u5362\u5fb7\u5de6\u5f84";
    }

    public String getNameForThreatList(boolean first) {
        if (first) {
            return "\u5362\u5fb7\u5de6\u5f84";
        }
        return "\u5362\u5fb7\u5de6\u5f84";
    }

    public Color getDescColor(BaseEventIntel intel) {
        if (this.getProgress(intel) <= 0) {
            return Misc.getGrayColor();
        }
        return Global.getSector().getFaction("luddic_path").getBaseUIColor();
    }

    public Color getNameColorForThreatList() {
        return Global.getSector().getFaction("luddic_path").getBaseUIColor();
    }

    public TooltipMakerAPI.TooltipCreator getMainRowTooltip(BaseEventIntel intel) {
        return new BaseFactorTooltip(){

            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                float opad = 10.0f;
                tooltip.addPara("\u5148\u8fdb\u79d1\u6280\u548c AI \u88ab\u5362\u5fb7\u5de6\u5f84\u89c6\u4f5c\u5669\u5146\u3002", 0.0f);
                tooltip.addPara("\u5de6\u5f84 \u8230\u961f\u591a\u4ee5\u5c0f\u578b\u8230\u961f\u4e3a\u4e3b\uff0c\u8fdb\u884c\u4fa6\u5bdf\u6216\u5411\u7f3a\u4e4f\u9632\u5907\u7684\u8239\u53ea\u6536\u53d6\u4ec0\u4e00\u7a0e\uff0c\u4f46\u6709\u65f6\u4e5f\u4f1a\u6709\u66f4\u5927\u7684\u52ab\u63a0\u8230\u961f\u51fa\u73b0\u3002", opad);
                LuddicPathHostileActivityFactor.addAgreementStatus(tooltip, opad);
            }
        };
    }

    public static void addAgreementStatus(TooltipMakerAPI tooltip, float initPad) {
        float opad = 10.0f;
        Color p = Misc.getPositiveHighlightColor();
        Color h = Misc.getHighlightColor();
        if (HA_CMD.playerHasPatherAgreement()) {
            if (!HA_CMD.playerPatherAgreementIsPermanent()) {
                float  = HA_CMD.getPlayerPatherAgreementDays();
                if ( < 1.0f &&  > 0.0f) {
                     = 1.0f;
                }
                 = Math.round();
                String dStr = "";
                if ((int) == 1) {
                    dStr = "";
                }
                tooltip.addPara("\u4f60 %s}\uff0c\u4ed6\u4eec\u5927\u90e8\u5206\u7684\u8230\u961f\u548c\u5728\u884c\u661f\u8868\u9762\u884c\u52a8\u7684\u5c0f\u7ec4\u90fd\u4e0d\u4f1a\u5728 %s \u5185\u627e\u4f60\u6b96\u6c11\u5730\u7684\u9ebb\u70e6" + dStr + "\u3002", initPad, new Color[]{p, h}, "\u652f\u4ed8\u4e86\u4ec0\u4e00\u7a0e", "" + (int));
            } else {
                tooltip.addPara("\u4f60\u548c\u5362\u5fb7\u5de6\u5f84\u8fbe\u6210\u4e86\u548c\u89e3\uff0c\u53ea\u8981\u4e0d\u51fa\u610f\u5916\uff0c\u4ed6\u4eec\u7684\u8230\u961f\u548c\u5728\u884c\u661f\u8868\u9762\u884c\u52a8\u7684\u5c0f\u7ec4\u90fd\u4e0d\u4f1a\u518d\u627e\u4f60\u6b96\u6c11\u5730\u7684\u9ebb\u70e6\u3002", initPad, p, "\u548c\u89e3");
            }
        } else {
            tooltip.addPara("\u4f60\u6709\u53ef\u80fd\u4e0e\u5362\u5fb7\u5de6\u5f84\u8fbe\u6210\u67d0\u79cd\u548c\u89e3\uff0c\u5982\u679c\u4f60\u80fd \u627e\u5230\u67d0\u4e2a\u6b63\u786e\u7684\u4eba \u5e76\u4e0e\u4e4b\u5546\u8ba8\u3002", initPad, h, "\u627e\u5230\u67d0\u4e2a\u6b63\u786e\u7684\u4eba");
        }
    }

    public boolean shouldShow(BaseEventIntel intel) {
        return this.getProgress(intel) > 0 || HA_CMD.playerHasPatherAgreement() && !HA_CMD.playerPatherAgreementIsPermanent();
    }

    public int getMaxNumFleets(StarSystemAPI system) {
        return Global.getSettings().getInt("luddicPathMaxFleets");
    }

    public CampaignFleetAPI createFleet(StarSystemAPI system, Random random) {
        float f = 0.0f;
        if ((f += this.getEffectMagnitude(system)) > 1.0f) {
            f = 1.0f;
        }
        float p = Global.getSettings().getFloat("luddicPathSmallFleetProb");
        boolean small = random.nextFloat() < p;
        int difficulty = 0;
        if (small) {
            difficulty = 1 + random.nextInt(2);
        } else {
            difficulty = 3;
            difficulty += Math.round(f * 5.0f);
            difficulty += random.nextInt(6);
        }
        FleetCreatorMission m = new FleetCreatorMission(random);
        m.beginFleet();
        Vector2f loc = system.getLocation();
        String factionId = "luddic_path";
        if (small) {
            m.createStandardFleet(difficulty, factionId, loc);
        } else {
            m.createStandardFleet(difficulty, factionId, loc);
        }
        m.triggerSetPirateFleet();
        m.triggerMakeLowRepImpact();
        if (!small) {
            m.triggerFleetAllowLongPursuit();
        }
        CampaignFleetAPI fleet = m.createFleet();
        return fleet;
    }

    public void notifyFactorRemoved() {
        Global.getSector().getListenerManager().removeListener(this);
    }

    public void notifyEventEnding() {
        this.notifyFactorRemoved();
    }

    public static HAPatherCellsEventData getPatherCellData(BaseEventIntel.EventStageData stage) {
        if (stage == null) {
            return null;
        }
        if (stage.rollData instanceof HostileActivityEventIntel.HAERandomEventData) {
            HostileActivityEventIntel.HAERandomEventData data = (HostileActivityEventIntel.HAERandomEventData)stage.rollData;
            if (data.custom instanceof HAPatherCellsEventData) {
                HAPatherCellsEventData attackData = (HAPatherCellsEventData)data.custom;
                return attackData;
            }
        }
        return null;
    }

    public void addBulletPointForEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        HAPatherCellsEventData data = LuddicPathHostileActivityFactor.getPatherCellData(stage);
        Color c = Global.getSector().getFaction("luddic_path").getBaseUIColor();
        if (data == null) {
            return;
        }
        LabelAPI label = info.addPara("\u8ff9\u8c61\u8868\u660e \u5362\u5fb7\u5de6\u5f84 \u5373\u5c06\u653b\u51fb %s", initPad, tc, tc, data.market.getName());
        label.setHighlight("\u5362\u5fb7\u5de6\u5f84", data.market.getName());
        label.setHighlightColors(c, Misc.getBasePlayerColor());
    }

    public void addBulletPointForEventReset(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        info.addPara("\u5362\u5fb7\u5de6\u5f84\u88ad\u51fb \u5df2\u907f\u514d", tc, initPad);
    }

    public void addStageDescriptionForEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info) {
        HAPatherCellsEventData data = LuddicPathHostileActivityFactor.getPatherCellData(stage);
        if (data == null) {
            return;
        }
        Color c = Global.getSector().getFaction("luddic_path").getBaseUIColor();
        float small = 0.0f;
        float opad = 10.0f;
        small = 8.0f;
        LabelAPI label = info.addPara("\u6709\u8ff9\u8c61\u8868\u660e \u5362\u5fb7\u5de6\u5f84 \u5373\u5c06\u653b\u51fb %s}\u3002\u5982\u679c\u6b64\u6b21\u653b\u51fb\u6210\u529f\uff0c\u76ee\u6807\u6b96\u6c11\u5730\u5c06\u88ab \u9971\u548c\u8f70\u70b8\u3002", small, c, data.market.getName());
        label.setHighlight(data.market.getName(), "\u9971\u548c\u8f70\u70b8");
        label.setHighlightColors(Misc.getBasePlayerColor(), Misc.getNegativeHighlightColor());
        info.addPara("\u5362\u5fb7\u5de6\u5f84\u4fe1\u5f92\u4e3a\u6b64\u6b21\u88ad\u51fb\u6295\u5165\u4e86\u5de8\u91cf\u8d44\u6e90\u3002\u5982\u679c\u5b83\u88ab\u51fb\u8d25\uff0c\u90a3\u4e48\u5168\u661f\u57df\u8303\u56f4\u5185\u7684\u5de6\u5f84\u6d3b\u52a8\u90fd\u5c06\u6682\u65f6 \u762b\u75ea\u3002", opad, Misc.getPositiveHighlightColor(), "\u762b\u75ea");
        stage.beginResetReqList(info, true, "\u5371\u673a", opad);
        label = info.addPara("\u4f4d\u4e8e %s \u7684\u5de6\u5f84\u72c2\u4fe1\u5f92\u5df2\u88ab\u762b\u75ea", 0.0f, Misc.getBasePlayerColor(), data.market.getName());
        label.setHighlight("\u5362\u5fb7\u5de6\u5f84", data.market.getName());
        label.setHighlightColors(c, Misc.getBasePlayerColor());
        info.addPara("\u4e0e\u5362\u5fb7\u5de6\u5f84\u8fbe\u6210\u67d0\u79cd\u548c\u89e3", 0.0f, Global.getSector().getFaction("luddic_path").getBaseUIColor(), "\u5362\u5fb7\u5de6\u5f84");
        stage.endResetReqList(info, false, "\u5371\u673a", -1, -1);
        this.addBorder(info, Global.getSector().getFaction("luddic_path").getBaseUIColor());
    }

    public String getEventStageIcon(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        return Global.getSector().getFaction("luddic_path").getCrest();
    }

    public TooltipMakerAPI.TooltipCreator getStageTooltipImpl(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        if (stage.id == HostileActivityEventIntel.Stage.HA_EVENT) {
            return this.getDefaultEventTooltip("\u5362\u5fb7\u5de6\u5f84\u88ad\u51fb", intel, stage);
        }
        return null;
    }

    public float getEventFrequency(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        if (HA_CMD.playerHasPatherAgreement()) {
            return 0.0f;
        }
        if (stage.id == HostileActivityEventIntel.Stage.HA_EVENT && this.pickTargetMarket() != null) {
            return 10.0f;
        }
        return 0.0f;
    }

    public MarketAPI pickTargetMarket() {
        WeightedRandomPicker<MarketAPI> picker = new WeightedRandomPicker<MarketAPI>(this.getRandomizedStageRandom());
        for (MarketAPI market : Misc.getPlayerMarkets(false)) {
            LuddicPathCellsIntel cells;
            if (market.getDaysInExistence() < 180.0f && !Global.getSettings().isDevMode() || (cells = LuddicPathCellsIntel.getCellsForMarket(market)) == null || cells.isSleeper()) continue;
            float w = LuddicPathBaseManager.getLuddicPathMarketInterest(market);
            picker.add(market, w * w);
        }
        return (MarketAPI)picker.pick();
    }

    public void rollEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        MarketAPI market = this.pickTargetMarket();
        LuddicPathCellsIntel cells = LuddicPathCellsIntel.getCellsForMarket(market);
        if (market == null || cells == null) {
            return;
        }
        HostileActivityEventIntel.HAERandomEventData data = new HostileActivityEventIntel.HAERandomEventData(this, stage);
        data.custom = new HAPatherCellsEventData(cells, market);
        stage.rollData = data;
        intel.sendUpdateIfPlayerHasIntel((Object)data, false);
    }

    public boolean fireEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        HAPatherCellsEventData data = LuddicPathHostileActivityFactor.getPatherCellData(stage);
        if (data == null || data.market == null || data.cells == null || data.cells.isSleeper()) {
            return false;
        }
        if (!data.market.isInEconomy()) {
            return false;
        }
        LuddicPathBaseIntel base = LuddicPathCellsIntel.getClosestBase(data.market);
        if (base == null) {
            return false;
        }
        StarSystemAPI system = data.market.getStarSystem();
        if (system == null) {
            return false;
        }
        return this.startRaid(base.getMarket(), data.market, data.interest, system, stage, this.getRandomizedStageRandom(3));
    }

    public void reportCellsDisrupted(LuddicPathCellsIntel cell) {
        BaseEventIntel.EventStageData stage = this.intel.getDataFor((Object)HostileActivityEventIntel.Stage.HA_EVENT);
        HAPatherCellsEventData data = LuddicPathHostileActivityFactor.getPatherCellData(stage);
        if (data != null && data.cells == cell && stage.rollData != null) {
            this.intel.resetHA_EVENT();
        }
    }

    public static void avertOrAbortAttack() {
        HostileActivityEventIntel intel;
        if (GenericRaidFGI.get(ATTACK_KEY) != null) {
            GenericRaidFGI.get(ATTACK_KEY).finish(false);
        }
        if ((intel = HostileActivityEventIntel.get()) == null) {
            return;
        }
        BaseEventIntel.EventStageData stage = intel.getDataFor((Object)HostileActivityEventIntel.Stage.HA_EVENT);
        HAPatherCellsEventData data = LuddicPathHostileActivityFactor.getPatherCellData(stage);
        if (data != null && stage.rollData != null) {
            intel.resetHA_EVENT();
        }
    }

    public boolean startRaid(MarketAPI source, MarketAPI target, float interest, StarSystemAPI system, BaseEventIntel.EventStageData stage, Random random) {
        GenericRaidFGI.GenericRaidParams params = new GenericRaidFGI.GenericRaidParams(new Random(random.nextLong()), true);
        params.factionId = source.getFactionId();
        params.source = source;
        params.prepDays = 14.0f + random.nextFloat() * 14.0f;
        params.payloadDays = 27.0f + 7.0f * random.nextFloat();
        params.raidParams.where = system;
        params.raidParams.allowedTargets.add(target);
        params.raidParams.allowNonHostileTargets = true;
        params.raidParams.setBombardment(MarketCMD.BombardType.SATURATION);
        params.style = FleetCreatorMission.FleetStyle.STANDARD;
        float w = interest;
        w += Math.max(0.0f, (float)(target.getSize() - 2)) * 10.0f;
        if (w < 0.0f) {
            w = 0.0f;
        }
        if (w > 50.0f) {
            w = 50.0f;
        }
        float f = w / 50.0f;
        float totalDifficulty = (0.25f + f * 0.75f) * 40.0f;
        Random r = this.getRandomizedStageRandom(7);
        if (r.nextFloat() < 0.33f) {
            params.style = FleetCreatorMission.FleetStyle.QUANTITY;
        }
        while (totalDifficulty > 0.0f) {
            int diff = (int)Math.min(10.0f, totalDifficulty);
            if (diff < 2) {
                diff = 2;
            }
            params.fleetSizes.add(diff);
            totalDifficulty -= (float)diff;
        }
        LuddicPathBaseIntel base = LuddicPathBaseIntel.getIntelFor(source);
        if (base != null && Misc.isHiddenBase(source) && !base.isPlayerVisible()) {
            base.makeKnown();
            base.sendUpdateIfPlayerHasIntel(LuddicPathBaseIntel.DISCOVERED_PARAM, false);
        }
        params.memoryKey = ATTACK_KEY;
        GenericRaidFGI raid = new GenericRaidFGI(params);
        raid.setListener(this);
        Global.getSector().getIntelManager().addIntel(raid);
        return true;
    }

    public void reportFGIAborted(FleetGroupIntel intel) {
        LuddicPathHostileActivityFactor.setPlayerDefeatedPatherExpedition();
        MessageIntel msg = new MessageIntel();
        msg.addLine("\u5362\u5fb7\u5de6\u5f84 \u5c0f\u7ec4 \u5df2\u88ab\u762b\u75ea", Misc.getBasePlayerColor());
        msg.setIcon(Global.getSettings().getSpriteName("intel", "sleeper_cells"));
        msg.setSound(Sounds.REP_GAIN);
        Global.getSector().getCampaignUI().addMessage(msg, CommMessageAPI.MessageClickAction.COLONY_INFO);
        List<IntelInfoPlugin> cells = Global.getSector().getIntelManager().getIntel(LuddicPathCellsIntel.class);
        for (IntelInfoPlugin curr : cells) {
            LuddicPathCellsIntel cell = (LuddicPathCellsIntel)curr;
            cell.makeSleeper(Global.getSettings().getFloat("patherCellDisruptionDuration"));
            ListenerUtil.reportCellDisrupted(cell);
        }
    }

    public static class HAPatherCellsEventData {
        public LuddicPathCellsIntel cells;
        public MarketAPI market;
        public float interest;

        public HAPatherCellsEventData(LuddicPathCellsIntel cells, MarketAPI market) {
            this.cells = cells;
            this.market = market;
            this.interest = LuddicPathBaseManager.getLuddicPathMarketInterest(market);
        }
    }
}

