/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.ColonyPlayerHostileActListener;
import com.fs.starfarer.api.impl.campaign.NPCHassler;
import com.fs.starfarer.api.impl.campaign.intel.PerseanLeagueMembership;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HAKazeronTacBombardmentFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.group.FGBlockadeAction;
import com.fs.starfarer.api.impl.campaign.intel.group.FleetGroupIntel;
import com.fs.starfarer.api.impl.campaign.intel.group.GenericRaidFGI;
import com.fs.starfarer.api.impl.campaign.intel.group.PerseanLeagueBlockade;
import com.fs.starfarer.api.impl.campaign.intel.group.PerseanLeaguePunitiveExpedition;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class PerseanLeagueHostileActivityFactor
extends BaseHostileActivityFactor
implements FleetGroupIntel.FGIEventListener,
ColonyPlayerHostileActListener {
    public static final String HASSLE_REASON = "leagueEnforcer";
    public static float INDEPENDENT_REP_FOR_DEFEATING = 0.5f;
    public static float HEGEMONY_REP_FOR_DEFEATING = 0.3f;

    public PerseanLeagueHostileActivityFactor(HostileActivityEventIntel intel) {
        super(intel);
        Global.getSector().getListenerManager().addListener(this);
    }

    public String getProgressStr(BaseEventIntel intel) {
        return "";
    }

    public int getProgress(BaseEventIntel intel) {
        if (!PerseanLeagueHostileActivityFactor.checkFactionExists("persean", true)) {
            return 0;
        }
        return super.getProgress(intel);
    }

    public String getDesc(BaseEventIntel intel) {
        return "\u82f1\u4ed9\u5ea7\u8054\u76df";
    }

    public String getNameForThreatList(boolean first) {
        return "\u82f1\u4ed9\u5ea7\u8054\u76df";
    }

    public Color getDescColor(BaseEventIntel intel) {
        if (this.getProgress(intel) <= 0) {
            return Misc.getGrayColor();
        }
        return Global.getSector().getFaction("persean").getBaseUIColor();
    }

    public TooltipMakerAPI.TooltipCreator getMainRowTooltip(BaseEventIntel intel) {
        return new BaseFactorTooltip(){

            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                float opad = 10.0f;
                tooltip.addPara("\u4e00\u4e2a\u5e9e\u5927\u7684\u72ec\u7acb\u653f\u4f53\u5bf9\u82f1\u4ed9\u5ea7\u8054\u76df\u800c\u8a00\u76f8\u5f53\u5177\u6709\u8bf1\u60d1\u529b\uff0c\u4ed6\u4eec\u4f1a\u6fc0\u70c8\u5730\u5411\u4f60\u65bd\u538b\uff0c\u903c\u8feb\u4f60\u52a0\u5165\u4ed6\u4eec\u3002\u8054\u76df\u7684 \"\u6267\u6cd5\u8005\" \u8230\u961f\u5c06\u5f98\u5f8a\u4e8e\u4f60\u7684\u661f\u7cfb\u4e2d\uff0c\u5e76\u4ee5\u4fdd\u62a4\u8054\u76df\u5728 \"\u65e0\u5ba3\u79f0\u9886\u571f\" \u5185\u5229\u76ca\u7684\u540d\u4e49\u884c\u5176\u6240\u6b32\u4e4b\u4e8b\u3002", 0.0f);
            }
        };
    }

    public boolean shouldShow(BaseEventIntel intel) {
        return this.getProgress(intel) > 0;
    }

    public Color getNameColor(float mag) {
        if (mag <= 0.0f) {
            return Misc.getGrayColor();
        }
        return Global.getSector().getFaction("persean").getBaseUIColor();
    }

    public int getMaxNumFleets(StarSystemAPI system) {
        return Global.getSettings().getInt("perseanLeagueMaxFleets");
    }

    public float getSpawnInHyperProbability(StarSystemAPI system) {
        return 0.0f;
    }

    public CampaignFleetAPI createFleet(StarSystemAPI system, Random random) {
        float f = this.intel.getMarketPresenceFactor(system);
        int difficulty = 0 + (int)Math.max(1.0f, (float)Math.round(f * 4.0f));
        FleetCreatorMission m = new FleetCreatorMission(random);
        m.beginFleet();
        Vector2f loc = system.getLocation();
        String factionId = "persean";
        m.createStandardFleet(difficulty += random.nextInt(6), factionId, loc);
        m.triggerSetFleetType(HASSLE_REASON);
        m.triggerSetPatrol();
        m.triggerSetFleetHasslePlayer(HASSLE_REASON);
        m.triggerSetFleetFlag("$leagueEnforcer");
        m.triggerFleetAllowLongPursuit();
        m.triggerMakeLowRepImpact();
        CampaignFleetAPI fleet = m.createFleet();
        if (fleet != null) {
            fleet.addScript(new NPCHassler(fleet, system));
        }
        return fleet;
    }

    public void addBulletPointForEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        Color c = Global.getSector().getFaction("persean").getBaseUIColor();
        info.addPara("\u8feb\u8fd1\u7684\u82f1\u4ed9\u5ea7\u8054\u76df\u5c01\u9501", initPad, tc, c, "\u82f1\u4ed9\u5ea7\u8054\u76df");
    }

    public void addBulletPointForEventReset(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        info.addPara("\u82f1\u4ed9\u5ea7\u8054\u76df\u5c01\u9501 \u5df2\u907f\u514d", tc, initPad);
    }

    public void addStageDescriptionForEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info) {
        float small = 0.0f;
        float opad = 10.0f;
        small = 8.0f;
        info.addPara("\u4f60\u83b7\u77e5\u7684\u60c5\u62a5\u8868\u660e\uff0c\u82f1\u4ed9\u5ea7\u8054\u76df\u6b63\u8ba1\u5212\u5bf9\u4f60\u7684\u67d0\u4e2a\u661f\u7cfb\u8fdb\u884c\u957f\u671f\u5c01\u9501\u3002\u8be5\u661f\u7cfb\u5185\u7684\u6b96\u6c11\u5730\u5c06\u6301\u7eed\u906d\u53d7 \u4e25\u91cd\u7684\u6d41\u901a\u6027\u60e9\u7f5a \u76f4\u81f3\u5c01\u9501\u7ed3\u675f\u3002", small, Misc.getNegativeHighlightColor(), "\u4e25\u91cd\u7684\u6d41\u901a\u6027\u60e9\u7f5a");
        LabelAPI label = info.addPara("\u5982\u679c\u5c01\u9501\u8230\u961f\u88ab\u51fb\u8d25\uff0c\u4f60\u4e0e \u9738\u4e3b \u4ee5\u53ca\u5404 \u975e\u52bf\u529b\u56e2\u4f53 \u7684\u5173\u7cfb\u5c06 \u5927\u5e45\u63d0\u9ad8\uff0c\u82f1\u4ed9\u5ea7\u8054\u76df \u5c06\u5f88\u53ef\u80fd\u5f7b\u5e95\u653e\u5f03\u5bf9\u4f60\u4f7f\u7528\u5f3a\u786c\u624b\u6bb5\uff0c\u5e76\u66f4\u613f\u610f\u4e0e\u4f60\u8c08\u5224\u3002", opad);
        label.setHighlight("\u9738\u4e3b", "independents", "\u5927\u5e45\u63d0\u9ad8", "\u82f1\u4ed9\u5ea7\u8054\u76df");
        label.setHighlightColors(Global.getSector().getFaction("hegemony").getBaseUIColor(), Global.getSector().getFaction("independent").getBaseUIColor(), Misc.getPositiveHighlightColor(), Global.getSector().getFaction("persean").getBaseUIColor());
        Color c = Global.getSector().getFaction("persean").getBaseUIColor();
        stage.beginResetReqList(info, true, "crisis", opad);
        info.addPara("\u524d\u5f80 %s \u5e76\u5c31\u52a0\u5165\u8054\u76df\u4e8b\u5b9c\u8fbe\u6210\u534f\u8bae", 0.0f, c, "Kazeron");
        info.addPara("\u6218\u672f\u8f70\u70b8 %s", 0.0f, c, "Kazeron");
        stage.endResetReqList(info, false, "crisis", -1, -1);
        this.addBorder(info, Global.getSector().getFaction("persean").getBaseUIColor());
    }

    public String getEventStageIcon(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        return Global.getSector().getFaction("persean").getCrest();
    }

    public TooltipMakerAPI.TooltipCreator getStageTooltipImpl(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        if (stage.id == HostileActivityEventIntel.Stage.HA_EVENT) {
            return this.getDefaultEventTooltip("\u82f1\u4ed9\u5ea7\u8054\u76df\u5c01\u9501", intel, stage);
        }
        return null;
    }

    public float getEventFrequency(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        if (stage.id == HostileActivityEventIntel.Stage.HA_EVENT) {
            if (PerseanLeagueHostileActivityFactor.wasPLEverSatBombardedByPlayer() || PerseanLeagueHostileActivityFactor.getKazeron(true) == null) {
                return 0.0f;
            }
            if (PerseanLeagueBlockade.get() != null) {
                return 0.0f;
            }
            if (PerseanLeaguePunitiveExpedition.get() != null) {
                return 0.0f;
            }
            StarSystemAPI target = PerseanLeagueHostileActivityFactor.findBlockadeTarget(intel, stage);
            MarketAPI source = this.getBlockadeSource(intel, stage, target);
            if (target != null && source != null) {
                return 10.0f;
            }
        }
        return 0.0f;
    }

    public void rollEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        HostileActivityEventIntel.HAERandomEventData data = new HostileActivityEventIntel.HAERandomEventData(this, stage);
        stage.rollData = data;
        intel.sendUpdateIfPlayerHasIntel((Object)data, false);
    }

    public boolean fireEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        StarSystemAPI target = PerseanLeagueHostileActivityFactor.findBlockadeTarget(intel, stage);
        MarketAPI source = this.getBlockadeSource(intel, stage, target);
        if (source == null || target == null) {
            return false;
        }
        stage.rollData = null;
        return this.startBlockade(source, target, stage, this.getRandomizedStageRandom(3));
    }

    public static StarSystemAPI findBlockadeTarget(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        float max = 0.0f;
        StarSystemAPI best = null;
        for (StarSystemAPI system : Misc.getPlayerSystems(false)) {
            float w = intel.getMarketPresenceFactor(system);
            if (!(w > max)) continue;
            max = w;
            best = system;
        }
        return best;
    }

    public MarketAPI getBlockadeSource(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, StarSystemAPI target) {
        return PerseanLeagueHostileActivityFactor.getKazeron(true);
    }

    public static MarketAPI getKazeron(boolean requireMilitaryBase) {
        MarketAPI kazeron = Global.getSector().getEconomy().getMarket("kazeron");
        if (kazeron == null || kazeron.hasCondition("decivilized")) {
            return null;
        }
        if (requireMilitaryBase) {
            Industry b = kazeron.getIndustry("militarybase");
            if (b == null) {
                b = kazeron.getIndustry("highcommand");
            }
            if (b == null || b.isDisrupted() || !b.isFunctional()) {
                return null;
            }
        }
        return kazeron;
    }

    public static boolean wasPLEverSatBombardedByPlayer() {
        FactionAPI faction = Global.getSector().getFaction("persean");
        if (faction != null) {
            return faction.getMemoryWithoutUpdate().getInt("$numTimesSatBombardedByPlayer") > 0;
        }
        return false;
    }

    public boolean startBlockade(MarketAPI source, StarSystemAPI target, BaseEventIntel.EventStageData stage, Random random) {
        float f;
        GenericRaidFGI.GenericRaidParams params = new GenericRaidFGI.GenericRaidParams(new Random(random.nextLong()), true);
        params.factionId = source.getFactionId();
        params.source = source;
        params.prepDays = 7.0f + random.nextFloat() * 14.0f;
        params.payloadDays = 365.0f;
        params.makeFleetsHostile = false;
        FGBlockadeAction.FGBlockadeParams bParams = new FGBlockadeAction.FGBlockadeParams();
        bParams.where = target;
        bParams.targetFaction = "player";
        params.style = FleetCreatorMission.FleetStyle.STANDARD;
        float fleetSizeMult = source.getStats().getDynamic().getMod("combat_fleet_size_mult").computeEffective(0.0f);
        float totalDifficulty = fleetSizeMult * 50.0f * (0.5f + 0.5f * (f = this.intel.getMarketPresenceFactor(target)));
        if (totalDifficulty < 30.0f) {
            return false;
        }
        if (totalDifficulty > 100.0f) {
            totalDifficulty = 100.0f;
        }
        totalDifficulty -= 10.0f;
        totalDifficulty -= 5.0f;
        totalDifficulty -= 4.0f;
        totalDifficulty -= 1.0f;
        totalDifficulty -= 1.0f;
        params.fleetSizes.add(10);
        params.fleetSizes.add(5);
        params.fleetSizes.add(4);
        params.fleetSizes.add(1);
        params.fleetSizes.add(1);
        Random r = this.getRandomizedStageRandom(7);
        while (totalDifficulty > 0.0f) {
            float max = 5.0f;
            float min = 3.0f;
            if (r.nextFloat() > 0.3f) {
                min = (int)Math.min(totalDifficulty, 10.0f);
                max = (int)Math.min(totalDifficulty, 10.0f);
            }
            int diff = Math.round(StarSystemGenerator.getNormalRandom(r, min, max));
            params.fleetSizes.add(diff);
            totalDifficulty -= (float)diff;
        }
        PerseanLeagueBlockade blockade = new PerseanLeagueBlockade(params, bParams);
        blockade.setListener(this);
        Global.getSector().getIntelManager().addIntel(blockade);
        return true;
    }

    public void reportFGIAborted(FleetGroupIntel intel) {
        PerseanLeagueMembership.setDefeatedBlockade(true);
        Misc.adjustRep("hegemony", HEGEMONY_REP_FOR_DEFEATING, null);
        Misc.adjustRep("independent", INDEPENDENT_REP_FOR_DEFEATING, null);
    }

    public void notifyFactorRemoved() {
        Global.getSector().getListenerManager().removeListener(this);
    }

    public void notifyEventEnding() {
        this.notifyFactorRemoved();
    }

    public void reportRaidForValuablesFinishedBeforeCargoShown(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData, CargoAPI cargo) {
    }

    public void reportRaidToDisruptFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData, Industry industry) {
    }

    public void reportTacticalBombardmentFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData) {
        BaseEventIntel.EventStageData stage;
        MarketAPI kazeron = PerseanLeagueHostileActivityFactor.getKazeron(false);
        if (market != null && market == kazeron && (stage = this.intel.getDataFor((Object)HostileActivityEventIntel.Stage.HA_EVENT)) != null) {
            int points;
            boolean thisEvent;
            boolean bl = thisEvent = stage.rollData instanceof HostileActivityEventIntel.HAERandomEventData && ((HostileActivityEventIntel.HAERandomEventData)stage.rollData).factor == this;
            if (!thisEvent && (points = Global.getSettings().getInt("HA_tacBombardKazeron")) > 0) {
                this.intel.addFactor(new HAKazeronTacBombardmentFactor(-points));
            }
        }
    }

    public void reportSaturationBombardmentFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData) {
    }

    public void advance(float amount) {
        MarketAPI kazeron;
        super.advance(amount);
        BaseEventIntel.EventStageData stage = this.intel.getDataFor((Object)HostileActivityEventIntel.Stage.HA_EVENT);
        if (stage != null && stage.rollData instanceof HostileActivityEventIntel.HAERandomEventData && ((HostileActivityEventIntel.HAERandomEventData)stage.rollData).factor == this && ((kazeron = PerseanLeagueHostileActivityFactor.getKazeron(true)) == null || PerseanLeagueHostileActivityFactor.wasPLEverSatBombardedByPlayer())) {
            this.intel.resetHA_EVENT();
        }
    }
}

