/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.campaign.econ.EconomyAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.econ.PiracyRespite;
import com.fs.starfarer.api.impl.campaign.ids.Sounds;
import com.fs.starfarer.api.impl.campaign.intel.MessageIntel;
import com.fs.starfarer.api.util.Misc;

public class PiracyRespiteScript
implements EconomyAPI.EconomyUpdateListener {
    public static String KEY = "$prs_ref";
    public static float DURATION = -1.0f;
    protected long timestamp;

    public static PiracyRespiteScript get() {
        return (PiracyRespiteScript)Global.getSector().getMemoryWithoutUpdate().get(KEY);
    }

    public PiracyRespiteScript() {
        this.sendGainedMessage();
        PiracyRespiteScript existing = PiracyRespiteScript.get();
        if (existing != null) {
            existing.resetTimestamp();
            return;
        }
        this.resetTimestamp();
        Global.getSector().getEconomy().addUpdateListener(this);
        Global.getSector().getMemoryWithoutUpdate().set(KEY, this);
        this.economyUpdated();
    }

    public void sendGainedMessage() {
        MessageIntel msg = new MessageIntel();
        msg.addLine("\u6d77\u76d7\u6d3b\u52a8\u51cf\u7f13", Misc.getBasePlayerColor());
        msg.addLine("    - \u6b96\u6c11\u5730 %s \u6d41\u901a\u6027", Misc.getTextColor(), new String[]{"+" + Math.round(PiracyRespite.ACCESSIBILITY_BONUS * 100.0f) + "%"}, Misc.getHighlightColor());
        if (DURATION > 0.0f) {
            msg.addLine("    - \u6301\u7eed %s \u5929", Misc.getTextColor(), new String[]{"" + (int)DURATION}, Misc.getHighlightColor());
        }
        msg.setIcon(Global.getSettings().getSpriteName("events", "piracy_respite"));
        msg.setSound(Sounds.REP_GAIN);
        Global.getSector().getCampaignUI().addMessage(msg, CommMessageAPI.MessageClickAction.COLONY_INFO);
    }

    public void sendExpiredMessage() {
        MessageIntel msg = new MessageIntel();
        msg.addLine("\u6d77\u76d7\u6d3b\u52a8\u51cf\u7f13 \u5df2\u7ed3\u675f", Misc.getBasePlayerColor());
        msg.setIcon(Global.getSettings().getSpriteName("events", "piracy_respite"));
        msg.setSound(Sounds.REP_LOSS);
        Global.getSector().getCampaignUI().addMessage(msg, CommMessageAPI.MessageClickAction.COLONY_INFO);
    }

    public void resetTimestamp() {
        this.timestamp = Global.getSector().getClock().getTimestamp();
    }

    public float getDaysRemaining() {
        if (DURATION < 0.0f) {
            return DURATION;
        }
        float rem = DURATION - Global.getSector().getClock().getElapsedDaysSince(this.timestamp);
        if (rem < 0.0f) {
            rem = 0.0f;
        }
        return rem;
    }

    public void commodityUpdated(String commodityId) {
    }

    public void economyUpdated() {
        for (MarketAPI curr : Misc.getPlayerMarkets(false)) {
            if (curr.hasCondition("piracy_respite")) continue;
            curr.addCondition("piracy_respite");
        }
    }

    public void cleanup() {
        if (Global.getSector().getMemoryWithoutUpdate().contains(KEY)) {
            this.sendExpiredMessage();
        }
        Global.getSector().getMemoryWithoutUpdate().unset(KEY);
        for (MarketAPI curr : Misc.getPlayerMarkets(false)) {
            if (!curr.hasCondition("piracy_respite")) continue;
            curr.removeCondition("piracy_respite");
        }
    }

    public boolean isEconomyListenerExpired() {
        if (DURATION < 0.0f) {
            return false;
        }
        float days = this.getDaysRemaining();
        if (days <= 0.0f) {
            this.cleanup();
            return true;
        }
        return false;
    }
}

