/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.enc.SlipstreamPirateEPEC;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseHostileActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.PirateHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.rulecmd.HA_CMD;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.MapParams;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.ui.UIPanelAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.Range;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PirateBasePirateActivityCause2
extends BaseHostileActivityCause2 {
    public static boolean DEAL_PROVIDES_NEGATIVE_PROGRESS = false;
    public static float MAX_MAG = 0.5f;
    transient boolean ignoreDeal = false;

    public static List<MarketAPI> getColoniesAffectedBy(PirateBaseIntel base) {
        ArrayList<MarketAPI> result = new ArrayList<MarketAPI>();
        for (StarSystemAPI system : PirateBasePirateActivityCause2.getSystemsAffectedBy(base)) {
            result.addAll(Misc.getMarketsInLocation(system, "player"));
        }
        return result;
    }

    public static List<StarSystemAPI> getSystemsAffectedBy(PirateBaseIntel base) {
        ArrayList<StarSystemAPI> result = new ArrayList<StarSystemAPI>();
        for (StarSystemAPI system : Misc.getSystemsWithPlayerColonies(false)) {
            if (PirateBasePirateActivityCause2.getBaseIntel(system) != base) continue;
            result.add(system);
        }
        return result;
    }

    public static PirateBaseIntel getBaseIntel(StarSystemAPI system) {
        if (system == null) {
            return null;
        }
        PirateBaseIntel base = SlipstreamPirateEPEC.getClosestPirateBase(system.getLocation());
        return base;
    }

    public PirateBasePirateActivityCause2(HostileActivityEventIntel intel) {
        super(intel);
    }

    @Override
    public void addExtraRows(TooltipMakerAPI info, BaseEventIntel intel) {
        LinkedHashSet<PirateBaseIntel> seen = new LinkedHashSet<PirateBaseIntel>();
        for (StarSystemAPI system : Misc.getSystemsWithPlayerColonies(false)) {
            final PirateBaseIntel base = PirateBasePirateActivityCause2.getBaseIntel(system);
            if (base == null || seen.contains(base)) continue;
            int numColonies = 0;
            final ArrayList<String> affected = new ArrayList<String>();
            for (StarSystemAPI curr : PirateBasePirateActivityCause2.getSystemsAffectedBy(base)) {
                affected.add(curr.getNameWithNoType());
                numColonies += Misc.getMarketsInLocation(curr, "player").size();
            }
            if (affected.isEmpty()) continue;
            seen.add(base);
            final String \u6b96\u6c11\u5730 = numColonies != 1 ? "\u6b96\u6c11\u5730" : "\u6b96\u6c11\u5730";
            final String isOrAre = numColonies != 1 ? "\u6b63" : "\u6b63";
            String desc = "\u9690\u85cf\u6d77\u76d7\u57fa\u5730\u4e34\u8fd1\u4e8e\u4f60\u7684 " + \u6b96\u6c11\u5730;
            if (base.isPlayerVisible()) {
                desc = "\u6d77\u76d7\u57fa\u5730\u4f4d\u4e8e " + base.getSystem().getNameWithLowercaseTypeShort();
            }
            this.ignoreDeal = true;
            final int progress = this.getProgressForBase(base);
            this.ignoreDeal = false;
            String progressStr = "+" + progress;
            if (progress < 0) {
                progressStr = "" + progress;
            }
            Color descColor = this.getDescColor(intel);
            Color progressColor = this.getProgressColor(intel);
            if (base.playerHasDealWithBaseCommander()) {
                if (DEAL_PROVIDES_NEGATIVE_PROGRESS) {
                    int p = this.getProgressForBase(base);
                    progressStr = "+" + p;
                    if (p < 0) {
                        progressStr = "" + p;
                    }
                    descColor = Misc.getTextColor();
                } else {
                    progressStr = "---";
                    descColor = Misc.getGrayColor();
                }
                progressColor = Misc.getPositiveHighlightColor();
            } else if (DEAL_PROVIDES_NEGATIVE_PROGRESS) {
                descColor = Misc.getTextColor();
            }
            info.addRowWithGlow(new Object[]{Alignment.LMID, descColor, "    " + desc, Alignment.RMID, progressColor, progressStr});
            BaseFactorTooltip t = new BaseFactorTooltip(){

                public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                    float opad = 10.0f;
                    String aStr = Misc.getAndJoined(affected);
                    String \u661f\u7cfb = "\u661f\u7cfb";
                    if (affected.size() == 1) {
                        \u661f\u7cfb = "\u661f\u7cfb";
                    }
                    MapParams params = new MapParams();
                    for (StarSystemAPI curr : PirateBasePirateActivityCause2.getSystemsAffectedBy(base)) {
                        params.showSystem(curr);
                    }
                    if (base.playerHasDealWithBaseCommander() || base.isPlayerVisible()) {
                        params.showMarket(base.getMarket(), 1.0f);
                    }
                    float w = tooltip.getWidthSoFar();
                    float h = Math.round(w / 1.6f);
                    params.positionToShowAllMarkersAndSystems(true, Math.min(w, h));
                    UIPanelAPI map = tooltip.createSectorMap(w, h, params, String.valueOf(aStr) + " " + \u661f\u7cfb);
                    if (base.playerHasDealWithBaseCommander()) {
                        String systemStr = "\u4f4d\u4e8e " + base.getSystem().getNameWithLowercaseTypeShort();
                        tooltip.addPara("\u4f60\u7684" + \u6b96\u6c11\u5730 + " \u4f4d\u4e8e " + aStr + " " + \u661f\u7cfb + " " + isOrAre + "\u5904\u4e8e\u6d77\u76d7\u57fa\u5730\u9644\u8fd1\uff0c\u8be5\u57fa\u5730 " + systemStr + "\u3002" + "\u4f60\u8ddf\u57fa\u5730\u6307\u6325\u5b98\u6709\u4e2a\u534f\u8bae " + "\u8fd9\u4e2a\u57fa\u5730\u7684\u8230\u961f\u539f\u5219\u4e0a " + "\u4e0d\u4f1a\u9a9a\u6270\u4f60\u7684\u6b96\u6c11\u5730\u548c\u8239\u8fd0\u3002", 0.0f, Misc.getPositiveHighlightColor(), "\u534f\u8bae");
                        int payment = HA_CMD.computePirateProtectionPaymentPerMonth(base);
                        String extra = "";
                        if (DEAL_PROVIDES_NEGATIVE_PROGRESS) {
                            extra = "\u800c\u4e0d\u662f\u51cf\u5c11\u8fdb\u5c55";
                        }
                        tooltip.addPara("\u5047\u8bbe\u6b96\u6c11\u5730\u6536\u5165\u7ef4\u6301\u5f53\u524d\u6c34\u5e73\uff0c\u8fd9\u4e2a\u534f\u8bae\u6bcf\u6708\u4f1a\u82b1\u8d39 %s}\u3002\u5982\u679c\u534f\u8bae\u5931\u6548\uff0c\u8fd9\u4e2a\u57fa\u5730\u4f1a\u5bfc\u81f4 \u4e8b\u4ef6\u8fdb\u5c55\u70b9 \u6bcf\u6708\u589e\u52a0 %s " + extra + "\u3002", opad, Misc.getHighlightColor(), Misc.getDGSCredits(payment), "" + progress);
                    } else {
                        String systemStr = "\u4f4d\u4e8e\u9644\u8fd1\u7684\u4e00\u4e2a\u661f\u7cfb";
                        if (base.isPlayerVisible()) {
                            systemStr = "\u4f4d\u4e8e " + base.getSystem().getNameWithLowercaseTypeShort();
                        }
                        tooltip.addPara("\u4f60\u7684" + \u6b96\u6c11\u5730 + " \u4f4d\u4e8e " + aStr + " " + \u661f\u7cfb + " " + isOrAre + "\u5904\u4e8e\u6d77\u76d7\u57fa\u5730\u9644\u8fd1\uff0c\u8be5\u57fa\u5730 " + systemStr + "\u3002" + "\u8fd9\u5bfc\u81f4\u66f4\u591a\u7684\u6d77\u76d7 " + "\u8230\u961f\u88ad\u51fb\u5546\u8239\u3002%s \u5e94\u5f53\u5904\u7406\u6b64\u4e8b\u3002", 0.0f, Misc.getHighlightColor(), "\u89e3\u51b3\u6389\u57fa\u5730");
                    }
                    tooltip.addCustom(map, opad);
                }
            };
            info.addTooltipToAddedRow(t, TooltipMakerAPI.TooltipLocation.RIGHT, false);
        }
    }

    public boolean playerHasDealWithAnyBases() {
        for (IntelInfoPlugin intel : Global.getSector().getIntelManager().getIntel(PirateBaseIntel.class)) {
            PirateBaseIntel curr = (PirateBaseIntel)intel;
            if (!curr.playerHasDealWithBaseCommander()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldShow() {
        return this.getProgress() != 0 || this.playerHasDealWithAnyBases();
    }

    @Override
    public int getProgress() {
        if (PirateHostileActivityFactor.isDefeatedLargePirateRaid()) {
            return 0;
        }
        int total = 0;
        for (IntelInfoPlugin intel : Global.getSector().getIntelManager().getIntel(PirateBaseIntel.class)) {
            PirateBaseIntel curr = (PirateBaseIntel)intel;
            total += this.getProgressForBase(curr);
        }
        return total;
    }

    protected int getProgressForBase(PirateBaseIntel base) {
        if (!DEAL_PROVIDES_NEGATIVE_PROGRESS && !this.ignoreDeal && base.playerHasDealWithBaseCommander()) {
            return 0;
        }
        boolean ignore = this.ignoreDeal;
        if (!ignore && DEAL_PROVIDES_NEGATIVE_PROGRESS) {
            this.ignoreDeal = true;
        }
        int total = 0;
        for (StarSystemAPI system : PirateBasePirateActivityCause2.getSystemsAffectedBy(base)) {
            total += this.getProgressForSystem(system);
        }
        if (!ignore && DEAL_PROVIDES_NEGATIVE_PROGRESS) {
            this.ignoreDeal = false;
        }
        if (DEAL_PROVIDES_NEGATIVE_PROGRESS && !this.ignoreDeal && base.playerHasDealWithBaseCommander()) {
            total *= -1;
        }
        return total;
    }

    protected int getProgressForSystem(StarSystemAPI system) {
        float mag = this.getMagnitudeContribution(system);
        if (mag <= 0.0f) {
            return 0;
        }
        if ((mag /= MAX_MAG) > 1.0f) {
            mag = 1.0f;
        }
        Range r = new Range("pirateBaseProximityPoints");
        return r.interpInt(mag);
    }

    @Override
    public String getDesc() {
        return null;
    }

    @Override
    public float getMagnitudeContribution(StarSystemAPI system) {
        List<MarketAPI> markets = Misc.getMarketsInLocation(system, "player");
        float maxSize = 0.0f;
        for (MarketAPI market : markets) {
            maxSize = Math.max(maxSize, (float)market.getSize());
        }
        PirateBaseIntel base = PirateBasePirateActivityCause2.getBaseIntel(system);
        float mag = SlipstreamPirateEPEC.getPirateBaseProximityFactor(base, system.getLocation());
        mag *= 0.5f;
        mag *= maxSize / 6.0f;
        if (base != null) {
            mag *= ((float)base.getTier().ordinal() + 1.0f) / 5.0f;
        }
        if (mag > MAX_MAG) {
            mag = MAX_MAG;
        }
        mag = (float)Math.round(mag * 100.0f) / 100.0f;
        if (base != null && base.playerHasDealWithBaseCommander() && !this.ignoreDeal) {
            mag = 0.0f;
        }
        return mag;
    }
}

