/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.group.FGRaidAction;
import com.fs.starfarer.api.impl.campaign.intel.group.FleetGroupIntel;
import com.fs.starfarer.api.impl.campaign.intel.group.GenericRaidFGI;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.Random;

public class RemnantHostileActivityFactor
extends BaseHostileActivityFactor
implements FleetGroupIntel.FGIEventListener {
    public RemnantHostileActivityFactor(HostileActivityEventIntel intel) {
        super(intel);
    }

    public String getProgressStr(BaseEventIntel intel) {
        return "";
    }

    public String getDesc(BaseEventIntel intel) {
        return "Remnant";
    }

    public String getNameForThreatList(boolean first) {
        return "Remnant";
    }

    public Color getDescColor(BaseEventIntel intel) {
        if (this.getProgress(intel) <= 0) {
            return Misc.getGrayColor();
        }
        return Global.getSector().getFaction("remnant").getBaseUIColor();
    }

    public TooltipMakerAPI.TooltipCreator getMainRowTooltip(BaseEventIntel intel) {
        return new BaseFactorTooltip(){

            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                float opad = 10.0f;
                tooltip.addPara("\u4f59\u8f89\u8230\u961f\u5df2\u51fa\u73b0\u5728\u4f60\u7684\u661f\u7cfb\u5185\u3002", opad);
            }
        };
    }

    public boolean shouldShow(BaseEventIntel intel) {
        return this.getProgress(intel) > 0;
    }

    public int getProgress(BaseEventIntel intel) {
        return super.getProgress(intel);
    }

    public Color getNameColor(float mag) {
        if (mag <= 0.0f) {
            return Misc.getGrayColor();
        }
        return Global.getSector().getFaction("remnant").getBaseUIColor();
    }

    public int getMaxNumFleets(StarSystemAPI system) {
        return 0;
    }

    public CampaignFleetAPI createFleet(StarSystemAPI system, Random random) {
        return null;
    }

    public void addBulletPointForEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        Color c = Global.getSector().getFaction("remnant").getBaseUIColor();
        info.addPara("\u8feb\u8fd1\u7684\u4f59\u8f89\u88ad\u51fb", initPad, tc, c, "Remnant");
    }

    public void addBulletPointForEventReset(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        info.addPara("\u4f59\u8f89\u88ad\u51fb \u5df2\u907f\u514d", tc, initPad);
    }

    public void addStageDescriptionForEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info) {
        float small = 0.0f;
        float opad = 10.0f;
        small = 8.0f;
        Color c = Global.getSector().getFaction("remnant").getBaseUIColor();
        if (!(stage.rollData instanceof HostileActivityEventIntel.HAERandomEventData)) {
            return;
        }
        HostileActivityEventIntel.HAERandomEventData data = (HostileActivityEventIntel.HAERandomEventData)stage.rollData;
        if (!(data.custom instanceof MarketAPI)) {
            return;
        }
        MarketAPI target = (MarketAPI)data.custom;
        Color h = Misc.getHighlightColor();
        info.addPara("\u6709\u8ff9\u8c61\u8868\u660e\u4f60\u661f\u7cfb\u5185\u7684\u67d0\u4e2a\u4f59\u8f89\u4e2d\u67a2\u6b63\u5904\u4e8e\u6d3b\u8dc3\u72b6\u6001\u3002\u8fd9\u610f\u5473\u7740\u5b83\u5f88\u53ef\u80fd\u5b83\u6d3e\u9063\u8230\u961f \u9971\u548c\u8f70\u70b8 " + target.getName() + "\u3002", small, Misc.getNegativeHighlightColor(), "\u9971\u548c\u8f70\u70b8");
        LabelAPI label = info.addPara("\u51fb\u9000\u88ad\u51fb\u8230\u961f\u53ea\u80fd\u6682\u65f6\u5ef6\u7f13\u6b64\u60c5\u51b5\uff0c\u53ea\u6709\u5f7b\u5e95\u6467\u6bc1 \u4f59\u8f89\u4e2d\u67a2 \u624d\u80fd\u4e00\u52b3\u6c38\u9038\u5730\u5c06\u5176 \u89e3\u51b3\u3002", opad);
        label.setHighlight("\u4f59\u8f89\u4e2d\u67a2", "\u89e3\u51b3");
        label.setHighlightColors(Global.getSector().getFaction("remnant").getBaseUIColor(), Misc.getPositiveHighlightColor());
        c = Global.getSector().getFaction("remnant").getBaseUIColor();
        stage.beginResetReqList(info, true, "crisis", opad);
        info.addPara("\u6467\u6bc1 %s", 0.0f, c, "\u4f59\u8f89\u4e2d\u67a2");
        stage.endResetReqList(info, false, "crisis", -1, -1);
        this.addBorder(info, Global.getSector().getFaction("remnant").getBaseUIColor());
    }

    public String getEventStageIcon(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        return Global.getSector().getFaction("remnant").getCrest();
    }

    public TooltipMakerAPI.TooltipCreator getStageTooltipImpl(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        if (stage.id == HostileActivityEventIntel.Stage.HA_EVENT) {
            return this.getDefaultEventTooltip("\u4f59\u8f89\u88ad\u51fb", intel, stage);
        }
        return null;
    }

    public static CampaignFleetAPI getRemnantNexus(StarSystemAPI system) {
        if (system == null) {
            return null;
        }
        for (CampaignFleetAPI fleet : system.getFleets()) {
            if (!fleet.isStationMode() || !"remnant".equals(fleet.getFaction().getId())) continue;
            return fleet;
        }
        return null;
    }

    public float getEventFrequency(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        if (stage.id == HostileActivityEventIntel.Stage.HA_EVENT) {
            MarketAPI target = this.findAttackTarget(intel, stage);
            if (target == null || target.getStarSystem() == null) {
                return 0.0f;
            }
            CampaignFleetAPI nexus = RemnantHostileActivityFactor.getRemnantNexus(target.getStarSystem());
            if (nexus == null) {
                return 0.0f;
            }
            return 10.0f;
        }
        return 0.0f;
    }

    public void rollEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        MarketAPI target = this.findAttackTarget(intel, stage);
        if (target == null) {
            return;
        }
        HostileActivityEventIntel.HAERandomEventData data = new HostileActivityEventIntel.HAERandomEventData(this, stage);
        data.custom = target;
        stage.rollData = data;
        intel.sendUpdateIfPlayerHasIntel((Object)data, false);
    }

    public boolean fireEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        MarketAPI target = this.findAttackTarget(intel, stage);
        if (target == null || target.getStarSystem() == null) {
            return false;
        }
        CampaignFleetAPI nexus = RemnantHostileActivityFactor.getRemnantNexus(target.getStarSystem());
        if (nexus == null) {
            return false;
        }
        stage.rollData = null;
        return this.startAttack(nexus, target, target.getStarSystem(), stage, this.getRandomizedStageRandom(3));
    }

    public MarketAPI findAttackTarget(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        WeightedRandomPicker<MarketAPI> picker = new WeightedRandomPicker<MarketAPI>(this.getRandomizedStageRandom(3));
        for (StarSystemAPI system : Misc.getPlayerSystems(false)) {
            CampaignFleetAPI nexus = RemnantHostileActivityFactor.getRemnantNexus(system);
            if (nexus == null) continue;
            for (MarketAPI curr : Misc.getMarketsInLocation(system, "player")) {
                picker.add(curr, curr.getSize() * curr.getSize() * curr.getSize());
            }
        }
        return (MarketAPI)picker.pick();
    }

    public void notifyFactorRemoved() {
    }

    public void notifyEventEnding() {
        this.notifyFactorRemoved();
    }

    public void advance(float amount) {
        super.advance(amount);
        BaseEventIntel.EventStageData stage = this.intel.getDataFor((Object)HostileActivityEventIntel.Stage.HA_EVENT);
        if (stage != null && stage.rollData instanceof HostileActivityEventIntel.HAERandomEventData && ((HostileActivityEventIntel.HAERandomEventData)stage.rollData).factor == this) {
            MarketAPI target;
            HostileActivityEventIntel.HAERandomEventData data = (HostileActivityEventIntel.HAERandomEventData)stage.rollData;
            if (data.custom instanceof MarketAPI && RemnantHostileActivityFactor.getRemnantNexus((target = (MarketAPI)data.custom).getStarSystem()) == null) {
                this.intel.resetHA_EVENT();
            }
        }
    }

    public boolean startAttack(CampaignFleetAPI nexus, MarketAPI target, StarSystemAPI system, BaseEventIntel.EventStageData stage, Random random) {
        GenericRaidFGI.GenericRaidParams params = new GenericRaidFGI.GenericRaidParams(new Random(random.nextLong()), true);
        params.makeFleetsHostile = true;
        params.remnant = true;
        params.factionId = nexus.getFaction().getId();
        MarketAPI fake = Global.getFactory().createMarket(nexus.getId(), nexus.getName(), 3);
        fake.setPrimaryEntity(nexus);
        fake.setFactionId(params.factionId);
        fake.getStats().getDynamic().getMod("fleet_quality_mod").modifyFlat("nexus_" + nexus.getId(), 1.0f);
        params.source = fake;
        params.prepDays = 0.0f;
        params.payloadDays = 27.0f + 7.0f * random.nextFloat();
        params.raidParams.where = system;
        params.raidParams.type = FGRaidAction.FGRaidType.SEQUENTIAL;
        params.raidParams.tryToCaptureObjectives = false;
        params.raidParams.allowedTargets.add(target);
        params.raidParams.allowNonHostileTargets = true;
        params.raidParams.setBombardment(MarketCMD.BombardType.SATURATION);
        params.forcesNoun = "\u4f59\u8f89\u8230\u961f";
        params.style = FleetCreatorMission.FleetStyle.STANDARD;
        params.repImpact = HubMissionWithTriggers.ComplicationRepImpact.FULL;
        float fleetSizeMult = 1.0f;
        boolean damaged = nexus.getMemoryWithoutUpdate().getBoolean("$damagedStation");
        if (damaged) {
            fleetSizeMult = 0.5f;
        }
        float totalDifficulty = fleetSizeMult * 50.0f;
        totalDifficulty -= 10.0f;
        params.fleetSizes.add(10);
        while (totalDifficulty > 0.0f) {
            int min = 6;
            int max = 10;
            int diff = min + random.nextInt(max - min + 1);
            params.fleetSizes.add(diff);
            totalDifficulty -= (float)diff;
        }
        GenericRaidFGI raid = new GenericRaidFGI(params);
        raid.setListener(this);
        Global.getSector().getIntelManager().addIntel(raid);
        return true;
    }

    public void reportFGIAborted(FleetGroupIntel intel) {
    }
}

