/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseHostileActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.RemnantHostileActivityFactor;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.MapParams;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.ui.UIPanelAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.LinkedHashSet;

public class RemnantNexusActivityCause
extends BaseHostileActivityCause2 {
    public static float MAX_MAG = 0.5f;
    public static int PROGRESS_NEXUS_DAMAGED = Global.getSettings().getInt("remnantNexusPointsDamaged");
    public static int PROGRESS_NEXUS_NORMAL = Global.getSettings().getInt("remnantNexusPointsNormal");

    public RemnantNexusActivityCause(HostileActivityEventIntel intel) {
        super(intel);
    }

    public void addExtraRows(TooltipMakerAPI info, BaseEventIntel intel) {
        LinkedHashSet seen = new LinkedHashSet();
        for (final StarSystemAPI system : Misc.getSystemsWithPlayerColonies(false)) {
            CampaignFleetAPI nexus = RemnantHostileActivityFactor.getRemnantNexus(system);
            if (nexus == null || nexus == null || seen.contains(nexus)) continue;
            int numColonies = Misc.getMarketsInLocation(system, "player").size();
            final String \u6b96\u6c11\u5730 = numColonies != 1 ? "\u6b96\u6c11\u5730" : "\u6b96\u6c11\u5730";
            final String isOrAre = numColonies != 1 ? "" : "";
            String desc = "\u4f59\u8f89\u4e2d\u67a2 \u6b63\u5f71\u54cd " + system.getNameWithLowercaseTypeShort();
            int progress = this.getProgressForNexus(nexus);
            String progressStr = "+" + progress;
            if (progress < 0) {
                progressStr = "" + progress;
            }
            Color descColor = this.getDescColor(intel);
            Color progressColor = this.getProgressColor(intel);
            info.addRowWithGlow(new Object[]{Alignment.LMID, descColor, "    " + desc, Alignment.RMID, progressColor, progressStr});
            BaseFactorTooltip t = new BaseFactorTooltip(){

                public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                    float opad = 10.0f;
                    MapParams params = new MapParams();
                    params.showSystem(system);
                    float w = tooltip.getWidthSoFar();
                    float h = Math.round(w / 1.6f);
                    params.positionToShowAllMarkersAndSystems(true, Math.min(w, h));
                    UIPanelAPI map = tooltip.createSectorMap(w, h, params, system.getNameWithLowercaseType());
                    tooltip.addPara("\u4f60" + \u6b96\u6c11\u5730 + "\u4f4d\u4e8e" + system.getNameWithLowercaseTypeShort() + " " + isOrAre + "\u7684\u6b96\u6c11\u5730\u6b63\u5904\u4e8e\u540c\u661f\u7cfb\u5185\u4f59\u8f89\u4e2d\u67a2\u7684\u5a01\u80c1\u4e4b\u4e0b\u3002" + "\u8fd9\u5c06\u5bfc\u81f4\u8d38\u6613\u8230\u961f\u88ab\u88ad\u51fb\uff0c\u5e76\u6700\u7ec8\u5f15\u53d1 " + "\u4f60\u6b96\u6c11\u5730\u7684\u5371\u6025\u5b58\u4ea1\u95ee\u9898" + \u6b96\u6c11\u5730 + "\u3002", 0.0f, Misc.getNegativeHighlightColor(), "\u4f60\u6b96\u6c11\u5730\u7684\u5371\u6025\u5b58\u4ea1\u95ee\u9898" + \u6b96\u6c11\u5730);
                    tooltip.addPara("\u5373\u4f7f\u5904\u4e8e\u4f11\u7720\u72b6\u6001\uff0c\u4f59\u8f89\u8230\u961f\u4e5f\u662f\u4e00\u79cd\u5371\u5728\u65e6\u5915\u7684\u8c61\u5f81\uff0c\u5b83\u4eec\u5c06\u635f\u8017\u4f60\u7684\u9632\u5fa1\u8d44\u6e90\u5e76\u8ba9\u4f60\u7684\u6b96\u6c11\u5730" + \u6b96\u6c11\u5730 + "\u66f4\u6613\u53d7\u5230\u5176\u4ed6\u5371\u673a\u5f71\u54cd\u3002", opad);
                    tooltip.addPara("%s \u7406\u5e94\u662f\u5f53\u4e0b\u7684\u7b2c\u4e00\u8981\u52a1\u3002", opad, Misc.getHighlightColor(), "\u6467\u6bc1\u4e2d\u67a2");
                    tooltip.addCustom(map, opad);
                }
            };
            info.addTooltipToAddedRow(t, TooltipMakerAPI.TooltipLocation.RIGHT, false);
        }
    }

    public boolean shouldShow() {
        return this.getProgress() != 0;
    }

    public int getProgress() {
        int total = 0;
        for (StarSystemAPI system : Misc.getSystemsWithPlayerColonies(false)) {
            CampaignFleetAPI nexus = RemnantHostileActivityFactor.getRemnantNexus(system);
            if (nexus == null) continue;
            total += this.getProgressForNexus(nexus);
        }
        return total;
    }

    protected int getProgressForNexus(CampaignFleetAPI nexus) {
        if (nexus == null) {
            return 0;
        }
        boolean damaged = nexus.getMemoryWithoutUpdate().getBoolean("$damagedStation");
        if (damaged) {
            return PROGRESS_NEXUS_DAMAGED;
        }
        return PROGRESS_NEXUS_NORMAL;
    }

    public String getDesc() {
        return null;
    }

    public float getMagnitudeContribution(StarSystemAPI system) {
        if (this.getProgress() <= 0) {
            return 0.0f;
        }
        CampaignFleetAPI nexus = RemnantHostileActivityFactor.getRemnantNexus(system);
        if (nexus == null) {
            return 0.0f;
        }
        boolean damaged = nexus.getMemoryWithoutUpdate().getBoolean("$damagedStation");
        if (damaged) {
            return MAX_MAG * 0.5f;
        }
        return MAX_MAG;
    }
}

