/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.DiktatFuelBonusScript;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.SindrianDiktatStandardActivityCause;
import com.fs.starfarer.api.impl.campaign.intel.events.TriTachyonStandardActivityCause;
import com.fs.starfarer.api.impl.campaign.intel.group.FGRaidAction;
import com.fs.starfarer.api.impl.campaign.intel.group.FleetGroupIntel;
import com.fs.starfarer.api.impl.campaign.intel.group.GenericRaidFGI;
import com.fs.starfarer.api.impl.campaign.intel.group.SindrianDiktatPunitiveExpedition;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.CountingMap;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class SindrianDiktatHostileActivityFactor
extends BaseHostileActivityFactor
implements FleetGroupIntel.FGIEventListener {
    public static String DEFEATED_DIKTAT_ATTACK = "$defeatedDiktatAttack";
    public static String MADE_DIKTAT_DEAL = "$makeDiktatDeal";
    public static String BROKE_DIKTAT_DEAL = "$brokeDiktatDeal";
    public static String RAIDER_FLEET = "$diktatRaider";

    public static boolean isMadeDeal() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(MADE_DIKTAT_DEAL);
    }

    public static void setMadeDeal(boolean value) {
        Global.getSector().getPlayerMemoryWithoutUpdate().set(MADE_DIKTAT_DEAL, value);
    }

    public static boolean brokeDeal() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(BROKE_DIKTAT_DEAL);
    }

    public static void setBrokeDeal(boolean broke) {
        Global.getSector().getPlayerMemoryWithoutUpdate().set(BROKE_DIKTAT_DEAL, broke);
    }

    public static boolean isPlayerDefeatedDiktatAttack() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(DEFEATED_DIKTAT_ATTACK);
    }

    public static void setPlayerDefeatedDiktatAttack() {
        Global.getSector().getPlayerMemoryWithoutUpdate().set(DEFEATED_DIKTAT_ATTACK, true);
    }

    public SindrianDiktatHostileActivityFactor(HostileActivityEventIntel intel) {
        super(intel);
    }

    public String getProgressStr(BaseEventIntel intel) {
        return "";
    }

    public String getDesc(BaseEventIntel intel) {
        return "\u8f9b\u8fbe\u5f3a\u6743";
    }

    public String getNameForThreatList(boolean first) {
        return "\u8f9b\u8fbe\u5f3a\u6743";
    }

    public Color getDescColor(BaseEventIntel intel) {
        if (this.getProgress(intel) <= 0) {
            return Misc.getGrayColor();
        }
        return Global.getSector().getFaction("sindrian_diktat").getBaseUIColor();
    }

    public TooltipMakerAPI.TooltipCreator getMainRowTooltip(BaseEventIntel intel) {
        return new BaseFactorTooltip(){

            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                float opad = 10.0f;
                tooltip.addPara("\u4f60\u5f15\u6765\u4e86\u8f9b\u8fbe\u5f3a\u6743\u7684\u6ce8\u610f\u3002", 0.0f);
                tooltip.addPara("\u8f9b\u8fbe\u5f3a\u6743\u88ad\u51fb\u8005\u8230\u961f\u5df2\u51fa\u73b0\u5728\u4f60\u7684\u661f\u7cfb\u5185\u3002\u4ed6\u4eec\u5c06\u4e0d\u95ee\u6765\u7531\u5730\u65e0\u5dee\u522b\u653b\u51fb\u8d38\u6613\u8230\u961f\u3002", opad);
            }
        };
    }

    public boolean shouldShow(BaseEventIntel intel) {
        return this.getProgress(intel) > 0;
    }

    public int getProgress(BaseEventIntel intel) {
        if (!SindrianDiktatHostileActivityFactor.checkFactionExists("sindrian_diktat", true)) {
            return 0;
        }
        return super.getProgress(intel);
    }

    public Color getNameColor(float mag) {
        if (mag <= 0.0f) {
            return Misc.getGrayColor();
        }
        return Global.getSector().getFaction("sindrian_diktat").getBaseUIColor();
    }

    public int getMaxNumFleets(StarSystemAPI system) {
        return Global.getSettings().getInt("diktatMaxFleets");
    }

    public CampaignFleetAPI createFleet(StarSystemAPI system, Random random) {
        float f = this.intel.getMarketPresenceFactor(system);
        int difficulty = 4 + Math.round(f * 4.0f);
        FleetCreatorMission m = new FleetCreatorMission(random);
        m.beginFleet();
        Vector2f loc = system.getLocation();
        String factionId = "sindrian_diktat";
        m.createQualityFleet(difficulty, factionId, loc);
        m.triggerSetFleetType("raider");
        m.triggerSetPirateFleet();
        m.triggerMakeHostile();
        m.triggerMakeNonHostileToFaction("sindrian_diktat");
        m.triggerMakeNonHostileToFaction("pirates");
        m.triggerMakeLowRepImpact();
        m.triggerFleetAllowLongPursuit();
        m.triggerMakeHostileToAllTradeFleets();
        m.triggerMakeEveryoneJoinBattleAgainst();
        m.triggerSetFleetFlag(RAIDER_FLEET);
        m.triggerFleetMakeFaster(true, 0, true);
        CampaignFleetAPI fleet = m.createFleet();
        return fleet;
    }

    public void addBulletPointForEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        Color c = Global.getSector().getFaction("sindrian_diktat").getBaseUIColor();
        info.addPara("\u8feb\u8fd1\u7684\u8f9b\u8fbe\u5f3a\u6743\u88ad\u51fb", initPad, tc, c, "\u8f9b\u8fbe\u5f3a\u6743");
    }

    public void addBulletPointForEventReset(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        info.addPara("\u8f9b\u8fbe\u5f3a\u6743\u88ad\u51fb \u5df2\u907f\u514d", tc, initPad);
    }

    public void addStageDescriptionForEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info) {
        float small = 0.0f;
        float opad = 10.0f;
        small = 8.0f;
        Color c = Global.getSector().getFaction("sindrian_diktat").getBaseUIColor();
        Color h = Misc.getHighlightColor();
        info.addPara("\u4f60\u83b7\u77e5\u7684\u60c5\u62a5\u8868\u660e\uff0c\u8f9b\u8fbe\u5f3a\u6743\u6b63\u8ba1\u5212\u4e8e\u4f60\u7684\u67d0\u4e2a\u5177\u6709\u71c3\u6599\u751f\u4ea7\u8bbe\u65bd\u7684\u6b96\u6c11\u5730\u5b9e\u65bd\u4e00\u6b21 \u9971\u548c\u8f70\u70b8\u3002", small, Misc.getNegativeHighlightColor(), "\u9971\u548c\u8f70\u70b8");
        LabelAPI label = info.addPara("\u5982\u679c\u8fd9\u4e00\u88ad\u51fb\u88ab\u51fb\u8d25\uff0c\u8f9b\u8fbe\u5f3a\u6743 \u5c06\u5f88\u53ef\u80fd\u5f7b\u5e95\u653e\u5f03\u6b64\u7c7b\u884c\u52a8\uff0c\u4e14\u4f60 \u51fa\u53e3\u71c3\u6599 \u7684\u80fd\u529b\u5c06\u5f97\u5230 \u589e\u76ca\u3002", opad);
        label.setHighlight("\u8f9b\u8fbe\u5f3a\u6743", "\u51fa\u53e3\u71c3\u6599", "\u589e\u76ca");
        label.setHighlightColors(Global.getSector().getFaction("sindrian_diktat").getBaseUIColor(), Misc.getPositiveHighlightColor(), Misc.getPositiveHighlightColor());
        c = Global.getSector().getFaction("sindrian_diktat").getBaseUIColor();
        stage.beginResetReqList(info, true, "crisis", opad);
        info.addPara("\u524d\u5f80 %s \u5e76\u4e0e\u8f9b\u8fbe\u5f3a\u6743\u8fbe\u6210\u534f\u8bae", 0.0f, c, "Sindria");
        info.addPara("\u6218\u672f\u8f70\u70b8 %s", 0.0f, c, "Sindria");
        info.addPara("\u762b\u75ea %s \u7684\u71c3\u6599\u751f\u4ea7\u8bbe\u65bd", 0.0f, c, "Sindria");
        stage.endResetReqList(info, false, "crisis", -1, -1);
        this.addBorder(info, Global.getSector().getFaction("sindrian_diktat").getBaseUIColor());
    }

    public String getEventStageIcon(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        return Global.getSector().getFaction("sindrian_diktat").getCrest();
    }

    public TooltipMakerAPI.TooltipCreator getStageTooltipImpl(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        if (stage.id == HostileActivityEventIntel.Stage.HA_EVENT) {
            return this.getDefaultEventTooltip("\u8f9b\u8fbe\u5f3a\u6743\u88ad\u51fb", intel, stage);
        }
        return null;
    }

    public static Industry getSindrianFuelProd() {
        MarketAPI sindria = SindrianDiktatHostileActivityFactor.getSindria(false);
        if (sindria == null) {
            return null;
        }
        Industry prod = sindria.getIndustry("fuelprod");
        return prod;
    }

    public static MarketAPI getSindria(boolean requireMilitaryBase) {
        MarketAPI sindria = Global.getSector().getEconomy().getMarket("sindria");
        if (sindria == null || sindria.hasCondition("decivilized")) {
            return null;
        }
        if (requireMilitaryBase) {
            Industry b = sindria.getIndustry("militarybase");
            if (b == null) {
                b = sindria.getIndustry("highcommand");
            }
            if (b == null || b.isDisrupted() || !b.isFunctional()) {
                return null;
            }
        }
        return sindria;
    }

    public float getEventFrequency(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        if (stage.id == HostileActivityEventIntel.Stage.HA_EVENT) {
            if (SindrianDiktatHostileActivityFactor.isPlayerDefeatedDiktatAttack() || SindrianDiktatHostileActivityFactor.getSindria(true) == null) {
                return 0.0f;
            }
            if (SindrianDiktatHostileActivityFactor.isMadeDeal()) {
                return 0.0f;
            }
            if (SindrianDiktatPunitiveExpedition.get() != null) {
                return 0.0f;
            }
            MarketAPI target = SindrianDiktatHostileActivityFactor.findExpeditionTarget(intel, stage);
            MarketAPI source = SindrianDiktatHostileActivityFactor.getSindria(true);
            if (target != null && source != null) {
                return 10.0f;
            }
        }
        return 0.0f;
    }

    public void rollEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        HostileActivityEventIntel.HAERandomEventData data = new HostileActivityEventIntel.HAERandomEventData(this, stage);
        stage.rollData = data;
        intel.sendUpdateIfPlayerHasIntel((Object)data, false);
    }

    public boolean fireEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        MarketAPI target = SindrianDiktatHostileActivityFactor.findExpeditionTarget(intel, stage);
        MarketAPI source = SindrianDiktatHostileActivityFactor.getSindria(true);
        if (source == null || target == null) {
            return false;
        }
        stage.rollData = null;
        return this.startAttack(source, target, target.getStarSystem(), stage, this.getRandomizedStageRandom(3));
    }

    public static MarketAPI findExpeditionTarget(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        List<TriTachyonStandardActivityCause.CompetitorData> data = SindrianDiktatStandardActivityCause.computePlayerCompetitionData();
        CountingMap<MarketAPI> counts = new CountingMap<MarketAPI>();
        for (TriTachyonStandardActivityCause.CompetitorData curr : data) {
            for (MarketAPI market : curr.competitorProducers) {
                StarSystemAPI system = market.getStarSystem();
                if (system == null) continue;
                int weight = market.getCommodityData(curr.commodityId).getMaxSupply();
                counts.add(market, weight);
            }
        }
        return (MarketAPI)counts.getLargest();
    }

    public void reportFGIAborted(FleetGroupIntel intel) {
        SindrianDiktatHostileActivityFactor.setPlayerDefeatedDiktatAttack();
        DiktatFuelBonusScript.grantBonus();
    }

    public void notifyFactorRemoved() {
    }

    public void notifyEventEnding() {
        this.notifyFactorRemoved();
    }

    public void advance(float amount) {
        super.advance(amount);
        BaseEventIntel.EventStageData stage = this.intel.getDataFor((Object)HostileActivityEventIntel.Stage.HA_EVENT);
        if (stage != null && stage.rollData instanceof HostileActivityEventIntel.HAERandomEventData && ((HostileActivityEventIntel.HAERandomEventData)stage.rollData).factor == this) {
            boolean prodOk;
            Industry prod = SindrianDiktatHostileActivityFactor.getSindrianFuelProd();
            boolean bl = prodOk = prod != null && prod.getSpecialItem() != null && !prod.isDisrupted();
            if (SindrianDiktatHostileActivityFactor.getSindria(true) == null || !prodOk) {
                this.intel.resetHA_EVENT();
            }
        }
    }

    public boolean startAttack(MarketAPI source, MarketAPI target, StarSystemAPI system, BaseEventIntel.EventStageData stage, Random random) {
        GenericRaidFGI.GenericRaidParams params = new GenericRaidFGI.GenericRaidParams(new Random(random.nextLong()), true);
        params.makeFleetsHostile = false;
        params.factionId = source.getFactionId();
        params.source = source;
        params.prepDays = 14.0f + random.nextFloat() * 14.0f;
        params.payloadDays = 27.0f + 7.0f * random.nextFloat();
        params.raidParams.where = system;
        params.raidParams.type = FGRaidAction.FGRaidType.SEQUENTIAL;
        params.raidParams.tryToCaptureObjectives = false;
        params.raidParams.allowedTargets.add(target);
        params.raidParams.allowNonHostileTargets = true;
        params.raidParams.setBombardment(MarketCMD.BombardType.SATURATION);
        params.style = FleetCreatorMission.FleetStyle.STANDARD;
        float fleetSizeMult = source.getStats().getDynamic().getMod("combat_fleet_size_mult").computeEffective(0.0f);
        float f = this.intel.getMarketPresenceFactor(system);
        float totalDifficulty = fleetSizeMult * 15.0f * (0.6f + 0.4f * f);
        if (totalDifficulty < 15.0f) {
            return false;
        }
        if (totalDifficulty > 100.0f) {
            totalDifficulty = 100.0f;
        }
        totalDifficulty -= 10.0f;
        params.fleetSizes.add(10);
        while (totalDifficulty > 0.0f) {
            int min = 6;
            int max = 10;
            int diff = min + random.nextInt(max - min + 1);
            params.fleetSizes.add(diff);
            totalDifficulty -= (float)diff;
        }
        SindrianDiktatPunitiveExpedition punex = new SindrianDiktatPunitiveExpedition(params);
        punex.setListener(this);
        Global.getSector().getIntelManager().addIntel(punex);
        return true;
    }
}

