/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseHostileActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.SindrianDiktatHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.TriTachyonStandardActivityCause;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.MapParams;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.ui.UIPanelAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SindrianDiktatStandardActivityCause
extends BaseHostileActivityCause2 {
    public static int MIN_DIKTAT_PRODUCTION = 7;
    public static int MIN_COMPETITOR_PRODUCTION = 4;
    public static int MIN_COMPETITOR_MARKET_SIZE = 4;
    public static float PROD_PROGRESS_MULT = Global.getSettings().getFloat("diktatProgressPerUnitProdMult");
    public static float MAX_MAG = 0.5f;

    public static TriTachyonStandardActivityCause.CompetitorData computeCompetitorData(String factionId, String competitorId, String commodityId) {
        TriTachyonStandardActivityCause.CompetitorData data = new TriTachyonStandardActivityCause.CompetitorData(commodityId);
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            int prod;
            CommodityOnMarketAPI com = market.getCommodityData(commodityId);
            if (com == null || (prod = com.getMaxSupply()) <= 0) continue;
            if (factionId.equals(market.getFactionId())) {
                data.factionProdTotal += prod;
                data.factionProducers.add(market);
                data.factionMaxProd = Math.max(data.factionMaxProd, prod);
            } else if (competitorId.equals(market.getFactionId())) {
                data.competitorProdTotal += prod;
                data.competitorMaxProd = Math.max(data.competitorMaxProd, prod);
                data.competitorProducers.add(market);
                data.competitorMaxMarketSize = Math.max(data.competitorMaxMarketSize, market.getSize());
            }
            data.allProdTotal += prod;
        }
        return data;
    }

    public static List<TriTachyonStandardActivityCause.CompetitorData> computePlayerCompetitionData() {
        String factionId = "sindrian_diktat";
        ArrayList<String> commodities = new ArrayList<String>();
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (!factionId.equals(market.getFactionId())) continue;
            for (CommodityOnMarketAPI com : market.getCommoditiesCopy()) {
                int prod;
                if (!com.isFuel() || (prod = com.getMaxSupply()) < MIN_DIKTAT_PRODUCTION) continue;
                commodities.add(com.getId());
            }
        }
        ArrayList<TriTachyonStandardActivityCause.CompetitorData> result = new ArrayList<TriTachyonStandardActivityCause.CompetitorData>();
        for (String commodityId : commodities) {
            TriTachyonStandardActivityCause.CompetitorData data = SindrianDiktatStandardActivityCause.computeCompetitorData(factionId, "player", commodityId);
            if (data.competitorMaxProd < MIN_COMPETITOR_PRODUCTION || data.competitorMaxMarketSize < MIN_COMPETITOR_MARKET_SIZE) continue;
            result.add(data);
        }
        return result;
    }

    public SindrianDiktatStandardActivityCause(HostileActivityEventIntel intel) {
        super(intel);
    }

    @Override
    public TooltipMakerAPI.TooltipCreator getTooltip() {
        return new BaseFactorTooltip(){

            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                float opad = 10.0f;
                Color h = Misc.getHighlightColor();
                Color tc = Misc.getTextColor();
                tooltip.addPara("\u4f60\u6b96\u6c11\u5730\u7684\u71c3\u6599\u751f\u4ea7\u80fd\u529b\u76f8\u5f53\u4e4b\u9ad8\uff0c\u8db3\u4ee5\u5f15\u6765\u8f9b\u8fbe\u5f3a\u6743 \u2014\u2014 \u5176\u5c06\u5927\u90e8\u5206\u7ecf\u6d4e\u5efa\u7acb\u5728\u71c3\u6599\u751f\u4ea7\u4e0e\u8d38\u6613\u4e4b\u4e0a \u2014\u2014 \u7684\u6ce8\u610f\u3002", 0.0f);
                List<TriTachyonStandardActivityCause.CompetitorData> comp = SindrianDiktatStandardActivityCause.computePlayerCompetitionData();
                FactionAPI player = Global.getSector().getFaction("player");
                tooltip.beginTable(player, 20.0f, "\u5546\u54c1", Float.valueOf(this.getTooltipWidth(tooltipParam) - 150.0f), "\u4ea7\u51fa", Float.valueOf(150.0f));
                for (TriTachyonStandardActivityCause.CompetitorData data : comp) {
                    tooltip.addRow(new Object[]{Alignment.LMID, tc, Misc.ucFirst(data.spec.getLowerCaseName()), Alignment.MID, h, "" + data.competitorMaxProd});
                }
                tooltip.addTable("", 0, opad);
                tooltip.addSpacer(5.0f);
                tooltip.addPara("\u4e8b\u4ef6\u8fdb\u5c55\u5c06\u57fa\u4e8e\u4f60\u7684\u603b\u71c3\u6599\u751f\u4ea7\u80fd\u529b\u3002%s \u81f3\u6240\u6709\u6b96\u6c11\u5730\u5747\u4f4e\u4e8e %s \u4e5f\u8bb8\u80fd\u8ba9\u8f9b\u8fbe\u5f3a\u6743\u4e0d\u518d\u5728\u610f\u4f60\u3002", opad, h, "\u5c06\u751f\u4ea7\u80fd\u529b\u964d\u4f4e", "" + MIN_COMPETITOR_PRODUCTION);
                tooltip.addPara("\u5c06\u8f9b\u8fbe\u5f3a\u6743\u9010\u51fa\u71c3\u6599\u5e02\u573a\u4e5f\u662f\u503c\u5f97\u8003\u8651\u7684\u3002\u5b83\u7edd\u5927\u90e8\u5206\u71c3\u6599\u751f\u4ea7\u80fd\u529b\u90fd\u57fa\u4e8e\u5176\u4f4d\u4e8e Sindria \u7684\u71c3\u6599\u751f\u4ea7\u8bbe\u65bd\u5185\u7684 \u540c\u6b65\u52a0\u901f\u5668\u6838\u5fc3 \u5236\u54c1\u4e4b\u4e0a\u3002", opad, h, "\u540c\u6b65\u52a0\u901f\u5668\u6838\u5fc3");
                MarketAPI sindria = SindrianDiktatHostileActivityFactor.getSindria(false);
                if (sindria != null && sindria.getStarSystem() != null) {
                    MapParams params = new MapParams();
                    params.showSystem(sindria.getStarSystem());
                    float w = tooltip.getWidthSoFar();
                    float ht = Math.round(w / 1.6f);
                    params.positionToShowAllMarkersAndSystems(true, Math.min(w, ht));
                    UIPanelAPI map = tooltip.createSectorMap(w, ht, params, String.valueOf(sindria.getName()) + " (" + sindria.getStarSystem().getNameWithLowercaseTypeShort() + ")");
                    tooltip.addCustom(map, opad);
                }
            }
        };
    }

    @Override
    public boolean shouldShow() {
        return this.getProgress() != 0;
    }

    @Override
    public int getProgress() {
        if (SindrianDiktatHostileActivityFactor.isMadeDeal() || SindrianDiktatHostileActivityFactor.isPlayerDefeatedDiktatAttack()) {
            return 0;
        }
        int total = 0;
        List<TriTachyonStandardActivityCause.CompetitorData> comp = SindrianDiktatStandardActivityCause.computePlayerCompetitionData();
        for (TriTachyonStandardActivityCause.CompetitorData data : comp) {
            total += data.getProgress(PROD_PROGRESS_MULT);
        }
        return total;
    }

    @Override
    public String getDesc() {
        return "\u71c3\u6599\u5e02\u573a\u7ade\u4e89";
    }

    @Override
    public float getMagnitudeContribution(StarSystemAPI system) {
        if (this.getProgress() <= 0) {
            return 0.0f;
        }
        List<TriTachyonStandardActivityCause.CompetitorData> comp = SindrianDiktatStandardActivityCause.computePlayerCompetitionData();
        float mag = 0.0f;
        for (TriTachyonStandardActivityCause.CompetitorData data : comp) {
            for (MarketAPI market : data.competitorProducers) {
                if (market.getContainingLocation() != system) continue;
                CommodityOnMarketAPI com = market.getCommodityData(data.commodityId);
                float prod = com.getMaxSupply();
                mag += prod * 0.1f;
            }
        }
        if (mag > MAX_MAG) {
            mag = MAX_MAG;
        }
        mag = (float)Math.round(mag * 100.0f) / 100.0f;
        return mag;
    }
}

