/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathBaseIntel;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathBaseManager;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathCellsIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseHostileActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.LuddicPathHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.rulecmd.HA_CMD;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.LinkedHashSet;
import java.util.List;

public class StandardLuddicPathActivityCause2
extends BaseHostileActivityCause2 {
    public StandardLuddicPathActivityCause2(HostileActivityEventIntel intel) {
        super(intel);
    }

    public TooltipMakerAPI.TooltipCreator getTooltip() {
        return new BaseFactorTooltip(){

            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                float opad = 10.0f;
                tooltip.addPara("\u4f7f\u7528 \u9ad8\u7aef\u79d1\u6280 \u548c AI \u6838\u5fc3 \u4f1a\u5438\u5f15 \u5de6\u5f84\u4efd\u5b50 \u7684\u5173\u6ce8\u3002", 0.0f, Misc.getHighlightColor(), "\u9ad8\u7aef\u79d1\u6280", "AI \u6838\u5fc3");
                LinkedHashSet<LuddicPathBaseIntel> seen = new LinkedHashSet<LuddicPathBaseIntel>();
                for (MarketAPI market : Misc.getPlayerMarkets(false)) {
                    LuddicPathCellsIntel cells;
                    LuddicPathBaseIntel base = LuddicPathCellsIntel.getClosestBase(market);
                    if (base == null || seen.contains(base) || (cells = LuddicPathCellsIntel.getCellsForMarket(market)) == null || cells.isSleeper()) continue;
                    seen.add(base);
                    Color h = Misc.getHighlightColor();
                    String system = "";
                    if (base.isPlayerVisible()) {
                        system = "\u4f4d\u4e8e " + base.getSystem().getNameWithLowercaseTypeShort();
                    }
                    tooltip.addPara("\u5728\u4f60\u4e00\u4e9b\u6b96\u6c11\u5730\u4e0a \u6d3b\u8dc3\u7684 \u5de6\u5f84\u5206\u5b50 \u5c0f\u7ec4 \u6b63\u5728\u63a5\u6536\u6765\u81ea\u4e00\u4e2a \u5de6\u5f84 \u57fa\u5730\u7684\u652f\u63f4\u3002" + system + "\u3002 %s " + "\u4f1a\u964d\u4f4e \u5de6\u5f84\u5206\u5b50\u8230\u961f \u7684\u6d3b\u52a8\u9891\u7e41\u7a0b\u5ea6\u3002", opad, h, "\u89e3\u51b3\u6389\u57fa\u5730");
                    break;
                }
                for (MarketAPI market : Misc.getPlayerMarkets(false)) {
                    LuddicPathCellsIntel cells = LuddicPathCellsIntel.getCellsForMarket(market);
                    if (cells == null || !(cells.getSleeperTimeout() > 0.0f)) continue;
                    tooltip.addPara("\u4f4d\u4e8e\u4f60\u4e00\u4e9b\u6b96\u6c11\u5730\u4e0a\u7684 \u5de6\u5f84\u5206\u5b50\u57fa\u5730 \u5df2\u88ab\u762b\u75ea \uff0c\u8fd9\u4e9b\u6b96\u6c11\u5730\u4e0a\u7684 \u5de6\u5f84\u5206\u5b50 \u5bf9\u4e8b\u4ef6\u8fdb\u5c55\u5ea6\u7684\u5f71\u54cd\u5df2\u88ab\u964d\u4f4e\u3002", opad, Misc.getPositiveHighlightColor(), "\u5df2\u88ab\u762b\u75ea");
                    break;
                }
            }
        };
    }

    public boolean shouldShow() {
        return this.getProgress() != 0 || HA_CMD.playerHasPatherAgreement();
    }

    public String getProgressStr() {
        if (HA_CMD.playerHasPatherAgreement()) {
            return "---";
        }
        return super.getProgressStr();
    }

    public Color getProgressColor(BaseEventIntel intel) {
        if (HA_CMD.playerHasPatherAgreement()) {
            return Misc.getPositiveHighlightColor();
        }
        return super.getProgressColor(intel);
    }

    public int getProgress() {
        if (HA_CMD.playerHasPatherAgreement()) {
            return 0;
        }
        if (LuddicPathHostileActivityFactor.isPlayerDefeatedPatherExpedition()) {
            return 0;
        }
        int progress = Math.round(this.getTotalPatherInterest());
        float unit = Global.getSettings().getFloat("patherProgressUnit");
        float mult = Global.getSettings().getFloat("patherProgressMult");
        int rem = progress;
        float adjusted = 0.0f;
        while ((float)rem > unit) {
            adjusted += unit;
            rem = (int)((float)rem - unit);
            rem = (int)((float)rem * mult);
        }
        int reduced = Math.round(adjusted += (float)rem);
        if (progress > 0 && reduced < 1) {
            reduced = 1;
        }
        progress = reduced;
        return progress;
    }

    public String getDesc() {
        return "\u4f7f\u7528 \u9ad8\u7aef\u79d1\u6280 \u548c AI \u6838\u5fc3";
    }

    public float getTotalPatherInterest() {
        float total = 0.0f;
        for (StarSystemAPI system : Misc.getPlayerSystems(false)) {
            float noCells = Global.getSettings().getFloat("patherProgressMultNoCells");
            float sleeperCells = Global.getSettings().getFloat("patherProgressMultSleeperCells");
            float activeCells = Global.getSettings().getFloat("patherProgressMultActiveCells");
            total += StandardLuddicPathActivityCause2.getPatherInterest(system, noCells, sleeperCells, activeCells);
        }
        return total;
    }

    public static float getPatherInterest(StarSystemAPI system, float multIfNoCells, float multIfSleeper, float multIfActive) {
        return StandardLuddicPathActivityCause2.getPatherInterest(system, multIfNoCells, multIfSleeper, multIfActive, false);
    }

    public static float getPatherInterest(StarSystemAPI system, float multIfNoCells, float multIfSleeper, float multIfActive, boolean countCellsOnly) {
        float total = 0.0f;
        List<MarketAPI> markets = Misc.getMarketsInLocation(system, "player");
        for (MarketAPI market : markets) {
            float mult = 1.0f;
            LuddicPathCellsIntel intel = LuddicPathCellsIntel.getCellsForMarket(market);
            mult = intel == null ? multIfNoCells : (intel.isSleeper() ? multIfSleeper : multIfActive);
            float interest = LuddicPathBaseManager.getLuddicPathMarketInterest(market);
            if (countCellsOnly) {
                interest = 1.0f;
            }
            total += interest * mult;
        }
        return total;
    }

    public float getMagnitudeContribution(StarSystemAPI system) {
        if (HA_CMD.playerHasPatherAgreement()) {
            return 0.0f;
        }
        if (LuddicPathHostileActivityFactor.isPlayerDefeatedPatherExpedition()) {
            return 0.0f;
        }
        List<MarketAPI> markets = Misc.getMarketsInLocation(system, "player");
        float perSleeperBase = Global.getSettings().getFloat("luddicPathSleeperCellsBase");
        float perSleeperSize = Global.getSettings().getFloat("luddicPathSleeperCellsPerSize");
        float perActiveBase = Global.getSettings().getFloat("luddicPathActiveCellsBase");
        float perActiveSize = Global.getSettings().getFloat("luddicPathActiveCellsPerSize");
        float perPointOfInterest = Global.getSettings().getFloat("luddicPathPerPointOfInterest");
        float max = 0.0f;
        for (MarketAPI market : markets) {
            LuddicPathCellsIntel intel = LuddicPathCellsIntel.getCellsForMarket(market);
            if (intel == null) continue;
            float curr = 0.0f;
            curr = intel.isSleeper() ? (curr += perSleeperBase + (float)market.getSize() * perSleeperSize) : (curr += perActiveBase + (float)market.getSize() * perActiveSize);
            float interest = LuddicPathBaseManager.getLuddicPathMarketInterest(market);
            curr += interest * perPointOfInterest;
            if (!(curr >= max)) continue;
            max = curr;
        }
        max = (float)Math.round(max * 100.0f) / 100.0f;
        return max;
    }
}

