/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.intel.PerseanLeagueMembership;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseHostileActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.PerseanLeagueHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.rulecmd.HA_CMD;
import com.fs.starfarer.api.ui.MapParams;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.ui.UIPanelAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class StandardPerseanLeagueActivityCause
extends BaseHostileActivityCause2 {
    public static int LARGE_COLONY = 5;
    public static int MEDIUM_COLONY = 4;
    public static int COUNT_IF_MEDIUM = 2;
    public static float MAX_MAG = 0.5f;

    public StandardPerseanLeagueActivityCause(HostileActivityEventIntel intel) {
        super(intel);
    }

    public TooltipMakerAPI.TooltipCreator getTooltip() {
        return new BaseFactorTooltip(){

            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                float opad = 10.0f;
                tooltip.addPara("\u524d\u5f80 Kazeron \u4e0e\u82f1\u4ed9\u5ea7\u8054\u76df\u5c31 \u52a0\u5165\u8054\u76df \u4e8b\u5b9c \u8fdb\u884c\u8c08\u5224 \u53ef\u80fd\u8ba9\u8fd9\u79cd\u9a9a\u6270\u505c\u6b62\u3002\u5982\u679c\u4e0d\u52a0\u4ee5\u63a7\u5236\uff0c\u8d77\u521d\u5fae\u5c0f\u7684\u51b2\u7a81\u7ec8\u5c06\u6fc0\u70c8\u7206\u53d1\uff0c\u5e76\u53ef\u80fd\u4ee5\u67d0\u79cd\u65b9\u5f0f\u5f97\u5230\u89e3\u51b3\u3002", 0.0f, Misc.getHighlightColor(), "\u52a0\u5165\u8054\u76df");
                tooltip.addPara("\u4e8b\u4ef6\u8fdb\u5c55\u5c06\u57fa\u4e8e\u4f60\u6b96\u6c11\u5730\u7684\u6570\u91cf\u4e0e\u603b\u89c4\u6a21\u3002\u5f53\u62e5\u6709\u4e00\u4e2a\u89c4\u6a21\u5927\u4e8e\u6216\u7b49\u4e8e %s \u7684\u6b96\u6c11\u5730\uff0c\u6216\u81f3\u5c11 %s \u4e2a\u89c4\u6a21\u5927\u4e8e\u6216\u7b49\u4e8e %s \u7684\u6b96\u6c11\u5730\u65f6\u5c06\u5f00\u59cb\u8fdb\u5c55\u3002", opad, Misc.getHighlightColor(), "" + LARGE_COLONY, "" + COUNT_IF_MEDIUM, "" + MEDIUM_COLONY);
                MarketAPI kazeron = PerseanLeagueHostileActivityFactor.getKazeron(false);
                if (kazeron != null && kazeron.getStarSystem() != null) {
                    MapParams params = new MapParams();
                    params.showSystem(kazeron.getStarSystem());
                    float w = tooltip.getWidthSoFar();
                    float h = Math.round(w / 1.6f);
                    params.positionToShowAllMarkersAndSystems(true, Math.min(w, h));
                    UIPanelAPI map = tooltip.createSectorMap(w, h, params, String.valueOf(kazeron.getName()) + " (" + kazeron.getStarSystem().getNameWithLowercaseTypeShort() + ")");
                    tooltip.addCustom(map, opad);
                }
            }
        };
    }

    public boolean shouldShow() {
        return this.getProgress() != 0;
    }

    public String getProgressStr() {
        return super.getProgressStr();
    }

    public Color getProgressColor(BaseEventIntel intel) {
        return super.getProgressColor(intel);
    }

    public int getProgress() {
        if (!HA_CMD.canPlayerJoinTheLeague()) {
            return 0;
        }
        if (PerseanLeagueMembership.isDefeatedBlockadeOrPunEx()) {
            return 0;
        }
        int score = 0;
        for (MarketAPI market : Misc.getPlayerMarkets(false)) {
            int size = market.getSize();
            if (size <= 4) {
                score += size;
                continue;
            }
            if (size == 5) {
                score += size + 2;
                continue;
            }
            if (size == 6) {
                score += size + 4;
                continue;
            }
            score += size + 6;
        }
        int progress = score;
        return progress;
    }

    public String getDesc() {
        return "\u6b96\u6c11\u5730\u6570\u91cf\u4e0e\u89c4\u6a21";
    }

    public float getMagnitudeContribution(StarSystemAPI system) {
        if (this.getProgress() <= 0) {
            return 0.0f;
        }
        return (0.4f + 0.6f * this.intel.getMarketPresenceFactor(system)) * MAX_MAG;
    }
}

