/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseHostileActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.rulecmd.KantaCMD;
import com.fs.starfarer.api.ui.MapParams;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.ui.UIPanelAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;

public class StandardPirateActivityCause2
extends BaseHostileActivityCause2 {
    public static float MAX_MAG = 0.5f;

    public StandardPirateActivityCause2(HostileActivityEventIntel intel) {
        super(intel);
    }

    public TooltipMakerAPI.TooltipCreator getTooltip() {
        return new BaseFactorTooltip(){

            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                float opad = 10.0f;
                tooltip.addPara("\u4efb\u4f55\u6b96\u6c11\u5730\uff0c\u5c24\u5176\u662f\u4f4d\u4e8e\u6838\u5fc3\u661f\u57df\u4ee5\u5916\u7684\u6b96\u6c11\u5730\uff0c\u90fd\u4f1a\u5438\u5f15\u6d77\u76d7\u6d3b\u52a8\u3002 %s \u548c %s \u6b96\u6c11\u5730\u4f1a\u5438\u5f15\u66f4\u591a\u6d77\u76d7\u3002", 0.0f, Misc.getHighlightColor(), "\u66f4\u5927", "\u66f4\u4e0d\u7a33\u5b9a");
                tooltip.addPara("\u4e8b\u4ef6\u8fdb\u5c55\u70b9\u8fdb\u5ea6\u57fa\u4e8e\u4f60\u63a7\u5236\u4e0b\u6700\u5927\u6b96\u6c11\u5730\u7684\u89c4\u6a21\u548c\u5176\u7a33\u5b9a\u6027\u3002\u5982\u679c\u6709\u591a\u4e2a\u540c\u6837\u89c4\u6a21\u7684\u6b96\u6c11\u5730\uff0c\u4f7f\u7528\u7a33\u5b9a\u6027\u6700\u9ad8\u7684\u90a3\u4e2a\u3002", opad);
                MarketAPI biggest = StandardPirateActivityCause2.this.getBiggestColony();
                if (biggest != null && biggest.getStarSystem() != null) {
                    tooltip.addPara("\u6700\u5927\u7684\u6b96\u6c11\u5730\uff1a%s}\uff0c\u89c4\u6a21: %s}\uff0c\u7a33\u5b9a\u6027\uff1a%s", opad, Misc.getHighlightColor(), biggest.getName(), "" + biggest.getSize(), "" + (int)biggest.getStabilityValue());
                    MapParams params = new MapParams();
                    params.showSystem(biggest.getStarSystem());
                    float w = tooltip.getWidthSoFar();
                    float h = Math.round(w / 1.6f);
                    params.positionToShowAllMarkersAndSystems(true, Math.min(w, h));
                    UIPanelAPI map = tooltip.createSectorMap(w, h, params, biggest.getStarSystem().getNameWithLowercaseTypeShort());
                    tooltip.addCustom(map, opad);
                }
            }
        };
    }

    public MarketAPI getBiggestColony() {
        List<MarketAPI> markets = Misc.getPlayerMarkets(false);
        MarketAPI biggest = null;
        float max = 0.0f;
        for (MarketAPI market : markets) {
            float size = market.getSize();
            if (!(size >= max) || size == max && biggest != null && biggest.getStabilityValue() > market.getStabilityValue()) continue;
            max = size;
            biggest = market;
        }
        return biggest;
    }

    public boolean shouldShow() {
        return this.getProgress() != 0 || KantaCMD.playerHasProtection();
    }

    public String getProgressStr() {
        if (KantaCMD.playerHasProtection()) {
            return "---";
        }
        return super.getProgressStr();
    }

    public Color getProgressColor(BaseEventIntel intel) {
        if (KantaCMD.playerHasProtection()) {
            return Misc.getPositiveHighlightColor();
        }
        return super.getProgressColor(intel);
    }

    public int getProgress() {
        if (KantaCMD.playerHasProtection()) {
            return 0;
        }
        MarketAPI biggest = this.getBiggestColony();
        if (biggest == null) {
            return 0;
        }
        int progress = (int)((float)biggest.getSize() + (10.0f - biggest.getStabilityValue()));
        return progress;
    }

    public String getDesc() {
        return "\u6b96\u6c11\u5730\u7684\u5b58\u5728\u548c\u7a33\u5b9a\u6027";
    }

    public float getMagForMarket(MarketAPI market) {
        float val = (float)market.getSize() * (0.33f + 0.67f * (1.0f - market.getStabilityValue() / 10.0f));
        if ((val *= 0.1f) > MAX_MAG) {
            val = MAX_MAG;
        }
        return val;
    }

    public float getMagnitudeContribution(StarSystemAPI system) {
        if (KantaCMD.playerHasProtection()) {
            return 0.0f;
        }
        if (this.getProgress() <= 0) {
            return 0.0f;
        }
        List<MarketAPI> markets = Misc.getMarketsInLocation(system, "player");
        float max = 0.1f;
        for (MarketAPI market : markets) {
            float val = this.getMagForMarket(market);
            max = Math.max(val, max);
        }
        if (max > MAX_MAG) {
            max = MAX_MAG;
        }
        max = (float)Math.round(max * 100.0f) / 100.0f;
        return max;
    }
}

