/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseHostileActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.TriTachyonHostileActivityFactor;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.MapParams;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.ui.UIPanelAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriTachyonStandardActivityCause
extends BaseHostileActivityCause2 {
    public static int MIN_TRITACH_PRODUCTION = 5;
    public static int MIN_COMPETITOR_PRODUCTION = 4;
    public static int MIN_COMPETITOR_MARKET_SIZE = 4;
    public static float PROD_PROGRESS_MULT = Global.getSettings().getFloat("triTachyonProgressPerUnitProdMult");
    public static Set<String> COMPETING_COMMODITIES = new LinkedHashSet<String>();
    public static float MAX_MAG;

    static {
        COMPETING_COMMODITIES.add("luxury_goods");
        COMPETING_COMMODITIES.add("fuel");
        COMPETING_COMMODITIES.add("drugs");
        COMPETING_COMMODITIES.add("organs");
        COMPETING_COMMODITIES.add("hand_weapons");
        COMPETING_COMMODITIES.add("rare_ore");
        COMPETING_COMMODITIES.add("rare_metals");
        COMPETING_COMMODITIES.add("heavy_machinery");
        COMPETING_COMMODITIES.add("supplies");
        COMPETING_COMMODITIES.add("volatiles");
        COMPETING_COMMODITIES.add("organics");
        MAX_MAG = 0.5f;
    }

    public static CompetitorData computeCompetitorData(String factionId, String competitorId, String commodityId) {
        CompetitorData data = new CompetitorData(commodityId);
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            int prod;
            CommodityOnMarketAPI com = market.getCommodityData(commodityId);
            if (com == null || (prod = com.getMaxSupply()) <= 0) continue;
            if (factionId.equals(market.getFactionId())) {
                data.factionProdTotal += prod;
                data.factionProducers.add(market);
                data.factionMaxProd = Math.max(data.factionMaxProd, prod);
            } else if (competitorId.equals(market.getFactionId())) {
                data.competitorProdTotal += prod;
                data.competitorMaxProd = Math.max(data.competitorMaxProd, prod);
                data.competitorProducers.add(market);
                data.competitorMaxMarketSize = Math.max(data.competitorMaxMarketSize, market.getSize());
            }
            data.allProdTotal += prod;
        }
        return data;
    }

    public static List<CompetitorData> computePlayerCompetitionData() {
        String factionId = "tritachyon";
        LinkedHashSet<String> commodities = new LinkedHashSet<String>();
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (!factionId.equals(market.getFactionId())) continue;
            for (CommodityOnMarketAPI com : market.getCommoditiesCopy()) {
                int prod;
                if (com.isPersonnel() || com.getId().equals("ships") || com.getId().equals("ship_weapons") || !COMPETING_COMMODITIES.contains(com.getId()) || (prod = com.getMaxSupply()) < MIN_TRITACH_PRODUCTION) continue;
                commodities.add(com.getId());
            }
        }
        ArrayList<CompetitorData> result = new ArrayList<CompetitorData>();
        for (String commodityId : commodities) {
            CompetitorData data = TriTachyonStandardActivityCause.computeCompetitorData(factionId, "player", commodityId);
            if (data.competitorMaxProd < MIN_COMPETITOR_PRODUCTION || data.competitorMaxMarketSize < MIN_COMPETITOR_MARKET_SIZE) continue;
            result.add(data);
        }
        return result;
    }

    public TriTachyonStandardActivityCause(HostileActivityEventIntel intel) {
        super(intel);
    }

    @Override
    public TooltipMakerAPI.TooltipCreator getTooltip() {
        return new BaseFactorTooltip(){

            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                float opad = 10.0f;
                Color h = Misc.getHighlightColor();
                Color tc = Misc.getTextColor();
                tooltip.addPara("\u4f60\u6b96\u6c11\u5730\u5728\u67d0\u51e0\u7c7b\u5546\u54c1\u9886\u57df\u5185\u5177\u6709\u76f8\u5f53\u9ad8\u7684\u751f\u4ea7\u80fd\u529b\uff0c\u800c\u901f\u5b50\u79d1\u6280\u4e5f\u5728\u540c\u6837\u7684\u9886\u57df\u5185\u62e5\u6709\u5927\u91cf\u8d44\u4ea7\uff0c\u56e0\u6b64\u53ef\u4ee5\u88ab\u89c6\u4e3a\u7ade\u4e89\u3002", 0.0f);
                TriTachyonHostileActivityFactor.addDealtSectionToTooltip(tooltip, opad);
                List<CompetitorData> comp = TriTachyonStandardActivityCause.computePlayerCompetitionData();
                FactionAPI player = Global.getSector().getFaction("player");
                tooltip.beginTable(player, 20.0f, "\u5546\u54c1", Float.valueOf(this.getTooltipWidth(tooltipParam) - 150.0f), "\u4ea7\u51fa", Float.valueOf(150.0f));
                for (CompetitorData data : comp) {
                    tooltip.addRow(new Object[]{Alignment.LMID, tc, Misc.ucFirst(data.spec.getLowerCaseName()), Alignment.MID, h, "" + data.competitorMaxProd});
                }
                tooltip.addTable("", 0, opad);
                tooltip.addSpacer(5.0f);
                tooltip.addPara("\u4e8b\u4ef6\u8fdb\u5c55\u5c06\u57fa\u4e8e\u4f60\u5bf9\u6bcf\u79cd\u5546\u54c1\u7684\u603b\u751f\u4ea7\u80fd\u529b\u3002%s \u81f3\u6240\u6709\u6b96\u6c11\u5730\u5747\u4f4e\u4e8e %s}\uff0c\u6216\u5c06\u7ade\u4e89\u524a\u51cf\u81f3 \u5355\u4e00\u5546\u54c1 \u5185\uff0c\u4e5f\u8bb8\u80fd\u8ba9\u901f\u5b50\u79d1\u6280\u4e0d\u518d\u5728\u610f\u4f60\u3002", opad, h, "\u5c06\u751f\u4ea7\u80fd\u529b\u964d\u4f4e", "" + MIN_COMPETITOR_PRODUCTION, "\u5355\u4e00\u5546\u54c1");
                tooltip.addPara("%s \u4e5f\u662f\u4e00\u79cd\u89e3\u51b3\u65b9\u6cd5\u3002", opad, h, "\u5bfb\u6c42\u4e92\u60e0\u65b9\u6848");
                StarSystemAPI system = TriTachyonHostileActivityFactor.getPrimaryTriTachyonSystem();
                if (system != null) {
                    tooltip.addPara("\u901f\u5b50\u79d1\u6280\u7684\u4e3b\u8981\u751f\u4ea7\u4e2d\u5fc3\u4f4d\u4e8e " + system.getNameWithLowercaseType() + "\u3002", opad);
                    MapParams params = new MapParams();
                    params.showSystem(system);
                    float width = tooltip.getWidthSoFar();
                    float height = Math.round(width / 1.6f);
                    params.positionToShowAllMarkersAndSystems(true, Math.min(width, height));
                    UIPanelAPI map = tooltip.createSectorMap(width, height, params, system.getNameWithLowercaseTypeShort());
                    tooltip.addCustom(map, opad);
                }
            }
        };
    }

    @Override
    public boolean shouldShow() {
        return this.getProgress() != 0;
    }

    @Override
    public int getProgress() {
        if (TriTachyonHostileActivityFactor.isPlayerCounterRaidedTriTach() || TriTachyonHostileActivityFactor.getPrimaryTriTachyonSystem() == null) {
            return 0;
        }
        int total = 0;
        List<CompetitorData> comp = TriTachyonStandardActivityCause.computePlayerCompetitionData();
        if (comp.size() <= 1) {
            return 0;
        }
        for (CompetitorData data : comp) {
            total += data.getProgress(PROD_PROGRESS_MULT);
        }
        if (TriTachyonHostileActivityFactor.isDealtWithMercAttack()) {
            total = Math.round((float)total * TriTachyonHostileActivityFactor.DEALT_WITH_MERC_PROGRESS_MULT);
        }
        return total;
    }

    @Override
    public String getDesc() {
        return "\u51fa\u53e3\u7ade\u4e89";
    }

    @Override
    public float getMagnitudeContribution(StarSystemAPI system) {
        if (this.getProgress() <= 0) {
            return 0.0f;
        }
        List<CompetitorData> comp = TriTachyonStandardActivityCause.computePlayerCompetitionData();
        float mag = 0.0f;
        for (CompetitorData data : comp) {
            for (MarketAPI market : data.competitorProducers) {
                if (market.getContainingLocation() != system) continue;
                CommodityOnMarketAPI com = market.getCommodityData(data.commodityId);
                float prod = com.getMaxSupply();
                mag += prod * 0.05f;
            }
        }
        if (mag > MAX_MAG) {
            mag = MAX_MAG;
        }
        mag = (float)Math.round(mag * 100.0f) / 100.0f;
        return mag;
    }

    public static class CompetitorData {
        public String commodityId;
        public CommoditySpecAPI spec;
        public int factionProdTotal;
        public int factionMaxProd;
        public int competitorProdTotal;
        public int competitorMaxProd;
        public int competitorMaxMarketSize;
        public int allProdTotal;
        public List<MarketAPI> factionProducers = new ArrayList<MarketAPI>();
        public List<MarketAPI> competitorProducers = new ArrayList<MarketAPI>();

        public CompetitorData(String commodityId) {
            this.commodityId = commodityId;
            this.spec = Global.getSettings().getCommoditySpec(commodityId);
        }

        public int getProgress(float progMult) {
            return Math.round((float)this.competitorMaxProd * progMult);
        }
    }
}

