/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events.ht;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.characters.AbilityPlugin;
import com.fs.starfarer.api.impl.campaign.intel.events.ht.HTHighBurnFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.ht.HTPoints;
import com.fs.starfarer.api.impl.campaign.intel.events.ht.HTScanFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.ht.HyperspaceTopographyEventIntel;
import com.fs.starfarer.api.impl.campaign.terrain.PulsarBeamTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.StarCoronaTerrainPlugin;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.util.LinkedHashSet;

public class HTFactorTracker
implements EveryFrameScript {
    public static float CHECK_DAYS = 0.05f;
    protected IntervalUtil interval = new IntervalUtil(CHECK_DAYS * 0.8f, CHECK_DAYS * 1.2f);
    protected float burnBasedPoints = 0.0f;
    protected float daysSinceAtHighBurn = 1.0f;
    protected boolean canCheckSB = true;
    protected LinkedHashSet<String> scanned = new LinkedHashSet();

    protected Object readResolve() {
        if (this.scanned == null) {
            this.scanned = new LinkedHashSet();
        }
        return this;
    }

    public boolean isDone() {
        return false;
    }

    public boolean runWhilePaused() {
        return false;
    }

    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        this.interval.advance(days);
        if (this.interval.intervalElapsed()) {
            this.checkHighBurn(this.interval.getIntervalDuration());
            this.checkSensorBursts();
        }
    }

    protected void checkHighBurn(float days) {
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        if (pf != null && pf.isInHyperspace()) {
            int chunk;
            float burn = pf.getCurrBurnLevel();
            this.daysSinceAtHighBurn = burn > 20.0f ? 0.0f : (this.daysSinceAtHighBurn += days);
            float add = 0.0f;
            float min = 0.0f;
            float max = 0.0f;
            float f = 0.0f;
            if (burn > 40.0f) {
                min = HTPoints.PER_DAY_AT_BURN_40;
                max = HTPoints.PER_DAY_AT_BURN_50;
                f = (Math.min(burn, (float)HTPoints.MAX_BURN_FOR_POINT_GAIN) - 40.0f) / 10.0f;
            } else if (burn > 30.0f) {
                min = HTPoints.PER_DAY_AT_BURN_30;
                max = HTPoints.PER_DAY_AT_BURN_40;
                f = (burn - 30.0f) / 10.0f;
            } else if (burn > 20.0f) {
                min = HTPoints.PER_DAY_AT_BURN_20;
                max = HTPoints.PER_DAY_AT_BURN_30;
                f = (burn - 20.0f) / 10.0f;
            }
            add = min + (max - min) * f;
            add *= CHECK_DAYS;
            if (pf.getMemoryWithoutUpdate().getBoolean("$noHighBurnTopographyReadings")) {
                add = 0.0f;
            }
            if (add > 0.0f) {
                this.burnBasedPoints += add;
            }
            if (this.burnBasedPoints >= (float)(chunk = HTPoints.BURN_POINT_CHUNK_SIZE) && this.daysSinceAtHighBurn > 0.3f) {
                int mult = (int)this.burnBasedPoints / chunk;
                int points = chunk * mult;
                this.burnBasedPoints -= (float)points;
                HyperspaceTopographyEventIntel.addFactorCreateIfNecessary(new HTHighBurnFactor(points), null);
            }
        } else {
            this.daysSinceAtHighBurn = 1.0f;
        }
    }

    public void checkSensorBursts() {
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        if (pf == null) {
            return;
        }
        AbilityPlugin sb = pf.getAbility("sensor_burst");
        if (sb == null) {
            return;
        }
        if (sb.isUsable() || sb.getLevel() <= 0.0f) {
            this.canCheckSB = true;
        }
        if (this.canCheckSB && !pf.isInHyperspace() && sb.isInProgress() && sb.getLevel() > 0.9f && !pf.getContainingLocation().hasTag("no_topography_scans")) {
            for (SectorEntityToken entity : pf.getContainingLocation().getAllEntities()) {
                this.checkBlackHole(entity);
                this.checkIonStorm(entity);
                this.checkGasGiant(entity);
                this.checkPulsar(entity);
            }
            for (CampaignTerrainAPI terrain : pf.getContainingLocation().getTerrainCopy()) {
                this.checkMagneticField(terrain);
            }
            this.checkSystemCenter();
            this.canCheckSB = false;
        }
    }

    protected void checkBlackHole(SectorEntityToken entity) {
        if (!(entity instanceof PlanetAPI)) {
            return;
        }
        PlanetAPI planet = (PlanetAPI)entity;
        if (!planet.getSpec().isBlackHole()) {
            return;
        }
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        float dist = Misc.getDistance(pf.getLocation(), entity.getLocation());
        StarCoronaTerrainPlugin eventHorizon = Misc.getCoronaFor(planet);
        if (eventHorizon == null) {
            return;
        }
        String id1 = String.valueOf(planet.getId()) + "_1";
        String id2 = String.valueOf(planet.getId()) + "_2";
        float closeRange = planet.getRadius() + 300.0f;
        if (dist < closeRange) {
            if (this.scanned.contains(id2)) {
                this.addMessage("\u9ed1\u6d1e\u5df2\u88ab\u8fd1\u8ddd\u79bb\u626b\u63cf");
            } else {
                HyperspaceTopographyEventIntel.addFactorCreateIfNecessary(new HTScanFactor("\u9ed1\u6d1e\u5df2\u88ab\u8fd1\u8ddd\u79bb\u626b\u63cf (" + planet.getName() + ") ", HTPoints.SCAN_BLACK_HOLE_SHORT_RANGE), null);
                this.scanned.add(id2);
            }
        } else if (eventHorizon.containsEntity(pf)) {
            if (this.scanned.contains(id1)) {
                this.addMessage("\u9ed1\u6d1e\u5df2\u88ab\u8fdc\u8ddd\u79bb\u626b\u63cf");
            } else {
                HyperspaceTopographyEventIntel.addFactorCreateIfNecessary(new HTScanFactor("\u9ed1\u6d1e\u5df2\u88ab\u8fdc\u8ddd\u79bb\u626b\u63cf (" + planet.getName() + ") ", HTPoints.SCAN_BLACK_HOLE_LONG_RANGE), null);
                this.scanned.add(id1);
            }
        }
    }

    protected void checkIonStorm(SectorEntityToken entity) {
        if (!(entity instanceof PlanetAPI)) {
            return;
        }
        PlanetAPI planet = (PlanetAPI)entity;
        if (!planet.isGasGiant()) {
            return;
        }
        StarCoronaTerrainPlugin ionStorm = Misc.getCoronaFor(planet);
        if (ionStorm == null) {
            return;
        }
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        String id = ionStorm.getEntity().getId();
        if (ionStorm.containsEntity(pf)) {
            if (this.scanned.contains(id)) {
                this.addMessage("\u79bb\u5b50\u98ce\u66b4\u5df2\u88ab\u626b\u63cf");
            } else {
                HyperspaceTopographyEventIntel.addFactorCreateIfNecessary(new HTScanFactor("\u79bb\u5b50\u98ce\u66b4\u5df2\u88ab\u626b\u63cf (" + planet.getName() + ") ", HTPoints.SCAN_ION_STORM), null);
                this.scanned.add(id);
            }
        }
    }

    protected void checkMagneticField(CampaignTerrainAPI terrain) {
        if (terrain.getPlugin() == null) {
            return;
        }
        if (!"magnetic_field".equals(terrain.getType())) {
            return;
        }
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        String id = terrain.getId();
        if (terrain.getPlugin().containsEntity(pf)) {
            if (this.scanned.contains(id)) {
                this.addMessage("\u5df2\u626b\u63cf\u8fc7\u6b64\u78c1\u573a");
            } else {
                HyperspaceTopographyEventIntel.addFactorCreateIfNecessary(new HTScanFactor("\u78c1\u573a\u5df2\u88ab\u626b\u63cf", HTPoints.SCAN_MAGNETIC_FIELD), null);
                this.scanned.add(id);
            }
        }
    }

    protected void checkGasGiant(SectorEntityToken entity) {
        boolean inRange;
        if (!(entity instanceof PlanetAPI)) {
            return;
        }
        PlanetAPI planet = (PlanetAPI)entity;
        if (!planet.isGasGiant()) {
            return;
        }
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        String id = planet.getId();
        float dist = Misc.getDistance(pf.getLocation(), entity.getLocation());
        boolean bl = inRange = dist < 500.0f + planet.getRadius();
        if (inRange) {
            if (this.scanned.contains(id)) {
                this.addMessage("\u6c14\u6001\u5de8\u884c\u661f\u5df2\u88ab\u626b\u63cf");
            } else {
                HyperspaceTopographyEventIntel.addFactorCreateIfNecessary(new HTScanFactor("\u6c14\u6001\u5de8\u884c\u661f\u5df2\u88ab\u626b\u63cf (" + planet.getName() + ") ", HTPoints.SCAN_GAS_GIANT), null);
                this.scanned.add(id);
            }
        }
    }

    protected void checkSystemCenter() {
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        StarSystemAPI system = pf.getStarSystem();
        if (system == null) {
            return;
        }
        String type = null;
        int points = 0;
        switch (system.getType()) {
            case BINARY_CLOSE: {
                type = "\u53cc\u661f\u7cfb\u7edf\u4e2d\u5fc3";
                points = HTPoints.SCAN_BINARY;
                break;
            }
            case NEBULA: {
                type = "\u6ca1\u6709\u6052\u661f\u7684\u661f\u4e91\u4e2d\u592e";
                points = HTPoints.SCAN_NEBULA;
                break;
            }
            case TRINARY_1CLOSE_1FAR: {
                type = "\u53cc\u661f\u7cfb\u7edf\u4e2d\u5fc3";
                points = HTPoints.SCAN_BINARY;
                break;
            }
            case TRINARY_2CLOSE: {
                type = "\u4e09\u661f\u7cfb\u7edf\u4e2d\u5fc3";
                points = HTPoints.SCAN_TRINARY;
                break;
            }
            default: {
                int count = 0;
                for (PlanetAPI curr : system.getPlanets()) {
                    float dist;
                    if (!curr.isStar() || !((dist = Misc.getDistance(curr.getLocation(), pf.getLocation())) < 2000.0f + curr.getRadius())) continue;
                    ++count;
                }
                if (count <= true) break;
                type = "\u661f\u9645\u6270\u6d41";
                points = count == 2 ? HTPoints.SCAN_BINARY : HTPoints.SCAN_TRINARY;
            }
        }
        if (type == null) {
            return;
        }
        String id = "systemtypescan_" + system.getId();
        float range = pf.getLocation().length();
        if (range < 2000.0f) {
            if (this.scanned.contains(id)) {
                this.addMessage("\u661f\u7cfb\u6838\u5fc3\u5df2\u88ab\u626b\u63cf");
            } else {
                HyperspaceTopographyEventIntel.addFactorCreateIfNecessary(new HTScanFactor(String.valueOf(type) + " \u5df2\u626b\u63cf (" + system.getBaseName() + ") ", points), null);
                this.scanned.add(id);
            }
        }
    }

    protected void checkPulsar(SectorEntityToken entity) {
        if (!(entity instanceof PlanetAPI)) {
            return;
        }
        PlanetAPI planet = (PlanetAPI)entity;
        if (!planet.getSpec().isPulsar()) {
            return;
        }
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        StarCoronaTerrainPlugin corona = Misc.getCoronaFor(planet);
        if (corona == null) {
            return;
        }
        PulsarBeamTerrainPlugin pulsar = Misc.getPulsarFor(planet);
        if (pulsar == null) {
            return;
        }
        String id1 = String.valueOf(planet.getId()) + "_1";
        String id2 = String.valueOf(planet.getId()) + "_2";
        if (corona.containsEntity(pf)) {
            if (this.scanned.contains(id2)) {
                this.addMessage("\u4e2d\u5b50\u661f\u5df2\u88ab\u626b\u63cf");
            } else {
                HyperspaceTopographyEventIntel.addFactorCreateIfNecessary(new HTScanFactor("\u4e2d\u5b50\u661f\u5df2\u88ab\u626b\u63cf (" + planet.getName() + ") ", HTPoints.SCAN_NEUTRON_STAR), null);
                this.scanned.add(id2);
            }
        }
        if (pulsar.containsEntity(pf)) {
            if (this.scanned.contains(id1)) {
                this.addMessage("\u8109\u51b2\u661f\u5149\u675f\u5df2\u88ab\u626b\u63cf");
            } else {
                HyperspaceTopographyEventIntel.addFactorCreateIfNecessary(new HTScanFactor("\u8109\u51b2\u661f\u5149\u675f\u5df2\u88ab\u626b\u63cf (" + planet.getName() + ") ", HTPoints.SCAN_PULSAR_BEAM), null);
                this.scanned.add(id1);
            }
        }
    }

    protected void addMessage(String text) {
        Global.getSector().getCampaignUI().getMessageDisplay().addMessage(String.valueOf(text) + "\uff0c\u6ca1\u6709\u83b7\u5f97\u65b0\u7684\u8d85\u7a7a\u95f4\u6d4b\u7ed8\u6570\u636e", Misc.getNegativeHighlightColor());
    }
}

