/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events.ht;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PersistentUIDataAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.CharacterStatsRefreshListener;
import com.fs.starfarer.api.campaign.listeners.CurrentLocationChangedListener;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.combat.StatBonus;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.EventFactor;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddAbility;
import com.fs.starfarer.api.impl.campaign.velfield.SlipstreamTerrainPlugin2;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.TimeoutTracker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperspaceTopographyEventIntel
extends BaseEventIntel
implements FleetEventListener,
CharacterStatsRefreshListener,
CurrentLocationChangedListener {
    public static Color BAR_COLOR = Global.getSettings().getColor("progressBarFleetPointsColor");
    public static int PROGRESS_MAX = 1000;
    public static int PROGRESS_1 = 100;
    public static int PROGRESS_2 = 250;
    public static int PROGRESS_3 = 400;
    public static int PROGRESS_4 = 550;
    public static int PROGRESS_5 = 700;
    public static float BASE_DETECTION_RANGE_LY = 3.0f;
    public static float RANGE_WITHIN_WHICH_SENSOR_ARRAYS_HELP_LY = 5.0f;
    public static float RANGE_PER_DOMAIN_SENSOR_ARRAY = 2.0f;
    public static float RANGE_PER_MAKESHIFT_SENSOR_ARRAY = 1.0f;
    public static int MAX_SENSOR_ARRAYS = 3;
    public static float WAYSTATION_BONUS = 2.0f;
    public static float SLIPSTREAM_FUEL_MULT = 0.25f;
    public static float HYPER_BURN_BONUS = 3.0f;
    public static String KEY = "$hte_ref";
    public static float RECENT_READINGS_TIMEOUT = 30.0f;
    public static float RECENT_READINGS_RANGE_LY = 10.0f;
    protected TimeoutTracker<RecentTopographyReadings> recent = new TimeoutTracker();

    public static void addFactorCreateIfNecessary(EventFactor factor, InteractionDialogAPI dialog) {
        if (HyperspaceTopographyEventIntel.get() == null) {
            new HyperspaceTopographyEventIntel(null, false);
        }
        if (HyperspaceTopographyEventIntel.get() != null) {
            HyperspaceTopographyEventIntel.get().addFactor(factor, dialog);
        }
    }

    public static HyperspaceTopographyEventIntel get() {
        return (HyperspaceTopographyEventIntel)Global.getSector().getMemoryWithoutUpdate().get(KEY);
    }

    public HyperspaceTopographyEventIntel(TextPanelAPI text, boolean withIntelNotification) {
        Global.getSector().getMemoryWithoutUpdate().set(KEY, this);
        this.setup();
        Global.getSector().getIntelManager().addIntel(this, !withIntelNotification, text);
    }

    protected void setup() {
        this.factors.clear();
        this.stages.clear();
        this.setMaxProgress(PROGRESS_MAX);
        this.addStage((Object)Stage.START, 0);
        this.addStage((Object)Stage.SLIPSTREAM_NAVIGATION, PROGRESS_1, BaseEventIntel.StageIconSize.MEDIUM);
        this.addStage((Object)Stage.SLIPSTREAM_DETECTION, PROGRESS_2, BaseEventIntel.StageIconSize.MEDIUM);
        this.addStage((Object)Stage.REVERSE_POLARITY, PROGRESS_3, BaseEventIntel.StageIconSize.LARGE);
        this.addStage((Object)Stage.HYPERFIELD_OPTIMIZATION, PROGRESS_4, BaseEventIntel.StageIconSize.MEDIUM);
        this.addStage((Object)Stage.GENERATE_SLIPSURGE, PROGRESS_5, BaseEventIntel.StageIconSize.LARGE);
        this.addStage((Object)Stage.TOPOGRAPHIC_DATA, PROGRESS_MAX, true, BaseEventIntel.StageIconSize.SMALL);
        this.getDataFor((Object)((Object)Stage.SLIPSTREAM_NAVIGATION)).keepIconBrightWhenLaterStageReached = true;
        this.getDataFor((Object)((Object)Stage.SLIPSTREAM_DETECTION)).keepIconBrightWhenLaterStageReached = true;
        this.getDataFor((Object)((Object)Stage.REVERSE_POLARITY)).keepIconBrightWhenLaterStageReached = true;
        this.getDataFor((Object)((Object)Stage.HYPERFIELD_OPTIMIZATION)).keepIconBrightWhenLaterStageReached = true;
        this.getDataFor((Object)((Object)Stage.GENERATE_SLIPSURGE)).keepIconBrightWhenLaterStageReached = true;
    }

    protected Object readResolve() {
        if (this.getDataFor((Object)Stage.GENERATE_SLIPSURGE) == null) {
            this.setup();
        }
        return this;
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
        Global.getSector().getMemoryWithoutUpdate().unset(KEY);
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        if (this.addEventFactorBulletPoints(info, mode, isUpdate, tc, initPad)) {
            return;
        }
        Color h = Misc.getHighlightColor();
        if (isUpdate && this.getListInfoParam() instanceof BaseEventIntel.EventStageData) {
            BaseEventIntel.EventStageData esd = (BaseEventIntel.EventStageData)this.getListInfoParam();
            if (esd.id == Stage.SLIPSTREAM_DETECTION) {
                info.addPara("\u53ef\u4ee5\u89c2\u6d4b\u5230\u4f60\u592a\u7a7a\u6e2f\u9644\u8fd1\u7684 \u8d85\u7a7a\u95f4\u6ed1\u6d41", tc, initPad);
            }
            if (esd.id == Stage.SLIPSTREAM_NAVIGATION) {
                info.addPara("\u5728 \u8d85\u7a7a\u95f4\u6ed1\u6d41 \u4e2d\u822a\u884c\u65f6\uff0c\u71c3\u6599\u82b1\u8d39\u51cf\u5c11 %s", initPad, tc, h, Math.round((1.0f - SLIPSTREAM_FUEL_MULT) * 100.0f) + "%");
            }
            if (esd.id == Stage.HYPERFIELD_OPTIMIZATION) {
                info.addPara("\u8d85\u7a7a\u95f4\u4e2d\u7684\u6700\u5927\u5b87\u5b99\u822a\u901f\u63d0\u9ad8 %s", initPad, tc, h, "" + (int)HYPER_BURN_BONUS);
            }
            if (esd.id == Stage.REVERSE_POLARITY) {
                info.addPara("\u89e3\u9501 %s \u80fd\u529b", initPad, tc, h, "\u6781\u6027\u9006\u8f6c");
            }
            if (esd.id == Stage.GENERATE_SLIPSURGE) {
                info.addPara("\u89e3\u9501 %s \u80fd\u529b", initPad, tc, h, "\u6fc0\u6d41\u8ff8\u53d1");
            }
            if (esd.id == Stage.TOPOGRAPHIC_DATA) {
                info.addPara("\u5f97\u5230\u4e86\u8d85\u7a7a\u95f4\u6d4b\u7ed8\u6570\u636e", tc, initPad);
            }
            return;
        }
    }

    @Override
    public float getImageSizeForStageDesc(Object stageId) {
        if (stageId == Stage.START) {
            return 64.0f;
        }
        return 48.0f;
    }

    @Override
    public float getImageIndentForStageDesc(Object stageId) {
        if (stageId == Stage.START) {
            return 0.0f;
        }
        return 16.0f;
    }

    @Override
    public void addStageDescriptionText(TooltipMakerAPI info, float width, Object stageId) {
        float opad = 10.0f;
        float small = 0.0f;
        Color h = Misc.getHighlightColor();
        BaseEventIntel.EventStageData stage = this.getDataFor(stageId);
        if (stage == null) {
            return;
        }
        if (this.isStageActive(stageId)) {
            this.addStageDesc(info, stageId, small, false);
        }
    }

    public void addStageDesc(TooltipMakerAPI info, Object stageId, float initPad, boolean forTooltip) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (stageId == Stage.START) {
            info.addPara("\u8be6\u7ec6\u7684\u4f20\u611f\u5668\u6570\u636e\u80fd\u5bf9\u8d85\u7a7a\u95f4\u5bfc\u822a\u5927\u6709\u52a9\u76ca\u3002\u83b7\u53d6\u8fd9\u4e9b\u6570\u636e\u7684\u9014\u5f84\u6709\u5f88\u591a\uff0c\u5305\u62ec\u64cd\u4f5c\u661f\u7cfb\u5185\u7684\u4f20\u611f\u5668\u9635\u5217\u3001\u5728\u6709\u8da3\u7684\u5929\u6587\u73b0\u8c61\u9644\u8fd1\u4f7f\u7528\u4f20\u611f\u5668\u626b\u63cf\u3001\u4ee5\u6781\u9ad8\u7684\u6700\u5927\u5b87\u5b99\u822a\u901f\u7a7f\u8d8a\u8d85\u7a7a\u95f4\uff0c\u6216\u8005\u76f4\u63a5\u5411\u62fe\u8352\u8005\u8d2d\u4e70\u6570\u636e\u3002", initPad);
        } else if (stageId == Stage.SLIPSTREAM_DETECTION) {
            info.addPara("\u5141\u8bb8\u501f\u52a9\u592a\u7a7a\u6e2f\u6765\u53d1\u73b0\u661f\u7cfb\u9644\u8fd1\u7684\u8d85\u7a7a\u95f4\u6ed1\u6d41\uff0c\u4e14 %s \u62e5\u6709\u66f4\u5927\u7684\u89c2\u6d4b\u8303\u56f4\u3002%s \u5149\u5e74\u5185\u5904\u4e8e\u4f60\u63a7\u5236\u4e0b\u7684 \u4f20\u611f\u5668\u9635\u5217 \u4f1a\u8fdb\u4e00\u6b65\u63d0\u9ad8\u8be5\u89c2\u6d4b\u8303\u56f4 \u2014\u2014 \u4eba\u4e4b\u9886\u65f6\u4ee3\u9635\u5217\u63d0\u9ad8 %s \u5149\u5e74\uff0c\u4e34\u65f6\u9635\u5217\u63d0\u9ad8 %s \u5149\u5e74\u3002\u6700\u591a\u53d6 %s \u4e2a\u4f20\u611f\u5668\u9635\u5217\u7684\u589e\u76ca\u6548\u679c\u3002", initPad, Misc.getHighlightColor(), "\u66f4\u5927\u7684\u6b96\u6c11\u5730", "" + (int)RANGE_WITHIN_WHICH_SENSOR_ARRAYS_HELP_LY, "+" + (int)RANGE_PER_DOMAIN_SENSOR_ARRAY, "+" + (int)RANGE_PER_MAKESHIFT_SENSOR_ARRAY, "" + MAX_SENSOR_ARRAYS);
        } else if (stageId == Stage.SLIPSTREAM_NAVIGATION) {
            info.addPara("\u5728 \u8d85\u7a7a\u95f4\u6ed1\u6d41 \u4e2d\u822a\u884c\u65f6\uff0c\u71c3\u6599\u82b1\u8d39\u8fdb\u4e00\u6b65\u51cf\u5c11 %s}\u3002\u6b64\u9879\u51cf\u514d\u4e0e\u5229\u7528 \u8d85\u7a7a\u95f4\u6ed1\u6d41 \u822a\u884c\u65f6\u7684\u57fa\u7840\u71c3\u6599\u82b1\u8d39\u51cf\u514d\u76f8\u4e58\u53e0\u52a0\u3002", initPad, h, Math.round((1.0f - SLIPSTREAM_FUEL_MULT) * 100.0f) + "%");
        } else if (stageId == Stage.REVERSE_POLARITY) {
            info.addPara("\u89e3\u9501 %s \u80fd\u529b\uff0c\u53ef\u8ba9\u8230\u961f\u6cbf\u7740\u5f53\u524d\u8d85\u7a7a\u95f4\u6ed1\u6d41\u7684\u53cd\u65b9\u5411\u524d\u8fdb\u3002", initPad, h, "\u6781\u6027\u9006\u8f6c");
        } else if (stageId == Stage.GENERATE_SLIPSURGE) {
            info.addPara("\u89e3\u9501 %s \u80fd\u529b\uff0c\u53ef\u8ba9\u8230\u961f\u4ea7\u751f\u4e00\u9635\u7528\u4e8e\u5feb\u901f\u524d\u8fdb\u7684\u77ed\u6682\u6fc0\u6d41\u3002", initPad, h, "\u6fc0\u6d41\u8ff8\u53d1");
        } else if (stageId == Stage.HYPERFIELD_OPTIMIZATION) {
            info.addPara("\u8d85\u7a7a\u95f4\u4e2d\u7684\u6700\u5927\u5b87\u5b99\u822a\u901f\u63d0\u9ad8 %s}\u3002", initPad, h, "" + (int)HYPER_BURN_BONUS);
        } else if (stageId == Stage.TOPOGRAPHIC_DATA) {
            int min = this.getTopoResetMin();
            int max = this.getTopoResetMax();
            info.addPara("\u4e00\u7cfb\u5217\u53ef\u4ee5\u5356\u51fa\u53ef\u89c2\u4ef7\u683c\u7684\u8d85\u7a7a\u95f4\u6d4b\u7ed8\u6570\u636e\u3002", initPad);
            info.addPara("\u5f53\u8be5\u7ed3\u679c\u53d1\u751f\u65f6\uff0c\u4e8b\u4ef6\u8fdb\u5c55\u5ea6 \u4f1a\u88ab\u91cd\u7f6e\u4e3a %s \u5230 %s \u70b9\u4e4b\u95f4\u3002", opad, h, "" + min, "" + max);
        }
    }

    @Override
    public TooltipMakerAPI.TooltipCreator getStageTooltipImpl(Object stageId) {
        final BaseEventIntel.EventStageData esd = this.getDataFor(stageId);
        if (esd != null && EnumSet.of(Stage.SLIPSTREAM_DETECTION, new Stage[]{Stage.SLIPSTREAM_NAVIGATION, Stage.GENERATE_SLIPSURGE, Stage.REVERSE_POLARITY, Stage.HYPERFIELD_OPTIMIZATION, Stage.TOPOGRAPHIC_DATA}).contains(esd.id)) {
            return new BaseFactorTooltip(){

                public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                    float opad = 10.0f;
                    if (esd.id == Stage.SLIPSTREAM_DETECTION) {
                        tooltip.addTitle("\u6ed1\u6d41\u63a2\u6d4b");
                    } else if (esd.id == Stage.SLIPSTREAM_NAVIGATION) {
                        tooltip.addTitle("\u6ed1\u6d41\u5bfc\u822a");
                    } else if (esd.id == Stage.HYPERFIELD_OPTIMIZATION) {
                        tooltip.addTitle("\u8d85\u6ce2\u573a\u4f18\u5316");
                    } else if (esd.id == Stage.REVERSE_POLARITY) {
                        tooltip.addTitle("\u6781\u6027\u9006\u8f6c");
                    } else if (esd.id == Stage.GENERATE_SLIPSURGE) {
                        tooltip.addTitle("\u6fc0\u6d41\u8ff8\u53d1");
                    } else if (esd.id == Stage.TOPOGRAPHIC_DATA) {
                        tooltip.addTitle("\u8d85\u7a7a\u95f4\u6d4b\u7ed8\u6570\u636e");
                    }
                    HyperspaceTopographyEventIntel.this.addStageDesc(tooltip, esd.id, opad, true);
                    esd.addProgressReq(tooltip, opad);
                }
            };
        }
        return null;
    }

    @Override
    public String getIcon() {
        return Global.getSettings().getSpriteName("events", "hyperspace_topography");
    }

    @Override
    protected String getStageIconImpl(Object stageId) {
        BaseEventIntel.EventStageData esd = this.getDataFor(stageId);
        if (esd == null) {
            return null;
        }
        if (EnumSet.of(Stage.SLIPSTREAM_DETECTION, Stage.SLIPSTREAM_NAVIGATION, Stage.HYPERFIELD_OPTIMIZATION, Stage.TOPOGRAPHIC_DATA, Stage.START).contains(esd.id)) {
            return Global.getSettings().getSpriteName("events", "hyperspace_topography_" + ((Stage)((Object)esd.id)).name());
        }
        if (stageId == Stage.REVERSE_POLARITY) {
            return Global.getSettings().getAbilitySpec("reverse_polarity").getIconName();
        }
        if (stageId == Stage.GENERATE_SLIPSURGE) {
            return Global.getSettings().getAbilitySpec("generate_slipsurge").getIconName();
        }
        return Global.getSettings().getSpriteName("events", "hyperspace_topography");
    }

    @Override
    public Color getBarColor() {
        Color color = BAR_COLOR;
        color = Misc.interpolateColor(color, Color.black, 0.25f);
        return color;
    }

    @Override
    public Color getBarProgressIndicatorColor() {
        return super.getBarProgressIndicatorColor();
    }

    @Override
    protected int getStageImportance(Object stageId) {
        return super.getStageImportance(stageId);
    }

    @Override
    protected String getName() {
        return "\u8d85\u7a7a\u95f4\u6d4b\u7ed8";
    }

    @Override
    public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
    }

    @Override
    public void reportBattleOccurred(CampaignFleetAPI fleet, CampaignFleetAPI primaryWinner, BattleAPI battle) {
    }

    public int getTopoResetMin() {
        BaseEventIntel.EventStageData stage = this.getDataFor((Object)Stage.GENERATE_SLIPSURGE);
        return stage.progress;
    }

    public int getTopoResetMax() {
        return this.getTopoResetMin() + 50;
    }

    public void resetTopographicData() {
        int resetProgress = this.getTopoResetMin() + this.getRandom().nextInt(this.getTopoResetMax() - this.getTopoResetMin() + 1);
        this.setProgress(resetProgress);
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Exploration");
        return tags;
    }

    @Override
    protected void advanceImpl(float amount) {
        super.advanceImpl(amount);
        this.applyFleetEffects();
        float days = Global.getSector().getClock().convertToDays(amount);
        this.recent.advance(days);
    }

    public void addAbility(String id) {
        if (Global.getSector().getPlayerFleet().hasAbility(id)) {
            return;
        }
        ArrayList<Misc.Token> params = new ArrayList<Misc.Token>();
        Misc.Token t = new Misc.Token(id, Misc.TokenType.LITERAL);
        params.add(t);
        t = new Misc.Token("-1", Misc.TokenType.LITERAL);
        params.add(t);
        new AddAbility().execute(null, null, params, null);
        PersistentUIDataAPI.AbilitySlotsAPI slots = Global.getSector().getUIData().getAbilitySlotsAPI();
        int curr = slots.getCurrBarIndex();
        int i = 0;
        block0: while (i < 5) {
            slots.setCurrBarIndex(i);
            for (PersistentUIDataAPI.AbilitySlotAPI slot : slots.getCurrSlotsCopy()) {
                if ("reverse_polarity".equals(id) && "scavenge".equals(slot.getAbilityId())) {
                    slot.setInHyperAbilityId("reverse_polarity");
                    break block0;
                }
                if (!"generate_slipsurge".equals(id) || !"distress_call".equals(slot.getAbilityId())) continue;
                slot.setInHyperAbilityId("generate_slipsurge");
                break block0;
            }
            ++i;
        }
        slots.setCurrBarIndex(curr);
    }

    @Override
    protected void notifyStageReached(BaseEventIntel.EventStageData stage) {
        if (stage.id == Stage.REVERSE_POLARITY) {
            this.addAbility("reverse_polarity");
        }
        if (stage.id == Stage.GENERATE_SLIPSURGE) {
            this.addAbility("generate_slipsurge");
        }
        if (stage.id == Stage.TOPOGRAPHIC_DATA) {
            this.resetTopographicData();
            CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
            cargo.addSpecial(new SpecialItemData("topographic_data", null), 1.0f);
        }
    }

    @Override
    public void reportCurrentLocationChanged(LocationAPI prev, LocationAPI curr) {
    }

    @Override
    public void reportAboutToRefreshCharacterStatEffects() {
    }

    @Override
    public void reportRefreshedCharacterStatEffects() {
        this.updateMarketDetectionRanges();
        this.applyFleetEffects();
    }

    public void applyFleetEffects() {
        String id1 = "hypertopology1";
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        pf.getStats().getFleetwideMaxBurnMod().unmodifyFlat(id1);
        MutableStat stat = pf.getStats().getDynamic().getStat("fuel_use_not_shown_on_map_mult");
        stat.unmodifyMult(id1);
        if (Global.getSector().getCurrentLocation().isHyperspace()) {
            if (this.isStageActive((Object)Stage.SLIPSTREAM_NAVIGATION)) {
                for (MutableStat.StatMod mod : stat.getMultMods().values()) {
                    if (!SlipstreamTerrainPlugin2.FUEL_USE_MODIFIER_DESC.equals(mod.desc)) continue;
                    stat.modifyMult(id1, SLIPSTREAM_FUEL_MULT, String.valueOf(SlipstreamTerrainPlugin2.FUEL_USE_MODIFIER_DESC) + " (\u8d85\u7a7a\u95f4\u6d4b\u7ed8)");
                    break;
                }
            }
            if (this.isStageActive((Object)Stage.HYPERFIELD_OPTIMIZATION)) {
                pf.getStats().getFleetwideMaxBurnMod().modifyFlat(id1, HYPER_BURN_BONUS, "\u8d85\u7a7a\u95f4\u6d4b\u7ed8");
            }
        }
    }

    public void updateMarketDetectionRanges() {
        if (this.isStageActive((Object)Stage.SLIPSTREAM_DETECTION)) {
            String id1 = "hypertopology1";
            String id2 = "hypertopology2";
            String id3 = "hypertopology3";
            String id4 = "hypertopology4";
            for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
                if (market.isHidden()) continue;
                boolean unapplicable = false;
                Industry spaceport = market.getIndustry("spaceport");
                if (spaceport == null) {
                    spaceport = market.getIndustry("megaport");
                }
                if (spaceport == null || !spaceport.isFunctional()) {
                    unapplicable = true;
                }
                StatBonus mod = market.getStats().getDynamic().getMod("slipstream_reveal_range_ly_mod");
                if (!market.isPlayerOwned() || unapplicable) {
                    mod.unmodify(id1);
                    mod.unmodify(id2);
                    mod.unmodify(id3);
                    mod.unmodify(id4);
                    continue;
                }
                mod.modifyFlat(id1, BASE_DETECTION_RANGE_LY, "\u57fa\u7840\u63a2\u6d4b\u8ddd\u79bb");
                mod.modifyFlat(id2, market.getSize(), "\u6b96\u6c11\u5730\u89c4\u6a21");
                float arraysBonus = this.gerSensorArrayBonusFor(market, RANGE_WITHIN_WHICH_SENSOR_ARRAYS_HELP_LY);
                mod.modifyFlatAlways(id3, arraysBonus, "\u5728\u4f60\u63a7\u5236\u4e0b" + (int)RANGE_WITHIN_WHICH_SENSOR_ARRAYS_HELP_LY + "\u5149\u5e74\u5185\uff0c\u6700\u591a " + MAX_SENSOR_ARRAYS + "\u5ea7\u4f20\u611f\u5668\u9635\u5217");
            }
        }
    }

    public float gerSensorArrayBonusFor(MarketAPI market, float range) {
        int countDomain = 0;
        int countMakeshift = 0;
        Vector2f locInHyper = market.getLocationInHyperspace();
        for (StarSystemAPI system : Global.getSector().getStarSystems()) {
            float dist = Misc.getDistanceLY(locInHyper, system.getLocation());
            if (dist > range && (float)Math.round(dist * 10.0f) <= range * 10.0f) {
                dist = range;
            }
            if (!(dist <= range)) continue;
            for (SectorEntityToken entity : system.getEntitiesWithTag("sensor_array")) {
                if (entity.getFaction() == null || !entity.getFaction().isPlayerFaction()) continue;
                if (entity.hasTag("makeshift")) {
                    ++countMakeshift;
                    continue;
                }
                ++countDomain;
            }
        }
        float bonus = (float)Math.min(countDomain, MAX_SENSOR_ARRAYS) * RANGE_PER_DOMAIN_SENSOR_ARRAY;
        float useMakeshift = Math.min(MAX_SENSOR_ARRAYS - countDomain, countMakeshift);
        if (useMakeshift < 0.0f) {
            useMakeshift = 0.0f;
        }
        return bonus += useMakeshift * RANGE_PER_MAKESHIFT_SENSOR_ARRAY;
    }

    @Override
    public boolean withMonthlyFactors() {
        return false;
    }

    public void addRecentReadings(Vector2f loc) {
        this.recent.add(new RecentTopographyReadings(loc), RECENT_READINGS_TIMEOUT);
    }

    public static boolean hasRecentReadingsNearPlayer() {
        return HyperspaceTopographyEventIntel.get() != null && HyperspaceTopographyEventIntel.get().hasRecentReadingsNear(Global.getSector().getPlayerFleet().getLocationInHyperspace());
    }

    public boolean hasRecentReadingsNear(Vector2f loc) {
        for (RecentTopographyReadings curr : this.recent.getItems()) {
            float distLY = Misc.getDistanceLY(loc, curr.loc);
            if (!(distLY <= RECENT_READINGS_RANGE_LY)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String getSoundForStageReachedUpdate(Object stageId) {
        if (stageId == Stage.REVERSE_POLARITY || stageId == Stage.GENERATE_SLIPSURGE) {
            return "ui_learned_ability";
        }
        return super.getSoundForStageReachedUpdate(stageId);
    }

    @Override
    protected String getSoundForOneTimeFactorUpdate(EventFactor factor) {
        return null;
    }

    public static class RecentTopographyReadings {
        public Vector2f loc;

        public RecentTopographyReadings(Vector2f loc) {
            this.loc = loc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        START,
        SLIPSTREAM_DETECTION,
        SLIPSTREAM_NAVIGATION,
        REVERSE_POLARITY,
        HYPERFIELD_OPTIMIZATION,
        GENERATE_SLIPSURGE,
        TOPOGRAPHIC_DATA;

    }
}

