/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events.ttcr;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.EventFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.TriTachyonHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.ttcr.TTCRCommerceRaidersDestroyedFactorHint;
import com.fs.starfarer.api.impl.campaign.intel.events.ttcr.TTCRIndustryDisruptedFactorHint;
import com.fs.starfarer.api.impl.campaign.intel.events.ttcr.TTCRTradeFleetsDestroyedFactorHint;
import com.fs.starfarer.api.impl.campaign.missions.DelayedFleetEncounter;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriTachyonCommerceRaiding
extends BaseEventIntel {
    public static int PROGRESS_MAX = 300;
    public static int PROGRESS_1 = 150;
    public static String KEY = "$ttcr_ref";

    public static void addFactorCreateIfNecessary(EventFactor factor, InteractionDialogAPI dialog) {
        if (TriTachyonCommerceRaiding.get() == null) {
            new TriTachyonCommerceRaiding(null, false);
        }
        if (TriTachyonCommerceRaiding.get() != null) {
            TriTachyonCommerceRaiding.get().addFactor(factor, dialog);
        }
    }

    public static TriTachyonCommerceRaiding get() {
        return (TriTachyonCommerceRaiding)Global.getSector().getMemoryWithoutUpdate().get(KEY);
    }

    public TriTachyonCommerceRaiding(TextPanelAPI text, boolean withIntelNotification) {
        Global.getSector().getMemoryWithoutUpdate().set(KEY, this);
        this.setup();
        Global.getSector().getIntelManager().addIntel(this, !withIntelNotification, text);
    }

    protected void setup() {
        this.factors.clear();
        this.stages.clear();
        this.setMaxProgress(PROGRESS_MAX);
        this.addStage((Object)Stage.START, 0);
        this.addStage((Object)Stage.SEND_MERC, PROGRESS_1, true, BaseEventIntel.StageIconSize.MEDIUM);
        this.addStage((Object)Stage.SUCCESS, PROGRESS_MAX, true, BaseEventIntel.StageIconSize.LARGE);
        this.addFactor(new TTCRCommerceRaidersDestroyedFactorHint());
        this.addFactor(new TTCRTradeFleetsDestroyedFactorHint());
        this.addFactor(new TTCRIndustryDisruptedFactorHint());
    }

    protected Object readResolve() {
        return this;
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
        Global.getSector().getMemoryWithoutUpdate().unset(KEY);
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        if (this.addEventFactorBulletPoints(info, mode, isUpdate, tc, initPad)) {
            return;
        }
        Color h = Misc.getHighlightColor();
        if (isUpdate && this.getListInfoParam() instanceof BaseEventIntel.EventStageData) {
            BaseEventIntel.EventStageData esd = (BaseEventIntel.EventStageData)this.getListInfoParam();
            if (esd.id == Stage.SEND_MERC) {
                info.addPara("\u4e00\u4e9b\u8d4f\u91d1\u730e\u4eba\u6700\u8fd1\u5df2\u88ab\u96c7\u4f63\u4ee5\u6b7c\u706d\u4f60", tc, initPad);
            }
            if (esd.id == Stage.SUCCESS) {
                info.addPara("\u4f60\u8bf4\u670d \u901f\u5b50\u79d1\u6280 \u4e0d\u518d\u653b\u51fb\u4f60\u7684\u8d44\u4ea7", tc, initPad);
            }
            return;
        }
    }

    @Override
    public void addStageDescriptionText(TooltipMakerAPI info, float width, Object stageId) {
        float opad = 10.0f;
        float small = 0.0f;
        Color h = Misc.getHighlightColor();
        BaseEventIntel.EventStageData stage = this.getDataFor(stageId);
        if (stage == null) {
            return;
        }
        if (this.isStageActive(stageId)) {
            this.addStageDesc(info, stageId, small, false);
        }
    }

    public FactionAPI getFaction() {
        return Global.getSector().getFaction("tritachyon");
    }

    public void addStageDesc(TooltipMakerAPI info, Object stageId, float initPad, boolean forTooltip) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        FactionAPI faction = this.getFaction();
        Color tt = faction.getBaseUIColor();
        if (stageId == Stage.START) {
            LabelAPI label = info.addPara("\u9700\u8981\u4f7f %s \u7406\u89e3\u5176\u6bc1\u574f\u4f60\u8d44\u4ea7\u7684\u76f8\u5173\u6295\u5165\u65e0\u6cd5\u5e26\u6765\u957f\u671f\u6536\u76ca\u3002\u5982\u679c\u4f60\u80fd\u7528\u67d0\u4e9b\u975e\u516c\u5f00\u654c\u5bf9\u7684\u65b9\u5f0f\u4f20\u8fbe\u8fd9\u4e00\u4fe1\u606f \u2014\u2014 \u6216\u5728\u51b2\u7a81\u540e\u5e73\u606f\u4e8b\u6001 \u2014\u2014 \u8fd9\u5c31\u53ef\u80fd\u8868\u660e\u4f60\u5bf9\u4e8e\u5546\u4e1a\u62e5\u6709\u975e\u5e38\u73b0\u5b9e\u7684\u7406\u89e3\uff0c\u662f\u4ed6\u4eec\u8ba4\u540c \u503c\u5f97\u5408\u4f5c \u7684\u4eba\u3002", initPad, tt, faction.getDisplayNameLong());
            label.setHighlight(faction.getDisplayNameLong(), "\u503c\u5f97\u5408\u4f5c");
            label.setHighlightColors(tt, Misc.getPositiveHighlightColor());
        } else if (stageId == Stage.SUCCESS) {
            info.addPara("\u4f60\u8bf4\u670d %s \u4e0d\u518d\u653b\u51fb\u4f60\u7684\u8d44\u4ea7\u3002", initPad, tt, faction.getDisplayNameLong());
        } else if (stageId == Stage.SEND_MERC) {
            info.addPara("\u4e00\u4e9b\u8d4f\u91d1\u730e\u4eba\u6700\u8fd1\u5df2\u88ab\u96c7\u4f63\u4ee5\u6b7c\u706d\u4f60\u3002\u4f60\u5f88\u53ef\u80fd\u5728\u63a5\u4e0b\u6765\u7684\u51e0\u4e2a\u6708\u5185\u9047\u5230\u4ed6\u4eec\u3002\u5728\u906d\u9047\u8d4f\u91d1\u730e\u4eba\u4e4b\u524d\u4e0e \u901f\u5b50\u79d1\u6280 \u8c08\u59a5\u4e0d\u592a\u53ef\u80fd\u8ba9\u4ed6\u4eec\u6d88\u9664\u654c\u610f\uff0c\u6bd5\u7adf\u5408\u540c\u5df2\u662f\u767d\u7eb8\u9ed1\u5b57\u3002", initPad);
        }
    }

    @Override
    public TooltipMakerAPI.TooltipCreator getStageTooltipImpl(Object stageId) {
        final BaseEventIntel.EventStageData esd = this.getDataFor(stageId);
        if (esd != null && EnumSet.of(Stage.SEND_MERC, Stage.SUCCESS).contains(esd.id)) {
            return new BaseFactorTooltip(){

                public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                    float opad = 10.0f;
                    if (esd.id == Stage.SEND_MERC) {
                        tooltip.addTitle("\u8d4f\u91d1\u5df2\u53d1\u5e03");
                    } else if (esd.id == Stage.SUCCESS) {
                        tooltip.addTitle("\u6210\u529f\uff01");
                    }
                    TriTachyonCommerceRaiding.this.addStageDesc(tooltip, esd.id, opad, true);
                    esd.addProgressReq(tooltip, opad);
                }
            };
        }
        return null;
    }

    @Override
    public String getIcon() {
        return Global.getSettings().getSpriteName("events", "triTachyonCR_START");
    }

    @Override
    protected String getStageIconImpl(Object stageId) {
        BaseEventIntel.EventStageData esd = this.getDataFor(stageId);
        if (esd == null) {
            return null;
        }
        return Global.getSettings().getSpriteName("events", "triTachyonCR_" + ((Stage)((Object)esd.id)).name());
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Colony threats");
        tags.add("tritachyon");
        return tags;
    }

    @Override
    public Color getBarColor() {
        Color color = this.getFaction().getBaseUIColor();
        color = Misc.interpolateColor(color, Color.black, 0.25f);
        return color;
    }

    @Override
    public Color getBarProgressIndicatorColor() {
        return super.getBarProgressIndicatorColor();
    }

    @Override
    protected int getStageImportance(Object stageId) {
        return super.getStageImportance(stageId);
    }

    @Override
    protected String getName() {
        return "\u901f\u5b50\u79d1\u6280 \u5546\u4e1a\u88ad\u51fb";
    }

    @Override
    protected void advanceImpl(float amount) {
        super.advanceImpl(amount);
    }

    @Override
    protected void notifyStageReached(BaseEventIntel.EventStageData stage) {
        if (stage.id == Stage.SEND_MERC) {
            this.sendBountyHunters();
        }
        if (stage.id == Stage.SUCCESS) {
            TriTachyonHostileActivityFactor.setPlayerCounterRaidedTriTach();
            this.endAfterDelay();
        }
    }

    @Override
    public boolean withMonthlyFactors() {
        return false;
    }

    @Override
    protected String getSoundForStageReachedUpdate(Object stageId) {
        return super.getSoundForStageReachedUpdate(stageId);
    }

    @Override
    protected String getSoundForOneTimeFactorUpdate(EventFactor factor) {
        return null;
    }

    protected void sendBountyHunters() {
        Random r = Misc.getRandom(this.random.nextLong(), 7);
        DelayedFleetEncounter e = new DelayedFleetEncounter(r, "TTCRBountyHunterWolfpack");
        e.setDelayVeryShort();
        e.setDoNotAbortWhenPlayerFleetTooStrong();
        e.setLocationOuterSector(true, "independent");
        e.beginCreate();
        e.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.SMOD_3, "mercenary", "mercBountyHunter", new Vector2f());
        e.triggerSetFleetMaxShipSize(1);
        e.triggerSetFleetDoctrineOther(5, 4);
        WeightedRandomPicker<String> picker = new WeightedRandomPicker<String>(r);
        picker.add("tempest_Attack", 10.0f);
        picker.add("tempest_Attack", 10.0f);
        picker.add("tempest_Attack", 10.0f);
        picker.add("scarab_Experimental", 10.0f);
        picker.add("scarab_Experimental", 10.0f);
        picker.add("scarab_Experimental", 10.0f);
        picker.add("hyperion_Attack", 10.0f);
        picker.add("hyperion_Strike", 10.0f);
        picker.add("omen_PD", 5.0f);
        picker.add("omen_PD", 5.0f);
        picker.add("monitor_Escort", 5.0f);
        picker.add("monitor_Escort", 5.0f);
        picker.add("shade_Assault", 5.0f);
        picker.add("shade_Assault", 5.0f);
        picker.add("afflictor_Strike", 5.0f);
        picker.add("afflictor_Strike", 5.0f);
        int add = 9;
        while (!picker.isEmpty() && add > 0) {
            e.triggerAddShips((String)picker.pickAndRemove());
            --add;
        }
        e.triggerSetFleetMaxNumShips(14);
        e.triggerSetFleetDoctrineComp(5, 0, 0);
        e.triggerFleetAddCommanderSkill("coordinated_maneuvers", 1);
        e.triggerFleetAddCommanderSkill("wolfpack_tactics", 1);
        e.triggerFleetAddCommanderSkill("electronic_warfare", 1);
        e.triggerFleetAddCommanderSkill("flux_regulation", 1);
        e.triggerFleetAddCommanderSkill("tactical_drills", 1);
        e.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.UNUSUALLY_HIGH);
        e.triggerFleetMakeFaster(true, 0, true);
        e.triggerSetFleetFaction("independent");
        e.triggerMakeNoRepImpact();
        e.triggerSetStandardAggroInterceptFlags();
        e.triggerMakeFleetIgnoreOtherFleets();
        e.triggerSetFleetGenericHailPermanent("TTCRBountyHunterHail");
        e.triggerSetFleetFlagPermanent("$ttcr_wolfpack");
        e.endCreate();
        r = Misc.getRandom(this.random.nextLong(), 3);
        e = new DelayedFleetEncounter(r, "TTCRBountyHunterPhase");
        e.setDelayVeryShort();
        e.setLocationInnerSector(true, "independent");
        e.beginCreate();
        e.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.SMOD_3, "mercenary", "mercBountyHunter", new Vector2f());
        e.triggerSetFleetDoctrineComp(0, 0, 5);
        e.triggerFleetAddCommanderSkill("coordinated_maneuvers", 1);
        e.triggerFleetAddCommanderSkill("phase_corps", 1);
        e.triggerFleetAddCommanderSkill("electronic_warfare", 1);
        e.triggerFleetAddCommanderSkill("flux_regulation", 1);
        e.triggerFleetAddCommanderSkill("tactical_drills", 1);
        e.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.HIGHER);
        e.triggerFleetMakeFaster(true, 0, true);
        e.triggerSetFleetFaction("independent");
        e.triggerMakeNoRepImpact();
        e.triggerSetStandardAggroInterceptFlags();
        e.triggerMakeFleetIgnoreOtherFleets();
        e.triggerSetFleetGenericHailPermanent("TTCRBountyHunterHail");
        e.triggerSetFleetFlagPermanent("$ttcr_phase");
        e.endCreate();
        r = Misc.getRandom(this.random.nextLong(), 11);
        e = new DelayedFleetEncounter(r, "TTCRBountyHunterDerelict");
        e.setDelayVeryShort();
        e.setLocationCoreOnly(true, "independent");
        e.beginCreate();
        e.triggerCreateFleet(HubMissionWithTriggers.FleetSize.HUGE, HubMissionWithTriggers.FleetQuality.VERY_LOW, "luddic_church", "mercBountyHunter", new Vector2f());
        e.triggerSetFleetDoctrineOther(5, 5);
        e.triggerFleetAddCommanderSkill("derelict_contingent", 1);
        e.triggerFleetAddCommanderSkill("support_doctrine", 1);
        e.triggerFleetAddCommanderSkill("coordinated_maneuvers", 1);
        e.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.LOWER);
        e.triggerFleetMakeFaster(true, 2, true);
        e.triggerSetFleetFaction("independent");
        e.triggerMakeNoRepImpact();
        e.triggerSetStandardAggroInterceptFlags();
        e.triggerMakeFleetIgnoreOtherFleets();
        e.triggerSetFleetGenericHailPermanent("TTCRBountyHunterHail");
        e.triggerSetFleetFlagPermanent("$ttcr_derelict");
        e.endCreate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        START,
        SEND_MERC,
        SUCCESS;

    }
}

