/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.group;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.intel.group.FGBlockadeAction;
import com.fs.starfarer.api.impl.campaign.intel.group.GenericRaidFGI;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;

public class BlockadeFGI
extends GenericRaidFGI {
    protected FGBlockadeAction.FGBlockadeParams blockadeParams;
    protected IntervalUtil interval = new IntervalUtil(0.1f, 0.3f);

    public BlockadeFGI(GenericRaidFGI.GenericRaidParams params, FGBlockadeAction.FGBlockadeParams blockadeParams) {
        super(null);
        if (params.noun == null) {
            params.noun = "\u5c01\u9501";
        }
        if (params.forcesNoun == null) {
            params.forcesNoun = "\u5c01\u9501\u8230\u961f";
        }
        this.params = params;
        this.blockadeParams = blockadeParams;
        this.setRandom(params.random);
        this.initActions();
    }

    protected GenericRaidFGI.GenericPayloadAction createPayloadAction() {
        return new FGBlockadeAction(this.blockadeParams, this.params.payloadDays);
    }

    public float getAccessibilityPenalty() {
        int str = this.getRelativeFGStrength(this.getTargetSystem());
        if (str < 0) {
            return 0.0f;
        }
        if (str == 0) {
            return this.blockadeParams.accessibilityPenalty * 0.5f;
        }
        return this.blockadeParams.accessibilityPenalty;
    }

    public void advance(float amount) {
        super.advance(amount);
        if (this.isEnded() || this.isEnding() || this.isAborted() || this.isSpawning()) {
            return;
        }
        float \u5929 = Misc.getDays(amount);
        this.interval.advance(\u5929);
        if (this.interval.intervalElapsed()) {
            if (this.isCurrent(PAYLOAD_ACTION)) {
                this.applyBlockadeCondition();
            } else {
                this.unapplyBlockadeCondition();
            }
            this.periodicUpdate();
        }
    }

    protected void periodicUpdate() {
    }

    protected void applyBlockadeCondition() {
        int str = this.getRelativeFGStrength(this.getTargetSystem());
        if (str < 0) {
            this.unapplyBlockadeCondition();
            return;
        }
        for (MarketAPI market : Misc.getMarketsInLocation(this.getTargetSystem(), this.blockadeParams.targetFaction)) {
            if (market.hasCondition("blockaded")) continue;
            market.addCondition("blockaded", this);
        }
    }

    protected void unapplyBlockadeCondition() {
        for (MarketAPI market : Misc.getMarketsInLocation(this.getTargetSystem(), this.blockadeParams.targetFaction)) {
            market.removeCondition("blockaded");
        }
    }

    protected void notifyEnding() {
        super.notifyEnding();
        this.unapplyBlockadeCondition();
    }

    protected void addBasicDescription(TooltipMakerAPI info, float width, float height, float opad) {
        info.addImage(this.getFaction().getLogo(), width, 128.0f, opad);
        StarSystemAPI system = this.raidAction.getWhere();
        String noun = this.getNoun();
        info.addPara(String.valueOf(Misc.ucFirst(this.faction.getPersonNamePrefixAOrAn())) + " %s " + noun + " " + this.getOfString() + " " + "" + system.getNameWithLowercaseTypeShort() + "\u3002", opad, this.faction.getBaseUIColor(), this.faction.getPersonNamePrefix());
    }

    protected String getOfString() {
        return "\u4e8e";
    }

    protected void addAssessmentSection(TooltipMakerAPI info, float width, float height, float opad) {
        Color h = Misc.getHighlightColor();
        Color bad = Misc.getNegativeHighlightColor();
        FactionAPI faction = this.getFaction();
        List<MarketAPI> targets = this.params.raidParams.allowedTargets;
        String noun = this.getNoun();
        String forcesNoun = this.getForcesNoun();
        if (!(this.isEnding() || this.isSucceeded() || this.isFailed())) {
            String \u5929;
            FactionAPI other = Global.getSector().getFaction(this.blockadeParams.targetFaction);
            boolean hostile = this.getFaction().isHostileTo(this.blockadeParams.targetFaction);
            info.addSectionHeading("\u8bc4\u4f30", faction.getBaseUIColor(), faction.getDarkUIColor(), Alignment.MID, opad);
            boolean started = this.isCurrent(PAYLOAD_ACTION);
            float remaining = this.getETAUntil(PAYLOAD_ACTION, true) - this.getETAUntil(TRAVEL_ACTION, true);
            if (remaining > 0.0f && remaining < 1.0f) {
                remaining = 1.0f;
            }
            String string = \u5929 = (int)remaining == 1 ? "\u5929" : "\u5929";
            if (started) {
                \u5929 = "" + \u5929;
            }
            LabelAPI label = info.addPara("" + noun + " \u5c06\u6301\u7eed\u5927\u7ea6 %s" + \u5929 + "\uff0c\u5e76\u5bfc\u81f4 %s \u6d41\u901a\u6027\u60e9\u7f5a" + "\u4e8e\u6240\u6709\u7684 %s \u6b96\u6c11\u5730\uff0c\u4ec5\u5f71\u54cd" + this.getTargetSystem().getNameWithLowercaseTypeShort() + "\u3002", opad, h, "" + (int)remaining, Math.round(this.blockadeParams.accessibilityPenalty * 100.0f) + "%", other.getPersonNamePrefix());
            label.setHighlight("" + (int)remaining, Math.round(this.blockadeParams.accessibilityPenalty * 100.0f) + "%", other.getPersonNamePrefix());
            label.setHighlightColors(h, h, other.getBaseUIColor());
            if (!hostile) {
                info.addPara("" + forcesNoun + " \u4e0e\u4f60\u540d\u4e49\u4e0a \u5c1a\u672a\u654c\u5bf9 \uff0c\u4f46\u4ecd\u4f1a\u9a9a\u6270\u8239\u8fd0\u5e76" + "\u5c1d\u8bd5\u63a7\u5236\u8be5\u661f\u7cfb\u7684\u8df3\u8dc3\u70b9\u3002", opad, Misc.getHighlightColor(), "\u5c1a\u672a\u654c\u5bf9");
            } else {
                info.addPara("" + forcesNoun + " \u4e0e\u4f60\u5df2 \u79ef\u6781\u654c\u5bf9 \uff0c\u4f46\u4e0d\u4f1a\u76f4\u63a5\u653b\u51fb\u4f60\u7684\u6b96\u6c11\u5730" + "\u800c\u662f" + "\u5c1d\u8bd5\u63a7\u5236\u8be5\u661f\u7cfb\u7684\u8df3\u8dc3\u70b9\u3002\u7136\u800c\uff0c\u5982\u679c\u8df3\u8dc3\u70b9\u9644\u8fd1\u5b58\u5728\u91cd\u5175\u628a\u5b88\u7684\u884c\u661f" + "\u90a3\u4e48\u4e8b\u6001\u5c06\u8fc5\u901f\u5347\u6e29\u3002", opad, Misc.getNegativeHighlightColor(), "\u79ef\u6781\u654c\u5bf9");
            }
            this.addStrengthDesc(info, opad, this.getTargetSystem(), forcesNoun, "" + noun + " \u5e94\u8be5\u4e0d\u4f1a\u6709\u6548", "" + noun + " \u53ef\u80fd\u4e00\u5b9a\u7a0b\u5ea6\u4e0a\u6709\u6548", "" + noun + " \u5f88\u53ef\u80fd\u975e\u5e38\u6709\u6548");
            this.addPostAssessmentSection(info, width, height, opad);
        }
    }

    protected void addPostAssessmentSection(TooltipMakerAPI info, float width, float height, float opad) {
    }

    public FGBlockadeAction.FGBlockadeParams getBlockadeParams() {
        return this.blockadeParams;
    }
}

