/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.group;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.ai.CampaignFleetAIAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.MilitaryResponseScript;
import com.fs.starfarer.api.impl.campaign.command.WarSimScript;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.intel.group.FGDurationAction;
import com.fs.starfarer.api.impl.campaign.intel.group.GenericRaidFGI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FGBlockadeAction
extends FGDurationAction
implements GenericRaidFGI.GenericPayloadAction {
    protected IntervalUtil interval = new IntervalUtil(0.1f, 0.3f);
    protected FGBlockadeParams params;
    protected List<SectorEntityToken> blockadePoints = new ArrayList<SectorEntityToken>();
    protected SectorEntityToken primary;
    protected boolean computedInitial = false;
    protected float origDuration = 1.0f;
    protected List<MilitaryResponseScript> scripts = new ArrayList<MilitaryResponseScript>();

    public FGBlockadeAction(FGBlockadeParams params, float duration) {
        super(duration);
        this.origDuration = duration;
        this.params = params;
        this.interval.forceIntervalElapsed();
    }

    public Object readResolve() {
        return this;
    }

    public void computeInitial() {
        this.computedInitial = true;
        this.blockadePoints = new ArrayList<SectorEntityToken>(this.params.where.getEntities(JumpPointAPI.class));
        final Vector2f center = new Vector2f();
        Collections.sort(this.blockadePoints, new Comparator<SectorEntityToken>(){

            @Override
            public int compare(SectorEntityToken o1, SectorEntityToken o2) {
                float d1 = Misc.getDistance(center, o1.getLocation());
                float d2 = Misc.getDistance(center, o2.getLocation());
                return (int)Math.signum(d1 - d2);
            }
        });
        if (this.blockadePoints.size() == 1) {
            this.primary = this.blockadePoints.get(0);
        } else if (this.blockadePoints.size() >= 3) {
            this.primary = this.blockadePoints.get(1);
        } else if (this.blockadePoints.size() == 2) {
            float d0 = Misc.getDistance(center, this.blockadePoints.get(0).getLocation());
            float d1 = Misc.getDistance(center, this.blockadePoints.get(1).getLocation());
            this.primary = d0 > 3000.0f ? this.blockadePoints.get(0) : this.blockadePoints.get(1);
        }
        for (SectorEntityToken objective : this.params.where.getEntitiesWithTag("objective")) {
            WarSimScript.setNoFightingForObjective(objective, this.intel.getFaction(), 1000.0f);
        }
    }

    @Override
    public void addRouteSegment(RouteManager.RouteData route) {
        RouteManager.RouteSegment segment = new RouteManager.RouteSegment(this.getDurDays(), this.params.where.getCenter());
        route.addSegment(segment);
    }

    @Override
    public void notifyFleetsSpawnedMidSegment(RouteManager.RouteSegment segment) {
        super.notifyFleetsSpawnedMidSegment(segment);
    }

    @Override
    public void notifySegmentFinished(RouteManager.RouteSegment segment) {
        super.notifySegmentFinished(segment);
    }

    @Override
    public void setActionFinished(boolean finished) {
        if (finished && !this.finished) {
            List<CampaignFleetAPI> fleets = this.intel.getFleets();
            for (CampaignFleetAPI fleet : fleets) {
                Misc.setFlagWithReason(fleet.getMemoryWithoutUpdate(), "$core_fleetBusy", fleet.getId(), true, -1.0f);
            }
            if (this.scripts != null) {
                for (MilitaryResponseScript s : this.scripts) {
                    s.forceDone();
                }
                this.scripts.clear();
            }
            for (SectorEntityToken objective : this.params.where.getEntitiesWithTag("objective")) {
                WarSimScript.removeNoFightingTimeoutForObjective(objective, this.intel.getFaction());
            }
        }
        super.setActionFinished(finished);
    }

    @Override
    public void directFleets(float amount) {
        super.directFleets(amount);
        if (this.isActionFinished()) {
            return;
        }
        List<CampaignFleetAPI> fleets = this.intel.getFleets();
        if (fleets.isEmpty()) {
            this.setActionFinished(true);
            return;
        }
        if (!this.computedInitial) {
            this.computeInitial();
            this.orderFleetMovements();
        }
        if (this.primary == null) {
            this.setActionFinished(true);
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        this.interval.advance(days);
        if (!this.interval.intervalElapsed()) {
            return;
        }
    }

    protected void orderFleetMovements() {
        if (this.blockadePoints.isEmpty() || this.primary == null) {
            return;
        }
        float fPrimary = 1.0f;
        float fNonPrimary = 1.0f / (float)this.blockadePoints.size();
        for (CampaignFleetAPI fleet : this.intel.getFleets()) {
            fleet.getMemoryWithoutUpdate().unset("$core_fleetBusy");
        }
        for (SectorEntityToken target : this.blockadePoints) {
            float rf = fNonPrimary;
            if (target == this.primary) {
                rf = fPrimary;
            }
            MilitaryResponseScript.MilitaryResponseParams aggroParams = new MilitaryResponseScript.MilitaryResponseParams(CampaignFleetAIAPI.ActionType.HOSTILE, "blockade_" + target.getId(), this.intel.getFaction(), target, rf, this.getDurDays());
            aggroParams.travelText = null;
            aggroParams.actionText = this.params.patrolText;
            MilitaryResponseScript script = new MilitaryResponseScript(aggroParams);
            this.params.where.addScript(script);
            this.scripts.add(script);
        }
    }

    public FGBlockadeParams getParams() {
        return this.params;
    }

    @Override
    public float getSuccessFraction() {
        float f = this.getElapsed() / Math.max(1.0f, this.origDuration);
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    @Override
    public Color getSystemNameHighlightColor() {
        return Global.getSector().getFaction(this.params.targetFaction).getBaseUIColor();
    }

    @Override
    public StarSystemAPI getWhere() {
        return this.params.where;
    }

    public List<SectorEntityToken> getBlockadePoints() {
        return this.blockadePoints;
    }

    public SectorEntityToken getPrimary() {
        return this.primary;
    }

    public static class FGBlockadeParams {
        public StarSystemAPI where;
        public MarketAPI specificMarket = null;
        public boolean doNotGetSidetracked = true;
        public float accessibilityPenalty = 0.6f;
        public String patrolText = null;
        public String targetFaction = "player";
    }
}

