/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.group;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.intel.group.FGDurationAction;
import com.fs.starfarer.api.util.IntervalUtil;
import java.util.List;

public class FGWaitAction
extends FGDurationAction {
    protected SectorEntityToken where;
    protected IntervalUtil interval = new IntervalUtil(0.1f, 0.3f);
    protected String waitText;
    protected boolean doNotGetSidetracked = true;

    public FGWaitAction(SectorEntityToken where, float waitDays) {
        this(where, waitDays, "\u73af\u7ed5\u4e8e " + where.getName());
    }

    public FGWaitAction(SectorEntityToken where, float waitDays, String waitText) {
        super(waitDays);
        this.where = where;
        this.waitText = waitText;
        this.interval.forceIntervalElapsed();
    }

    public void addRouteSegment(RouteManager.RouteData route) {
        RouteManager.RouteSegment segment = new RouteManager.RouteSegment(this.getDurDays(), this.where);
        route.addSegment(segment);
    }

    public void directFleets(float amount) {
        super.directFleets(amount);
        if (this.isActionFinished()) {
            return;
        }
        List<CampaignFleetAPI> fleets = this.intel.getFleets();
        if (fleets.isEmpty()) {
            this.setActionFinished(true);
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        this.interval.advance(days);
        if (!this.interval.intervalElapsed()) {
            return;
        }
        for (CampaignFleetAPI fleet : fleets) {
            fleet.clearAssignments();
            if (this.where.getStarSystem() != null && this.where == this.where.getStarSystem().getCenter()) {
                fleet.addAssignment(FleetAssignment.PATROL_SYSTEM, null, 3.0f, this.waitText);
                continue;
            }
            if (this.doNotGetSidetracked) {
                fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, this.where, 3.0f, this.waitText);
                continue;
            }
            fleet.addAssignment(FleetAssignment.ORBIT_AGGRESSIVE, this.where, 3.0f, this.waitText);
        }
    }

    public SectorEntityToken getWhere() {
        return this.where;
    }

    public void setWhere(SectorEntityToken where) {
        this.where = where;
    }

    public String getWaitText() {
        return this.waitText;
    }

    public void setWaitText(String waitText) {
        this.waitText = waitText;
    }

    public boolean isDoNotGetSidetracked() {
        return this.doNotGetSidetracked;
    }

    public void setDoNotGetSidetracked(boolean doNotGetSidetracked) {
        this.doNotGetSidetracked = doNotGetSidetracked;
    }
}

