/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.group;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.intel.group.FGAction;
import com.fs.starfarer.api.impl.campaign.intel.group.FGRaidAction;
import com.fs.starfarer.api.impl.campaign.intel.group.FGTravelAction;
import com.fs.starfarer.api.impl.campaign.intel.group.FGWaitAction;
import com.fs.starfarer.api.impl.campaign.intel.group.FleetGroupIntel;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericRaidFGI
extends FleetGroupIntel {
    public static String PREPARE_ACTION = "prepare_action";
    public static String TRAVEL_ACTION = "travel_action";
    public static String PAYLOAD_ACTION = "payload_action";
    public static String RETURN_ACTION = "return_action";
    protected GenericRaidParams params;
    protected SectorEntityToken origin;
    protected GenericPayloadAction raidAction;
    protected FGTravelAction travelAction;
    protected FGTravelAction returnAction;
    protected FGWaitAction waitAction;

    public static GenericRaidFGI get(String key) {
        return (GenericRaidFGI)Global.getSector().getMemoryWithoutUpdate().get(key);
    }

    public GenericRaidFGI(GenericRaidParams params) {
        if (params != null) {
            this.params = params;
            this.setRandom(params.random);
            this.initActions();
            if (params.memoryKey != null) {
                Global.getSector().getMemoryWithoutUpdate().set(params.memoryKey, this);
            }
        }
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        if (this.params != null && this.params.memoryKey != null) {
            Global.getSector().getMemoryWithoutUpdate().unset(this.params.memoryKey);
        }
    }

    protected void initActions() {
        this.setFaction(this.params.factionId);
        this.waitAction = new FGWaitAction(this.params.source.getPrimaryEntity(), this.params.prepDays, "\u51c6\u5907\u542f\u7a0b");
        this.addAction(this.waitAction, PREPARE_ACTION);
        this.raidAction = this.createPayloadAction();
        this.travelAction = new FGTravelAction(this.params.source.getPrimaryEntity(), this.raidAction.getWhere().getCenter());
        this.addAction(this.travelAction, TRAVEL_ACTION);
        this.addAction(this.raidAction, PAYLOAD_ACTION);
        SectorEntityToken returnWhere = this.params.source.getPrimaryEntity();
        if (returnWhere.getStarSystem() != null) {
            returnWhere = returnWhere.getStarSystem().getCenter();
        }
        this.returnAction = new FGTravelAction(this.raidAction.getWhere().getCenter(), this.params.source.getPrimaryEntity());
        this.returnAction.setTravelText("\u6b63\u5728\u8fd4\u56de " + this.params.source.getPrimaryEntity().getName());
        this.addAction(this.returnAction, RETURN_ACTION);
        this.origin = this.params.source.getPrimaryEntity();
        int total = 0;
        for (Integer i : this.params.fleetSizes) {
            total += i.intValue();
        }
        this.createRoute(this.params.factionId, total, this.params.fleetSizes.size(), null);
    }

    protected GenericPayloadAction createPayloadAction() {
        return new FGRaidAction(this.params.raidParams, this.params.payloadDays);
    }

    @Override
    protected void spawnFleets() {
        Float damage = null;
        if (this.route != null && this.route.getExtra() != null) {
            damage = this.route.getExtra().damage;
        }
        if (damage == null) {
            damage = Float.valueOf(0.0f);
        }
        WeightedRandomPicker<Integer> picker = new WeightedRandomPicker<Integer>(this.getRandom());
        picker.addAll(this.params.fleetSizes);
        int total = 0;
        for (Integer i : this.params.fleetSizes) {
            total += i.intValue();
        }
        float spawnsToSkip = (float)total * damage.floatValue() * 0.5f;
        float skipped = 0.0f;
        while (!picker.isEmpty()) {
            Integer size = (Integer)picker.pickAndRemove();
            if (skipped < spawnsToSkip && this.getRandom().nextFloat() < damage.floatValue()) {
                skipped += (float)size.intValue();
                continue;
            }
            CampaignFleetAPI fleet = this.createFleet(size, damage.floatValue());
            if (fleet == null || this.route == null) continue;
            GenericRaidFGI.setLocationAndCoordinates(fleet, this.route.getCurrent());
            this.fleets.add(fleet);
        }
    }

    protected CampaignFleetAPI createFleet(int size, float damage) {
        Vector2f loc = this.origin.getLocationInHyperspace();
        boolean pirate = this.faction.getCustomBoolean("pirateBehavior");
        FleetCreatorMission m = new FleetCreatorMission(this.getRandom());
        this.preConfigureFleet(size, m);
        m.beginFleet();
        String factionId = this.getFleetCreationFactionOverride(size);
        if (factionId == null) {
            factionId = this.params.factionId;
        }
        m.createFleet(this.params.style, size, factionId, loc);
        m.triggerSetFleetFaction(this.params.factionId);
        m.setFleetSource(this.params.source);
        m.setFleetDamageTaken(damage);
        if (pirate) {
            m.triggerSetPirateFleet();
        } else {
            m.triggerSetWarFleet();
        }
        if (this.params.remnant) {
            m.triggerSetRemnantConfigActive();
        }
        if (this.params.makeFleetsHostile) {
            for (MarketAPI market : this.params.raidParams.allowedTargets) {
                m.triggerMakeHostileToFaction(market.getFactionId());
            }
            m.triggerMakeHostile();
            if ("luddic_path".equals(this.faction.getId())) {
                m.triggerFleetPatherNoDefaultTithe();
            }
        }
        if (this.params.repImpact == HubMissionWithTriggers.ComplicationRepImpact.LOW || this.params.repImpact == null) {
            m.triggerMakeLowRepImpact();
        } else if (this.params.repImpact == HubMissionWithTriggers.ComplicationRepImpact.NONE) {
            m.triggerMakeNoRepImpact();
        }
        if (this.params.repImpact != HubMissionWithTriggers.ComplicationRepImpact.FULL) {
            m.triggerMakeAlwaysSpreadTOffHostility();
        }
        this.configureFleet(size, m);
        CampaignFleetAPI fleet = m.createFleet();
        if (fleet != null) {
            this.configureFleet(size, fleet);
        }
        return fleet;
    }

    protected String getFleetCreationFactionOverride(int size) {
        return null;
    }

    protected void preConfigureFleet(int size, FleetCreatorMission m) {
    }

    protected void configureFleet(int size, FleetCreatorMission m) {
    }

    protected void configureFleet(int size, CampaignFleetAPI fleet) {
    }

    protected void addTargetingBulletPoint(TooltipMakerAPI info, Color tc, Object param, IntelInfoPlugin.ListInfoMode mode, float initPad) {
        StarSystemAPI system = this.raidAction.getWhere();
        Color s = this.raidAction.getSystemNameHighlightColor();
        LabelAPI label = info.addPara("\u76ee\u6807 " + system.getNameWithLowercaseTypeShort(), tc, initPad);
        label.setHighlightColors(s);
        label.setHighlight(system.getNameWithNoType());
    }

    @Override
    protected void addNonUpdateBulletPoints(TooltipMakerAPI info, Color tc, Object param, IntelInfoPlugin.ListInfoMode mode, float initPad) {
        Color h = Misc.getHighlightColor();
        Color s = this.raidAction.getSystemNameHighlightColor();
        FGAction curr = this.getCurrentAction();
        StarSystemAPI system = this.raidAction.getWhere();
        String forces = this.getForcesNoun();
        float untilDeployment = this.getETAUntil(PREPARE_ACTION);
        float untilDeparture = this.getETAUntil(TRAVEL_ACTION);
        float untilRaid = this.getETAUntil(PAYLOAD_ACTION);
        float untilReturn = this.getETAUntil(RETURN_ACTION, true);
        if (!this.isEnding()) {
            if (mode == IntelInfoPlugin.ListInfoMode.MESSAGES || this.getElapsed() <= 0.0f) {
                this.addTargetingBulletPoint(info, tc, param, mode, initPad);
                initPad = 0.0f;
            }
            if (untilDeployment > 0.0f) {
                this.addETABulletPoints(null, null, false, untilDeployment, FleetGroupIntel.ETAType.DEPLOYMENT, info, tc, initPad);
                initPad = 0.0f;
            } else if (untilDeparture > 0.0f) {
                this.addETABulletPoints(null, null, false, untilDeparture, FleetGroupIntel.ETAType.DEPARTURE, info, tc, initPad);
                initPad = 0.0f;
            }
            if (untilRaid > 0.0f && this.getSource().getContainingLocation() != system) {
                this.addETABulletPoints(system.getNameWithLowercaseTypeShort(), s, false, untilRaid, FleetGroupIntel.ETAType.ARRIVING, info, tc, initPad);
                initPad = 0.0f;
            }
            if (untilReturn > 0.0f && RETURN_ACTION.equals(curr.getId()) && this.getSource().getContainingLocation() != system && mode != IntelInfoPlugin.ListInfoMode.INTEL) {
                StarSystemAPI from = this.getSource().getStarSystem();
                this.addETABulletPoints(from.getNameWithLowercaseTypeShort(), null, false, untilReturn, FleetGroupIntel.ETAType.RETURNING, info, tc, initPad);
                initPad = 0.0f;
            }
            if ((mode == IntelInfoPlugin.ListInfoMode.INTEL || mode == IntelInfoPlugin.ListInfoMode.MAP_TOOLTIP) && curr != null && curr.getId().equals(PAYLOAD_ACTION)) {
                LabelAPI label = info.addPara("\u6267\u884c\u884c\u52a8\u4e8e " + system.getNameWithLowercaseTypeShort(), tc, initPad);
                label.setHighlightColors(s);
                label.setHighlight(system.getNameWithNoType());
                initPad = 0.0f;
            }
        }
        if (mode != IntelInfoPlugin.ListInfoMode.IN_DESC && this.isEnding() && !this.isSucceeded()) {
            if (!this.isAborted() && !this.isFailed()) {
                info.addPara("" + forces + " \u672a\u8fbe\u6210\u5176\u76ee\u6807", tc, initPad);
            } else if (this.isFailedButNotDefeated()) {
                info.addPara("" + forces + " \u672a\u8fbe\u6210\u5176\u76ee\u6807", tc, initPad);
            } else {
                info.addPara("" + forces + " \u88ab\u51fb\u8d25\u5e76\u9a71\u79bb", tc, initPad);
            }
        }
    }

    @Override
    protected void addUpdateBulletPoints(TooltipMakerAPI info, Color tc, Object param, IntelInfoPlugin.ListInfoMode mode, float initPad) {
        StarSystemAPI system = this.raidAction.getWhere();
        String forces = this.getForcesNoun();
        String noun = this.getNoun();
        Color s = this.raidAction.getSystemNameHighlightColor();
        if (ABORT_UPDATE.equals(param)) {
            if (this.isInPreLaunchDelay()) {
                info.addPara("" + noun + " \u5728\u7b79\u5212\u9636\u6bb5\u5c31\u88ab\u8feb\u4e2d\u65ad", tc, initPad);
            } else {
                info.addPara("" + forces + " \u88ab\u51fb\u8d25\u5e76\u9a71\u79bb", tc, initPad);
            }
        } else if (FLEET_LAUNCH_UPDATE.equals(param)) {
            float untilDeparture = this.getETAUntil(TRAVEL_ACTION);
            float untilRaid = this.getETAUntil(PAYLOAD_ACTION);
            info.addPara("\u8230\u961f\u90e8\u7f72\u4e2d", tc, initPad);
            initPad = 0.0f;
            if (untilDeparture > 0.0f) {
                this.addETABulletPoints(null, null, false, untilDeparture, FleetGroupIntel.ETAType.DEPARTURE, info, tc, initPad);
            }
            if (untilRaid > 0.0f && this.getSource().getContainingLocation() != system) {
                this.addETABulletPoints(system.getNameWithLowercaseTypeShort(), s, false, untilRaid, FleetGroupIntel.ETAType.ARRIVING, info, tc, initPad);
            }
        } else if (PREPARE_ACTION.equals(param)) {
            float untilRaid = this.getETAUntil(PAYLOAD_ACTION);
            this.addETABulletPoints(system.getNameWithLowercaseTypeShort(), s, true, untilRaid, FleetGroupIntel.ETAType.ARRIVING, info, tc, initPad);
        } else if (TRAVEL_ACTION.equals(param)) {
            this.addArrivedBulletPoint(system.getNameWithLowercaseTypeShort(), s, info, tc, initPad);
        } else if (PAYLOAD_ACTION.equals(param)) {
            if (this.isSucceeded()) {
                info.addPara("" + forces + " \u6b63\u5728\u64a4\u9000", tc, initPad);
            } else if (this.isAborted()) {
                info.addPara("" + forces + " \u88ab\u51fb\u8d25\u5e76\u9a71\u79bb", tc, initPad);
            } else {
                info.addPara("" + forces + " \u672a\u8fbe\u6210\u5176\u76ee\u6807", tc, initPad);
            }
        }
    }

    @Override
    protected boolean shouldSendIntelUpdateWhenActionFinished(FGAction action) {
        if (RETURN_ACTION.equals(action.getId())) {
            return false;
        }
        if (PAYLOAD_ACTION.equals(action.getId())) {
            return this.isSucceeded() || this.isFailed() && !this.isAborted();
        }
        if (TRAVEL_ACTION.equals(action.getId())) {
            if (action instanceof FGTravelAction && (this.isAborted() || this.isFailed())) {
                return false;
            }
            return this.getSource().getContainingLocation() != this.raidAction.getWhere();
        }
        return super.shouldSendIntelUpdateWhenActionFinished(action);
    }

    @Override
    protected void addBasicDescription(TooltipMakerAPI info, float width, float height, float opad) {
        info.addImage(this.getFaction().getLogo(), width, 128.0f, opad);
        StarSystemAPI system = this.raidAction.getWhere();
        String noun = this.getNoun();
        info.addPara(String.valueOf(Misc.ucFirst(this.faction.getPersonNamePrefixAOrAn())) + " %s " + noun + " \u9488\u5bf9 " + "" + system.getNameWithLowercaseTypeShort() + "\u3002", opad, this.faction.getBaseUIColor(), this.faction.getPersonNamePrefix());
    }

    @Override
    protected void addAssessmentSection(TooltipMakerAPI info, float width, float height, float opad) {
        Color h = Misc.getHighlightColor();
        FactionAPI faction = this.getFaction();
        List<MarketAPI> targets = this.params.raidParams.allowedTargets;
        String noun = this.getNoun();
        if (!(this.isEnding() || this.isSucceeded() || this.isFailed())) {
            info.addSectionHeading("\u8bc4\u4f30", faction.getBaseUIColor(), faction.getDarkUIColor(), Alignment.MID, opad);
            if (targets.isEmpty()) {
                info.addPara("\u8be5\u661f\u7cfb\u5185\u6ca1\u6709\u53ef\u4f9b " + noun + " \u4f5c\u4e3a\u76ee\u6807\u7684\u6b96\u6c11\u5730\u3002", opad);
            } else {
                String forces;
                StarSystemAPI system = this.raidAction.getWhere();
                boolean potentialDanger = this.addStrengthDesc(info, opad, system, forces = this.getForcesNoun(), "" + noun + " \u5e94\u8be5\u4e0d\u4f1a\u6210\u529f", "\u6b64\u6b21 " + noun + " \u7ed3\u679c\u5c1a\u4e0d\u660e\u786e", "" + noun + " \u5f88\u53ef\u80fd\u6210\u529f");
                if (potentialDanger) {
                    String safe = "\u5927\u6982\u4e0d\u4f1a\u53d7\u5230 " + noun;
                    String risk = "\u5177\u6709\u88ab\u63a0\u593a\u5e76 \u635f\u5931\u7a33\u5b9a\u6027 \u7684\u98ce\u9669\uff1a";
                    String highlight = "\u635f\u5931\u7a33\u5b9a\u6027";
                    if (this.params.raidParams.bombardment == MarketCMD.BombardType.SATURATION) {
                        risk = "\u5177\u6709\u88ab \u9971\u548c\u8f70\u70b8 \u7684\u98ce\u9669\uff1a";
                        highlight = "\u9971\u548c\u8f70\u70b8";
                    } else if (this.params.raidParams.bombardment == MarketCMD.BombardType.TACTICAL) {
                        risk = "\u5177\u6709\u88ab\u6218\u672f\u8f70\u70b8\u5e76 \u762b\u75ea\u519b\u4e8b\u8bbe\u65bd \u7684\u98ce\u9669\uff1a";
                        highlight = "\u762b\u75ea\u519b\u4e8b\u8bbe\u65bd";
                    } else if (!this.params.raidParams.disrupt.isEmpty()) {
                        risk = "\u5177\u6709\u88ab\u63a0\u593a\u5e76 \u4e25\u91cd\u5e72\u6270\u8bbe\u65bd\u8fd0\u4f5c \u7684\u98ce\u9669\uff1a";
                        highlight = "\u4e25\u91cd\u5e72\u6270\u8bbe\u65bd\u8fd0\u4f5c";
                    }
                    if (this.getAssessmentRiskStringOverride() != null) {
                        risk = this.getAssessmentRiskStringOverride();
                    }
                    if (this.getAssessmentRiskStringHighlightOverride() != null) {
                        highlight = this.getAssessmentRiskStringHighlightOverride();
                    }
                    this.showMarketsInDanger(info, opad, width, system, targets, safe, risk, highlight);
                }
            }
            this.addPostAssessmentSection(info, width, height, opad);
        }
    }

    protected void addPostAssessmentSection(TooltipMakerAPI info, float width, float height, float opad) {
    }

    protected String getAssessmentRiskStringOverride() {
        return null;
    }

    protected String getAssessmentRiskStringHighlightOverride() {
        return null;
    }

    protected void addPayloadActionStatus(TooltipMakerAPI info, float width, float height, float opad) {
        StarSystemAPI to = this.raidAction.getWhere();
        info.addPara("\u5b9e\u65bd\u884c\u52a8\u4e8e " + to.getNameWithLowercaseTypeShort() + "\u3002", opad);
    }

    @Override
    protected void addStatusSection(TooltipMakerAPI info, float width, float height, float opad) {
        boolean showStatus;
        FGAction curr = this.getCurrentAction();
        boolean bl = showStatus = curr != null || this.isEnding() || this.isSucceeded();
        if (showStatus) {
            String noun = this.getNoun();
            String forces = this.getForcesNoun();
            info.addSectionHeading("\u5f62\u52bf", this.faction.getBaseUIColor(), this.faction.getDarkUIColor(), Alignment.MID, opad);
            if (this.isEnding() && !this.isSucceeded()) {
                if (this.isFailed() || this.isAborted()) {
                    if (this.isFailedButNotDefeated()) {
                        info.addPara("" + forces + " \u6b63\u5728\u64a4\u9000\u3002", opad);
                    } else {
                        info.addPara("" + forces + " \u5df2\u88ab\u51fb\u8d25\u4e14\u4efb\u4f55" + "\u6b8b\u4f59\u8230\u8239\u90fd\u6b63\u4ed3\u7687\u9003\u7a9c\u3002", opad);
                    }
                } else {
                    info.addPara("" + forces + " \u6b63\u5728\u64a4\u9000\u3002", opad);
                }
            } else if (this.isEnding() || this.isSucceeded()) {
                info.addPara("" + noun + " \u7684\u884c\u52a8\u5df2\u7ecf\u6210\u529f\u4e14 " + forces + " \u6b63\u5728\u64a4\u9000\u3002", opad);
            } else if (curr != null) {
                StarSystemAPI to = this.raidAction.getWhere();
                if (this.isInPreLaunchDelay()) {
                    if (this.getSource().getMarket() != null) {
                        BaseHubMission.addStandardMarketDesc("" + noun + " \u6b63\u5904\u4e8e\u7b79\u5212\u9636\u6bb5\uff0c\u5176\u57fa\u5730\u4f4d\u4e8e ", this.getSource().getMarket(), info, opad);
                        boolean mil = this.isSourceFunctionalMilitaryMarket();
                        if (mil) {
                            info.addPara("\u762b\u75ea\u519b\u4e8b\u8bbe\u65bd " + this.getSource().getMarket().getOnOrAt() + " " + this.getSource().getMarket().getName() + " \u5c06\u8feb\u4f7f\u5176\u653e\u5f03 " + noun + "\u3002", opad);
                        }
                    }
                } else if (PREPARE_ACTION.equals(curr.getId())) {
                    if (this.getSource().getMarket() != null) {
                        BaseHubMission.addStandardMarketDesc("\u7b79\u5907\u884c\u52a8\u5e76\u73af\u7ed5\u4e8e ", this.getSource().getMarket(), info, opad);
                    } else {
                        info.addPara("\u7b79\u5907\u884c\u52a8\u5e76\u73af\u7ed5\u4e8e " + this.getSource().getName() + "\u3002", opad);
                    }
                } else if (TRAVEL_ACTION.equals(curr.getId())) {
                    if (this.getSource().getMarket() == null) {
                        info.addPara("\u6b63\u5728\u524d\u5f80 " + to.getNameWithLowercaseTypeShort() + "\u3002", opad);
                    } else {
                        info.addPara("\u7531 " + this.getSource().getMarket().getName() + " \u524d\u5f80 " + to.getNameWithLowercaseTypeShort() + "\u3002", opad);
                    }
                } else if (RETURN_ACTION.equals(curr.getId())) {
                    if (this.getSource().getMarket() == null) {
                        info.addPara("\u6b63\u5728\u8fd4\u56de\u59cb\u53d1\u6e2f\u3002", opad);
                    } else {
                        info.addPara("\u6b63\u5728\u8fd4\u56de " + this.getSource().getMarket().getName() + " \u4f4d\u4e8e " + this.origin.getContainingLocation().getNameWithLowercaseTypeShort() + "\u3002", opad);
                    }
                } else if (PAYLOAD_ACTION.equals(curr.getId())) {
                    this.addPayloadActionStatus(info, width, height, opad);
                }
            }
        }
    }

    public String getNoun() {
        if (this.params.noun != null) {
            return this.params.noun;
        }
        String noun = "\u7a81\u88ad";
        if (this.params.raidParams.bombardment != null) {
            noun = "\u88ad\u51fb";
        }
        return noun;
    }

    public String getForcesNoun() {
        if (this.params.forcesNoun != null) {
            return this.params.forcesNoun;
        }
        String forces = "\u7a81\u88ad\u8230\u961f";
        if (!this.getNoun().equals("\u7a81\u88ad")) {
            forces = "\u88ad\u51fb\u8230\u961f";
        }
        return forces;
    }

    @Override
    public String getBaseName() {
        return String.valueOf(Misc.ucFirst(this.getFaction().getPersonNamePrefix())) + " " + Misc.ucFirst(this.getNoun());
    }

    @Override
    public boolean isSucceeded() {
        return this.raidAction.getSuccessFraction() > 0.0f && this.raidAction.isActionFinished() && !this.isAborted();
    }

    @Override
    public boolean isFailed() {
        return this.isAborted() || this.raidAction.getSuccessFraction() <= 0.0f && this.raidAction.isActionFinished();
    }

    @Override
    protected SectorEntityToken getSource() {
        return this.origin;
    }

    @Override
    protected SectorEntityToken getDestination() {
        return this.raidAction.getWhere().getHyperspaceAnchor();
    }

    protected StarSystemAPI getTargetSystem() {
        return this.raidAction.getWhere();
    }

    public GenericPayloadAction getRaidAction() {
        return this.raidAction;
    }

    public FGTravelAction getTravelAction() {
        return this.travelAction;
    }

    public FGTravelAction getReturnAction() {
        return this.returnAction;
    }

    public FGWaitAction getWaitAction() {
        return this.waitAction;
    }

    @Override
    public String getCommMessageSound() {
        if (this.isSendingUpdate()) {
            return GenericRaidFGI.getSoundStandardUpdate();
        }
        if (this.params.playerTargeted) {
            return GenericRaidFGI.getSoundColonyThreat();
        }
        return super.getCommMessageSound();
    }

    @Override
    public boolean isPlayerTargeted() {
        return this.params.playerTargeted;
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        return super.getIntelTags(map);
    }

    @Override
    public List<IntelInfoPlugin.ArrowData> getArrowData(SectorMapAPI map) {
        if (this.isAborted() || this.isFailed() || this.isSucceeded() || this.isEnded() || this.isEnding()) {
            return null;
        }
        return super.getArrowData(map);
    }

    public GenericRaidParams getParams() {
        return this.params;
    }

    public void setOrigin(SectorEntityToken origin) {
        this.origin = origin;
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        if (this.getCurrentAction() != null && PREPARE_ACTION.equals(this.getCurrentAction().getId()) || this.getDelayRemaining() > 0.0f) {
            return this.getSource();
        }
        return this.getDestination();
    }

    public boolean hasCustomRaidAction() {
        return false;
    }

    public void doCustomRaidAction(CampaignFleetAPI fleet, MarketAPI market, float raidStr) {
    }

    public static interface GenericPayloadAction
    extends FGAction {
        public Color getSystemNameHighlightColor();

        public float getSuccessFraction();

        public StarSystemAPI getWhere();
    }

    public static class GenericRaidParams {
        public Random random = new Random();
        public boolean playerTargeted;
        public boolean remnant = false;
        public MarketAPI source;
        public String factionId;
        public List<Integer> fleetSizes = new ArrayList<Integer>();
        public FleetCreatorMission.FleetStyle style = FleetCreatorMission.FleetStyle.STANDARD;
        public FGRaidAction.FGRaidParams raidParams = new FGRaidAction.FGRaidParams();
        public float prepDays = 5.0f;
        public float payloadDays = 30.0f;
        public boolean makeFleetsHostile = true;
        public HubMissionWithTriggers.ComplicationRepImpact repImpact = HubMissionWithTriggers.ComplicationRepImpact.LOW;
        public String noun;
        public String forcesNoun;
        public Object custom;
        public String memoryKey = null;

        public GenericRaidParams(Random random, boolean playerTargeted) {
            this.random = random;
            this.playerTargeted = playerTargeted;
        }
    }
}

