/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.group;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.EconomyTickListener;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.MutableStatWithTempMods;
import com.fs.starfarer.api.impl.campaign.NPCHassler;
import com.fs.starfarer.api.impl.campaign.econ.RecentUnrest;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.ids.Sounds;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.group.BlockadeFGI;
import com.fs.starfarer.api.impl.campaign.intel.group.FGAction;
import com.fs.starfarer.api.impl.campaign.intel.group.FGBlockadeAction;
import com.fs.starfarer.api.impl.campaign.intel.group.FGBlockadePlanetAction;
import com.fs.starfarer.api.impl.campaign.intel.group.GenericRaidFGI;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class KnightsOfLuddTakeoverExpedition
extends BlockadeFGI
implements EconomyTickListener {
    public static int STABILITY_PER_MONTH_FULL = 2;
    public static int STABILITY_PER_MONTH_PARTIAL = 1;
    public static float NUM_OTHER_FLEETS_MULT = 0.25f;
    public static final String STABILITY_UPDATE = "stability_update";
    public static final String TAKEOVER_UPDATE = "takeover_update";
    public static final String BLOCKADING = "$KOLT_isBlockading";
    public static final String KOLT_FLEET = "$KOLT_fleet";
    public static final String ARMADA = "$KOLT_armada";
    public static final String PICKET = "$KOLT_picket";
    public static String KEY = "$KOLT_ref";
    protected boolean voluntary;

    public static KnightsOfLuddTakeoverExpedition get() {
        return (KnightsOfLuddTakeoverExpedition)Global.getSector().getMemoryWithoutUpdate().get(KEY);
    }

    public KnightsOfLuddTakeoverExpedition(GenericRaidFGI.GenericRaidParams params, FGBlockadeAction.FGBlockadeParams blockadeParams) {
        super(params, blockadeParams);
        Global.getSector().getMemoryWithoutUpdate().set(KEY, this);
        Global.getSector().getListenerManager().addListener(this);
    }

    protected void notifyEnding() {
        super.notifyEnding();
        Global.getSector().getMemoryWithoutUpdate().unset(KEY);
        Global.getSector().getListenerManager().removeListener(this);
    }

    protected void notifyEnded() {
        super.notifyEnded();
    }

    protected CampaignFleetAPI createFleet(int size, float damage) {
        CampaignFleetAPI fleet;
        Random r = this.getRandom();
        Vector2f loc = this.origin.getLocationInHyperspace();
        FleetCreatorMission m = new FleetCreatorMission(r);
        m.beginFleet();
        m.createFleet(this.params.style, size, this.params.factionId, loc);
        if (size == 10) {
            m.triggerSetFleetDoctrineOther(5, 0);
            m.triggerSetFleetSize(HubMissionWithTriggers.FleetSize.MAXIMUM);
            m.triggerSetFleetSizeFraction(1.4f);
            m.triggerSetFleetQuality(HubMissionWithTriggers.FleetQuality.HIGHER);
        }
        m.triggerSetFleetFlag(KOLT_FLEET);
        m.setFleetSource(this.params.source);
        m.setFleetDamageTaken(damage);
        m.triggerSetWarFleet();
        m.triggerMakeLowRepImpact();
        m.triggerMakeAlwaysSpreadTOffHostility();
        if (size >= 8) {
            m.triggerFleetAddCommanderSkill("coordinated_maneuvers", 1);
            m.triggerFleetAddCommanderSkill("tactical_drills", 1);
            m.triggerFleetAddCommanderSkill("carrier_group", 1);
        }
        if ((fleet = m.createFleet()) != null) {
            if (size >= 8) {
                this.setNeverStraggler(fleet);
            } else {
                fleet.addScript(new NPCHassler(fleet, this.getTargetSystem()));
                fleet.getMemoryWithoutUpdate().set(PICKET, true);
                fleet.setName("\u5362\u5fb7\u9a91\u58eb\u56e2 \u770b\u62a4\u8005");
                fleet.setNoFactionInName(true);
            }
            if (size == 10) {
                fleet.setName("\u5362\u5fb7\u9a91\u58eb\u56e2 \u795e\u5723\u65e0\u654c\u8230\u961f");
                fleet.setNoFactionInName(true);
                fleet.getMemoryWithoutUpdate().set(ARMADA, true);
                fleet.getCommander().setRankId(Ranks.SPACE_ADMIRAL);
            }
        }
        return fleet;
    }

    public void advance(float amount) {
        super.advance(amount);
        if (this.isSpawnedFleets()) {
            if (this.isEnded() || this.isEnding() || this.isAborted() || this.isCurrent(RETURN_ACTION)) {
                for (CampaignFleetAPI curr : this.getFleets()) {
                    curr.getMemoryWithoutUpdate().set(BLOCKADING, false);
                }
                return;
            }
            if (this.isCurrent(PAYLOAD_ACTION)) {
                for (CampaignFleetAPI curr : this.getFleets()) {
                    curr.getMemoryWithoutUpdate().set(BLOCKADING, true);
                }
            }
        }
    }

    protected void periodicUpdate() {
        FGBlockadePlanetAction blockade;
        super.periodicUpdate();
        if (this.isEnded() || this.isEnding() || this.isSucceeded() || this.isFailed() || this.isAborted()) {
            return;
        }
        if (HostileActivityEventIntel.get() == null) {
            this.abort();
            return;
        }
        MarketAPI target = this.blockadeParams.specificMarket;
        if (target != null && !target.hasCondition("luddic_majority")) {
            this.finish(false);
            return;
        }
        FGAction action = this.getCurrentAction();
        if (action instanceof FGBlockadeAction) {
            MutableStatWithTempMods stat = HostileActivityEventIntel.get().getNumFleetsStat(this.getTargetSystem());
            stat.addTemporaryModMult(1.0f, "KOLBlockade", null, NUM_OTHER_FLEETS_MULT);
        }
        if (!this.isSpawnedFleets() || this.isSpawning()) {
            return;
        }
        int armada = 0;
        for (CampaignFleetAPI curr : this.getFleets()) {
            if (!curr.getMemoryWithoutUpdate().getBoolean(ARMADA)) continue;
            ++armada;
        }
        if (armada <= 0) {
            this.abort();
        }
        if (action instanceof FGBlockadePlanetAction && (blockade = (FGBlockadePlanetAction)action).getPrimary() != null) {
            for (CampaignFleetAPI curr : this.getFleets()) {
                if (blockade.getPrimary().getContainingLocation() != curr.getContainingLocation() || curr.getMemoryWithoutUpdate().getBoolean(PICKET)) continue;
                curr.getMemoryWithoutUpdate().set("$doNotGetSidetracked", true, 0.4f);
            }
        }
    }

    protected String getOfString() {
        return "\u9488\u5bf9";
    }

    protected GenericRaidFGI.GenericPayloadAction createPayloadAction() {
        FGBlockadePlanetAction action = new FGBlockadePlanetAction(this.blockadeParams, this.params.payloadDays);
        action.setSuccessFractionOverride(0.0f);
        return action;
    }

    protected void applyBlockadeCondition() {
    }

    protected void unapplyBlockadeCondition() {
    }

    protected void addUpdateBulletPoints(TooltipMakerAPI info, Color tc, Object param, IntelInfoPlugin.ListInfoMode mode, float initPad) {
        Object p = this.getListInfoParam();
        if (STABILITY_UPDATE.equals(p)) {
            int penalty = this.getStabilityPenaltyPerMonth();
            MarketAPI target = this.blockadeParams.specificMarket;
            LabelAPI label = info.addPara(String.valueOf(target.getName()) + " \u7a33\u5b9a\u6027\u964d\u4f4e %s", initPad, tc, Misc.getHighlightColor(), "" + penalty);
            label.setHighlightColors(target.getFaction().getBaseUIColor(), Misc.getHighlightColor());
            label.setHighlight(target.getName(), "" + penalty);
        } else if (!TAKEOVER_UPDATE.equals(p)) {
            super.addUpdateBulletPoints(info, tc, param, mode, initPad);
        }
    }

    protected void addTargetingBulletPoint(TooltipMakerAPI info, Color tc, Object param, IntelInfoPlugin.ListInfoMode mode, float initPad) {
        MarketAPI target = this.blockadeParams.specificMarket;
        LabelAPI label = info.addPara("\u76ee\u6807 " + target.getName(), tc, initPad);
        label.setHighlightColors(target.getFaction().getBaseUIColor());
        label.setHighlight(target.getName());
    }

    protected void addBasicDescription(TooltipMakerAPI info, float width, float height, float opad) {
        info.addImage(this.getFaction().getLogo(), width, 128.0f, opad);
        MarketAPI target = this.blockadeParams.specificMarket;
        StarSystemAPI system = this.raidAction.getWhere();
        String noun = this.getNoun();
        LabelAPI label = info.addPara(String.valueOf(Misc.ucFirst(this.faction.getPersonNamePrefixAOrAn())) + " %s " + noun + " " + this.getOfString() + " " + target.getName() + " \u4e8e " + system.getNameWithLowercaseType() + "\u3002", opad, this.faction.getBaseUIColor(), this.faction.getPersonNamePrefix());
        label.setHighlightColors(this.faction.getBaseUIColor(), target.getFaction().getBaseUIColor());
        label.setHighlight(this.faction.getPersonNamePrefix(), target.getName());
    }

    protected void addAssessmentSection(TooltipMakerAPI info, float width, float height, float opad) {
        Color h = Misc.getHighlightColor();
        Color bad = Misc.getNegativeHighlightColor();
        FactionAPI faction = this.getFaction();
        MarketAPI target = this.blockadeParams.specificMarket;
        String noun = this.getNoun();
        String forcesNoun = this.getForcesNoun();
        if (!(this.isEnding() || this.isSucceeded() || this.isFailed())) {
            String \u5929;
            FactionAPI other = Global.getSector().getFaction(this.blockadeParams.targetFaction);
            boolean hostile = this.getFaction().isHostileTo(this.blockadeParams.targetFaction);
            info.addSectionHeading("\u8bc4\u4f30", faction.getBaseUIColor(), faction.getDarkUIColor(), Alignment.MID, opad);
            boolean started = this.isCurrent(PAYLOAD_ACTION);
            float remaining = this.getETAUntil(PAYLOAD_ACTION, true) - this.getETAUntil(TRAVEL_ACTION, true);
            if (remaining > 0.0f && remaining < 1.0f) {
                remaining = 1.0f;
            }
            String string = \u5929 = (int)remaining == 1 ? "\u5929" : "\u5929";
            if (started) {
                \u5929 = "" + \u5929;
            }
            LabelAPI label = info.addPara("\u884c\u52a8\u5c06\u6301\u7eed\u5927\u7ea6 %s" + \u5929 + "\uff0c\u5bfc\u81f4\u9010\u6e10\u964d\u4f4e\u7a33\u5b9a\u6027 " + target.getOnOrAt() + " %s}\u3002\u5982\u679c\u7a33\u5b9a\u6027\u4f4e\u81f3\u96f6\uff0c%s \u5c06\u6c38\u4e45\u9677\u5165 %s \u7684\u63a7\u5236\u3002", opad, h, "" + (int)remaining, target.getName(), target.getName(), faction.getDisplayName());
            label.setHighlight("" + (int)remaining, target.getName(), target.getName(), "\u5c06\u6c38\u4e45\u9677\u5165", faction.getDisplayName());
            label.setHighlightColors(h, other.getBaseUIColor(), Misc.getTextColor(), Misc.getNegativeHighlightColor(), faction.getBaseUIColor());
            if (!hostile) {
                info.addPara("" + forcesNoun + " \u4e0e\u4f60\u540d\u4e49\u4e0a \u5c1a\u672a\u654c\u5bf9 \uff0c\u4f46\u4ecd\u4f1a\u9a9a\u6270\u8239\u8fd0\u5e76" + "\u5c1d\u8bd5\u63a7\u5236\u4f60\u6b96\u6c11\u5730\u7684\u5468\u906d\u533a\u57df\uff0c\u8fdb\u884c\u5404\u7c7b\u884c\u52a8\u4ee5\u7834\u574f\u4f60\u7684" + "\u6743\u5a01\u3002", opad, Misc.getHighlightColor(), "\u5c1a\u672a\u654c\u5bf9");
            } else {
                info.addPara("" + forcesNoun + " \u4e0e\u4f60\u5df2 \u79ef\u6781\u654c\u5bf9 \uff0c\u4f1a\u76f4\u63a5\u653b\u51fb\u4f60\u7684\u6b96\u6c11\u5730\u7684\u8f68\u9053\u9632\u5fa1\u8bbe\u65bd\uff0c\u5e76" + "\u5728\u5730\u8868\u8fdb\u884c\u5404\u7c7b\u884c\u52a8\u4ee5\u7834\u574f\u4f60\u7684\u6743\u5a01\u3002", opad, Misc.getNegativeHighlightColor(), "\u79ef\u6781\u654c\u5bf9");
            }
            this.addStrengthDesc(info, opad, target, forcesNoun, "\u6b96\u6c11\u5730\u5e94\u8be5\u4e0d\u4f1a\u906d\u53d7\u5a01\u80c1", "\u6b96\u6c11\u5730\u53ef\u80fd\u906d\u53d7\u5a01\u80c1", "\u6b96\u6c11\u5730\u5c06\u906d\u53d7\u5a01\u80c1");
            this.addPostAssessmentSection(info, width, height, opad);
        }
    }

    protected void addPostAssessmentSection(TooltipMakerAPI info, float width, float height, float opad) {
    }

    protected void addPayloadActionStatus(TooltipMakerAPI info, float width, float height, float opad) {
        StarSystemAPI to = this.raidAction.getWhere();
        info.addPara("\u5b9e\u65bd\u884c\u52a8\u4e8e " + to.getNameWithLowercaseTypeShort() + "\u3002", opad);
        int penalty = this.getStabilityPenaltyPerMonth();
        MarketAPI target = this.blockadeParams.specificMarket;
        this.bullet(info);
        if (penalty > 0) {
            LabelAPI label = info.addPara(String.valueOf(target.getName()) + " \u7a33\u5b9a\u6027\uff1a%s \u6bcf\u6708", opad, Misc.getHighlightColor(), "-" + penalty);
            label.setHighlightColors(target.getFaction().getBaseUIColor(), Misc.getHighlightColor());
            label.setHighlight(target.getName(), "-" + penalty);
        } else {
            info.addPara("%s \u7a33\u5b9a\u6027 \u672a\u53d7\u5f71\u54cd", opad, target.getFaction().getBaseUIColor(), target.getName());
            this.unindent(info);
        }
    }

    public int getStabilityPenaltyPerMonth() {
        int str = this.getRelativeFGStrength(this.getTargetSystem());
        if (str < 0) {
            return 0;
        }
        if (str == 0) {
            return STABILITY_PER_MONTH_PARTIAL;
        }
        return STABILITY_PER_MONTH_FULL;
    }

    public void reportEconomyTick(int iterIndex) {
        if (iterIndex == 0) {
            if (!this.isCurrent(PAYLOAD_ACTION)) {
                return;
            }
            MarketAPI target = this.blockadeParams.specificMarket;
            int penalty = this.getStabilityPenaltyPerMonth();
            if (penalty > 0) {
                RecentUnrest.get(target).add(penalty, "\u5362\u5fb7\u6559\u4f1a\u5ba3\u79f0\u593a\u5360");
                target.reapplyConditions();
                this.sendUpdateIfPlayerHasIntel((Object)STABILITY_UPDATE, false);
            }
            if (target.getStabilityValue() <= 0.0f) {
                this.performTakeover(false);
            }
        }
    }

    public void reportEconomyMonthEnd() {
    }

    public void performTakeover(boolean voluntary) {
        this.voluntary = voluntary;
        MarketAPI target = this.blockadeParams.specificMarket;
        target.setFactionId("luddic_church");
        target.setPlayerOwned(false);
        target.setAdmin(null);
        for (SectorEntityToken curr : target.getConnectedEntities()) {
            curr.setFaction("luddic_church");
        }
        if (!target.hasSubmarket("open_market")) {
            target.addSubmarket("open_market");
        }
        if (!target.hasSubmarket("black_market")) {
            target.addSubmarket("black_market");
        }
        if ((Misc.isMilitary(target) || target.hasIndustry("militarybase") || target.hasIndustry("highcommand")) && !target.hasSubmarket("generic_military")) {
            target.addSubmarket("generic_military");
        }
        RecentUnrest.get(target).setPenalty(0);
        if (this.getCurrentAction() instanceof FGBlockadePlanetAction) {
            FGBlockadePlanetAction action = (FGBlockadePlanetAction)this.getCurrentAction();
            action.setSuccessFractionOverride(1.0f);
            action.setActionFinished(true);
        }
        if (target.getStarSystem() != null) {
            for (CampaignFleetAPI fleet : target.getStarSystem().getFleets()) {
                MemoryAPI mem = fleet.getMemoryWithoutUpdate();
                String type = mem.getString("$hassleType");
                if (!"sacredProtectors".equals(type)) continue;
                mem.unset("$willHasslePlayer");
                mem.unset("$hassleType");
                mem.set("$hassleComplete", true);
                fleet.removeScriptsOfClass(NPCHassler.class);
            }
        }
    }

    public String getCommMessageSound() {
        if (this.isSendingUpdate() && this.isSucceeded() && this.isCurrent(RETURN_ACTION) && !this.voluntary) {
            return Sounds.REP_LOSS;
        }
        return super.getCommMessageSound();
    }
}

