/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.group;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.MutableStatWithTempMods;
import com.fs.starfarer.api.impl.campaign.NPCHassler;
import com.fs.starfarer.api.impl.campaign.ids.People;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.group.BlockadeFGI;
import com.fs.starfarer.api.impl.campaign.intel.group.FGAction;
import com.fs.starfarer.api.impl.campaign.intel.group.FGBlockadeAction;
import com.fs.starfarer.api.impl.campaign.intel.group.GenericRaidFGI;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class PerseanLeagueBlockade
extends BlockadeFGI {
    public static float NUM_OTHER_FLEETS_MULT = 0.25f;
    public static final String ARMADA = "$PLB_armada";
    public static final String SUPPLY = "$PLB_supply";
    public static final String GENERIC = "$PLB_generic";
    public static final String BLOCKADING = "$PLB_isBlockading";
    public static String KEY = "$plBlockade_ref";
    protected boolean createdArmada = false;
    protected int supplyFleets = 0;

    public static PerseanLeagueBlockade get() {
        return (PerseanLeagueBlockade)Global.getSector().getMemoryWithoutUpdate().get(KEY);
    }

    public PerseanLeagueBlockade(GenericRaidFGI.GenericRaidParams params, FGBlockadeAction.FGBlockadeParams blockadeParams) {
        super(params, blockadeParams);
        Global.getSector().getMemoryWithoutUpdate().set(KEY, this);
        PersonAPI reynard = People.getPerson(People.REYNARD_HANNAN);
        if (reynard != null) {
            Misc.makeImportant(reynard, "PLB");
        }
    }

    protected void notifyEnding() {
        super.notifyEnding();
        Global.getSector().getMemoryWithoutUpdate().unset(KEY);
        PersonAPI reynard = People.getPerson(People.REYNARD_HANNAN);
        if (reynard != null) {
            Misc.makeUnimportant(reynard, "PLB");
        }
    }

    protected void notifyEnded() {
        super.notifyEnded();
    }

    protected CampaignFleetAPI createFleet(int size, float damage) {
        boolean supplyFleet;
        Random r = this.getRandom();
        Vector2f loc = this.origin.getLocationInHyperspace();
        FleetCreatorMission m = new FleetCreatorMission(r);
        m.beginFleet();
        boolean armada = size == 10 && !this.createdArmada;
        boolean bl = supplyFleet = size == 1 && this.supplyFleets < 2;
        if (armada) {
            this.createdArmada = true;
            m.triggerCreateFleet(HubMissionWithTriggers.FleetSize.MAXIMUM, HubMissionWithTriggers.FleetQuality.SMOD_2, this.params.factionId, "leagueArmada", loc);
            m.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.HIGHER);
            m.triggerSetFleetFlag(ARMADA);
            m.triggerSetFleetType("leagueArmada");
            m.triggerSetFleetDoctrineQuality(5, 5, 5);
            m.triggerSetFleetDoctrineOther(5, 0);
            m.triggerSetFleetComposition(0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            m.triggerFleetMakeFaster(true, 1, false);
            m.triggerFleetAddCommanderSkill("crew_training", 1);
            m.triggerFleetAddCommanderSkill("coordinated_maneuvers", 1);
            m.triggerFleetAddCommanderSkill("tactical_drills", 1);
            m.triggerFleetAddCommanderSkill("carrier_group", 1);
        } else if (supplyFleet) {
            ++this.supplyFleets;
            int total = 0;
            for (Integer i : this.params.fleetSizes) {
                total += i.intValue();
            }
            HubMissionWithTriggers.FleetSize supplyFleetSize = HubMissionWithTriggers.FleetSize.MEDIUM;
            if (total < 50) {
                supplyFleetSize = HubMissionWithTriggers.FleetSize.SMALL;
            } else if (total >= 80) {
                supplyFleetSize = HubMissionWithTriggers.FleetSize.LARGE;
            }
            m.triggerCreateFleet(supplyFleetSize, HubMissionWithTriggers.FleetQuality.DEFAULT, this.params.factionId, "supplyFleet", loc);
            m.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.DEFAULT, HubMissionWithTriggers.OfficerQuality.DEFAULT);
            m.triggerSetFleetFlag(SUPPLY);
            m.triggerSetFleetType("supplyFleet");
            m.triggerFleetMakeFaster(true, 0, false);
            m.triggerSetFleetComposition(0.5f, 0.5f, 0.1f, 0.0f, 0.1f);
        } else {
            m.createFleet(this.params.style, size, this.params.factionId, loc);
            m.triggerSetFleetFlag(GENERIC);
        }
        m.setFleetSource(this.params.source);
        m.setFleetDamageTaken(damage);
        m.triggerSetPatrol();
        m.triggerMakeLowRepImpact();
        m.triggerMakeAlwaysSpreadTOffHostility();
        CampaignFleetAPI fleet = m.createFleet();
        if (fleet != null && !armada && !supplyFleet) {
            fleet.addScript(new NPCHassler(fleet, this.getTargetSystem()));
        }
        if (fleet != null && armada) {
            fleet.getCommander().setRankId(Ranks.SPACE_ADMIRAL);
            this.setNeverStraggler(fleet);
        }
        return fleet;
    }

    public void advance(float amount) {
        super.advance(amount);
        if (this.isSpawnedFleets()) {
            if (this.isEnded() || this.isEnding() || this.isAborted() || this.isCurrent(RETURN_ACTION)) {
                for (CampaignFleetAPI curr : this.getFleets()) {
                    curr.getMemoryWithoutUpdate().set(BLOCKADING, false);
                }
                return;
            }
            if (this.isCurrent(PAYLOAD_ACTION)) {
                for (CampaignFleetAPI curr : this.getFleets()) {
                    curr.getMemoryWithoutUpdate().set(BLOCKADING, true);
                }
            }
        }
    }

    protected void periodicUpdate() {
        FGBlockadeAction blockade;
        super.periodicUpdate();
        if (HostileActivityEventIntel.get() == null) {
            this.abort();
            return;
        }
        FGAction action = this.getCurrentAction();
        if (action instanceof FGBlockadeAction) {
            MutableStatWithTempMods stat = HostileActivityEventIntel.get().getNumFleetsStat(this.getTargetSystem());
            stat.addTemporaryModMult(1.0f, "PLBlockade", null, NUM_OTHER_FLEETS_MULT);
        }
        if (!this.isSpawnedFleets() || this.isSpawning()) {
            return;
        }
        int armada = 0;
        int supply = 0;
        for (CampaignFleetAPI curr : this.getFleets()) {
            if (curr.getMemoryWithoutUpdate().getBoolean(ARMADA)) {
                ++armada;
            }
            if (!curr.getMemoryWithoutUpdate().getBoolean(SUPPLY)) continue;
            ++supply;
        }
        if (armada <= 0 || supply <= 0) {
            this.abort();
            return;
        }
        if (action instanceof FGBlockadeAction && (blockade = (FGBlockadeAction)action).getPrimary() != null) {
            int supplyIndex = 0;
            for (CampaignFleetAPI curr : this.getFleets()) {
                if (blockade.getPrimary().getContainingLocation() != curr.getContainingLocation()) continue;
                if (curr.getMemoryWithoutUpdate().getBoolean(SUPPLY)) {
                    Misc.setFlagWithReason(curr.getMemoryWithoutUpdate(), "$core_fleetBusy", curr.getId(), true, -1.0f);
                    curr.getMemoryWithoutUpdate().set("$doNotGetSidetracked", true, 0.4f);
                    curr.clearAssignments();
                    SectorEntityToken resupplyLoc = blockade.getPrimary();
                    if (supplyIndex == 1) {
                        for (SectorEntityToken jp : blockade.getBlockadePoints()) {
                            if (jp == resupplyLoc) continue;
                            resupplyLoc = jp;
                            break;
                        }
                    }
                    curr.addAssignment(FleetAssignment.ORBIT_PASSIVE, resupplyLoc, 3.0f, "\u6b63\u63d0\u4f9b\u8865\u7ed9");
                    ++supplyIndex;
                    continue;
                }
                if (curr.getMemoryWithoutUpdate().getBoolean(ARMADA)) continue;
                curr.getMemoryWithoutUpdate().set("$willHasslePlayer", true, 2.0f);
                curr.getMemoryWithoutUpdate().set("$hassleType", "leagueEnforcer", 2.0f);
            }
        }
    }

    protected void addPostAssessmentSection(TooltipMakerAPI info, float width, float height, float opad) {
        info.addPara("\u5c01\u9501\u8230\u961f\u7531\u4e00\u652f\u8054\u76df\u65e0\u654c\u8230\u961f\u7387\u9886\uff0c\u4e24\u652f\u8865\u7ed9\u8230\u961f\u4f5c\u4e3a\u652f\u63f4\u3002", opad);
    }
}

