/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.group;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.impl.campaign.intel.group.GenericRaidFGI;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;

public class SindrianDiktatPunitiveExpedition
extends GenericRaidFGI {
    public static final String SDPE_FLEET = "$SDPE_fleet";
    public static String KEY = "$SDPE_ref";
    protected IntervalUtil interval = new IntervalUtil(0.1f, 0.3f);

    public static SindrianDiktatPunitiveExpedition get() {
        return (SindrianDiktatPunitiveExpedition)Global.getSector().getMemoryWithoutUpdate().get(KEY);
    }

    public SindrianDiktatPunitiveExpedition(GenericRaidFGI.GenericRaidParams params) {
        super(params);
        Global.getSector().getMemoryWithoutUpdate().set(KEY, this);
    }

    protected void notifyEnding() {
        super.notifyEnding();
        Global.getSector().getMemoryWithoutUpdate().unset(KEY);
    }

    protected void notifyEnded() {
        super.notifyEnded();
    }

    public String getNoun() {
        return super.getNoun();
    }

    public String getForcesNoun() {
        return super.getForcesNoun();
    }

    public String getBaseName() {
        return super.getBaseName();
    }

    protected void preConfigureFleet(int size, FleetCreatorMission m) {
        m.setFleetTypeMedium("taskForce");
    }

    protected void configureFleet(int size, FleetCreatorMission m) {
        m.triggerSetFleetFlag(SDPE_FLEET);
        if (size >= 8) {
            m.triggerSetFleetDoctrineOther(5, 0);
        }
    }

    public void abort() {
        if (!this.isAborted()) {
            for (CampaignFleetAPI curr : this.getFleets()) {
                curr.getMemoryWithoutUpdate().unset(SDPE_FLEET);
            }
        }
        super.abort();
    }

    public void advance(float amount) {
        super.advance(amount);
        float days = Misc.getDays(amount);
        this.interval.advance(days);
        if (this.interval.intervalElapsed() && this.isCurrent(PAYLOAD_ACTION)) {
            String reason = "SDPunEx";
            for (CampaignFleetAPI curr : this.getFleets()) {
                Misc.setFlagWithReason(curr.getMemoryWithoutUpdate(), "$cfai_makeHostile", reason, true, 1.0f);
            }
        }
    }
}

