/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.group;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.intel.group.FGAction;
import com.fs.starfarer.api.impl.campaign.intel.group.FGRaidAction;
import com.fs.starfarer.api.impl.campaign.intel.group.FGTravelAction;
import com.fs.starfarer.api.impl.campaign.intel.group.FGWaitAction;
import com.fs.starfarer.api.impl.campaign.intel.group.FleetGroupIntel;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.List;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class TestFleetGroupIntel
extends FleetGroupIntel {
    public static String PREPARE_ACTION = "prepare_action";
    public static String TRAVEL_ACTION = "travel_action";
    public static String RAID_ACTION = "raid_action";
    public static String RETURN_ACTION = "return_action";
    protected SectorEntityToken origin;
    protected FGRaidAction raidAction;

    public TestFleetGroupIntel() {
        MarketAPI garnir = Global.getSector().getEconomy().getMarket("corvus_IIIa");
        MarketAPI jangala = Global.getSector().getEconomy().getMarket("jangala");
        MarketAPI gilead = Global.getSector().getEconomy().getMarket("gilead");
        MarketAPI asher = Global.getSector().getEconomy().getMarket("asher");
        this.setFaction("pirates");
        this.addAction(new FGWaitAction(garnir.getPrimaryEntity(), 1.0f, "preparing for raid"), PREPARE_ACTION);
        this.addAction(new FGTravelAction(garnir.getPrimaryEntity(), gilead.getPrimaryEntity().getStarSystem().getCenter()), TRAVEL_ACTION);
        FGRaidAction.FGRaidParams params = new FGRaidAction.FGRaidParams();
        params.where = gilead.getPrimaryEntity().getStarSystem();
        params.allowedTargets.add(gilead);
        params.allowedTargets.add(asher);
        params.setDisrupt("farming", "megaport");
        this.raidAction = new FGRaidAction(params, 3.0f);
        this.addAction(this.raidAction, RAID_ACTION);
        this.addAction(new FGTravelAction(gilead.getPrimaryEntity().getStarSystem().getCenter(), garnir.getPrimaryEntity().getStarSystem().getCenter()), RETURN_ACTION);
        this.origin = garnir.getPrimaryEntity();
        this.createRoute("pirates", 30, 7, null);
    }

    protected void spawnFleets() {
        MarketAPI garnir = Global.getSector().getEconomy().getMarket("corvus_IIIa");
        Vector2f loc = garnir.getLocationInHyperspace();
        Float damage = null;
        if (this.route != null && this.route.getExtra() != null) {
            damage = this.route.getExtra().damage;
        }
        if (damage == null) {
            damage = Float.valueOf(0.0f);
        }
        String factionId = "luddic_church";
        factionId = "pirates";
        WeightedRandomPicker<Integer> picker = new WeightedRandomPicker<Integer>(this.getRandom());
        picker.add(3);
        picker.add(4);
        picker.add(6);
        picker.add(7);
        picker.add(9);
        picker.add(10);
        picker.add(10);
        float total = 0.0f;
        for (Integer i : picker.getItems()) {
            total += (float)i.intValue();
        }
        float spawnsToSkip = total * damage.floatValue() * 0.5f;
        float skipped = 0.0f;
        while (!picker.isEmpty()) {
            Integer size = (Integer)picker.pickAndRemove();
            if (skipped < spawnsToSkip && this.getRandom().nextFloat() < damage.floatValue()) {
                skipped += (float)size.intValue();
                continue;
            }
            FleetCreatorMission m = new FleetCreatorMission(new Random());
            m.beginFleet();
            m.createQualityFleet(size, factionId, loc);
            m.setFleetSource(garnir);
            m.setFleetDamageTaken(damage.floatValue());
            m.triggerSetPirateFleet();
            m.triggerMakeNoRepImpact();
            CampaignFleetAPI fleet = m.createFleet();
            if (fleet == null || this.route == null) continue;
            TestFleetGroupIntel.setLocationAndCoordinates(fleet, this.route.getCurrent());
            this.fleets.add(fleet);
        }
    }

    protected void addNonUpdateBulletPoints(TooltipMakerAPI info, Color tc, Object param, IntelInfoPlugin.ListInfoMode mode, float initPad) {
        Color h = Misc.getHighlightColor();
        FGAction curr = this.getCurrentAction();
        StarSystemAPI system = this.raidAction.getParams().where;
        float untilDeparture = this.getETAUntil(TRAVEL_ACTION);
        float untilRaid = this.getETAUntil(RAID_ACTION);
        float untilReturn = this.getETAUntil(RETURN_ACTION, true);
        if (mode == IntelInfoPlugin.ListInfoMode.MESSAGES) {
            info.addPara("Targeting the " + system.getNameWithLowercaseTypeShort(), tc, initPad);
            initPad = 0.0f;
        }
        if (untilDeparture > 0.0f) {
            this.addETABulletPoints(null, null, false, untilDeparture, FleetGroupIntel.ETAType.DEPARTURE, info, tc, initPad);
        }
        if (untilRaid > 0.0f && this.getSource().getContainingLocation() != system) {
            this.addETABulletPoints(system.getNameWithLowercaseTypeShort(), null, false, untilRaid, FleetGroupIntel.ETAType.ARRIVING, info, tc, initPad);
            initPad = 0.0f;
        }
        if (untilReturn > 0.0f && this.isSucceeded() && this.getSource().getContainingLocation() != system) {
            StarSystemAPI from = this.getSource().getStarSystem();
            this.addETABulletPoints(from.getNameWithLowercaseTypeShort(), null, false, untilReturn, FleetGroupIntel.ETAType.RETURNING, info, tc, initPad);
            initPad = 0.0f;
        }
        if (mode == IntelInfoPlugin.ListInfoMode.INTEL && curr != null && curr.getId().equals(RAID_ACTION)) {
            info.addPara("Operating in the " + system.getNameWithLowercaseTypeShort(), tc, initPad);
            initPad = 0.0f;
        }
        if (mode != IntelInfoPlugin.ListInfoMode.IN_DESC && this.isEnding() && !this.isSucceeded()) {
            info.addPara("The raiding forces have been defeated and scatter", tc, initPad);
        }
    }

    protected void addUpdateBulletPoints(TooltipMakerAPI info, Color tc, Object param, IntelInfoPlugin.ListInfoMode mode, float initPad) {
        StarSystemAPI system = this.raidAction.getParams().where;
        if (ABORT_UPDATE.equals(param)) {
            info.addPara("The raiding forces have been defeated and scatter", tc, initPad);
        } else if (PREPARE_ACTION.equals(param)) {
            float untilRaid = this.getETAUntil(RAID_ACTION);
            this.addETABulletPoints(system.getNameWithLowercaseTypeShort(), null, true, untilRaid, FleetGroupIntel.ETAType.ARRIVING, info, tc, initPad);
        } else if (TRAVEL_ACTION.equals(param)) {
            this.addArrivedBulletPoint(system.getNameWithLowercaseTypeShort(), null, info, tc, initPad);
        } else if (RAID_ACTION.equals(param)) {
            if (this.isSucceeded()) {
                info.addPara("The raiding forces are withdrawing", tc, initPad);
            } else {
                info.addPara("The raiding forces have been defeated and scatter", tc, initPad);
            }
        }
    }

    protected boolean shouldSendIntelUpdateWhenActionFinished(FGAction action) {
        if (RETURN_ACTION.equals(action.getId())) {
            return false;
        }
        if (RAID_ACTION.equals(action.getId())) {
            return this.isSucceeded();
        }
        if (TRAVEL_ACTION.equals(action.getId())) {
            return this.getSource().getContainingLocation() != this.raidAction.getParams().where;
        }
        return super.shouldSendIntelUpdateWhenActionFinished(action);
    }

    protected void addBasicDescription(TooltipMakerAPI info, float width, float height, float opad) {
        info.addImage(this.getFaction().getLogo(), width, 128.0f, opad);
        StarSystemAPI system = this.raidAction.getParams().where;
        info.addPara(String.valueOf(Misc.ucFirst(this.faction.getPersonNamePrefixAOrAn())) + " %s raid against " + "the " + system.getNameWithLowercaseTypeShort() + ".", opad, this.faction.getBaseUIColor(), this.faction.getEntityNamePrefix());
    }

    protected void addAssessmentSection(TooltipMakerAPI info, float width, float height, float opad) {
        Color h = Misc.getHighlightColor();
        FactionAPI faction = this.getFaction();
        List<MarketAPI> targets = this.raidAction.getParams().allowedTargets;
        if (!this.isEnding() && !this.isSucceeded()) {
            info.addSectionHeading("Assessment", faction.getBaseUIColor(), faction.getDarkUIColor(), Alignment.MID, opad);
            if (targets.isEmpty()) {
                info.addPara("There are no colonies for the raid to target in the system.", opad);
            } else {
                StarSystemAPI system = this.raidAction.getParams().where;
                boolean potentialDanger = this.addStrengthDesc(info, opad, system, "raiding forces", "the raid is unlikely to find success", "the raid's outcome is uncertain", "the raid is likely to find success");
                if (potentialDanger) {
                    this.showMarketsInDanger(info, opad, width, system, targets, "should be safe from the raid", "are at risk of being raided and losing stability:", "losing stability");
                }
            }
        }
    }

    protected void addStatusSection(TooltipMakerAPI info, float width, float height, float opad) {
        boolean showStatus;
        FGAction curr = this.getCurrentAction();
        boolean bl = showStatus = curr != null || this.isEnding() || this.isSucceeded();
        if (showStatus) {
            info.addSectionHeading("Status", this.faction.getBaseUIColor(), this.faction.getDarkUIColor(), Alignment.MID, opad);
            if (this.isEnding() && !this.isSucceeded()) {
                info.addPara("The raiding forces have been defeated and any remaining ships are retreating in disarray.", opad);
            } else if (this.isEnding() || this.isSucceeded()) {
                info.addPara("The raid was successful and the raiding forces are withdrawing.", opad);
            } else if (curr != null) {
                StarSystemAPI to = this.raidAction.getParams().where;
                if (PREPARE_ACTION.equals(curr.getId())) {
                    BaseHubMission.addStandardMarketDesc("Making preparations in orbit around", this.getSource().getMarket(), info, opad);
                } else if (TRAVEL_ACTION.equals(curr.getId())) {
                    info.addPara("Traveling from " + this.getSource().getMarket().getName() + " to the " + to.getNameWithLowercaseTypeShort() + ".", opad);
                } else if (RAID_ACTION.equals(curr.getId())) {
                    info.addPara("Conducting operations in the " + to.getNameWithLowercaseTypeShort() + ".", opad);
                }
            }
        }
    }

    public String getBaseName() {
        return String.valueOf(Misc.ucFirst(this.getFaction().getPersonNamePrefix())) + " Raid";
    }

    public boolean isSucceeded() {
        return this.raidAction.getSuccessFraction() > 0.0f && this.raidAction.isActionFinished();
    }

    protected SectorEntityToken getSource() {
        return this.origin;
    }

    protected SectorEntityToken getDestination() {
        return this.raidAction.getParams().where.getHyperspaceAnchor();
    }

    protected boolean isPlayerTargeted() {
        return true;
    }
}

