/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.inspection;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.ai.CampaignFleetAIAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.MilitaryResponseScript;
import com.fs.starfarer.api.impl.campaign.command.WarSimScript;
import com.fs.starfarer.api.impl.campaign.econ.impl.OrbitalStation;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.intel.inspection.HegemonyInspectionIntel;
import com.fs.starfarer.api.impl.campaign.intel.raid.ActionStage;
import com.fs.starfarer.api.impl.campaign.intel.raid.RaidIntel;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseAssignmentAI;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HIActionStage
extends ActionStage
implements BaseAssignmentAI.FleetActionDelegate {
    public static float REP_PENALTY_HID_STUFF = -0.2f;
    public static float REP_PENALTY_NORMAL = -0.1f;
    protected MarketAPI target;
    protected boolean playerTargeted = false;
    protected List<MilitaryResponseScript> scripts = new ArrayList<MilitaryResponseScript>();
    protected boolean gaveOrders = true;
    protected float untilAutoresolve = 0.0f;
    protected List<String> coresRemoved = new ArrayList<String>();

    public HIActionStage(HegemonyInspectionIntel raid, MarketAPI target) {
        super(raid);
        this.target = target;
        this.playerTargeted = target.isPlayerOwned();
        this.untilAutoresolve = 5.0f;
        HegemonyInspectionIntel intel = (HegemonyInspectionIntel)this.intel;
        if (intel.getOrders() == HegemonyInspectionIntel.AntiInspectionOrders.RESIST) {
            this.untilAutoresolve = 15.0f + 5.0f * (float)Math.random();
        }
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
        float days = Misc.getDays(amount);
        this.untilAutoresolve -= days;
        if (!this.gaveOrders) {
            this.gaveOrders = true;
            this.removeMilScripts();
            float duration = 100.0f;
            MilitaryResponseScript.MilitaryResponseParams params = new MilitaryResponseScript.MilitaryResponseParams(CampaignFleetAIAPI.ActionType.HOSTILE, "HI_" + this.target.getId(), this.intel.getFaction(), this.target.getPrimaryEntity(), 1.0f, duration);
            MilitaryResponseScript script = new MilitaryResponseScript(params);
            this.target.getContainingLocation().addScript(script);
            this.scripts.add(script);
            MilitaryResponseScript.MilitaryResponseParams defParams = new MilitaryResponseScript.MilitaryResponseParams(CampaignFleetAIAPI.ActionType.HOSTILE, "defHI_" + this.target.getId(), this.target.getFaction(), this.target.getPrimaryEntity(), 1.0f, duration);
            MilitaryResponseScript defScript = new MilitaryResponseScript(defParams);
            this.target.getContainingLocation().addScript(defScript);
            this.scripts.add(defScript);
        }
    }

    protected void removeMilScripts() {
        if (this.scripts != null) {
            for (MilitaryResponseScript s : this.scripts) {
                s.forceDone();
            }
        }
    }

    @Override
    protected void updateStatus() {
        this.abortIfNeededBasedOnFP(true);
        if (this.status != RaidIntel.RaidStageStatus.ONGOING) {
            return;
        }
        boolean inSpawnRange = RouteManager.isPlayerInSpawnRange(this.target.getPrimaryEntity());
        if (!inSpawnRange && this.untilAutoresolve <= 0.0f) {
            this.autoresolve();
            return;
        }
        if (!this.target.isInEconomy() || !this.target.isPlayerOwned()) {
            this.status = RaidIntel.RaidStageStatus.FAILURE;
            this.removeMilScripts();
            this.giveReturnOrdersToStragglers(this.getRoutes());
            return;
        }
    }

    @Override
    public String getRaidActionText(CampaignFleetAPI fleet, MarketAPI market) {
        return "\u6b63\u5728\u89c6\u5bdf " + market.getName();
    }

    @Override
    public String getRaidApproachText(CampaignFleetAPI fleet, MarketAPI market) {
        return "\u6b63\u5728\u524d\u5f80\u5e76\u89c6\u5bdf " + market.getName();
    }

    @Override
    public void performRaid(CampaignFleetAPI fleet, MarketAPI market) {
        this.removeMilScripts();
        if (market == null) {
            market = this.target;
        }
        HegemonyInspectionIntel intel = (HegemonyInspectionIntel)this.intel;
        this.status = RaidIntel.RaidStageStatus.SUCCESS;
        boolean hostile = market.getFaction().isHostileTo(intel.getFaction());
        HegemonyInspectionIntel.AntiInspectionOrders orders = intel.getOrders();
        if (hostile || orders == HegemonyInspectionIntel.AntiInspectionOrders.RESIST) {
            float str = intel.getAssembleStage().getOrigSpawnFP() * 3.0f;
            if (fleet != null) {
                str = MarketCMD.getRaidStr(fleet);
            }
            float re = MarketCMD.getRaidEffectiveness(market, str);
            MarketCMD.applyRaidStabiltyPenalty(market, String.valueOf(Misc.ucFirst(intel.getFaction().getPersonNamePrefix())) + " \u89c6\u5bdf\u56e2", re);
            Misc.setFlagWithReason(market.getMemoryWithoutUpdate(), "$recentlyRaided", intel.getFaction().getId(), true, 30.0f);
            Misc.setRaidedTimestamp(market);
            this.removeCoresAndApplyResult(fleet);
        } else if (orders == HegemonyInspectionIntel.AntiInspectionOrders.BRIBE) {
            intel.setOutcome(HegemonyInspectionIntel.HegemonyInspectionOutcome.BRIBED);
        } else if (orders == HegemonyInspectionIntel.AntiInspectionOrders.COMPLY) {
            this.removeCoresAndApplyResult(fleet);
        }
        if (intel.getOutcome() != null) {
            if (this.status == RaidIntel.RaidStageStatus.SUCCESS) {
                intel.sendOutcomeUpdate();
            } else {
                this.removeMilScripts();
                this.giveReturnOrdersToStragglers(this.getRoutes());
            }
        }
    }

    protected void removeCoresAndApplyResult(CampaignFleetAPI fleet) {
        CommoditySpecAPI spec;
        HegemonyInspectionIntel intel = (HegemonyInspectionIntel)this.intel;
        HegemonyInspectionIntel.AntiInspectionOrders orders = intel.getOrders();
        boolean resist = orders == HegemonyInspectionIntel.AntiInspectionOrders.RESIST;
        List<String> found = this.removeCores(fleet, resist);
        if (this.coresRemoved == null) {
            this.coresRemoved = new ArrayList<String>();
        }
        this.coresRemoved.clear();
        this.coresRemoved.addAll(found);
        List<String> expected = intel.getExpectedCores();
        int valFound = 0;
        int valExpected = 0;
        for (String id : found) {
            spec = Global.getSettings().getCommoditySpec(id);
            valFound = (int)((float)valFound + spec.getBasePrice());
            if (fleet == null) continue;
            fleet.getCargo().addCommodity(id, 1.0f);
        }
        for (String id : expected) {
            spec = Global.getSettings().getCommoditySpec(id);
            valExpected = (int)((float)valExpected + spec.getBasePrice());
        }
        if (valExpected < 30000) {
            valExpected = 30000;
        }
        if (!resist && (float)valExpected > (float)valFound * 1.25f) {
            intel.setOutcome(HegemonyInspectionIntel.HegemonyInspectionOutcome.FOUND_EVIDENCE_NO_CORES);
            for (Industry curr : this.target.getIndustries()) {
                curr.setDisrupted(intel.getRandom().nextFloat() * 45.0f + 15.0f);
            }
            intel.applyRepPenalty(REP_PENALTY_HID_STUFF);
        } else {
            intel.setOutcome(HegemonyInspectionIntel.HegemonyInspectionOutcome.CONFISCATE_CORES);
            intel.applyRepPenalty(REP_PENALTY_NORMAL);
        }
    }

    public List<String> getCoresRemoved() {
        return this.coresRemoved;
    }

    protected List<String> removeCores(CampaignFleetAPI inspector, boolean resist) {
        float qty;
        HegemonyInspectionIntel intel = (HegemonyInspectionIntel)this.intel;
        float str = intel.getRaidFPAdjusted() / intel.getNumFleets() * Misc.FP_TO_GROUND_RAID_STR_APPROX_MULT;
        if (inspector != null) {
            str = MarketCMD.getRaidStr(inspector);
        }
        float re = MarketCMD.getRaidEffectiveness(this.target, str);
        ArrayList<String> result = new ArrayList<String>();
        for (Industry curr : this.target.getIndustries()) {
            String id = curr.getAICoreId();
            if (id == null || resist && intel.getRandom().nextFloat() > re) continue;
            result.add(id);
            curr.setAICoreId(null);
        }
        PersonAPI admin = this.target.getAdmin();
        if (admin.isAICore() && (!resist || intel.getRandom().nextFloat() < re)) {
            result.add(admin.getAICoreId());
            this.target.setAdmin(null);
        }
        this.target.reapplyIndustries();
        ArrayList<String> missing = new ArrayList<String>(intel.getExpectedCores());
        for (String id : result) {
            missing.remove(id);
        }
        CargoAPI cargo = Misc.getStorageCargo(this.target);
        if (cargo != null) {
            for (String id : new ArrayList<String>(missing)) {
                qty = cargo.getCommodityQuantity(id);
                if (!(qty >= 1.0f) || resist && intel.getRandom().nextFloat() > re) continue;
                cargo.removeCommodity(id, 1.0f);
                missing.remove(id);
                result.add(id);
            }
        }
        if ((cargo = Misc.getLocalResourcesCargo(this.target)) != null) {
            for (String id : new ArrayList<String>(missing)) {
                qty = cargo.getCommodityQuantity(id);
                if (!(qty >= 1.0f) || resist && intel.getRandom().nextFloat() > re) continue;
                cargo.removeCommodity(id, 1.0f);
                missing.remove(id);
                result.add(id);
            }
        }
        return result;
    }

    protected void autoresolve() {
        Industry station;
        float str = WarSimScript.getFactionStrength(this.intel.getFaction(), this.target.getStarSystem());
        float enemyStr = WarSimScript.getEnemyStrength(this.intel.getFaction(), this.target.getStarSystem(), true);
        boolean hostile = this.target.getFaction().isHostileTo(this.intel.getFaction());
        float defensiveStr = enemyStr + WarSimScript.getStationStrength(this.target.getFaction(), this.target.getStarSystem(), this.target.getPrimaryEntity());
        if (hostile && defensiveStr >= str) {
            this.status = RaidIntel.RaidStageStatus.FAILURE;
            this.removeMilScripts();
            this.giveReturnOrdersToStragglers(this.getRoutes());
            return;
        }
        if (hostile && (station = Misc.getStationIndustry(this.target)) != null) {
            OrbitalStation.disrupt(station);
        }
        this.performRaid(null, this.target);
    }

    @Override
    protected void updateRoutes() {
        this.resetRoutes();
        boolean hostile = this.target.getFaction().isHostileTo(this.intel.getFaction());
        HegemonyInspectionIntel.AntiInspectionOrders orders = ((HegemonyInspectionIntel)this.intel).getOrders();
        if (!hostile && orders == HegemonyInspectionIntel.AntiInspectionOrders.RESIST) {
            ((HegemonyInspectionIntel)this.intel).makeHostileAndSendUpdate();
        } else {
            ((HegemonyInspectionIntel)this.intel).sendInSystemUpdate();
        }
        this.gaveOrders = false;
        ((HegemonyInspectionIntel)this.intel).setEnteredSystem(true);
        List<RouteManager.RouteData> routes = RouteManager.getInstance().getRoutesForSource(this.intel.getRouteSourceId());
        for (RouteManager.RouteData route : routes) {
            if (this.target.getStarSystem() != null) {
                route.addSegment(new RouteManager.RouteSegment(Math.min(5.0f, this.untilAutoresolve), this.target.getStarSystem().getCenter()));
            }
            route.addSegment(new RouteManager.RouteSegment(1000.0f, this.target.getPrimaryEntity()));
        }
    }

    @Override
    public void showStageInfo(TooltipMakerAPI info) {
        boolean resist;
        int curr = this.intel.getCurrentStage();
        int index = this.intel.getStageIndex(this);
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        HegemonyInspectionIntel intel = (HegemonyInspectionIntel)this.intel;
        HegemonyInspectionIntel.AntiInspectionOrders orders = intel.getOrders();
        boolean bl = resist = orders == HegemonyInspectionIntel.AntiInspectionOrders.RESIST;
        if (this.status == RaidIntel.RaidStageStatus.FAILURE) {
            if (intel.getOutcome() == HegemonyInspectionIntel.HegemonyInspectionOutcome.COLONY_NO_LONGER_EXISTS) {
                info.addPara("\u89c6\u5bdf\u5de5\u4f5c\u5df2\u7ecf\u53d6\u6d88\u3002", opad);
            } else {
                info.addPara("\u56e0\u89c6\u5bdf\u56e2\u88ab " + this.target.getName() + " \u7684\u9632\u5fa1\u8230\u961f\u6240\u51fb\u8d25\u3002\u800c\u4e2d\u6b62\u4efb\u52a1\u3002", opad);
            }
        } else if (this.status == RaidIntel.RaidStageStatus.SUCCESS) {
            CargoAPI cores = Global.getFactory().createCargo(true);
            for (String id : this.coresRemoved) {
                cores.addCommodity(id, 1.0f);
            }
            cores.sort();
            switch (intel.getOutcome()) {
                case BRIBED: {
                    info.addPara("\u4f60\u6240\u7f34\u7eb3\u7684 \"\u7f5a\u6b3e\" \u5df2\u88ab\u7528\u4e8e\u89e3\u51b3\u8fd9\u6b21\u89c6\u5bdf\u5de5\u4f5c\u6240\u53d1\u73b0\u7684\u95ee\u9898\uff0c\u4e14\u53cc\u65b9\u5747\u5bf9\u8be5\u7ed3\u679c\u8868\u793a\u6ee1\u610f\u3002", opad);
                    break;
                }
                case CONFISCATE_CORES: {
                    if (!cores.isEmpty()) {
                        info.addPara("\u89c6\u5bdf\u4eba\u5458\u6ca1\u6536\u4e86\u4ee5\u4e0b AI \u6838\u5fc3\uff1a", opad);
                        info.showCargo(cores, 10, true, opad);
                        break;
                    }
                    if (resist) {
                        info.addPara("\u89c6\u5bdf\u4eba\u5458\u672a\u80fd\u6ca1\u6536 AI \u6838\u5fc3\u3002", opad);
                        break;
                    }
                    info.addPara("\u89c6\u5bdf\u4eba\u5458\u6ca1\u6709\u53d1\u73b0\u4efb\u4f55 AI \u6838\u5fc3\u3002", opad);
                    break;
                }
                case FOUND_EVIDENCE_NO_CORES: {
                    if (!cores.isEmpty()) {
                        info.addPara("\u89c6\u5bdf\u4eba\u5458\u6ca1\u6536\u4e86\u4ee5\u4e0b AI \u6838\u5fc3\uff1a", opad);
                        info.showCargo(cores, 10, true, opad);
                    } else {
                        info.addPara("\u89c6\u5bdf\u4eba\u5458\u6ca1\u6709\u53d1\u73b0\u4efb\u4f55 AI \u6838\u5fc3\u3002", opad);
                    }
                    info.addPara("\u5df2\u7ecf\u6709\u5145\u8db3\u7684\u8bc1\u636e\u8868\u660e \u8be5\u6b96\u6c11\u5730\u5b58\u5728\u7740\u975e\u6cd5\u4f7f\u7528 AI \u6838\u5fc3\u7684\u7f6a\u8bc1\uff0c\u8fd9\u4e0d\u4ec5\u4f1a\u4fc3\u4f7f\u89c6\u5bdf\u4eba\u5458 \u5728\u5bfb\u627e\u5b83\u4eec\u7684\u8fc7\u7a0b\u4e2d \u8868\u73b0\u51fa\u6781\u5927\u7684\u70ed\u60c5\u3002\u4e5f\u4f1a\u5bfc\u81f4\u5f53\u5730\u8bbe\u65bd\u7684 \u8fd0\u4f5c\u906d\u5230\u4e25\u91cd\u5e72\u6270\u3002", opad);
                }
            }
        } else if (curr == index) {
            info.addPara("\u76ee\u524d\u6b63\u5728\u5bf9 " + this.target.getName() + " \u8fdb\u884c\u89c6\u5bdf\u3002", opad);
        }
    }

    @Override
    public boolean canRaid(CampaignFleetAPI fleet, MarketAPI market) {
        HegemonyInspectionIntel intel = (HegemonyInspectionIntel)this.intel;
        if (intel.getOutcome() != null) {
            return false;
        }
        return market == this.target;
    }

    @Override
    public String getRaidPrepText(CampaignFleetAPI fleet, SectorEntityToken from) {
        return "\u6b63\u73af\u7ed5\u4e8e " + from.getName();
    }

    @Override
    public String getRaidInSystemText(CampaignFleetAPI fleet) {
        return "\u884c\u52a8\u4e2d";
    }

    @Override
    public String getRaidDefaultText(CampaignFleetAPI fleet) {
        return "\u884c\u52a8\u4e2d";
    }

    @Override
    public boolean isPlayerTargeted() {
        return this.playerTargeted;
    }
}

