/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.inspection;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.VisualPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.impl.campaign.ids.Sounds;
import com.fs.starfarer.api.impl.campaign.intel.events.HegemonyHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.inspection.HegemonyInspectionIntel;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.SetStoryOption;
import com.fs.starfarer.api.ui.IntelUIAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HIOrdersInteractionDialogPluginImpl
implements InteractionDialogPlugin {
    public static int BRIBE_MULT = 200000;
    public static int BRIBE_MAX = 500000;
    protected InteractionDialogAPI dialog;
    protected TextPanelAPI textPanel;
    protected OptionPanelAPI options;
    protected VisualPanelAPI visual;
    protected CampaignFleetAPI playerFleet;
    protected HegemonyInspectionIntel intel;
    protected IntelUIAPI ui;
    protected HegemonyInspectionIntel.AntiInspectionOrders beingConfirmed = null;

    public HIOrdersInteractionDialogPluginImpl(HegemonyInspectionIntel intel, IntelUIAPI ui) {
        this.intel = intel;
        this.ui = ui;
    }

    @Override
    public void init(InteractionDialogAPI dialog) {
        this.dialog = dialog;
        this.textPanel = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.visual = dialog.getVisualPanel();
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.visual.setVisualFade(0.25f, 0.25f);
        this.visual.showPlanetInfo(this.intel.getTarget().getPrimaryEntity());
        dialog.setOptionOnEscape("\u79bb\u5f00", (Object)OptionId.LEAVE);
        this.optionSelected(null, (Object)OptionId.INIT);
    }

    @Override
    public Map<String, MemoryAPI> getMemoryMap() {
        return null;
    }

    @Override
    public void backFromEngagement(EngagementResultAPI result) {
    }

    protected int computeBribeAmount() {
        int bribe = (int)(Math.pow(1.5, HegemonyHostileActivityFactor.getInspectionAttempts()) * (double)BRIBE_MULT);
        if (bribe > BRIBE_MAX) {
            bribe = BRIBE_MAX;
        }
        return bribe;
    }

    protected void printOptionDesc(HegemonyInspectionIntel.AntiInspectionOrders orders, boolean inConfirm) {
        switch (orders) {
            case BRIBE: {
                int bribe = this.computeBribeAmount();
                this.textPanel.addPara("\u5206\u914d\u9002\u5f53\u7684 \"\u6d3b\u52a8\u8d44\u91d1\", \u6765\u786e\u4fdd\u89c6\u5bdf\u5de5\u4f5c\u53d6\u5f97\u4ee4\u4eba\u6ee1\u610f\u7684\u7ed3\u679c\u3002");
                if (inConfirm) {
                    this.textPanel.addPara("\u4e00\u65e6\u4e0b\u8fbe\u4e86\u8be5\u547d\u4ee4\uff0c\u56e0\u8d44\u91d1\u4e0e\u4ee3\u7406\u4eba\u5747\u5df2\u5206\u914d\uff0c\u6240\u4ee5\u65e0\u6cd5\u64a4\u9500\u3002");
                    int credits = (int)this.playerFleet.getCargo().getCredits().get();
                    Color costColor = Misc.getHighlightColor();
                    if (bribe > credits) {
                        costColor = Misc.getNegativeHighlightColor();
                    }
                    this.textPanel.addPara("\u82b1\u8d39 %s \u5c31\u8db3\u4ee5\u5e94\u5bf9\u8fd9\u6b21\u7a81\u53d1\u4e8b\u4ef6\uff0c\u5e76\u4e14\u8fd8\u80fd\u786e\u4fdd\u4f60\u4e0e \u9738\u4e3b \u4e4b\u95f4\u7684\u5173\u7cfb\u4e0d\u4f1a\u53d7\u5230\u5f71\u54cd\u3002", costColor, Misc.getDGSCredits(bribe));
                    this.textPanel.addPara("\u4f60\u6709 %s \u53ef\u7528\u3002", Misc.getHighlightColor(), Misc.getDGSCredits(credits));
                    break;
                }
                this.textPanel.addPara("\u4f60\u5df2\u7ecf\u51c6\u5907\u4e86 %s, \u5e76\u51c6\u5907\u5b9e\u65bd\u8fd9\u4e00\u884c\u52a8\u3002", Misc.getHighlightColor(), Misc.getDGSCredits(bribe));
                break;
            }
            case COMPLY: {
                this.textPanel.addPara("\u5f53\u5730\u5b98\u65b9\u4f1a\u914d\u5408\u8fdb\u884c\u89c6\u5bdf\u3002\u8fd9\u4f1a\u5bfc\u81f4\u6240\u6709 AI \u6838\u5fc3 \u88ab\u53d1\u73b0\u5e76\u6536\u7f34\uff0c\u540c\u65f6\u6839\u636e\u6240\u53d1\u73b0\u7684 AI \u6838\u5fc3 \u6570\u91cf\u964d\u4f4e\u4f60\u548c \u9738\u4e3b \u7684\u5173\u7cfb\u3002");
                this.textPanel.addPara("\u5047\u5982\u5f53\u524d\u4f7f\u7528\u4e2d\u7684 AI\u6838\u5fc3 \u88ab\u79fb\u9664\u6216\u8005\u8f6c\u79fb\u5230\u5f53\u524d\u884c\u661f\u4e4b\u5916\uff0c\u90a3\u8fd9\u4e9b\u884c\u4e3a\u5fc5\u7136\u4f1a\u7559\u4e0b\u86db\u4e1d\u9a6c\u8ff9\u8ba9\u89c6\u5bdf\u56e2\u66f4\u52a0\u79ef\u6781\u8c03\u67e5\u3002");
                break;
            }
            case RESIST: {
                this.textPanel.addPara("\u5229\u7528\u6240\u6709\u9632\u5fa1\u8230\u961f\u4e0e\u5730\u9762\u9632\u5fa1\u6765\u62b5\u5236\u89c6\u5bdf\u56e2\u7684\u5de5\u4f5c\u3002");
                this.textPanel.addPara("\u5982\u679c\u89c6\u5bdf\u56e2\u5230\u8fbe\u5730\u9762\uff0c\u5730\u9762\u9632\u5fa1\u6218\u529b\u5c06\u51b3\u5b9a\u4ed6\u4eec\u662f\u5426\u80fd\u6210\u529f\u641c\u67e5\u5230 AI \u6838\u5fc3\u3002");
                this.textPanel.addPara("\u5f53\u89c6\u5bdf\u56e2\u5230\u8fbe\u76ee\u6807\u661f\u7cfb\u65f6\uff0c\u9738\u4e3b \u5c06\u5fc5\u5b9a\u610f\u8bc6\u5230\u8fd9\u4e00\u70b9\uff0c\u5e76\u8fc5\u901f\u4e88\u4ee5\u8fd8\u51fb\u3002");
            }
        }
    }

    protected void addChoiceOptions() {
        this.options.clearOptions();
        HegemonyInspectionIntel.AntiInspectionOrders curr = this.intel.getOrders();
        if (curr != HegemonyInspectionIntel.AntiInspectionOrders.BRIBE) {
            this.options.addOption("\u547d\u4ee4\u5730\u65b9\u5f53\u5c40\u914d\u5408\u89c6\u5bdf\u5de5\u4f5c", (Object)OptionId.COMPLY, null);
            this.options.addOption("\u5206\u914d\u8db3\u591f\u7684\u8d44\u91d1\u7528\u4ee5\u8d3f\u8d42\u672c\u6b21\u53c2\u4e0e\u89c6\u5bdf\u5de5\u4f5c\u7684\u9886\u5bfc\u4eec", (Object)OptionId.BRIBE, null);
            this.options.addOption("\u547d\u4ee4\u5730\u65b9\u5f53\u5c40\u62b5\u5236\u89c6\u5bdf\u5de5\u4f5c", (Object)OptionId.RESIST, null);
            this.dialog.setOptionColor((Object)OptionId.BRIBE, Misc.getStoryOptionColor());
        }
        this.options.addOption("\u79bb\u5f00", (Object)OptionId.LEAVE, null);
        this.options.setShortcut((Object)OptionId.LEAVE, 1, false, false, false, true);
        if (curr == HegemonyInspectionIntel.AntiInspectionOrders.COMPLY) {
            this.options.setEnabled((Object)OptionId.COMPLY, false);
        }
        if (curr == HegemonyInspectionIntel.AntiInspectionOrders.BRIBE) {
            this.options.setEnabled((Object)OptionId.BRIBE, false);
        }
        if (curr == HegemonyInspectionIntel.AntiInspectionOrders.RESIST) {
            this.options.setEnabled((Object)OptionId.RESIST, false);
        }
    }

    protected void addConfirmOptions() {
        if (this.beingConfirmed == null) {
            return;
        }
        this.options.clearOptions();
        this.printOptionDesc(this.beingConfirmed, true);
        this.options.addOption("\u786e\u8ba4\u6267\u884c", (Object)OptionId.CONFIRM, null);
        this.options.addOption("\u653e\u5f03", (Object)OptionId.CANCEL, null);
        this.options.setShortcut((Object)OptionId.CANCEL, 1, false, false, false, true);
        if (this.beingConfirmed == HegemonyInspectionIntel.AntiInspectionOrders.BRIBE) {
            int bribe = this.computeBribeAmount();
            if ((float)bribe > this.playerFleet.getCargo().getCredits().get()) {
                this.options.setEnabled((Object)OptionId.CONFIRM, false);
                this.options.setTooltip((Object)OptionId.CONFIRM, "\u6ca1\u6709\u8db3\u591f\u7684\u661f\u5e01\u3002");
            }
            SetStoryOption.set(this.dialog, 1, (Object)OptionId.CONFIRM, "bribeAICoreInspection", Sounds.STORY_POINT_SPEND_TECHNOLOGY, "\u901a\u8fc7\u8d3f\u8d42\u6765\u963b\u6b62 " + this.intel.getFaction().getDisplayName() + " AI \u5ba1\u67e5");
        }
    }

    @Override
    public void optionSelected(String text, Object optionData) {
        if (optionData == null) {
            return;
        }
        OptionId option = (OptionId)((Object)optionData);
        if (text != null) {
            this.dialog.addOptionSelectedText((Object)option);
        }
        switch (option) {
            case INIT: {
                this.printOptionDesc(this.intel.getOrders(), false);
                this.addChoiceOptions();
                break;
            }
            case COMPLY: {
                this.beingConfirmed = HegemonyInspectionIntel.AntiInspectionOrders.COMPLY;
                this.addConfirmOptions();
                break;
            }
            case BRIBE: {
                this.beingConfirmed = HegemonyInspectionIntel.AntiInspectionOrders.BRIBE;
                this.addConfirmOptions();
                break;
            }
            case RESIST: {
                this.beingConfirmed = HegemonyInspectionIntel.AntiInspectionOrders.RESIST;
                this.addConfirmOptions();
                break;
            }
            case CONFIRM: {
                int invested = this.intel.getInvestedCredits();
                if (invested > 0) {
                    AddRemoveCommodity.addCreditsGainText(invested, this.textPanel);
                    this.playerFleet.getCargo().getCredits().add(invested);
                    this.intel.setInvestedCredits(0);
                }
                this.intel.setOrders(this.beingConfirmed);
                if (this.beingConfirmed == HegemonyInspectionIntel.AntiInspectionOrders.BRIBE) {
                    int bribe = this.computeBribeAmount();
                    this.intel.setInvestedCredits(bribe);
                    AddRemoveCommodity.addCreditsLossText(bribe, this.textPanel);
                    this.playerFleet.getCargo().getCredits().subtract(bribe);
                }
                this.addChoiceOptions();
                break;
            }
            case CANCEL: {
                this.addChoiceOptions();
                break;
            }
            case LEAVE: {
                this.leave();
            }
        }
    }

    protected void leave() {
        this.dialog.dismiss();
        if (this.ui != null) {
            this.ui.updateUIForItem(this.intel);
        }
    }

    @Override
    public void optionMousedOver(String optionText, Object optionData) {
    }

    @Override
    public void advance(float amount) {
    }

    @Override
    public Object getContext() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum OptionId {
        INIT,
        COMPLY,
        BRIBE,
        RESIST,
        LEAVE,
        CONFIRM,
        CANCEL,
        HIDE;

    }
}

