/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.inspection;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.ReputationActionResponsePlugin;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.fleets.RouteLocationCalculator;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.intel.inspection.HIActionStage;
import com.fs.starfarer.api.impl.campaign.intel.inspection.HIAssembleStage;
import com.fs.starfarer.api.impl.campaign.intel.inspection.HIOrdersInteractionDialogPluginImpl;
import com.fs.starfarer.api.impl.campaign.intel.inspection.HIOrganizeStage;
import com.fs.starfarer.api.impl.campaign.intel.inspection.HIReturnStage;
import com.fs.starfarer.api.impl.campaign.intel.inspection.HITravelStage;
import com.fs.starfarer.api.impl.campaign.intel.raid.RaidAssignmentAI;
import com.fs.starfarer.api.impl.campaign.intel.raid.RaidIntel;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RouteFleetAssignmentAI;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.ButtonAPI;
import com.fs.starfarer.api.ui.IntelUIAPI;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HegemonyInspectionIntel
extends RaidIntel
implements RaidIntel.RaidDelegate {
    public static final String BUTTON_CHANGE_ORDERS = "BUTTON_CHANGE_ORDERS";
    public static final Object MADE_HOSTILE_UPDATE = new Object();
    public static final Object ENTERED_SYSTEM_UPDATE = new Object();
    public static final Object OUTCOME_UPDATE = new Object();
    protected HIActionStage action;
    protected AntiInspectionOrders orders = AntiInspectionOrders.COMPLY;
    protected int investedCredits = 0;
    protected MarketAPI target;
    protected FactionAPI targetFaction;
    protected MarketAPI from;
    protected List<String> expectedCores = new ArrayList<String>();
    protected boolean enteredSystem = false;
    protected HegemonyInspectionOutcome outcome;
    protected Random random = new Random();
    protected InspectionEndedListener listener;
    protected transient String targetOwner = null;
    protected transient ReputationActionResponsePlugin.ReputationAdjustmentResult repResult = null;

    public HegemonyInspectionIntel(MarketAPI from, MarketAPI target, float inspectionFP) {
        super(target.getStarSystem(), from.getFaction(), null);
        this.delegate = this;
        this.from = from;
        this.target = target;
        this.targetFaction = target.getFaction();
        for (Industry curr : target.getIndustries()) {
            String id = curr.getAICoreId();
            if (id == null) continue;
            this.expectedCores.add(id);
        }
        PersonAPI admin = target.getAdmin();
        if (admin.isAICore()) {
            this.expectedCores.add(admin.getAICoreId());
        }
        float orgDur = 20.0f + 10.0f * (float)Math.random();
        if (Global.getSettings().isDevMode()) {
            orgDur = 1.0f;
        }
        if (DebugFlags.HEGEMONY_INSPECTION_DEBUG || DebugFlags.FAST_RAIDS) {
            orgDur = 0.5f;
        }
        this.addStage(new HIOrganizeStage(this, from, orgDur));
        SectorEntityToken gather = from.getPrimaryEntity();
        JumpPointAPI raidJump = RouteLocationCalculator.findJumpPointToUse(this.getFactionForUIColors(), target.getPrimaryEntity());
        if (gather == null || raidJump == null) {
            this.endImmediately();
            return;
        }
        float successMult = 0.5f;
        HIAssembleStage assemble = new HIAssembleStage(this, gather);
        assemble.addSource(from);
        assemble.setSpawnFP(inspectionFP);
        assemble.setAbortFP(inspectionFP * successMult);
        this.addStage(assemble);
        HITravelStage travel = new HITravelStage(this, gather, raidJump, false);
        travel.setAbortFP(inspectionFP * successMult);
        this.addStage(travel);
        this.action = new HIActionStage(this, target);
        this.action.setAbortFP(inspectionFP * successMult);
        this.addStage(this.action);
        this.addStage(new HIReturnStage(this));
        this.setImportant(true);
        Global.getSector().getIntelManager().addIntel(this);
    }

    public InspectionEndedListener getListener() {
        return this.listener;
    }

    public void setListener(InspectionEndedListener listener) {
        this.listener = listener;
    }

    public Random getRandom() {
        return this.random;
    }

    public MarketAPI getTarget() {
        return this.target;
    }

    public MarketAPI getFrom() {
        return this.from;
    }

    @Override
    public RouteFleetAssignmentAI createAssignmentAI(CampaignFleetAPI \u652f\u8230\u961f, RouteManager.RouteData route) {
        RaidAssignmentAI raidAI = new RaidAssignmentAI(\u652f\u8230\u961f, route, this.action);
        return raidAI;
    }

    public AntiInspectionOrders getOrders() {
        return this.orders;
    }

    public void setOrders(AntiInspectionOrders orders) {
        this.orders = orders;
    }

    public List<String> getExpectedCores() {
        return this.expectedCores;
    }

    public int getInvestedCredits() {
        return this.investedCredits;
    }

    public void setInvestedCredits(int investedCredits) {
        this.investedCredits = investedCredits;
    }

    public boolean isEnteredSystem() {
        return this.enteredSystem;
    }

    public void setEnteredSystem(boolean enteredSystem) {
        this.enteredSystem = enteredSystem;
    }

    public HegemonyInspectionOutcome getOutcome() {
        return this.outcome;
    }

    public void setOutcome(HegemonyInspectionOutcome outcome) {
        this.outcome = outcome;
    }

    @Override
    protected void advanceImpl(float amount) {
        super.advanceImpl(amount);
        if (this.target != null && this.targetOwner == null) {
            this.targetOwner = this.target.getFactionId();
        }
        if (this.failStage < 0 && this.targetOwner != null && this.target != null && !this.targetOwner.equals(this.target.getFactionId())) {
            this.forceFail(false);
        }
    }

    public void makeHostileAndSendUpdate() {
        boolean hostile = this.getFaction().isHostileTo("player");
        if (!hostile) {
            this.repResult = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.MAKE_HOSTILE_AT_BEST, null, null, null, false, false), "hegemony");
            this.sendUpdateIfPlayerHasIntel(MADE_HOSTILE_UPDATE, false);
        }
    }

    public void sendInSystemUpdate() {
        this.sendUpdateIfPlayerHasIntel(ENTERED_SYSTEM_UPDATE, false);
    }

    public void applyRepPenalty(float delta) {
        CoreReputationPlugin.CustomRepImpact impact = new CoreReputationPlugin.CustomRepImpact();
        impact.delta = delta;
        this.repResult = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, null, false, false), this.getFaction().getId());
    }

    public void sendOutcomeUpdate() {
        this.sendUpdateIfPlayerHasIntel(OUTCOME_UPDATE, false);
    }

    @Override
    public String getName() {
        String base = "\u9738\u4e3b AI \u5ba1\u67e5";
        if (this.outcome == HegemonyInspectionOutcome.TASK_FORCE_DESTROYED || this.outcome == HegemonyInspectionOutcome.COLONY_NO_LONGER_EXISTS) {
            return String.valueOf(base) + " - \u5931\u8d25";
        }
        if (this.outcome != null) {
            return String.valueOf(base) + " - \u5b8c\u6210";
        }
        return base;
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean isUpdate = this.getListInfoParam() != null;
        boolean hostile = this.getFaction().isHostileTo("player");
        if (hostile) {
            this.orders = AntiInspectionOrders.RESIST;
        }
        if (this.getListInfoParam() == MADE_HOSTILE_UPDATE) {
            FactionAPI other = this.target.getFaction();
            info.addPara("\u76ee\u6807\uff1a%s", initPad, tc, other.getBaseUIColor(), this.target.getName());
            initPad = 0.0f;
            info.addPara(this.faction.getDisplayName() + " \u5728\u62b5\u8fbe\u76ee\u6807\u661f\u7cfb\u540e\u9047\u5230\u4e86\u963b\u529b", initPad, tc, this.faction.getBaseUIColor(), this.faction.getDisplayName());
            initPad = 0.0f;
            CoreReputationPlugin.addAdjustmentMessage(this.repResult.delta, this.faction, null, null, null, info, tc, isUpdate, initPad);
            return;
        }
        if (this.getListInfoParam() == ENTERED_SYSTEM_UPDATE) {
            FactionAPI other = this.target.getFaction();
            info.addPara("\u76ee\u6807\uff1a%s", initPad, tc, other.getBaseUIColor(), this.target.getName());
            initPad = 0.0f;
            info.addPara("\u5df2\u62b5\u8fbe\u76ee\u6807\u661f\u7cfb", tc, initPad);
            return;
        }
        if (this.getListInfoParam() == OUTCOME_UPDATE) {
            int num = this.getActionStage().getCoresRemoved().size();
            if (num > 0) {
                String \u6838\u5fc3 = "\u6838\u5fc3";
                if (num == 1) {
                    \u6838\u5fc3 = "\u6838\u5fc3";
                }
                info.addPara("%s \u4e2a AI " + \u6838\u5fc3 + "\u906d\u5230\u6ca1\u6536", initPad, tc, h, "" + num);
                initPad = 0.0f;
            }
            if (this.outcome == HegemonyInspectionOutcome.BRIBED) {
                info.addPara("\u672a\u53d1\u73b0 AI \u6838\u5fc3", initPad, tc, h, "" + num);
            } else if (this.outcome == HegemonyInspectionOutcome.FOUND_EVIDENCE_NO_CORES) {
                FactionAPI other = this.target.getFaction();
                info.addPara("\u8be5 %s \u906d\u5230\u762b\u75ea", initPad, tc, other.getBaseUIColor(), this.target.getName());
            }
            initPad = 0.0f;
            if (this.repResult != null) {
                CoreReputationPlugin.addAdjustmentMessage(this.repResult.delta, this.faction, null, null, null, info, tc, isUpdate, initPad);
            }
            return;
        }
        float eta = this.getETA();
        FactionAPI other = this.target.getFaction();
        info.addPara("\u76ee\u6807\uff1a%s", initPad, tc, other.getBaseUIColor(), this.target.getName());
        initPad = 0.0f;
        if (eta > 1.0f && this.outcome == null) {
            String days = HegemonyInspectionIntel.getDaysString(eta);
            info.addPara("\u9884\u8ba1 %s " + days + " \u540e\u5230\u8fbe", initPad, tc, h, "" + Math.round(eta));
            initPad = 0.0f;
            if (hostile || this.orders == AntiInspectionOrders.RESIST) {
                info.addPara("\u5b88\u519b\u5c06\u62b5\u5236\u89c6\u5bdf\u5de5\u4f5c", tc, initPad);
            } else if (this.orders == AntiInspectionOrders.COMPLY) {
                info.addPara("\u5b88\u519b\u5c06\u9ed8\u8ba4\u914d\u5408\u89c6\u5bdf\u5de5\u4f5c", tc, initPad);
            } else if (this.orders == AntiInspectionOrders.BRIBE) {
                info.addPara("\u7528\u8d3f\u8d42\u7684\u65b9\u5f0f\u6765\u89c4\u907f\u5ba1\u67e5", tc, initPad);
            }
        } else if (this.outcome == null && this.action.getElapsed() > 0.0f) {
            info.addPara("\u89c6\u5bdf\u5de5\u4f5c\u6b63\u5728\u8fdb\u884c", tc, initPad);
            initPad = 0.0f;
        } else if (this.outcome != null) {
            int num = this.getActionStage().getCoresRemoved().size();
            if (num > 0) {
                String \u6838\u5fc3 = "\u6838\u5fc3";
                if (num == 1) {
                    \u6838\u5fc3 = "\u6838\u5fc3";
                }
                info.addPara("%s \u4e2a AI " + \u6838\u5fc3 + "\u906d\u5230\u6ca1\u6536", initPad, tc, h, "" + num);
                initPad = 0.0f;
            }
        }
        this.unindent(info);
    }

    @Override
    public HIActionStage getActionStage() {
        for (RaidIntel.RaidStage stage : this.stages) {
            if (!(stage instanceof HIActionStage)) continue;
            return (HIActionStage)stage;
        }
        return null;
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        super.createIntelInfo(info, mode);
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        info.addImage(this.getFactionForUIColors().getLogo(), width, 128.0f, opad);
        FactionAPI faction = this.getFaction();
        String has = faction.getDisplayNameHasOrHave();
        String is = faction.getDisplayNameIsOrAre();
        String strDesc = this.getRaidStrDesc();
        int numFleets = (int)this.getOrigNumFleets();
        String \u652f\u8230\u961f = "\u652f\u8230\u961f";
        if (numFleets == 1) {
            \u652f\u8230\u961f = "\u652f\u8230\u961f";
        }
        LabelAPI label = info.addPara(String.valueOf(Misc.ucFirst(faction.getDisplayNameWithArticle())) + " " + is + "\u5f00\u5c55\u4e86\u9488\u5bf9 %s \u7684\u89c6\u5bdf\u5de5\u4f5c\uff0c\u56e0\u4e3a\u8be5\u6b96\u6c11\u5730\u88ab\u6000\u7591\u4f7f\u7528\u4e86 AI \u6838\u5fc3\u3002" + "\u8be5\u89c6\u5bdf\u56e2\u7684\u6218\u529b\u4e3a " + strDesc + ", \u4e14\u9884\u8ba1\u6709 " + numFleets + " " + \u652f\u8230\u961f + ".", opad, faction.getBaseUIColor(), this.target.getName());
        label.setHighlight(faction.getDisplayNameWithArticleWithoutArticle(), this.target.getName(), strDesc, "" + numFleets);
        label.setHighlightColors(faction.getBaseUIColor(), this.target.getFaction().getBaseUIColor(), h, h);
        if (this.outcome == null) {
            this.addStandardStrengthComparisons(info, this.target, this.targetFaction, true, false, "\u89c6\u5bdf\u56e2", "\u89c6\u5bdf\u56e2");
        }
        info.addSectionHeading("\u5f62\u52bf", faction.getBaseUIColor(), faction.getDarkUIColor(), Alignment.MID, opad);
        for (RaidIntel.RaidStage stage : this.stages) {
            stage.showStageInfo(info);
            if (this.getStageIndex(stage) == this.failStage) break;
        }
        if (this.outcome == null) {
            FactionAPI pf = Global.getSector().getPlayerFaction();
            info.addSectionHeading("\u5f53\u524d\u5e94\u5bf9\u63aa\u65bd", pf.getBaseUIColor(), pf.getDarkUIColor(), Alignment.MID, opad);
            boolean hostile = this.getFaction().isHostileTo("player");
            if (hostile) {
                label = info.addPara(String.valueOf(Misc.ucFirst(faction.getDisplayNameWithArticle())) + " " + is + "\u4e0e " + pf.getDisplayNameWithArticle() + "\u3002\u76ee\u524d\u6b63\u5904\u4e8e\u654c\u5bf9\u72b6\u6001\uff0c\u8fd9\u5c06\u5bfc\u81f4\u4f60\u7684\u8230\u961f\u4f1a\u8bd5\u56fe\u62b5\u5236\u89c6\u5bdf\u5de5\u4f5c\u3002", opad);
                label.setHighlight(faction.getDisplayNameWithArticleWithoutArticle(), pf.getDisplayNameWithArticleWithoutArticle());
                label.setHighlightColors(faction.getBaseUIColor(), pf.getBaseUIColor());
            } else {
                switch (this.orders) {
                    case COMPLY: {
                        info.addPara("\u8be5 " + this.target.getName() + " \u5f53\u5c40\u5c06\u9ed8\u8ba4\u914d\u5408\u89c6\u5bdf\u5de5\u4f5c\uff0c" + "\u8fd9\u5c06\u610f\u5473\u7740\u90a3\u4e9b\u6b63\u5728\u88ab\u4f7f\u7528\u7684 AI \u6838\u5fc3\u4e00\u5b9a\u4f1a\u88ab\u627e\u5230\u3002", opad);
                        break;
                    }
                    case BRIBE: {
                        info.addPara("\u4f60\u5df2\u7ecf\u62e8\u51fa\u8db3\u591f\u7684\u8d44\u91d1\uff0c\u4ee5\u786e\u4fdd\u672c\u6b21\u89c6\u5bdf\u80fd\u4ea7\u751f\u4ee4\u4eba\u6ee1\u610f\u7684\u7ed3\u679c\u3002", opad);
                        break;
                    }
                    case RESIST: {
                        info.addPara("\u4f60\u7684\u7a7a\u95f4\u4e0e\u5730\u9762\u90e8\u961f\u5c06\u8bd5\u56fe\u62b5\u6297\u68c0\u67e5\u3002", opad);
                    }
                }
                if (!this.enteredSystem) {
                    ButtonAPI button = info.addButton("\u53d8\u66f4\u5e94\u5bf9\u63aa\u65bd", BUTTON_CHANGE_ORDERS, pf.getBaseUIColor(), pf.getDarkUIColor(), (int)width, 20.0f, opad * 2.0f);
                    button.setShortcut(20, true);
                } else {
                    info.addPara("\u89c6\u5bdf\u56e2\u5df2\u7ecf\u62b5\u8fbe\u76ee\u6807\u661f\u7cfb\uff0c\u4f60\u5df2\u7ecf\u6ca1\u6709\u65f6\u95f4\u6267\u884c\u65b0\u7684\u63aa\u65bd\u4e86\u3002", opad);
                }
            }
        } else {
            this.bullet(info);
            if (this.repResult != null) {
                CoreReputationPlugin.addAdjustmentMessage(this.repResult.delta, faction, null, null, null, info, tc, false, opad);
            }
            this.unindent(info);
        }
    }

    @Override
    public void sendUpdateIfPlayerHasIntel(Object listInfoParam, boolean onlyIfImportant, boolean sendIfHidden) {
        if (listInfoParam == UPDATE_RETURNING) {
            return;
        }
        super.sendUpdateIfPlayerHasIntel(listInfoParam, onlyIfImportant, sendIfHidden);
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Military");
        tags.add("Colony threats");
        tags.add(this.getFaction().getId());
        return tags;
    }

    @Override
    public void notifyRaidEnded(RaidIntel raid, RaidIntel.RaidStageStatus status) {
        if (this.outcome == null && this.failStage >= 0) {
            this.outcome = !this.target.isInEconomy() || !this.target.isPlayerOwned() ? HegemonyInspectionOutcome.COLONY_NO_LONGER_EXISTS : HegemonyInspectionOutcome.TASK_FORCE_DESTROYED;
        }
        if (this.listener != null && this.outcome != null) {
            this.listener.notifyInspectionEnded(this.outcome);
        }
    }

    @Override
    public void buttonPressConfirmed(Object buttonId, IntelUIAPI ui) {
        if (buttonId == BUTTON_CHANGE_ORDERS) {
            ui.showDialog(null, new HIOrdersInteractionDialogPluginImpl(this, ui));
        }
    }

    @Override
    public String getIcon() {
        return Global.getSettings().getSpriteName("intel", "hegemony_inspection");
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        if (this.target != null && this.target.isInEconomy() && this.target.getPrimaryEntity() != null) {
            return this.target.getPrimaryEntity();
        }
        return super.getMapLocation(map);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AntiInspectionOrders {
        COMPLY,
        HIDE,
        BRIBE,
        RESIST;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HegemonyInspectionOutcome {
        COLONY_NO_LONGER_EXISTS,
        TASK_FORCE_DESTROYED,
        CONFISCATE_CORES,
        FOUND_EVIDENCE_NO_CORES,
        BRIBED;

    }

    public static interface InspectionEndedListener {
        public void notifyInspectionEnded(HegemonyInspectionOutcome var1);
    }
}

