/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.misc;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.impl.campaign.CargoPodsEntityPlugin;
import com.fs.starfarer.api.impl.campaign.intel.misc.FleetLogIntel;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CargoPodsIntel
extends FleetLogIntel {
    public static String PODS_UPDATE = "pods_update";
    protected SectorEntityToken pods;

    public CargoPodsIntel(SectorEntityToken pods) {
        this.pods = pods;
        this.setRemoveTrigger(pods);
    }

    public SectorEntityToken getPods() {
        return this.pods;
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        this.bullet(info);
        CargoPodsEntityPlugin plugin = (CargoPodsEntityPlugin)this.pods.getCustomPlugin();
        this.addDays(info, "\u540e\u98d8\u6563", plugin.getDaysLeft(), tc, initPad);
        this.unindent(info);
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float small = 3.0f;
        float opad = 10.0f;
        info.addPara("\u6f02\u6d6e\u4e8e\u4e0d\u7a33\u5b9a\u8f68\u9053\u4e0a\u7684\u4e00\u6279\u8d27\u7269\u540a\u8231\uff0c\u4e00\u65e6\u8f68\u9053\u5931\u53bb\u7a33\u5b9a\uff0c\u5b83\u4eec\u4e5f\u5c06\u968f\u4e4b\u6d88\u5931\u3002", opad);
        this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
        CargoAPI cargo = this.pods.getCargo();
        if (cargo != null && !cargo.getStacksCopy().isEmpty()) {
            info.addSectionHeading("\u8d27\u7269", Alignment.MID, opad);
            info.showCargo(cargo, 20, true, opad);
        }
    }

    @Override
    public String getIcon() {
        return Global.getSettings().getSpriteName("intel", "stabilized_pods");
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        return tags;
    }

    @Override
    public String getSortString() {
        return "\u7a33\u5b9a\u7684\u8d27\u7269\u540a\u8231";
    }

    @Override
    public String getName() {
        return "\u7a33\u5b9a\u7684\u8d27\u7269\u540a\u8231";
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return this.pods;
    }
}

