/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.misc;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CustomCampaignEntityPlugin;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.impl.campaign.CampaignObjective;
import com.fs.starfarer.api.impl.campaign.CommRelayEntityPlugin;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.ui.ButtonAPI;
import com.fs.starfarer.api.ui.IntelUIAPI;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommSnifferIntel
extends BaseIntelPlugin {
    public static final String UNINSTALL = "uninstall";
    protected SectorEntityToken relay;
    protected IntervalUtil check = new IntervalUtil(15.0f, 45.0f);
    protected Boolean uninstalled = null;

    public static CommSnifferIntel getExistingSnifferIntelForRelay(SectorEntityToken relay) {
        for (IntelInfoPlugin p : Global.getSector().getIntelManager().getIntel(CommSnifferIntel.class)) {
            CommSnifferIntel intel = (CommSnifferIntel)p;
            if (intel.getRelay() != relay) continue;
            return intel;
        }
        return null;
    }

    public CommSnifferIntel(SectorEntityToken relay) {
        this.relay = relay;
        Global.getSector().getIntelManager().addIntel(this, true);
        Global.getSector().addScript(this);
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
        Global.getSector().removeScript(this);
        CustomCampaignEntityPlugin plugin = this.relay.getCustomPlugin();
        if (plugin instanceof CampaignObjective) {
            CampaignObjective o = (CampaignObjective)((Object)plugin);
            o.setHacked(false);
        }
    }

    @Override
    protected void advanceImpl(float amount) {
        super.advanceImpl(amount);
        float days = Misc.getDays(amount);
        this.check.advance(days);
        if (this.check.intervalElapsed()) {
            float p = this.getCurrLoseProb();
            if ((float)Math.random() < p) {
                this.endAfterDelay();
                this.sendUpdateIfPlayerHasIntel(new Object(), false);
                return;
            }
        }
        if (!this.relay.isAlive() || !((CommRelayEntityPlugin)this.relay.getCustomPlugin()).isHacked().booleanValue()) {
            this.endAfterDelay();
            this.sendUpdateIfPlayerHasIntel(new Object(), false);
            return;
        }
    }

    public SectorEntityToken getRelay() {
        return this.relay;
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean isUpdate = this.getListInfoParam() != null;
        this.unindent(info);
    }

    protected float getMax() {
        return Global.getSettings().getInt("maxCommSniffersBeforeChanceToLose");
    }

    protected float getBaseLoseProb() {
        return Global.getSettings().getFloat("probToLoseSnifferPerMonthPerExtra");
    }

    protected float getCurrLoseProb() {
        float curr = 0.0f;
        for (IntelInfoPlugin p : Global.getSector().getIntelManager().getIntel(CommSnifferIntel.class)) {
            CommSnifferIntel intel = (CommSnifferIntel)p;
            if (intel.isEnding()) continue;
            curr += 1.0f;
        }
        float max = this.getMax();
        if (curr <= max) {
            return 0.0f;
        }
        float p = (curr - max) * this.getBaseLoseProb();
        if (p > 1.0f) {
            p = 1.0f;
        }
        return p;
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color c = this.getTitleColor(mode);
        info.addPara(this.getName(), c, 0.0f);
        this.addBulletPoints(info, mode);
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        info.addImage(Global.getSector().getPlayerFaction().getLogo(), width, 128.0f, opad);
        String name = this.relay.getName();
        if (name.equals(this.relay.getCustomEntitySpec().getDefaultName())) {
            name = name.toLowerCase();
        }
        if (this.isEnding()) {
            if (this.uninstalled != null) {
                info.addPara("\u4f60\u5df2\u7ecf\u5378\u8f7d\u4e86\u901a\u8baf\u55c5\u63a2\u5668 - " + name + ".", opad);
            } else {
                info.addPara("\u5b89\u88c5\u5728 " + name + " \u4e0a\u7684\u901a\u4fe1\u55c5\u63a2\u5668\u5c06\u4e0d\u518d\u54cd\u5e94\u67e5\u8be2\u529f\u80fd\u3002", opad);
            }
            this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
        } else {
            info.addPara("\u4f60\u5df2\u7ecf\u5b89\u88c5\u4e86\u4e00\u4e2a\u901a\u4fe1\u55c5\u63a2\u5668 - " + name + ".", opad);
            if (!this.relay.isInHyperspace()) {
                info.addPara("\u5b83\u5c06\u5b9e\u65f6\u4e3a\u4f60\u63d0\u4f9b\u4e0b\u5217\u661f\u7cfb\u7684\u6240\u6709\u8baf\u606f\uff1a" + this.relay.getContainingLocation().getNameWithLowercaseType() + ".", opad);
            }
            this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
            float p = this.getCurrLoseProb();
            String danger = null;
            Color dangerColor = null;
            if (!(p <= 0.0f)) {
                if (p <= 0.33f) {
                    danger = "\u4f4e";
                    dangerColor = Misc.getPositiveHighlightColor();
                } else if (p <= 0.67f) {
                    danger = "\u666e\u901a";
                    dangerColor = h;
                } else {
                    danger = "\u9ad8";
                    dangerColor = Misc.getNegativeHighlightColor();
                }
            }
            int num = 0;
            for (IntelInfoPlugin i : Global.getSector().getIntelManager().getIntel(CommSnifferIntel.class)) {
                CommSnifferIntel intel = (CommSnifferIntel)i;
                if (intel.isEnding()) continue;
                ++num;
            }
            String \u55c5\u63a2\u5668 = "\u55c5\u63a2\u5668";
            String any = "\u4e0e";
            if (num == 1) {
                \u55c5\u63a2\u5668 = "\u55c5\u63a2\u5668";
                any = "\u5b83";
            }
            if (danger == null) {
                info.addPara("\u4f60\u5728 %s \u4e2a\u901a\u8baf\u7f51\u7edc\u5185\u5b89\u88c5\u4e86 " + \u55c5\u63a2\u5668 + " \u3002" + "\u4f46\u5b83\u6ca1\u6709\u88ab\u53d1\u73b0\uff0c\u6240\u4ee5" + any + "\u4e0d\u5b58\u5728\u88ab\u79fb\u9664\u7684\u98ce\u9669\u3002", opad, h, "" + num);
            } else {
                LabelAPI label = info.addPara("\u4f60\u5728 %s \u4e2a\u901a\u8baf\u7f51\u7edc\u5185\u5b89\u88c5\u4e86 " + \u55c5\u63a2\u5668 + "\u3002\u800c\u5b83\u88ab" + "\u53d1\u73b0" + any + "\u79fb\u9664\u7684\u6982\u7387\u4e3a %s.", opad, h, "" + num, danger);
                label.setHighlight("" + num, danger);
                label.setHighlightColors(h, dangerColor);
            }
            ButtonAPI button = this.addGenericButton(info, width, "\u5378\u8f7d\u901a\u8baf\u55c5\u63a2\u5668", UNINSTALL);
            button.setShortcut(22, true);
        }
    }

    public void uninstall() {
        this.buttonPressConfirmed(UNINSTALL, null);
    }

    @Override
    public void buttonPressConfirmed(Object buttonId, IntelUIAPI ui) {
        if (buttonId == UNINSTALL) {
            this.endImmediately();
            this.uninstalled = true;
            if (ui != null) {
                ui.recreateIntelUI();
            }
        }
    }

    @Override
    public void createConfirmationPrompt(Object buttonId, TooltipMakerAPI prompt) {
        prompt.addPara("\u5378\u8f7d\u8be5\u901a\u4fe1\u55c5\u63a2\u5668\u5c06\u964d\u4f4e\u5176\u4ed6\u901a\u4fe1\u55c5\u63a2\u5668\u88ab\u53d1\u73b0\u7684\u673a\u4f1a\u3002", 0.0f);
    }

    @Override
    public boolean doesButtonHaveConfirmDialog(Object buttonId) {
        return true;
    }

    @Override
    public String getIcon() {
        return Global.getSettings().getSpriteName("intel", "comm_sniffer");
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Comm sniffers");
        return tags;
    }

    @Override
    public String getSortString() {
        return "\u901a\u8baf\u55c5\u63a2\u5668";
    }

    @Override
    public String getName() {
        String base = "\u901a\u8baf\u55c5\u63a2\u5668";
        if (this.isEnding()) {
            if (this.uninstalled != null) {
                return String.valueOf(base) + " - \u5df2\u5378\u8f7d";
            }
            return String.valueOf(base) + " - \u5df2\u5931\u53bb";
        }
        if (this.isNew()) {
            return String.valueOf(base) + " \u5df2\u5b89\u88c5";
        }
        return base;
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return super.getFactionForUIColors();
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return this.relay;
    }

    @Override
    public boolean shouldRemoveIntel() {
        return this.isEnded();
    }

    @Override
    public String getCommMessageSound() {
        return CommSnifferIntel.getSoundMinorMessage();
    }
}

