/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.misc;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.impl.campaign.intel.misc.BreadcrumbIntel;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class DistressCallIntel
extends BreadcrumbIntel {
    protected StarSystemAPI system;

    public DistressCallIntel(StarSystemAPI system) {
        super(null, system.getCenter());
        this.system = system;
        Global.getSector().addScript(this);
        this.setIcon(Global.getSettings().getSpriteName("intel", "distress_call"));
        this.setSound("ui_intel_distress_call");
        this.setDuration(60.0f);
        this.setTitle("\u6c42\u6551\u4fe1\u53f7");
        this.setText("\u4f60\u4ece " + system.getNameWithLowercaseType() + " " + "\u5185\u6536\u5230\u4e86\u4e00\u5219 \u6a21\u7cca\u4e0d\u6e05\u7684 \u6c42\u6551\u4fe1\u53f7\uff0c\u4f46\u8fd9\u5e76\u4e0d\u5947\u602a\uff0c" + "\u6bd5\u7adf\u4efb\u4f55\u4e00\u652f\u5e38\u89c4\u8230\u961f \u90fd\u4e0d\u4f1a\u643a\u5e26\u80fd\u5c06 \u5b8c\u6574\u6570\u636e\u5e7f\u64ad\u81f3 " + "\u8d85\u7a7a\u95f4\u7684\u5148\u8fdb\u8bbe\u5907\u3002");
    }

    public void advance(float amount) {
        super.advance(amount);
        if (this.system == Global.getSector().getCurrentLocation()) {
            this.endAfterDelay();
        }
    }

    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color c = this.getTitleColor(mode);
        info.addPara(this.getName(), c, 0.0f);
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        if (this.system != null) {
            this.bullet(info);
            info.addPara("\u6765\u6e90\u4e8e " + this.system.getNameWithLowercaseType(), tc, initPad);
            this.unindent(info);
        }
    }

    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        info.addPara(this.text, opad);
        float days = this.getDaysSincePlayerVisible();
        if (days >= 1.0f) {
            this.addDays(info, "\u524d\u3002", days, tc, opad);
        }
        if (this.isEnding()) {
            info.addPara("\u4f60\u5df2\u7ecf\u8c03\u67e5\u8fc7\u4e86\u8fd9\u5219\u6c42\u6551\u4fe1\u53f7\u7684\u6e90\u5934\u3002", opad);
        }
    }

    public String getSortString() {
        return "\u6c42\u6551\u4fe1\u53f7";
    }

    public String getName() {
        if (this.isEnding()) {
            return String.valueOf(this.title) + " - \u5df2\u8c03\u67e5";
        }
        return this.title;
    }

    public boolean shouldRemoveIntel() {
        if (this.isEnded()) {
            return true;
        }
        return super.shouldRemoveIntel();
    }
}

