/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.misc;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.entities.GateHaulerEntityPlugin;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseThemeGenerator;
import com.fs.starfarer.api.impl.campaign.rulecmd.missions.GateHaulerCMD;
import com.fs.starfarer.api.impl.campaign.terrain.DebrisFieldTerrainPlugin;
import com.fs.starfarer.api.loading.Description;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GateHaulerIntel
extends BaseIntelPlugin {
    public static float TRANSIT_DAYS_BASE = 100.0f;
    public static float TRANSIT_SPEED_LY_PER_CYCLE = 50.0f;
    public static Object UPDATE_WITNESSED_ARRIVAL = new Object();
    protected SectorEntityToken gateHauler;
    protected StarSystemAPI destination;
    protected float departureAngle;
    protected int transitDays;
    protected float elapsedDaysInAction;
    protected SectorEntityToken parkingOrbit;
    protected SectorEntityToken stableLocation;
    protected GateHaulerAction action = null;

    public static GateHaulerIntel get(SectorEntityToken gateHauler) {
        for (IntelInfoPlugin p : Global.getSector().getIntelManager().getIntel(GateHaulerIntel.class)) {
            GateHaulerIntel intel;
            if (!(p instanceof GateHaulerIntel) || (intel = (GateHaulerIntel)p).getGateHauler() != gateHauler) continue;
            return intel;
        }
        return null;
    }

    public GateHaulerIntel(SectorEntityToken gateHauler) {
        this.gateHauler = gateHauler;
        Global.getSector().addScript(this);
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
        Global.getSector().removeScript(this);
    }

    public void updateMemoryFlags() {
    }

    public void activate() {
    }

    public int computeTransitDays(StarSystemAPI destination) {
        if (destination == null) {
            return 0;
        }
        float dist = Misc.getDistanceLY(this.gateHauler, destination.getHyperspaceAnchor());
        float transitDays = TRANSIT_DAYS_BASE + dist / TRANSIT_SPEED_LY_PER_CYCLE * 365.0f;
        return Math.round(transitDays);
    }

    public void initiateDeployment(SectorEntityToken stableLocation) {
        if (stableLocation == null) {
            return;
        }
        this.setAction(GateHaulerAction.DEPLOYING);
        this.stableLocation = stableLocation;
        this.getPlugin().getMovement().moveToLocation(stableLocation.getLocation());
        this.getPlugin().getMovement().setFaceInOppositeDirection(false);
        this.getPlugin().getMovement().setTurnThenAccelerate(true);
        this.getPlugin().setLongBurn(false);
        this.gateHauler.getMemoryWithoutUpdate().set("$deploying", true);
        this.gateHauler.fadeOutIndicator();
        this.gateHauler.addTag("non_clickable");
        stableLocation.fadeOutIndicator();
        stableLocation.addTag("non_clickable");
        stableLocation.addTag("no_entity_tooltip");
    }

    public void initiateDeparture(StarSystemAPI destination) {
        if (destination == null || destination == this.gateHauler.getContainingLocation()) {
            return;
        }
        this.setAction(GateHaulerAction.OUTBOUND);
        if (this.parkingOrbit != null) {
            this.gateHauler.getContainingLocation().removeEntity(this.parkingOrbit);
            this.parkingOrbit = null;
        }
        this.transitDays = this.computeTransitDays(destination);
        this.destination = destination;
        this.departureAngle = Misc.getAngleInDegrees(this.gateHauler.getLocationInHyperspace(), destination.getLocation());
        this.gateHauler.fadeOutIndicator();
        this.getPlugin().getMovement().moveInDirection(this.departureAngle);
        this.getPlugin().getMovement().setFaceInOppositeDirection(false);
        this.getPlugin().getMovement().setTurnThenAccelerate(true);
        this.getPlugin().setLongBurn(true);
        this.gateHauler.getMemoryWithoutUpdate().set("$inTransit", true);
    }

    public void initiateArrival() {
        if (this.destination == null) {
            return;
        }
        this.setAction(GateHaulerAction.INBOUND);
        this.findParkingOrbit();
        float brakeTime = GateHaulerEntityPlugin.MAX_SPEED / GateHaulerEntityPlugin.ACCELERATION;
        float brakeDist = GateHaulerEntityPlugin.MAX_SPEED * 0.5f * brakeTime;
        Vector2f spawnLoc = Misc.getUnitVectorAtDegreeAngle(this.departureAngle + 180.0f);
        Vector2f spawnVel = new Vector2f((ReadableVector2f)spawnLoc);
        spawnVel.scale(GateHaulerEntityPlugin.MAX_SPEED);
        spawnVel.negate();
        spawnLoc.scale(brakeDist * 1.0f + 4000.0f);
        Vector2f.add((Vector2f)spawnLoc, (Vector2f)this.parkingOrbit.getLocation(), (Vector2f)spawnLoc);
        this.gateHauler.setExpired(false);
        this.gateHauler.removeTag("non_clickable");
        this.gateHauler.removeTag("fading_out_and_expiring");
        this.gateHauler.setAlwaysUseSensorFaderBrightness(null);
        if (!this.destination.getAllEntities().contains(this.gateHauler)) {
            this.destination.addEntity(this.gateHauler);
        }
        this.gateHauler.fadeOutIndicator();
        this.getPlugin().getMovement().setLocation(spawnLoc);
        this.getPlugin().getMovement().setVelocity(spawnVel);
        this.getPlugin().getMovement().setFacing(this.departureAngle + 180.0f);
        this.getPlugin().getMovement().moveToLocation(this.parkingOrbit.getLocation());
        this.getPlugin().getMovement().setTurnThenAccelerate(true);
        this.getPlugin().getMovement().setFaceInOppositeDirection(true);
        this.getPlugin().setLongBurn(true);
    }

    protected void findParkingOrbit() {
        float orbitDays;
        float dist;
        float minDist = 4000.0f;
        float maxDist = 8000.0f;
        this.parkingOrbit = null;
        SectorEntityToken found = null;
        for (SectorEntityToken sectorEntityToken : this.destination.getEntitiesWithTag("stable_location")) {
            dist = sectorEntityToken.getLocation().length();
            if (!(dist >= minDist) || !(dist <= 8000.0f)) continue;
            found = sectorEntityToken;
            break;
        }
        if (found == null) {
            for (PlanetAPI planetAPI : this.destination.getPlanets()) {
                if (planetAPI.isMoon() || !((dist = planetAPI.getLocation().length()) >= minDist) || !(dist <= 8000.0f)) continue;
                found = planetAPI;
                break;
            }
        }
        if (found != null) {
            Vector2f vector2f = Misc.getPointAtRadius(found.getLocation(), found.getRadius() + 400.0f);
            this.parkingOrbit = this.destination.createToken(vector2f);
            float orbitRadius = found.getRadius() + 250.0f;
            orbitDays = orbitRadius / (20.0f + Misc.random.nextFloat() * 5.0f);
            this.parkingOrbit.setCircularOrbit(found, Misc.random.nextFloat() * 360.0f, orbitRadius, orbitDays);
        } else {
            List<BaseThemeGenerator.OrbitGap> list = BaseThemeGenerator.findGaps(this.destination.getCenter(), minDist, maxDist, this.gateHauler.getRadius() + 50.0f);
            if (!list.isEmpty()) {
                BaseThemeGenerator.OrbitGap gap = list.get(0);
                float orbitRadius = (gap.start + gap.end) * 0.5f;
                Vector2f loc = Misc.getPointAtRadius(this.destination.getCenter().getLocation(), orbitRadius);
                this.parkingOrbit = this.destination.createToken(loc);
                if (!this.destination.isNebula()) {
                    float orbitDays2 = orbitRadius / (20.0f + Misc.random.nextFloat() * 5.0f);
                    this.parkingOrbit.setCircularOrbit(this.destination.getCenter(), Misc.random.nextFloat() * 360.0f, orbitRadius, orbitDays2);
                }
            }
        }
        if (this.parkingOrbit == null) {
            float f = minDist + (maxDist - minDist) * Misc.random.nextFloat();
            Vector2f loc = Misc.getPointAtRadius(this.destination.getCenter().getLocation(), f);
            this.parkingOrbit = this.destination.createToken(loc);
            if (!this.destination.isNebula()) {
                orbitDays = f / (20.0f + Misc.random.nextFloat() * 5.0f);
                this.parkingOrbit.setCircularOrbit(this.destination.getCenter(), Misc.random.nextFloat() * 360.0f, f, orbitDays);
            }
        }
        this.destination.addEntity(this.parkingOrbit);
    }

    protected void setAction(GateHaulerAction action) {
        this.action = action;
        this.elapsedDaysInAction = 0.0f;
    }

    public GateHaulerEntityPlugin getPlugin() {
        return (GateHaulerEntityPlugin)this.gateHauler.getCustomPlugin();
    }

    @Override
    public void advance(float amount) {
        float orbitDays;
        float orbitAngle;
        boolean closeEnough;
        float dist;
        float speed;
        super.advance(amount);
        if (this.action != null) {
            float \u5929 = Misc.getDays(amount);
            this.elapsedDaysInAction += \u5929;
            this.gateHauler.fadeOutIndicator();
            if (this.action == GateHaulerAction.DEPLOYING && this.stableLocation != null) {
                this.stableLocation.fadeOutIndicator();
            }
        }
        if (this.action == GateHaulerAction.OUTBOUND) {
            boolean nearPlayer;
            speed = this.gateHauler.getVelocity().length();
            dist = this.gateHauler.getLocation().length();
            CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
            boolean bl = nearPlayer = pf != null && this.gateHauler.isInCurrentLocation() && Misc.getDistance(pf, this.gateHauler) < 10000.0f;
            if (!nearPlayer && this.elapsedDaysInAction > 20.0f && speed >= GateHaulerEntityPlugin.MAX_SPEED * 0.95f && dist > 40000.0f) {
                Misc.fadeAndExpire(this.gateHauler);
                this.setAction(GateHaulerAction.DEEP_SPACE_TRANSIT);
                this.sendUpdateIfPlayerHasIntel((Object)GateHaulerAction.DEEP_SPACE_TRANSIT, false);
            }
        }
        if (this.action == GateHaulerAction.DEEP_SPACE_TRANSIT && this.elapsedDaysInAction >= (float)this.transitDays) {
            this.initiateArrival();
            this.sendUpdateIfPlayerHasIntel((Object)GateHaulerAction.INBOUND, false);
        }
        if (this.action == GateHaulerAction.INBOUND) {
            this.getPlugin().getMovement().moveToLocation(this.parkingOrbit.getLocation());
            speed = this.gateHauler.getVelocity().length();
            dist = Misc.getDistance(this.parkingOrbit, this.gateHauler);
            boolean overshot = Misc.isInArc(this.gateHauler.getFacing(), 270.0f, this.gateHauler.getLocation(), this.parkingOrbit.getLocation());
            if (overshot || dist < 700.0f) {
                this.getPlugin().getMovement().setTurnThenAccelerate(false);
                this.getPlugin().getMovement().setFaceInOppositeDirection(false);
            }
            boolean bl = closeEnough = speed < 20.0f && dist < 100.0f + this.parkingOrbit.getRadius() + this.gateHauler.getRadius();
            if (dist < 200.0f + this.parkingOrbit.getRadius() + this.gateHauler.getRadius() && this.elapsedDaysInAction > 30.0f) {
                closeEnough = true;
            }
            if (closeEnough) {
                this.setAction(null);
                this.destination = null;
                this.gateHauler.fadeInIndicator();
                this.getPlugin().getMovement().setFaceInOppositeDirection(false);
                this.getPlugin().setLongBurn(false);
                orbitAngle = Misc.getAngleInDegrees(this.parkingOrbit.getLocation(), this.gateHauler.getLocation());
                orbitDays = 1000000.0f;
                this.gateHauler.setCircularOrbit(this.parkingOrbit, orbitAngle, dist, orbitDays);
                if (!this.gateHauler.isInCurrentLocation()) {
                    int i = 0;
                    while (i < 10) {
                        this.getPlugin().getEngineGlow().showIdling();
                        this.getPlugin().getEngineGlow().advance(1.0f);
                        ++i;
                    }
                }
                this.gateHauler.getMemoryWithoutUpdate().unset("$inTransit");
                if (this.gateHauler.isInCurrentLocation()) {
                    float distToPlayer;
                    String key = "$witnessedGateHaulerArrival";
                    MemoryAPI mem = Global.getSector().getPlayerMemoryWithoutUpdate();
                    if (!mem.getBoolean(key) && (distToPlayer = Misc.getDistance(Global.getSector().getPlayerFleet(), this.gateHauler)) < 2000.0f) {
                        this.sendUpdateIfPlayerHasIntel(UPDATE_WITNESSED_ARRIVAL, false);
                        Global.getSector().getPlayerStats().addStoryPoints(1, null, false);
                        mem.set(key, true);
                    }
                }
            }
        }
        if (this.action == GateHaulerAction.DEPLOYING) {
            if (this.gateHauler.getOrbit() == null) {
                this.getPlugin().getMovement().moveToLocation(this.stableLocation.getLocation());
            }
            if (this.elapsedDaysInAction > 1.0f) {
                if (this.gateHauler.getOrbit() == null) {
                    speed = this.gateHauler.getVelocity().length();
                    dist = Misc.getDistance(this.stableLocation, this.gateHauler);
                    if (dist < 1000.0f) {
                        this.getPlugin().getMovement().setTurnThenAccelerate(false);
                    }
                    float test = 100.0f;
                    if (!this.gateHauler.isInCurrentLocation()) {
                        test = 400.0f;
                    }
                    boolean bl = closeEnough = speed < 20.0f && dist < test + this.stableLocation.getRadius() + this.gateHauler.getRadius();
                    if (dist < 500.0f + this.stableLocation.getRadius() + this.gateHauler.getRadius() + (this.elapsedDaysInAction - 50.0f) * 50.0f && this.elapsedDaysInAction > 50.0f) {
                        closeEnough = true;
                    }
                    if (closeEnough) {
                        orbitAngle = Misc.getAngleInDegrees(this.stableLocation.getLocation(), this.gateHauler.getLocation());
                        orbitDays = 1000000.0f;
                        this.gateHauler.setCircularOrbit(this.stableLocation, orbitAngle, dist, orbitDays);
                        this.elapsedDaysInAction = 0.0f;
                    }
                } else {
                    this.setAction(null);
                    this.addDebrisField();
                    BaseThemeGenerator.EntityLocation loc = new BaseThemeGenerator.EntityLocation();
                    if (this.stableLocation.getOrbit() != null) {
                        loc.orbit = this.stableLocation.getOrbit().makeCopy();
                    } else {
                        loc.location = new Vector2f((ReadableVector2f)this.stableLocation.getLocation());
                    }
                    BaseThemeGenerator.AddedEntity added = BaseThemeGenerator.addNonSalvageEntity(this.stableLocation.getStarSystem(), loc, "inactive_gate", "neutral");
                    this.gateHauler.getMemoryWithoutUpdate().unset("$deploying");
                    this.gateHauler.addTag("no_entity_tooltip");
                    Misc.fadeAndExpire(this.gateHauler, 10.0f);
                    Misc.fadeAndExpire(this.stableLocation, 10.0f);
                    this.endImmediately();
                    if (added.entity != null) {
                        Misc.fadeIn(added.entity, 3.0f);
                    }
                }
            }
        }
    }

    protected void addDebrisField() {
        if (this.stableLocation == null) {
            return;
        }
        DebrisFieldTerrainPlugin.DebrisFieldParams params = new DebrisFieldTerrainPlugin.DebrisFieldParams(400.0f, -1.0f, 3.0f, 0.0f);
        params.source = DebrisFieldTerrainPlugin.DebrisFieldSource.MIXED;
        params.density = 1.0f;
        params.baseSalvageXP = 500L;
        CampaignTerrainAPI debris = (CampaignTerrainAPI)Misc.addDebrisField(this.stableLocation.getContainingLocation(), params, null);
        debris.setDiscoverable(null);
        debris.setDiscoveryXP(null);
        debris.addDropValue("extended", 100000);
        debris.getLocation().set((ReadableVector2f)this.stableLocation.getLocation());
        if (this.stableLocation.getOrbit() != null) {
            debris.setOrbit(this.stableLocation.getOrbit().makeCopy());
        }
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        boolean isUpdate;
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        FactionAPI faction = this.getFactionForUIColors();
        Color base = faction.getBaseUIColor();
        Color dark = faction.getDarkUIColor();
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean bl = isUpdate = this.getListInfoParam() != null;
        if (isUpdate) {
            if (this.getListInfoParam() == GateHaulerAction.DEEP_SPACE_TRANSIT) {
                info.addPara("\u5df2\u8fdb\u5165\u661f\u9645\u7a7a\u95f4", tc, initPad);
                String dStr = "\u5929";
                if (this.transitDays == 1) {
                    dStr = "\u5929";
                }
                info.addPara("\u9884\u8ba1 %s " + dStr + "\u5b8c\u6210\u8f6c\u79fb", initPad, tc, h, "" + this.transitDays);
                return;
            }
            if (this.getListInfoParam() == GateHaulerAction.INBOUND) {
                info.addPara("\u5df2\u5230\u8fbe " + this.destination.getNameWithLowercaseType(), tc, initPad);
                return;
            }
            if (this.getListInfoParam() == UPDATE_WITNESSED_ARRIVAL) {
                info.addPara("\u76ee\u7779\u4e86 \u661f\u95e8\u8fd0\u8f93\u8230 \u6765\u5230\u4e00\u4e2a\u661f\u7cfb", tc, initPad);
                return;
            }
        }
        if (mode == IntelInfoPlugin.ListInfoMode.INTEL) {
            String locStr = this.gateHauler.getContainingLocation().getNameWithLowercaseTypeShort();
            if (this.gateHauler.getContainingLocation() != null && this.gateHauler.getContainingLocation().isDeepSpace()) {
                locStr = "\u6df1\u7a7a";
            } else if (this.gateHauler.getContainingLocation() != null) {
                locStr = this.gateHauler.getContainingLocation().getNameWithLowercaseTypeShort();
            }
            if (this.getPlugin().isInTransit() && this.action == GateHaulerAction.DEEP_SPACE_TRANSIT) {
                locStr = "\u5728\u6df1\u7a7a\u4e2d\u7a7f\u68ad";
            }
            info.addPara("\u4f4d\u7f6e\uff1a" + locStr, tc, initPad);
            initPad = 0.0f;
            GateHaulerEntityPlugin plugin = this.getPlugin();
            if (!plugin.isActivated()) {
                info.addPara("\u72b6\u6001\uff1a\u4f11\u7720\u4e2d", tc, initPad);
            } else if (plugin.isActivating()) {
                info.addPara("\u72b6\u6001\uff1a\u6fc0\u6d3b\u4e2d", tc, initPad);
            } else if (this.action == null) {
                info.addPara("\u72b6\u6001\uff1a\u53ef\u8fd0\u884c", tc, initPad);
            } else if (this.action == GateHaulerAction.OUTBOUND) {
                info.addPara("\u6b63\u79bb\u5f00\u5f53\u524d\u4f4d\u7f6e", tc, initPad);
                String dStr = "\u5929";
                if (this.transitDays == 1) {
                    dStr = "\u5929";
                }
                info.addPara("\u9884\u8ba1 %s " + dStr + " \u5b8c\u6210\u8f6c\u79fb", initPad, tc, h, "" + this.transitDays);
            } else if (this.action == GateHaulerAction.DEEP_SPACE_TRANSIT) {
                String dStr = "\u5929";
                int daysRemaining = Math.round((float)this.transitDays - this.elapsedDaysInAction);
                if (daysRemaining < 1) {
                    daysRemaining = 1;
                }
                if (daysRemaining == 1) {
                    dStr = "\u5929";
                }
                info.addPara("\u9884\u8ba1 %s " + dStr + "\u5b8c\u6210\u8f6c\u79fb", initPad, tc, h, "" + daysRemaining);
            } else if (this.action == GateHaulerAction.INBOUND) {
                info.addPara("\u5df2\u5230\u8fbe " + this.destination.getNameWithLowercaseType(), tc, initPad);
            }
        }
        this.unindent(info);
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        String pre = "";
        String post = "";
        Color c = this.getTitleColor(mode);
        info.addPara(String.valueOf(pre) + this.getName() + post, c, 0.0f);
        this.addBulletPoints(info, mode);
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        if (this.gateHauler.getCustomInteractionDialogImageVisual() != null) {
            info.addImage(this.gateHauler.getCustomInteractionDialogImageVisual().getSpriteName(), width, opad);
        }
        Description desc = Global.getSettings().getDescription(this.gateHauler.getCustomDescriptionId(), Description.Type.CUSTOM);
        info.addPara(desc.getText1(), opad);
        FactionAPI faction = this.getFactionForUIColors();
        Color base = faction.getBaseUIColor();
        Color dark = faction.getDarkUIColor();
        info.addSectionHeading("\u5f62\u52bf", base, dark, Alignment.MID, opad);
        GateHaulerEntityPlugin plugin = this.getPlugin();
        if (!plugin.isActivated()) {
            GateHaulerCMD cmd = new GateHaulerCMD();
            info.addPara("\u661f\u95e8\u8fd0\u8f93\u8230\u6b63\u5904\u4e8e\u4f11\u7720\u72b6\u6001\uff0c\u5b83\u4e3a\u8282\u7701\u80fd\u6e90\u5df2\u5173\u95ed\u7edd\u5927\u591a\u6570\u7cfb\u7edf\u3002", opad);
            info.showCost("\u63d0\u4f9b\u4ee5\u4e0b\u8d44\u6e90\u4ee5\u6fc0\u6d3b\uff1a", false, base, dark, opad, cmd.getResources(), cmd.getQuantities());
        } else if (plugin.isActivating()) {
            info.addPara("\u661f\u95e8\u8fd0\u8f93\u8230\u6b63\u5904\u4e8e\u91cd\u542f\u72b6\u6001\uff0c\u5b83\u7684\u7cfb\u7edf\u5c06\u5c3d\u5feb\u91cd\u65b0\u4e0a\u7ebf\u4ee5\u4f9b\u4f7f\u7528\u3002", opad);
        } else if (this.action == null) {
            info.addPara("\u661f\u95e8\u8fd0\u8f93\u8230\u6b63\u5904\u4e8e\u5f85\u673a\u72b6\u6001\uff0c\u53ef\u4ee5\u524d\u5f80\u5176\u4ed6\u661f\u7cfb\u5e76\u5728\u7a33\u5b9a\u70b9\u5904\u653e\u7f6e\u661f\u95e8\u3002", opad);
        } else if (this.action == GateHaulerAction.OUTBOUND) {
            info.addPara("\u661f\u95e8\u8fd0\u8f93\u8230\u6b63\u5728\u79bb\u5f00\u5f53\u524d\u4f4d\u7f6e\uff0c\u5411\u7740\u8fdc\u5904\u7684\u661f\u9645\u7a7a\u95f4\u4e0d\u65ad\u52a0\u901f\u3002", opad);
            String dStr = "\u5929";
            if (this.transitDays == 1) {
                dStr = "\u5929";
            }
            info.addPara("\u5f53\u5b83\u8fdb\u5165\u661f\u9645\u7a7a\u95f4\u540e\uff0c\u9884\u8ba1\u9700\u8981 %s " + dStr + "\u624d\u80fd\u5230\u8fbe" + "\u5176\u76ee\u7684\u5730 " + this.destination.getNameWithLowercaseTypeShort() + "\u3002\u8fdb\u5165\u76ee\u7684\u5730\u533a\u57df\u540e\uff0c" + "\u5b83\u5c06\u9700\u8981\u4e00\u4e9b\u65f6\u95f4\u8fdb\u884c\u51cf\u901f\u5e76\u505c\u9760\u5728\u7a33\u5b9a\u8f68\u9053\u4e0a\u3002", opad, h, "" + this.transitDays);
        } else if (this.action == GateHaulerAction.DEEP_SPACE_TRANSIT) {
            String dStr = "\u5929";
            int daysRemaining = Math.round((float)this.transitDays - this.elapsedDaysInAction);
            if (daysRemaining < 1) {
                daysRemaining = 1;
            }
            if (daysRemaining == 1) {
                dStr = "\u5929";
            }
            info.addPara("\u661f\u95e8\u8fd0\u8f93\u8230 \u6b63\u5728\u8f6c\u79fb\u81f3\u522b\u5904\uff0c\u4e14\u5f53\u524d\u5904\u4e8e\u6df1\u7a7a\u4e4b\u4e2d\u3002\u9884\u8ba1\u9700\u8981 %s " + dStr + "\u624d\u80fd\u5230\u8fbe" + "\u5176\u76ee\u7684\u5730 " + this.destination.getNameWithLowercaseTypeShort() + "\u3002\u8fdb\u5165\u76ee\u7684\u5730\u533a\u57df\u540e\uff0c" + "\u5b83\u5c06\u9700\u8981\u4e00\u4e9b\u65f6\u95f4\u8fdb\u884c\u51cf\u901f\u5e76\u505c\u9760\u5728\u7a33\u5b9a\u8f68\u9053\u4e0a\u3002", opad, h, "" + daysRemaining);
        } else if (this.action == GateHaulerAction.INBOUND) {
            info.addPara("\u661f\u95e8\u8fd0\u8f93\u8230 \u5df2\u5230\u8fbe " + this.destination.getNameWithLowercaseTypeShort() + " " + "\u4e14\u6b63\u5728\u8fdb\u884c\u51cf\u901f\u5e76\u505c\u9760\u5728\u7a33\u5b9a\u8f68\u9053\u4e0a\u3002", opad);
        } else if (this.action == GateHaulerAction.DEPLOYING) {
            info.addPara("\u661f\u95e8\u8fd0\u8f93\u8230\u6b63\u5728\u6839\u636e\u547d\u4ee4\u90e8\u7f72\u661f\u95e8\u3002", opad);
        }
    }

    @Override
    public String getIcon() {
        return Global.getSettings().getSpriteName("intel", "gate_hauler");
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Gates");
        tags.add("Exploration");
        return tags;
    }

    @Override
    public String getSortString() {
        return super.getSortString();
    }

    @Override
    public String getName() {
        return "\u661f\u95e8\u8fd0\u8f93\u8230";
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return this.gateHauler.getFaction();
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        if (!this.gateHauler.isAlive() && this.destination != null) {
            return this.destination.getCenter();
        }
        return this.gateHauler;
    }

    @Override
    public String getCommMessageSound() {
        return "ui_discovered_entity";
    }

    public SectorEntityToken getGateHauler() {
        return this.gateHauler;
    }

    @Override
    public List<IntelInfoPlugin.ArrowData> getArrowData(SectorMapAPI map) {
        boolean showArrow;
        if (this.destination == null || this.action == null) {
            return null;
        }
        boolean bl = showArrow = this.action == GateHaulerAction.OUTBOUND || this.action == GateHaulerAction.DEEP_SPACE_TRANSIT;
        if (!showArrow) {
            return null;
        }
        if (this.gateHauler.getContainingLocation() == this.destination) {
            return null;
        }
        ArrayList<IntelInfoPlugin.ArrowData> result = new ArrayList<IntelInfoPlugin.ArrowData>();
        IntelInfoPlugin.ArrowData arrow = new IntelInfoPlugin.ArrowData(this.gateHauler, this.destination.getCenter());
        arrow.color = this.getFactionForUIColors().getBaseUIColor();
        arrow.width = 20.0f;
        result.add(arrow);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GateHaulerAction {
        OUTBOUND,
        DEEP_SPACE_TRANSIT,
        INBOUND,
        DEPLOYING;

    }
}

