/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.misc;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.impl.campaign.GateEntityPlugin;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.loading.Description;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GateIntel
extends BaseIntelPlugin {
    protected SectorEntityToken gate;

    public GateIntel(SectorEntityToken gate) {
        this.gate = gate;
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        boolean isUpdate;
        boolean active = GateEntityPlugin.isActive(this.gate);
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean bl = isUpdate = this.getListInfoParam() != null;
        if (GateEntityPlugin.isScanned(this.gate)) {
            info.addPara("\u5df2\u626b\u63cf", tc, initPad);
            initPad = 0.0f;
        }
        this.unindent(info);
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        String pre = "";
        String post = "";
        if (mode == IntelInfoPlugin.ListInfoMode.MESSAGES) {
            pre = "\u53d1\u73b0\u4e86\uff1a";
        }
        if (mode == IntelInfoPlugin.ListInfoMode.INTEL) {
            post = " - " + this.gate.getContainingLocation().getNameWithTypeShort();
        }
        Color c = this.getTitleColor(mode);
        info.addPara(String.valueOf(pre) + this.getName() + post, c, 0.0f);
        this.addBulletPoints(info, mode);
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        if (this.gate.getCustomInteractionDialogImageVisual() != null) {
            info.addImage(this.gate.getCustomInteractionDialogImageVisual().getSpriteName(), width, opad);
        }
        Description desc = Global.getSettings().getDescription(this.gate.getCustomDescriptionId(), Description.Type.CUSTOM);
        info.addPara(desc.getText1(), opad);
        if (GateEntityPlugin.isScanned(this.gate)) {
            if (GateEntityPlugin.canUseGates()) {
                info.addPara("\u901a\u8fc7\u4ed4\u7ec6\u626b\u63cf\uff0c\u5176\u8bfb\u6570\u8868\u793a\u5df2\u7ecf\u53ef\u4ee5\u5b89\u5168\u901a\u8fc7\u3002", opad);
            } else {
                info.addPara("\u5df2\u7ecf\u626b\u63cf\u4e86\u8fd9\u5904\u661f\u95e8\u3002", opad);
            }
        }
    }

    protected boolean isActive() {
        return GateEntityPlugin.isActive(this.gate);
    }

    @Override
    public String getIcon() {
        if (this.isActive()) {
            return Global.getSettings().getSpriteName("intel", "gate_active");
        }
        return Global.getSettings().getSpriteName("intel", "gate_inactive");
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Gates");
        return tags;
    }

    @Override
    public String getSortString() {
        if (this.isActive()) {
            return "\u6fc0\u6d3b\u7684\u661f\u95e8 " + this.gate.getName();
        }
        return "\u672a\u6fc0\u6d3b\u7684\u661f\u95e8 " + this.gate.getName();
    }

    @Override
    public String getName() {
        return this.gate.getName();
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return super.getFactionForUIColors();
    }

    @Override
    public String getSmallDescriptionTitle() {
        return String.valueOf(this.getName()) + " - " + this.gate.getContainingLocation().getNameWithTypeShort();
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return this.gate;
    }

    @Override
    public boolean shouldRemoveIntel() {
        return false;
    }

    @Override
    public String getCommMessageSound() {
        return "ui_discovered_entity";
    }

    public SectorEntityToken getGate() {
        return this.gate;
    }
}

