/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.misc;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.intel.misc.FleetLogIntel;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.CountingMap;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductionReportIntel
extends FleetLogIntel {
    protected MarketAPI gatheringPoint;
    protected ProductionData data;
    protected int totalCost;
    protected int accrued;
    protected boolean noProductionThisMonth;

    public ProductionReportIntel(MarketAPI gatheringPoint, ProductionData data, int totalCost, int accrued, boolean noProductionThisMonth) {
        this.gatheringPoint = gatheringPoint;
        this.data = data;
        this.totalCost = totalCost;
        this.accrued = accrued;
        this.noProductionThisMonth = noProductionThisMonth;
        this.setDuration(10.0f);
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        if (!this.data.isEmpty()) {
            float days = this.getDaysSincePlayerVisible();
            if (days < 1.0f) {
                info.addPara("\u5df2\u4ea4\u4ed8\u5230 %s", initPad, tc, this.getFactionForUIColors().getBaseUIColor(), this.gatheringPoint.getName());
                initPad = 0.0f;
            } else {
                LabelAPI label = info.addPara("\u5df2\u4ea4\u4ed8\u5230 %s %s " + ProductionReportIntel.getDaysString(days) + " \u524d", initPad, tc, this.getFactionForUIColors().getBaseUIColor(), this.gatheringPoint.getName(), this.getDays(days));
                label.setHighlightColors(this.getFactionForUIColors().getBaseUIColor(), h);
                initPad = 0.0f;
            }
        }
        if (this.totalCost > 0) {
            info.addPara("\u672c\u6708\u8ba2\u5355\u6210\u672c\uff1a%s", initPad, tc, h, Misc.getDGSCredits(this.totalCost));
        }
        this.unindent(info);
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color c = this.getTitleColor(mode);
        info.addPara(this.getName(), c, 0.0f);
        this.addBulletPoints(info, mode);
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float small = 3.0f;
        float opad = 10.0f;
        if (this.data == null) {
            this.data = new ProductionData();
        }
        info.addImage(this.getFactionForUIColors().getLogo(), width, 128.0f, opad);
        if (this.accrued > 0) {
            info.addPara("\u5171\u6709 %s \u7684\u751f\u4ea7\u80fd\u529b\u88ab\u6295\u5165\u5230\u672a\u5b8c\u6210\u7684\u9879\u76ee\u4e2d\u3002", opad, Misc.getHighlightColor(), Misc.getDGSCredits(this.accrued));
        }
        if (this.noProductionThisMonth) {
            info.addPara("\u7531\u4e8e\u7f3a\u4e4f\u8d44\u91d1\uff0c\u5bfc\u81f4\u672c\u6708\u7684\u751f\u4ea7\u8ba1\u5212\u88ab\u8feb\u4e2d\u6b62\u3002", opad);
        }
        if (!this.data.isEmpty()) {
            info.addPara("\u4e0a\u4e2a\u6708\u5b8c\u6210\u7684\u751f\u4ea7\u4ee5\u53ca\u8d44\u6e90\u4e0e\u8239\u4f53\u7684\u91c7\u8d2d\u3002", opad);
        }
        this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
        ArrayList<String> keys = new ArrayList<String>(this.data.data.keySet());
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        for (String key : keys) {
            CargoAPI cargo = this.data.data.get(key);
            if (cargo.isEmpty() && (cargo.getMothballedShips() == null || cargo.getMothballedShips().getMembersListCopy().isEmpty())) continue;
            info.addSectionHeading(key, Alignment.MID, opad);
            float valueWidth = 30.0f;
            if (!cargo.getStacksCopy().isEmpty()) {
                info.addPara("\u6b66\u5668\uff0c\u8865\u7ed9\u4ee5\u53ca\u5176\u4ed6\u7269\u8d44\uff1a", opad);
                info.showCargo(cargo, 20, true, opad);
            }
            if (!cargo.getMothballedShips().getMembersListCopy().isEmpty()) {
                CountingMap<String> counts = new CountingMap<String>();
                for (FleetMemberAPI member : cargo.getMothballedShips().getMembersListCopy()) {
                    counts.add(String.valueOf(member.getVariant().getHullSpec().getHullName()) + " " + member.getVariant().getDesignation());
                }
                info.addPara("\u914d\u5907\u57fa\u672c\u6b66\u5668\u7684\u8239\u4f53\uff1a", opad);
                info.showShips(cargo.getMothballedShips().getMembersListCopy(), 20, true, opad);
            }
            Global.getSector().getPlayerFleet().getFleetData().setSyncNeeded();
            Global.getSector().getPlayerFleet().getFleetData().syncIfNeeded();
        }
    }

    @Override
    public String getIcon() {
        return Global.getSettings().getSpriteName("intel", "production_report");
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Production");
        return tags;
    }

    @Override
    public String getSortString() {
        return "Production";
    }

    @Override
    public String getName() {
        return "\u751f\u4ea7\u62a5\u544a";
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return Global.getSector().getPlayerFaction();
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return this.gatheringPoint.getPrimaryEntity();
    }

    @Override
    public boolean shouldRemoveIntel() {
        if (this.isImportant()) {
            return false;
        }
        if (this.getDaysSincePlayerVisible() < 30.0f) {
            return false;
        }
        return super.shouldRemoveIntel();
    }

    public static class ProductionData {
        public LinkedHashMap<String, CargoAPI> data = new LinkedHashMap();

        public CargoAPI getCargo(String name) {
            CargoAPI cargo = this.data.get(name);
            if (cargo == null) {
                cargo = Global.getFactory().createCargo(true);
                cargo.initMothballedShips("player");
                this.data.put(name, cargo);
            }
            return cargo;
        }

        public boolean isEmpty() {
            for (CargoAPI cargo : this.data.values()) {
                if (!cargo.isEmpty()) {
                    return false;
                }
                if (cargo.getMothballedShips() == null || cargo.getMothballedShips().getMembersListCopy().isEmpty()) continue;
                return false;
            }
            return true;
        }
    }
}

