/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.misc;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.impl.campaign.fleets.EconomyFleetAssignmentAI;
import com.fs.starfarer.api.impl.campaign.fleets.EconomyFleetRouteManager;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.ui.IconRenderMode;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TradeFleetDepartureIntel
extends BaseIntelPlugin {
    protected RouteManager.RouteData route;
    protected transient List<EconomyFleetAssignmentAI.CargoQuantityData> deliverList;
    protected transient List<EconomyFleetAssignmentAI.CargoQuantityData> returnList;
    protected transient boolean goods;
    protected transient boolean materiel;
    protected transient boolean valuable;
    protected transient boolean large;
    protected transient FactionAPI faction;
    protected transient EconomyFleetAssignmentAI.EconomyRouteData data;
    protected Float sinceLaunched = null;

    public TradeFleetDepartureIntel(RouteManager.RouteData route) {
        float numAlready;
        float target;
        float probMult;
        boolean sameLoc;
        this.route = route;
        this.initTransientData();
        if (this.deliverList.isEmpty()) {
            return;
        }
        float prob = 0.1f;
        if (this.valuable) {
            prob += 0.1f;
        }
        if (this.large) {
            prob += 0.1f;
        }
        if (!this.deliverList.isEmpty() && !this.returnList.isEmpty()) {
            prob += 0.2f;
        }
        boolean bl = sameLoc = this.data.from.getPrimaryEntity().getContainingLocation() != null && this.data.from.getPrimaryEntity().getContainingLocation() == Global.getSector().getPlayerFleet().getContainingLocation() && !this.data.from.getPrimaryEntity().getContainingLocation().isHyperspace();
        if (sameLoc) {
            prob = 1.0f;
        }
        if ((probMult = Misc.getProbabilityMult(target = Global.getSettings().getFloat("targetNumTradeFleetNotifications"), numAlready = (float)Global.getSector().getIntelManager().getIntelCount(TradeFleetDepartureIntel.class, true), 0.5f)) > 1.0f) {
            probMult = 1.0f;
        }
        prob *= probMult;
        if (Math.random() > (double)prob) {
            return;
        }
        float postingRange = Math.max(0.0f, this.data.size - 6.0f);
        if (this.valuable) {
            postingRange = Math.max(3.0f, postingRange);
        }
        this.setPostingRangeLY(Float.valueOf(postingRange), true);
        this.setPostingLocation(this.data.from.getPrimaryEntity());
        Global.getSector().getIntelManager().queueIntel(this);
    }

    protected void initTransientData() {
        this.data = (EconomyFleetAssignmentAI.EconomyRouteData)this.route.getCustom();
        this.deliverList = new ArrayList<EconomyFleetAssignmentAI.CargoQuantityData>();
        this.returnList = new ArrayList<EconomyFleetAssignmentAI.CargoQuantityData>();
        this.goods = false;
        this.materiel = false;
        this.valuable = false;
        this.large = this.data.size >= 6.0f;
        for (EconomyFleetAssignmentAI.CargoQuantityData curr : this.data.cargoDeliver) {
            CommoditySpecAPI c = curr.getCommodity();
            if (c.getBasePrice() >= 100.0f && !c.isPersonnel()) {
                this.valuable = true;
            }
            if (c.isMeta()) {
                this.materiel = true;
            } else if (!c.isPersonnel()) {
                this.goods = true;
            }
            this.deliverList.add(curr);
        }
        for (EconomyFleetAssignmentAI.CargoQuantityData curr : this.data.cargoReturn) {
            this.returnList.add(curr);
        }
        this.faction = Global.getSector().getFaction(this.route.getFactionId());
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        boolean isUpdate;
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean bl = isUpdate = this.getListInfoParam() != null;
        if (mode != IntelInfoPlugin.ListInfoMode.IN_DESC) {
            info.addPara("\u53d1\u5e03\u65b9\uff1a{" + this.faction.getDisplayName(), initPad, tc, this.faction.getBaseUIColor(), this.faction.getDisplayName());
            initPad = 0.0f;
        }
        if (mode != IntelInfoPlugin.ListInfoMode.IN_DESC) {
            LabelAPI label = info.addPara("\u4ece " + this.data.from.getName() + " \u5230 " + this.data.to.getName(), tc, initPad);
            label.setHighlight(this.data.from.getName(), this.data.to.getName());
            label.setHighlightColors(this.data.from.getFaction().getBaseUIColor(), this.data.to.getFaction().getBaseUIColor());
            initPad = 0.0f;
        }
        if (isUpdate) {
            info.addPara("\u8230\u961f\u51fa\u53d1", tc, initPad);
        } else {
            float delay = this.route.getDelay();
            if (delay > 0.0f) {
                this.addDays(info, "\u540e\u51fa\u53d1", delay, tc, initPad);
            } else {
                info.addPara("\u6700\u8fd1\u51fa\u53d1", tc, initPad);
            }
        }
        this.unindent(info);
    }

    protected String getWhat() {
        String what = "\u5546\u54c1\u4e0e\u7269\u8d44";
        if (!this.materiel) {
            what = "\u5546\u54c1";
        }
        if (!this.goods) {
            what = "\u7269\u8d44";
        }
        return what;
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color c = this.getTitleColor(mode);
        float pad = 3.0f;
        float opad = 10.0f;
        this.initTransientData();
        LabelAPI label = info.addPara(this.getName(), c, 0.0f);
        this.addBulletPoints(info, mode);
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        CommodityOnMarketAPI com;
        this.initTransientData();
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        info.addImage(this.faction.getLogo(), width, 128.0f, opad);
        float tier = this.data.size;
        String fleetType = this.getFleetTypeName().toLowerCase();
        LabelAPI label = info.addPara("\u4e00\u540d\u5728 " + this.data.from.getOnOrAt() + " " + this.data.from.getName() + " \u7684\u7ebf\u4eba\u5411\u4f60\u53d1\u6765\u8baf\u606f\uff1a" + this.faction.getPersonNamePrefixAOrAn() + " " + this.faction.getPersonNamePrefix() + " " + fleetType + " \u6b63\u51c6\u5907\u5728\u6b64\u79bb\u6e2f\uff0c\u5e76\u5373\u5c06\u542f\u7a0b\u524d\u5f80 " + this.data.to.getName() + ".", opad, tc, this.faction.getBaseUIColor(), this.faction.getPersonNamePrefix());
        label.setHighlight(this.data.from.getName(), this.faction.getPersonNamePrefix(), this.data.to.getName());
        label.setHighlightColors(this.data.from.getFaction().getBaseUIColor(), this.faction.getBaseUIColor(), this.data.to.getFaction().getBaseUIColor());
        this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
        String what = this.getWhat();
        if (!this.deliverList.isEmpty()) {
            info.addPara("\u5728\u524d\u5f80 " + this.data.to.getName() + " \u7684\u9014\u4e2d\uff0c\u8230\u961f\u5c06\u643a\u5e26 " + EconomyFleetAssignmentAI.EconomyRouteData.getCargoList(this.deliverList) + ".", opad);
            info.beginIconGroup();
            info.setIconSpacingMedium();
            for (EconomyFleetAssignmentAI.CargoQuantityData curr : this.deliverList) {
                com = this.data.from.getCommodityData(curr.cargo);
                info.addIcons(com, curr.units, IconRenderMode.NORMAL);
            }
            info.addIconGroup(32.0f, 1, opad);
        } else {
            info.addPara("\u8230\u961f\u5c06\u4e0d\u4f1a\u643a\u5e26\u4efb\u4f55\u503c\u5f97\u6ce8\u610f\u7684\u8d27\u7269\u524d\u5f80 " + this.data.to.getName() + ".", opad);
        }
        if (!this.returnList.isEmpty()) {
            info.addPara("\u5728\u8fd4\u56de " + this.data.from.getName() + " \u7684\u9014\u4e2d\uff0c\u8230\u961f\u5c06\u643a\u5e26 " + EconomyFleetAssignmentAI.EconomyRouteData.getCargoList(this.returnList) + ".", opad);
            info.beginIconGroup();
            info.setIconSpacingMedium();
            for (EconomyFleetAssignmentAI.CargoQuantityData curr : this.returnList) {
                com = this.data.to.getCommodityData(curr.cargo);
                info.addIcons(com, curr.units, IconRenderMode.NORMAL);
            }
            info.addIconGroup(32.0f, 1, opad);
        } else {
            info.addPara("\u8230\u961f\u5c06\u4e0d\u4f1a\u643a\u5e26\u4efb\u4f55\u503c\u5f97\u6ce8\u610f\u7684\u8d27\u7269\u8fd4\u56de " + this.data.from.getName() + ".", opad);
        }
        if (this.valuable && this.large) {
            info.addPara("\u6ce8\u610f\uff1a\u8be5\u8230\u961f\u5728\u672c\u8f6e\u8fd0\u8f93\u4e2d\u5c06\u643a\u5e26\u5927\u91cf\u8d35\u91cd " + what + ".", opad);
        } else if (this.valuable) {
            info.addPara("\u6ce8\u610f\uff1a\u8be5\u8230\u961f\u5728\u672c\u8f6e\u8fd0\u8f93\u4e2d\u643a\u5e26\u6709\u8d35\u91cd " + what + ".", opad);
        } else if (this.large) {
            info.addPara("\u6ce8\u610f\uff1a\u8be5\u8230\u961f\u5728\u672c\u8f6e\u8fd0\u8f93\u4e2d\u5c06\u643a\u5e26\u5927\u91cf " + what + ".", opad);
        }
        if (this.data.smuggling) {
            info.addPara("\u8d70\u79c1\u8005\u5e38\u5e38\u884c\u8d70\u5728\u6cd5\u5f8b\u548c\u4f26\u7406\u7684\u7070\u8272\u5730\u5e26\u3002\u56e0\u6b64\uff0c\u4ed6\u4eec\u5c31\u7b97\u4e0d\u5e78\u8eab\u4ea1 \u2014\u2014 \u800c\u5bf9\u5e72\u8fd9\u884c\u7684\u4eba\u6765\u8bf4\uff0c\u8fd9\u4e0d\u7a00\u7f55 \u2014\u2014 \u4e5f\u4e0d\u592a\u53ef\u80fd\u5bfc\u81f4\u4ed6\u4eec\u540d\u4e49\u4e0a\u5f52\u5c5e\u7684\u52bf\u529b\u91c7\u53d6\u4efb\u4f55\u5b9e\u8d28\u5e94\u5bf9\u63aa\u65bd\u3002", g, opad);
        }
    }

    @Override
    public String getIcon() {
        this.initTransientData();
        if (this.data.smuggling) {
            return Global.getSettings().getSpriteName("intel", "tradeFleet_smuggling");
        }
        if (this.valuable) {
            return Global.getSettings().getSpriteName("intel", "tradeFleet_valuable");
        }
        if (this.large) {
            return Global.getSettings().getSpriteName("intel", "tradeFleet_large");
        }
        return Global.getSettings().getSpriteName("intel", "tradeFleet_other");
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Fleet departures");
        this.faction = Global.getSector().getFaction(this.route.getFactionId());
        tags.add(this.faction.getId());
        this.data = (EconomyFleetAssignmentAI.EconomyRouteData)this.route.getCustom();
        if (this.data.smuggling) {
            tags.add("Smuggling");
        }
        return tags;
    }

    @Override
    public String getSortString() {
        return "\u8d38\u6613\u8230\u961f\u51fa\u53d1";
    }

    public String getFleetTypeName() {
        float tier = this.data.size;
        String typeId = EconomyFleetRouteManager.getFleetTypeIdForTier(tier, this.data.smuggling);
        String fleetType = this.faction.getFleetTypeName(typeId);
        if (fleetType == null) {
            fleetType = "\u8d38\u6613\u8230\u961f";
        }
        return fleetType;
    }

    @Override
    public String getName() {
        return this.getFleetTypeName();
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        this.faction = Global.getSector().getFaction(this.route.getFactionId());
        return this.faction;
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return this.route.getMarket().getPrimaryEntity();
    }

    @Override
    protected void advanceImpl(float amount) {
        super.advanceImpl(amount);
        if (this.route.getDelay() > 0.0f) {
            return;
        }
        if (this.sinceLaunched == null) {
            this.sinceLaunched = Float.valueOf(0.0f);
        }
        if (this.sinceLaunched.floatValue() <= 0.0f && amount > 0.0f) {
            this.sendUpdateIfPlayerHasIntel(new Object(), true);
        }
        float days = Misc.getDays(amount);
        this.sinceLaunched = Float.valueOf(this.sinceLaunched.floatValue() + days);
    }

    @Override
    public float getTimeRemainingFraction() {
        float f = this.route.getDelay() / 30.0f;
        return f;
    }

    @Override
    public boolean shouldRemoveIntel() {
        if (this.route.getDelay() > 0.0f) {
            return false;
        }
        if (this.isImportant()) {
            return false;
        }
        return this.sinceLaunched == null || !(this.sinceLaunched.floatValue() < this.getBaseDaysAfterEnd());
    }

    @Override
    public void setImportant(Boolean important) {
        super.setImportant(important);
        if (this.isImportant()) {
            if (!Global.getSector().getScripts().contains(this)) {
                Global.getSector().addScript(this);
            }
        } else {
            Global.getSector().removeScript(this);
        }
    }

    @Override
    public void reportRemovedIntel() {
        super.reportRemovedIntel();
        Global.getSector().removeScript(this);
    }

    @Override
    public List<IntelInfoPlugin.ArrowData> getArrowData(SectorMapAPI map) {
        SectorEntityToken iconEntity;
        ArrayList<IntelInfoPlugin.ArrowData> result = new ArrayList<IntelInfoPlugin.ArrowData>();
        if (this.data.from.getContainingLocation() == this.data.to.getContainingLocation() && this.data.from.getContainingLocation() != null && !this.data.from.getContainingLocation().isHyperspace()) {
            return null;
        }
        SectorEntityToken entityFrom = this.data.from.getPrimaryEntity();
        if (map != null && (iconEntity = map.getIntelIconEntity(this)) != null) {
            entityFrom = iconEntity;
        }
        this.data = (EconomyFleetAssignmentAI.EconomyRouteData)this.route.getCustom();
        IntelInfoPlugin.ArrowData arrow = new IntelInfoPlugin.ArrowData(entityFrom, this.data.to.getPrimaryEntity());
        arrow.color = this.getFactionForUIColors().getBaseUIColor();
        result.add(arrow);
        return result;
    }

    public RouteManager.RouteData getRoute() {
        return this.route;
    }
}

