/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.misc;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RemnantThemeGenerator;
import com.fs.starfarer.api.loading.Description;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarningBeaconIntel
extends BaseIntelPlugin {
    protected SectorEntityToken beacon;

    public WarningBeaconIntel(SectorEntityToken beacon) {
        this.beacon = beacon;
    }

    protected RemnantThemeGenerator.RemnantSystemType getRemnantType() {
        RemnantThemeGenerator.RemnantSystemType remnantType = null;
        if (this.beacon.getMemoryWithoutUpdate().contains(RemnantThemeGenerator.RemnantSystemType.DESTROYED.getBeaconFlag())) {
            remnantType = RemnantThemeGenerator.RemnantSystemType.DESTROYED;
        } else if (this.beacon.getMemoryWithoutUpdate().contains(RemnantThemeGenerator.RemnantSystemType.SUPPRESSED.getBeaconFlag())) {
            remnantType = RemnantThemeGenerator.RemnantSystemType.SUPPRESSED;
        } else if (this.beacon.getMemoryWithoutUpdate().contains(RemnantThemeGenerator.RemnantSystemType.RESURGENT.getBeaconFlag())) {
            remnantType = RemnantThemeGenerator.RemnantSystemType.RESURGENT;
        }
        return remnantType;
    }

    protected boolean isLow() {
        return this.beacon.hasTag("beacon_low");
    }

    protected boolean isMedium() {
        return this.beacon.hasTag("beacon_medium");
    }

    protected boolean isHigh() {
        return this.beacon.hasTag("beacon_high");
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean isUpdate = this.getListInfoParam() != null;
        String danger = null;
        Color dangerColor = null;
        if (this.isLow()) {
            danger = "\u4f4e";
            dangerColor = Misc.getPositiveHighlightColor();
        } else if (this.isMedium()) {
            danger = "\u666e\u901a";
            dangerColor = h;
        } else if (this.isHigh()) {
            danger = "\u9ad8";
            dangerColor = Misc.getNegativeHighlightColor();
        }
        if (danger != null) {
            info.addPara("\u5a01\u80c1\u7b49\u7ea7\uff1a" + danger, initPad, tc, dangerColor, danger);
            initPad = 0.0f;
        }
        this.unindent(info);
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color c = this.getTitleColor(mode);
        info.addPara(this.getName(), c, 0.0f);
        this.addBulletPoints(info, mode);
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        StarSystemAPI system;
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        Description desc = Global.getSettings().getDescription("warning_beacon", Description.Type.CUSTOM);
        info.addPara(desc.getText1FirstPara(), opad);
        this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
        if (this.beacon.isInHyperspace() && (system = Misc.getNearbyStarSystem(this.beacon, 1.0f)) != null) {
            info.addPara("\u8be5\u822a\u6807\u4f4d\u4e8e " + system.getNameWithLowercaseType() + " \u9644\u8fd1\uff0c\u5185\u5bb9\u5927\u81f4\u662f\u8b66\u544a\u8be5\u661f\u7cfb\u5185\u53ef\u80fd\u5b58\u5728\u5371\u9669\u3002", opad);
        }
    }

    @Override
    public String getIcon() {
        if (this.isLow()) {
            return Global.getSettings().getSpriteName("intel", "beacon_low");
        }
        if (this.isMedium()) {
            return Global.getSettings().getSpriteName("intel", "beacon_medium");
        }
        if (this.isHigh()) {
            return Global.getSettings().getSpriteName("intel", "beacon_high");
        }
        return Global.getSettings().getSpriteName("intel", "beacon_low");
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Warning beacons");
        if (this.getRemnantType() != null) {
            tags.add("remnant");
        }
        return tags;
    }

    @Override
    public String getSortString() {
        if (this.isLow()) {
            return "Warning Beacon 3";
        }
        if (this.isMedium()) {
            return "Warning Beacon 2";
        }
        if (this.isHigh()) {
            return "Warning Beacon 1";
        }
        return "Warning Beacon 0";
    }

    @Override
    public String getName() {
        return "\u8b66\u544a\u822a\u6807";
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return super.getFactionForUIColors();
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        this.beacon.isInHyperspace();
        return this.beacon;
    }

    @Override
    public boolean shouldRemoveIntel() {
        return false;
    }

    @Override
    public String getCommMessageSound() {
        return "ui_discovered_entity";
    }
}

