/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.punitive;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.ai.CampaignFleetAIAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.MilitaryResponseScript;
import com.fs.starfarer.api.impl.campaign.command.WarSimScript;
import com.fs.starfarer.api.impl.campaign.econ.impl.OrbitalStation;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.intel.punitive.PunitiveExpeditionIntel;
import com.fs.starfarer.api.impl.campaign.intel.punitive.PunitiveExpeditionManager;
import com.fs.starfarer.api.impl.campaign.intel.raid.ActionStage;
import com.fs.starfarer.api.impl.campaign.intel.raid.RaidIntel;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseAssignmentAI;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class PEActionStage
extends ActionStage
implements BaseAssignmentAI.FleetActionDelegate {
    protected MarketAPI target;
    protected boolean playerTargeted = false;
    protected List<MilitaryResponseScript> scripts = new ArrayList<MilitaryResponseScript>();
    protected boolean gaveOrders = true;
    protected float untilAutoresolve = 30.0f;

    public PEActionStage(PunitiveExpeditionIntel raid, MarketAPI target) {
        super(raid);
        this.target = target;
        this.playerTargeted = target.isPlayerOwned();
        this.untilAutoresolve = 15.0f + 5.0f * (float)Math.random();
    }

    public void advance(float amount) {
        super.advance(amount);
        float days = Misc.getDays(amount);
        this.untilAutoresolve -= days;
        if (DebugFlags.PUNITIVE_EXPEDITION_DEBUG || DebugFlags.FAST_RAIDS) {
            this.untilAutoresolve -= days * 100.0f;
        }
        if (!this.gaveOrders) {
            this.gaveOrders = true;
            this.removeMilScripts();
            float duration = 100.0f;
            MilitaryResponseScript.MilitaryResponseParams params = new MilitaryResponseScript.MilitaryResponseParams(CampaignFleetAIAPI.ActionType.HOSTILE, "PE_" + Misc.genUID() + this.target.getId(), this.intel.getFaction(), this.target.getPrimaryEntity(), 1.0f, duration);
            MilitaryResponseScript script = new MilitaryResponseScript(params);
            this.target.getContainingLocation().addScript(script);
            this.scripts.add(script);
            MilitaryResponseScript.MilitaryResponseParams defParams = new MilitaryResponseScript.MilitaryResponseParams(CampaignFleetAIAPI.ActionType.HOSTILE, "defPE_" + Misc.genUID() + this.target.getId(), this.target.getFaction(), this.target.getPrimaryEntity(), 1.0f, duration);
            MilitaryResponseScript defScript = new MilitaryResponseScript(defParams);
            this.target.getContainingLocation().addScript(defScript);
            this.scripts.add(defScript);
        }
    }

    protected void removeMilScripts() {
        if (this.scripts != null) {
            for (MilitaryResponseScript s : this.scripts) {
                s.forceDone();
            }
        }
    }

    protected void updateStatus() {
        this.abortIfNeededBasedOnFP(true);
        if (this.status != RaidIntel.RaidStageStatus.ONGOING) {
            return;
        }
        boolean inSpawnRange = RouteManager.isPlayerInSpawnRange(this.target.getPrimaryEntity());
        if (!inSpawnRange && this.untilAutoresolve <= 0.0f) {
            this.autoresolve();
            return;
        }
        if (!this.target.isInEconomy() || !this.target.isPlayerOwned()) {
            this.status = RaidIntel.RaidStageStatus.FAILURE;
            this.removeMilScripts();
            this.giveReturnOrdersToStragglers(this.getRoutes());
            return;
        }
    }

    public String getRaidActionText(CampaignFleetAPI fleet, MarketAPI market) {
        PunitiveExpeditionIntel intel = (PunitiveExpeditionIntel)this.intel;
        PunitiveExpeditionManager.PunExGoal goal = intel.getGoal();
        if (goal == PunitiveExpeditionManager.PunExGoal.BOMBARD) {
            return "\u6b63\u5728\u8f70\u70b8 " + market.getName();
        }
        return "\u6b63\u5728\u7a81\u88ad " + market.getName();
    }

    public String getRaidApproachText(CampaignFleetAPI fleet, MarketAPI market) {
        PunitiveExpeditionIntel intel = (PunitiveExpeditionIntel)this.intel;
        PunitiveExpeditionManager.PunExGoal goal = intel.getGoal();
        if (goal == PunitiveExpeditionManager.PunExGoal.BOMBARD) {
            return "\u6b63\u5728\u524d\u5f80\u5e76\u8f70\u70b8 " + market.getName();
        }
        return "\u6b63\u5728\u524d\u5f80\u5e76\u7a81\u88ad " + market.getName();
    }

    public void performRaid(CampaignFleetAPI fleet, MarketAPI market) {
        this.removeMilScripts();
        PunitiveExpeditionIntel intel = (PunitiveExpeditionIntel)this.intel;
        PunitiveExpeditionManager.PunExGoal goal = intel.getGoal();
        this.status = RaidIntel.RaidStageStatus.SUCCESS;
        if (goal == PunitiveExpeditionManager.PunExGoal.BOMBARD) {
            float cost = MarketCMD.getBombardmentCost(market, fleet);
            float maxCost = intel.getRaidFP() / intel.getNumFleets() * Misc.FP_TO_BOMBARD_COST_APPROX_MULT;
            if (fleet != null) {
                maxCost = fleet.getCargo().getMaxFuel() * 0.25f;
            }
            if (cost <= maxCost) {
                new MarketCMD(market.getPrimaryEntity()).doBombardment(intel.getFaction(), MarketCMD.BombardType.SATURATION);
                intel.setOutcome(PunitiveExpeditionIntel.PunExOutcome.SUCCESS);
            } else {
                intel.setOutcome(PunitiveExpeditionIntel.PunExOutcome.BOMBARD_FAIL);
                this.status = RaidIntel.RaidStageStatus.FAILURE;
                Misc.setFlagWithReason(market.getMemoryWithoutUpdate(), "$recentlyBombarded", intel.getFaction().getId(), true, 30.0f);
            }
        } else {
            float str = intel.getRaidFPAdjusted() / intel.getNumFleets() * Misc.FP_TO_GROUND_RAID_STR_APPROX_MULT;
            if (fleet != null) {
                str = MarketCMD.getRaidStr(fleet);
            }
            float durMult = Global.getSettings().getFloat("punitiveExpeditionDisruptDurationMult");
            boolean raidSuccess = new MarketCMD(market.getPrimaryEntity()).doIndustryRaid(intel.getFaction(), str, intel.targetIndustry, durMult);
            if (raidSuccess) {
                intel.setOutcome(PunitiveExpeditionIntel.PunExOutcome.SUCCESS);
            } else {
                intel.setOutcome(PunitiveExpeditionIntel.PunExOutcome.RAID_FAIL);
                this.status = RaidIntel.RaidStageStatus.FAILURE;
                Misc.setFlagWithReason(market.getMemoryWithoutUpdate(), "$recentlyRaided", intel.getFaction().getId(), true, 30.0f);
                Misc.setRaidedTimestamp(market);
            }
        }
        if (intel.getOutcome() != null) {
            if (this.status == RaidIntel.RaidStageStatus.SUCCESS) {
                intel.sendOutcomeUpdate();
            } else {
                this.removeMilScripts();
                this.giveReturnOrdersToStragglers(this.getRoutes());
            }
        }
    }

    protected void autoresolve() {
        float str = WarSimScript.getFactionStrength(this.intel.getFaction(), this.target.getStarSystem());
        float enemyStr = WarSimScript.getFactionStrength(this.target.getFaction(), this.target.getStarSystem());
        float defensiveStr = enemyStr + WarSimScript.getStationStrength(this.target.getFaction(), this.target.getStarSystem(), this.target.getPrimaryEntity());
        if (defensiveStr >= str) {
            this.status = RaidIntel.RaidStageStatus.FAILURE;
            this.removeMilScripts();
            this.giveReturnOrdersToStragglers(this.getRoutes());
            PunitiveExpeditionIntel intel = (PunitiveExpeditionIntel)this.intel;
            intel.setOutcome(PunitiveExpeditionIntel.PunExOutcome.TASK_FORCE_DEFEATED);
            return;
        }
        Industry station = Misc.getStationIndustry(this.target);
        if (station != null) {
            OrbitalStation.disrupt(station);
        }
        this.performRaid(null, this.target);
    }

    protected void updateRoutes() {
        this.resetRoutes();
        this.gaveOrders = false;
        ((PunitiveExpeditionIntel)this.intel).sendEnteredSystemUpdate();
        List<RouteManager.RouteData> routes = RouteManager.getInstance().getRoutesForSource(this.intel.getRouteSourceId());
        for (RouteManager.RouteData route : routes) {
            if (this.target.getStarSystem() != null) {
                route.addSegment(new RouteManager.RouteSegment(Math.min(5.0f, this.untilAutoresolve), this.target.getStarSystem().getCenter()));
            }
            route.addSegment(new RouteManager.RouteSegment(1000.0f, this.target.getPrimaryEntity()));
        }
    }

    public void showStageInfo(TooltipMakerAPI info) {
        block15: {
            float opad;
            block14: {
                int curr = this.intel.getCurrentStage();
                int index = this.intel.getStageIndex(this);
                Color h = Misc.getHighlightColor();
                Color g = Misc.getGrayColor();
                Color tc = Misc.getTextColor();
                float pad = 3.0f;
                opad = 10.0f;
                if (curr < index) {
                    return;
                }
                if (this.status == RaidIntel.RaidStageStatus.ONGOING && curr == index) {
                    info.addPara("\u8fdc\u5f81\u519b\u76ee\u524d\u6b63\u5904\u4e8e\u76ee\u6807\u661f\u7cfb\u5f53\u4e2d\u3002", opad);
                    return;
                }
                PunitiveExpeditionIntel intel = (PunitiveExpeditionIntel)this.intel;
                if (intel.getOutcome() == null) break block14;
                switch (intel.getOutcome()) {
                    case BOMBARD_FAIL: {
                        info.addPara("\u7136\u800c " + this.target.getName() + " \u7684\u5730\u9762\u9632\u5fa1\u529b\u8db3\u4ee5\u62b5\u5fa1\u654c\u65b9\u7684\u8f70\u70b8\u884c\u52a8\u3002", opad);
                        break;
                    }
                    case RAID_FAIL: {
                        info.addPara("\u56e0\u76ee\u6807\u5730\u9762\u9632\u5fa1\u6212\u5907\u68ee\u4e25\uff0c\u8fdc\u5f81\u519b\u60e8\u8d25\u4e8e " + this.target.getName() + ".", opad);
                        break;
                    }
                    case SUCCESS: {
                        if (intel.goal == PunitiveExpeditionManager.PunExGoal.BOMBARD) {
                            if (!this.target.isInEconomy()) {
                                info.addPara("\u8fdc\u5f81\u519b\u6210\u529f\u5730\u8f70\u70b8\u4e86 " + this.target.getName() + "\uff0c\u5e76\u5f7b\u5e95\u6467\u6bc1\u4e86\u8be5\u6b96\u6c11\u5730\u3002", opad);
                                break;
                            }
                            info.addPara("\u8fdc\u5f81\u519b\u6210\u529f\u5730\u8f70\u70b8\u4e86 " + this.target.getName() + ".", opad);
                            break;
                        }
                        if (intel.getTargetIndustry() != null) {
                            info.addPara("\u8fdc\u5f81\u519b\u5df2\u7ecf\u6210\u529f\u762b\u75ea\u76ee\u6807 " + intel.getTargetIndustry().getCurrentName() + " \u7684\u8fd0\u4f5c\u7ea6 %s \u5929\u3002", opad, h, "" + Math.round(intel.getTargetIndustry().getDisruptedDays()));
                            break;
                        }
                        break block15;
                    }
                    case TASK_FORCE_DEFEATED: {
                        info.addPara("\u56e0\u76ee\u6807\u5b88\u519b\u5b9e\u529b\u5f3a\u5927\uff0c\u8fdc\u5f81\u519b\u60e8\u8d25\u4e8e " + this.target.getName() + ".", opad);
                        break;
                    }
                    case COLONY_NO_LONGER_EXISTS: {
                        info.addPara("\u8fdc\u5f81\u519b\u7684\u884c\u52a8\u5df2\u88ab\u7ec8\u6b62\u3002", opad);
                    }
                }
                break block15;
            }
            if (this.status == RaidIntel.RaidStageStatus.SUCCESS) {
                info.addPara("\u8fdc\u5f81\u519b\u83b7\u5f97\u4e86\u80dc\u5229\u3002", opad);
            } else {
                info.addPara("\u8fdc\u5f81\u519b\u88ab\u51fb\u8d25\u4e86\u3002", opad);
            }
        }
    }

    public boolean canRaid(CampaignFleetAPI fleet, MarketAPI market) {
        PunitiveExpeditionIntel intel = (PunitiveExpeditionIntel)this.intel;
        if (intel.getOutcome() != null) {
            return false;
        }
        return market == this.target;
    }

    public String getRaidPrepText(CampaignFleetAPI fleet, SectorEntityToken from) {
        return "\u6b63\u73af\u7ed5\u4e8e " + from.getName();
    }

    public String getRaidInSystemText(CampaignFleetAPI fleet) {
        return "\u884c\u52a8\u4e2d";
    }

    public String getRaidDefaultText(CampaignFleetAPI fleet) {
        return "\u884c\u52a8\u4e2d";
    }

    public boolean isPlayerTargeted() {
        return this.playerTargeted;
    }
}

