/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.punitive;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.ReputationActionResponsePlugin;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.VisualPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.ids.Sounds;
import com.fs.starfarer.api.impl.campaign.intel.punitive.PunitiveExpeditionIntel;
import com.fs.starfarer.api.impl.campaign.intel.punitive.PunitiveExpeditionManager;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.SetStoryOption;
import com.fs.starfarer.api.ui.IntelUIAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PEAvertInteractionDialogPluginImpl
implements InteractionDialogPlugin {
    public static int BRIBE_MULT = 10000;
    public static int BRIBE_MAX = 100000;
    public static RepLevel MIN_REP = RepLevel.WELCOMING;
    public static float REP_COST = 0.2f;
    protected InteractionDialogAPI dialog;
    protected TextPanelAPI textPanel;
    protected OptionPanelAPI options;
    protected VisualPanelAPI visual;
    protected CampaignFleetAPI playerFleet;
    protected PunitiveExpeditionIntel intel;
    protected IntelUIAPI ui;
    protected OptionId beingConfirmed = null;

    public PEAvertInteractionDialogPluginImpl(PunitiveExpeditionIntel intel, IntelUIAPI ui) {
        this.intel = intel;
        this.ui = ui;
    }

    @Override
    public void init(InteractionDialogAPI dialog) {
        this.dialog = dialog;
        this.textPanel = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.visual = dialog.getVisualPanel();
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.visual.setVisualFade(0.25f, 0.25f);
        this.visual.showPlanetInfo(this.intel.getTarget().getPrimaryEntity());
        dialog.setOptionOnEscape("\u79bb\u5f00", (Object)OptionId.LEAVE);
        this.optionSelected(null, (Object)OptionId.INIT);
    }

    @Override
    public Map<String, MemoryAPI> getMemoryMap() {
        return null;
    }

    @Override
    public void backFromEngagement(EngagementResultAPI result) {
    }

    protected int computeBribeAmount() {
        int bribe;
        PunitiveExpeditionManager.PunExData data = PunitiveExpeditionManager.getInstance().getDataFor(this.intel.getFaction());
        int numAttempts = 1;
        if (data != null) {
            numAttempts = data.numAttempts;
        }
        if ((bribe = (int)(Math.pow(2.0, numAttempts) * (double)BRIBE_MULT)) > BRIBE_MAX) {
            bribe = BRIBE_MAX;
        }
        return bribe;
    }

    protected void printOptionDesc(OptionId option) {
        Color tc = Misc.getTextColor();
        FactionAPI faction = this.intel.getFaction();
        switch (option) {
            case BRIBE: {
                int bribe = this.computeBribeAmount();
                this.textPanel.addPara("\u5206\u914d\u8db3\u591f\u7684\u8d44\u91d1\u7528\u4ee5\u6253\u901a\u5b98\u65b9\u548c\u975e\u5b98\u65b9\u6e20\u9053\u5e94\u8be5\u8db3\u4ee5\u786e\u4fdd\u8fd9\u6b21\u8fdc\u5f81\u8ba1\u5212\u80ce\u6b7b\u8179\u4e2d\u3002");
                int credits = (int)this.playerFleet.getCargo().getCredits().get();
                Color costColor = Misc.getHighlightColor();
                if (bribe > credits) {
                    costColor = Misc.getNegativeHighlightColor();
                }
                this.textPanel.addPara("\u9700\u82b1\u8d39 %s \u5c31\u8db3\u4ee5\u5e94\u5bf9\u8fd9\u6b21\u7a81\u53d1\u4e8b\u4ef6\uff0c\u5e76\u4e14\u8fd8\u80fd\u786e\u4fdd\u4f60\u4e0e " + faction.getDisplayNameWithArticle() + " \u4e4b\u95f4\u7684\u5173\u7cfb\u4e0d\u4f1a\u53d7\u5230\u5f71\u54cd\u3002", costColor, Misc.getDGSCredits(bribe));
                this.textPanel.addPara("\u4f60\u6709 %s \u53ef\u7528\u3002", Misc.getHighlightColor(), Misc.getDGSCredits(credits));
                break;
            }
            case USE_CONNECTIONS: {
                boolean canUseConnections = faction.isAtWorst("player", MIN_REP);
                if (canUseConnections) {
                    this.textPanel.addPara("\u5982\u679c\u5411\u53c2\u4e0e\u7b79\u5212\u672c\u6b21\u884c\u52a8\u7684\u67d0\u4f4d\u8981\u597d\u5b98\u5458\u53d1\u9001\u6c42\u52a9\u77ed\u8baf\uff0c\u5e94\u8be5\u8db3\u4ee5\u7ec8\u6b62\u8fd9\u6b21\u8ba1\u5212\u3002");
                } else {
                    this.textPanel.addPara("\u4f60\u4e0e " + faction.getPersonNamePrefix() + " \u5b98\u5458\u6ca1\u6709\u8db3\u591f\u7684\u5173\u7cfb\u6765\u62d6\u5ef6\u8fd9\u6b21\u884c\u52a8\u3002");
                    CoreReputationPlugin.addRequiredStanding(faction, MIN_REP, null, this.textPanel, null, tc, 0.0f, true);
                }
                CoreReputationPlugin.addCurrentStanding(faction, null, this.textPanel, null, tc, 0.0f);
                if (!canUseConnections) break;
                this.textPanel.addPara("\u5229\u7528\u4eba\u8109\u5173\u7cfb\u5c06\u4f1a\u964d\u4f4e\u4f60\u4e0e " + faction.getDisplayNameWithArticle() + " \u4e4b\u95f4 %s \u70b9\u7684\u5173\u7cfb\u3002", Misc.getHighlightColor(), "" + Math.round(REP_COST * 100.0f));
            }
        }
    }

    protected void addChoiceOptions() {
        this.options.clearOptions();
        this.options.addOption("\u5206\u914d\u8db3\u591f\u7684\u8d44\u91d1\u7528\u4ee5\u8d3f\u8d42\u53c2\u4e0e\u8fd9\u6b21\u884c\u52a8\u7684\u9ad8\u5c42\u5b98\u5458\uff0c\u6765\u8fbe\u5230\u7834\u574f\u8ba1\u5212\u7684\u76ee\u7684", (Object)OptionId.BRIBE, null);
        this.options.addOption("\u5229\u7528\u4f60\u7684\u4eba\u8109\u5173\u7cfb\u6765\u6253\u4e71\u8fd9\u6b21\u8ba1\u5212", (Object)OptionId.USE_CONNECTIONS, null);
        this.dialog.setOptionColor((Object)OptionId.BRIBE, Misc.getStoryOptionColor());
        this.options.addOption("\u79bb\u5f00", (Object)OptionId.LEAVE, null);
        this.options.setShortcut((Object)OptionId.LEAVE, 1, false, false, false, true);
    }

    protected void addDismissOption() {
        this.options.clearOptions();
        this.options.addOption("\u79bb\u5f00", (Object)OptionId.LEAVE, null);
        this.options.setShortcut((Object)OptionId.LEAVE, 1, false, false, false, true);
    }

    protected void addConfirmOptions() {
        FactionAPI faction;
        boolean canUseConnections;
        if (this.beingConfirmed == null) {
            return;
        }
        this.options.clearOptions();
        this.printOptionDesc(this.beingConfirmed);
        this.options.addOption("\u91c7\u53d6\u8fd9\u9879\u5fc5\u8981\u63aa\u65bd", (Object)OptionId.CONFIRM, null);
        this.options.addOption("\u653e\u5f03", (Object)OptionId.CANCEL, null);
        this.options.setShortcut((Object)OptionId.CANCEL, 1, false, false, false, true);
        if (this.beingConfirmed == OptionId.BRIBE) {
            SetStoryOption.set(this.dialog, 1, (Object)OptionId.CONFIRM, "bribePunitiveExpedition", Sounds.STORY_POINT_SPEND_INDUSTRY, "\u901a\u8fc7\u8d3f\u8d42\u6765\u89c4\u907f " + this.intel.getFaction().getDisplayName() + " \u7684\u60e9\u7f5a\u6027\u8fdc\u5f81");
            int bribe = this.computeBribeAmount();
            if ((float)bribe > this.playerFleet.getCargo().getCredits().get()) {
                this.options.setEnabled((Object)OptionId.CONFIRM, false);
                this.options.setTooltip((Object)OptionId.CONFIRM, "\u6ca1\u6709\u8db3\u591f\u7684\u661f\u5e01\u3002");
            }
        } else if (this.beingConfirmed == OptionId.USE_CONNECTIONS && !(canUseConnections = (faction = this.intel.getFaction()).isAtWorst("player", MIN_REP))) {
            this.options.setEnabled((Object)OptionId.CONFIRM, false);
            this.options.setTooltip((Object)OptionId.CONFIRM, "\u58f0\u671b\u4e0d\u8db3\u3002");
        }
    }

    public void printInit() {
        TooltipMakerAPI info = this.textPanel.beginTooltip();
        info.setParaSmallInsignia();
        this.intel.addInitialDescSection(info, 0.0f);
        this.textPanel.addTooltip();
        this.textPanel.addPara("\u7531\u4e8e\u8be5\u884c\u52a8\u76ee\u524d\u5904\u4e8e\u7b79\u5212\u9636\u6bb5\uff0c\u6240\u4ee5\u4f60\u4ecd\u53ef\u91c7\u7528\u591a\u79cd\u63aa\u65bd\u6765\u8ba9\u6b64\u6b21\u8fdc\u5f81\u5f7b\u5e95\u5931\u8d25\u3002");
    }

    @Override
    public void optionSelected(String text, Object optionData) {
        if (optionData == null) {
            return;
        }
        OptionId option = (OptionId)((Object)optionData);
        if (text != null) {
            this.dialog.addOptionSelectedText((Object)option);
        }
        switch (option) {
            case INIT: {
                this.printInit();
                this.addChoiceOptions();
                break;
            }
            case BRIBE: {
                this.beingConfirmed = OptionId.BRIBE;
                this.addConfirmOptions();
                break;
            }
            case USE_CONNECTIONS: {
                this.beingConfirmed = OptionId.USE_CONNECTIONS;
                this.addConfirmOptions();
                break;
            }
            case CONFIRM: {
                if (this.beingConfirmed == OptionId.BRIBE) {
                    int bribe = this.computeBribeAmount();
                    AddRemoveCommodity.addCreditsLossText(bribe, this.textPanel);
                    this.playerFleet.getCargo().getCredits().subtract(bribe);
                } else if (this.beingConfirmed == OptionId.USE_CONNECTIONS) {
                    CoreReputationPlugin.CustomRepImpact impact = new CoreReputationPlugin.CustomRepImpact();
                    impact.delta = -REP_COST;
                    ReputationActionResponsePlugin.ReputationAdjustmentResult reputationAdjustmentResult = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, this.textPanel, false, true), this.intel.getFaction().getId());
                }
                this.intel.getOrganizeStage().abort();
                this.intel.setOutcome(PunitiveExpeditionIntel.PunExOutcome.AVERTED);
                this.intel.forceFail(false);
                this.intel.sendUpdate(PunitiveExpeditionIntel.OUTCOME_UPDATE, this.textPanel);
                this.addDismissOption();
                break;
            }
            case CANCEL: {
                this.addChoiceOptions();
                break;
            }
            case LEAVE: {
                this.leave();
            }
        }
    }

    protected void leave() {
        this.dialog.dismiss();
        this.ui.updateUIForItem(this.intel);
    }

    @Override
    public void optionMousedOver(String optionText, Object optionData) {
    }

    @Override
    public void advance(float amount) {
    }

    @Override
    public Object getContext() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum OptionId {
        INIT,
        USE_CONNECTIONS,
        BRIBE,
        LEAVE,
        CONFIRM,
        CANCEL;

    }
}

