/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.punitive;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.ReputationActionResponsePlugin;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParamsV3;
import com.fs.starfarer.api.impl.campaign.fleets.RouteLocationCalculator;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.punitive.PEActionStage;
import com.fs.starfarer.api.impl.campaign.intel.punitive.PEAssembleStage;
import com.fs.starfarer.api.impl.campaign.intel.punitive.PEAvertInteractionDialogPluginImpl;
import com.fs.starfarer.api.impl.campaign.intel.punitive.PEOrganizeStage;
import com.fs.starfarer.api.impl.campaign.intel.punitive.PEReturnStage;
import com.fs.starfarer.api.impl.campaign.intel.punitive.PETravelStage;
import com.fs.starfarer.api.impl.campaign.intel.punitive.PunitiveExpeditionManager;
import com.fs.starfarer.api.impl.campaign.intel.raid.RaidAssignmentAI;
import com.fs.starfarer.api.impl.campaign.intel.raid.RaidIntel;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RouteFleetAssignmentAI;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.ButtonAPI;
import com.fs.starfarer.api.ui.IntelUIAPI;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Random;
import java.util.Set;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PunitiveExpeditionIntel
extends RaidIntel
implements RaidIntel.RaidDelegate {
    public static final String BUTTON_AVERT = "BUTTON_CHANGE_ORDERS";
    public static float REP_PENALTY = 0.05f;
    public static final Object ENTERED_SYSTEM_UPDATE = new Object();
    public static final Object OUTCOME_UPDATE = new Object();
    protected PEActionStage action;
    protected PunitiveExpeditionManager.PunExGoal goal;
    protected MarketAPI target;
    protected MarketAPI from;
    protected PunExOutcome outcome;
    protected Random random = new Random();
    protected PunitiveExpeditionManager.PunExReason bestReason;
    protected Industry targetIndustry;
    protected FactionAPI targetFaction;
    protected transient ReputationActionResponsePlugin.ReputationAdjustmentResult repResult = null;
    protected transient String targetOwner = null;

    public PunitiveExpeditionIntel(FactionAPI faction, MarketAPI from, MarketAPI target, float expeditionFP, float organizeDuration, PunitiveExpeditionManager.PunExGoal goal, Industry targetIndustry, PunitiveExpeditionManager.PunExReason bestReason) {
        super(target.getStarSystem(), faction, null);
        this.goal = goal;
        this.targetIndustry = targetIndustry;
        this.bestReason = bestReason;
        this.delegate = this;
        this.from = from;
        this.target = target;
        this.targetFaction = target.getFaction();
        SectorEntityToken gather = from.getPrimaryEntity();
        JumpPointAPI raidJump = RouteLocationCalculator.findJumpPointToUse(this.getFactionForUIColors(), target.getPrimaryEntity());
        if (gather == null || raidJump == null) {
            this.endImmediately();
            return;
        }
        float orgDur = organizeDuration;
        if (DebugFlags.PUNITIVE_EXPEDITION_DEBUG || DebugFlags.FAST_RAIDS) {
            orgDur = 0.5f;
        }
        this.addStage(new PEOrganizeStage(this, from, orgDur));
        float successMult = 0.5f;
        PEAssembleStage assemble = new PEAssembleStage(this, gather);
        assemble.addSource(from);
        assemble.setSpawnFP(expeditionFP);
        assemble.setAbortFP(expeditionFP * successMult);
        this.addStage(assemble);
        PETravelStage travel = new PETravelStage(this, gather, raidJump, false);
        travel.setAbortFP(expeditionFP * successMult);
        this.addStage(travel);
        this.action = new PEActionStage(this, target);
        this.action.setAbortFP(expeditionFP * successMult);
        this.addStage(this.action);
        this.addStage(new PEReturnStage(this));
        this.setImportant(true);
        Global.getSector().getIntelManager().addIntel(this);
    }

    public void applyRepPenalty() {
        CoreReputationPlugin.CustomRepImpact impact = new CoreReputationPlugin.CustomRepImpact();
        impact.delta = -REP_PENALTY;
        this.repResult = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, null, false, false), this.getFaction().getId());
    }

    public Random getRandom() {
        return this.random;
    }

    public MarketAPI getTarget() {
        return this.target;
    }

    public FactionAPI getTargetFaction() {
        return this.targetFaction;
    }

    public MarketAPI getFrom() {
        return this.from;
    }

    @Override
    public RouteFleetAssignmentAI createAssignmentAI(CampaignFleetAPI \u652f\u8230\u961f, RouteManager.RouteData route) {
        RaidAssignmentAI raidAI = new RaidAssignmentAI(\u652f\u8230\u961f, route, this.action);
        return raidAI;
    }

    @Override
    protected void advanceImpl(float amount) {
        super.advanceImpl(amount);
        if (this.target != null && this.targetOwner == null) {
            this.targetOwner = this.target.getFactionId();
        }
        if (this.failStage < 0 && this.targetOwner != null && this.target != null && !this.targetOwner.equals(this.target.getFactionId())) {
            this.forceFail(false);
        }
    }

    public void sendOutcomeUpdate() {
        this.sendUpdateIfPlayerHasIntel(OUTCOME_UPDATE, false);
    }

    @Override
    public void sendEnteredSystemUpdate() {
        this.sendUpdateIfPlayerHasIntel(ENTERED_SYSTEM_UPDATE, false);
    }

    @Override
    public String getName() {
        String base = String.valueOf(Misc.ucFirst(this.faction.getPersonNamePrefix())) + " \u8fdc\u5f81\u519b";
        if (this.isEnding()) {
            if (this.outcome == PunExOutcome.AVERTED) {
                return String.valueOf(base) + " - \u907f\u514d";
            }
            if (this.isSendingUpdate() && this.isFailed()) {
                return String.valueOf(base) + " - \u5931\u8d25";
            }
            if (this.isSucceeded() || this.outcome == PunExOutcome.SUCCESS) {
                return String.valueOf(base) + " - \u6210\u529f";
            }
            if (this.outcome == PunExOutcome.RAID_FAIL || this.outcome == PunExOutcome.BOMBARD_FAIL || this.outcome == PunExOutcome.COLONY_NO_LONGER_EXISTS || this.outcome == PunExOutcome.TASK_FORCE_DEFEATED) {
                return String.valueOf(base) + " - \u5931\u8d25";
            }
        }
        return base;
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        float eta;
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean isUpdate = this.getListInfoParam() != null;
        this.getListInfoParam();
        if (this.getListInfoParam() == ENTERED_SYSTEM_UPDATE) {
            FactionAPI other = this.target.getFaction();
            info.addPara("\u76ee\u6807\uff1a%s", initPad, tc, other.getBaseUIColor(), this.target.getName());
            initPad = 0.0f;
            info.addPara("\u5df2\u62b5\u8fbe\u76ee\u6807\u661f\u7cfb", tc, initPad);
            if (this.repResult != null) {
                initPad = 0.0f;
                CoreReputationPlugin.addAdjustmentMessage(this.repResult.delta, this.faction, null, null, null, info, tc, isUpdate, initPad);
            }
            return;
        }
        FactionAPI other = this.targetFaction;
        if (this.outcome != null) {
            if (this.outcome == PunExOutcome.TASK_FORCE_DEFEATED) {
                info.addPara("\u8fdc\u5f81\u519b\u6218\u8d25", tc, initPad);
            } else if (this.outcome == PunExOutcome.COLONY_NO_LONGER_EXISTS) {
                info.addPara("\u8fdc\u5f81\u884c\u52a8\u4e2d\u6b62", tc, initPad);
            } else if (this.outcome == PunExOutcome.AVERTED) {
                info.addPara("\u8fdc\u5f81\u8ba1\u5212\u5931\u8d25", initPad, tc, other.getBaseUIColor(), this.target.getName());
            } else if (this.outcome == PunExOutcome.BOMBARD_FAIL) {
                info.addPara("\u8f70\u70b8 %s \u5931\u8d25", initPad, tc, other.getBaseUIColor(), this.target.getName());
            } else if (this.outcome == PunExOutcome.RAID_FAIL) {
                info.addPara("\u7a81\u88ad %s \u5931\u8d25", initPad, tc, other.getBaseUIColor(), this.target.getName());
            } else if (this.outcome == PunExOutcome.SUCCESS) {
                if (this.goal == PunitiveExpeditionManager.PunExGoal.BOMBARD) {
                    if (!this.target.isInEconomy()) {
                        info.addPara("%s \u88ab\u8f70\u70b8\u6467\u6bc1", initPad, tc, other.getBaseUIColor(), this.target.getName());
                    } else {
                        info.addPara("\u8f70\u70b8 %s \u6210\u529f", initPad, tc, other.getBaseUIColor(), this.target.getName());
                    }
                } else if (this.targetIndustry != null && this.targetIndustry.getDisruptedDays() >= 2.0f) {
                    info.addPara(String.valueOf(this.targetIndustry.getCurrentName()) + " \u88ab\u762b\u75ea\u4e86 %s \u5929", initPad, tc, h, "" + Math.round(this.targetIndustry.getDisruptedDays()));
                }
            }
            if (this.repResult != null) {
                initPad = 0.0f;
                CoreReputationPlugin.addAdjustmentMessage(this.repResult.delta, this.faction, null, null, null, info, tc, isUpdate, initPad);
            }
            return;
        }
        info.addPara("\u76ee\u6807\uff1a%s", initPad, tc, other.getBaseUIColor(), this.target.getName());
        initPad = 0.0f;
        if (this.goal == PunitiveExpeditionManager.PunExGoal.BOMBARD) {
            String goalStr = "\u9971\u548c\u8f70\u70b8";
            info.addPara("\u76ee\u7684\uff1a%s", initPad, tc, Misc.getNegativeHighlightColor(), goalStr);
        }
        if ((eta = this.getETA()) > 1.0f && !this.isEnding()) {
            String days = PunitiveExpeditionIntel.getDaysString(eta);
            info.addPara("\u9884\u8ba1 %s " + days + " \u540e\u5230\u8fbe", initPad, tc, h, "" + Math.round(eta));
            initPad = 0.0f;
        } else if (!this.isEnding() && this.action.getElapsed() > 0.0f) {
            info.addPara("\u76ee\u524d\u6b63\u5728\u76ee\u6807\u661f\u7cfb", tc, initPad);
            initPad = 0.0f;
        }
        if (this.repResult != null) {
            initPad = 0.0f;
            CoreReputationPlugin.addAdjustmentMessage(this.repResult.delta, this.faction, null, null, null, info, tc, isUpdate, initPad);
        }
        this.unindent(info);
    }

    @Override
    public PEActionStage getActionStage() {
        for (RaidIntel.RaidStage stage : this.stages) {
            if (!(stage instanceof PEActionStage)) continue;
            return (PEActionStage)stage;
        }
        return null;
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        super.createIntelInfo(info, mode);
    }

    public void addInitialDescSection(TooltipMakerAPI info, float initPad) {
        Color h = Misc.getHighlightColor();
        float opad = 10.0f;
        FactionAPI faction = this.getFaction();
        String is = faction.getDisplayNameIsOrAre();
        String goalDesc = "";
        String goalHL = "";
        Color goalColor = Misc.getTextColor();
        switch (this.goal) {
            case RAID_PRODUCTION: {
                goalDesc = "\u762b\u75ea\u8be5\u6b96\u6c11\u5730\u7684" + this.targetIndustry.getCurrentName();
                break;
            }
            case RAID_SPACEPORT: {
                goalDesc = "\u7a81\u88ad\u8be5\u6b96\u6c11\u5730\u7684 " + this.targetIndustry.getCurrentName() + " , \u4ee5\u4f7f\u5176\u762b\u75ea";
                break;
            }
            case BOMBARD: {
                goalDesc = "\u5bf9\u8be5\u6b96\u6c11\u5730\u5b9e\u65bd\u9971\u548c\u8f70\u70b8";
                goalHL = "\u5bf9\u8be5\u6b96\u6c11\u5730\u5b9e\u65bd\u9971\u548c\u8f70\u70b8";
                goalColor = Misc.getNegativeHighlightColor();
            }
        }
        String strDesc = this.getRaidStrDesc();
        int numFleets = (int)this.getOrigNumFleets();
        String \u652f\u8230\u961f = "\u652f\u8230\u961f";
        if (numFleets == 1) {
            \u652f\u8230\u961f = "\u652f\u8230\u961f";
        }
        if (this.outcome == null) {
            LabelAPI label = info.addPara(String.valueOf(Misc.ucFirst(faction.getDisplayNameWithArticle())) + " " + is + "\u5411 %s \u6d3e\u9063\u4e86\u652f " + strDesc + " \u7684\u8fdc\u5f81\u519b\uff0c\u9884\u8ba1\u6709 " + numFleets + " " + \u652f\u8230\u961f + ". " + "\u76ee\u6807\u662f\uff1a" + goalDesc + ".", initPad, faction.getBaseUIColor(), this.target.getName());
            label.setHighlight(faction.getDisplayNameWithArticleWithoutArticle(), this.target.getName(), strDesc, "" + numFleets, goalHL);
            label.setHighlightColors(faction.getBaseUIColor(), this.targetFaction.getBaseUIColor(), h, h, goalColor);
        } else {
            LabelAPI label = info.addPara(String.valueOf(Misc.ucFirst(faction.getDisplayNameWithArticle())) + " " + is + "\u5411 %s \u6d3e\u9063\u4e86\u4e00\u652f\u8fdc\u5f81\u519b\u3002" + "\u76ee\u6807\u662f\uff1a" + goalDesc + ".", initPad, faction.getBaseUIColor(), this.target.getName());
            label.setHighlight(faction.getDisplayNameWithArticleWithoutArticle(), this.target.getName(), goalHL);
            label.setHighlightColors(faction.getBaseUIColor(), this.targetFaction.getBaseUIColor(), goalColor);
        }
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        info.addImage(this.getFactionForUIColors().getLogo(), width, 128.0f, opad);
        FactionAPI faction = this.getFaction();
        String has = faction.getDisplayNameHasOrHave();
        String is = faction.getDisplayNameIsOrAre();
        this.addInitialDescSection(info, opad);
        if (this.bestReason.type == PunitiveExpeditionManager.PunExType.ANTI_COMPETITION && this.bestReason.commodityId != null) {
            CommoditySpecAPI spec = Global.getSettings().getCommoditySpec(this.bestReason.commodityId);
            info.addPara("\u6b64\u6b21\u8fdc\u5f81\u7684\u4e3b\u8981\u52a8\u673a\u662f\u76ee\u6807\u6b96\u6c11\u5730\u5728\u51fa\u53e3\u4e0b\u5217\u8d27\u7269\u65f6\u5360\u636e\u4e86\u53ef\u89c2\u7684\u5e02\u573a\u4efd\u989d " + spec.getName() + ".", opad);
        } else if (this.bestReason.type == PunitiveExpeditionManager.PunExType.ANTI_FREE_PORT) {
            info.addPara("\u6b64\u6b21\u8fdc\u5f81\u7684\u4e3b\u8981\u52a8\u673a\u662f\u76ee\u6807\u6b96\u6c11\u5730\u7684 \"\u81ea\u7531\u6e2f\" \u6027\u8d28\uff0c\u4ee5\u53ca\u8be5\u6b96\u6c11\u5730\u4f5c\u4e3a\u975e\u6cd5\u8d27\u7269\u4ee5\u53ca\u95ee\u9898\u4eba\u58eb\u6d41\u901a\u85cf\u533f\u4e4b\u6240\u7684\u60c5\u51b5\u3002", opad);
        } else if (this.bestReason.type == PunitiveExpeditionManager.PunExType.TERRITORIAL) {
            info.addPara("\u6b64\u6b21\u8fdc\u5f81\u7684\u4e3b\u8981\u52a8\u673a\u662f\u76ee\u6807\u6b96\u6c11\u5730\u5efa\u7acb\u4e8e\u5df2\u88ab\u4e0b\u5217\u52bf\u529b\u5360\u636e\u7684\u533a\u57df " + faction.getDisplayNameWithArticle() + ".", opad);
        }
        if (this.outcome == null) {
            this.addStandardStrengthComparisons(info, this.target, this.targetFaction, this.goal != PunitiveExpeditionManager.PunExGoal.BOMBARD, this.goal == PunitiveExpeditionManager.PunExGoal.BOMBARD, "\u8fdc\u5f81", "\u8fdc\u5f81");
        }
        info.addSectionHeading("\u5f62\u52bf", faction.getBaseUIColor(), faction.getDarkUIColor(), Alignment.MID, opad);
        for (RaidIntel.RaidStage stage : this.stages) {
            stage.showStageInfo(info);
            if (this.getStageIndex(stage) == this.failStage) break;
        }
        if (this.getCurrentStage() == 0 && !this.isFailed()) {
            FactionAPI pf = Global.getSector().getPlayerFaction();
            ButtonAPI button = info.addButton("\u5e94\u5bf9\u63aa\u65bd", BUTTON_AVERT, pf.getBaseUIColor(), pf.getDarkUIColor(), (int)width, 20.0f, opad * 2.0f);
            button.setShortcut(20, true);
        }
        if (!this.from.getFaction().isHostileTo(this.targetFaction) && !this.isFailed()) {
            LabelAPI label = info.addPara("\u6b64\u6b21\u884c\u52a8\u662f\u5728\u6ca1\u6709\u6b63\u5f0f\u5ba3\u6218\u7684\u60c5\u51b5\u4e0b\u8fdb\u884c\u3002\u51fb\u8d25\u8fdc\u5f81\u519b\u6307\u4f1a\u7a0d\u5fae\u964d\u4f4e\u548c\u4e0b\u5217\u52bf\u529b\u7684\u5173\u7cfb" + faction.getDisplayNameWithArticle() + ".", Misc.getGrayColor(), opad);
            label.setHighlight(faction.getDisplayNameWithArticleWithoutArticle());
            label.setHighlightColors(faction.getBaseUIColor());
        }
    }

    @Override
    public void sendUpdateIfPlayerHasIntel(Object listInfoParam, boolean onlyIfImportant, boolean sendIfHidden) {
        if (listInfoParam == UPDATE_RETURNING) {
            return;
        }
        if (listInfoParam == UPDATE_FAILED) {
            this.applyRepPenalty();
        }
        super.sendUpdateIfPlayerHasIntel(listInfoParam, onlyIfImportant, sendIfHidden);
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Military");
        tags.add("Colony threats");
        tags.add(this.getFaction().getId());
        return tags;
    }

    @Override
    public void notifyRaidEnded(RaidIntel raid, RaidIntel.RaidStageStatus status) {
        PunitiveExpeditionManager.PunExData data;
        if (this.outcome == null && this.failStage >= 0) {
            this.outcome = !this.target.isInEconomy() || !this.target.isPlayerOwned() ? PunExOutcome.COLONY_NO_LONGER_EXISTS : PunExOutcome.TASK_FORCE_DEFEATED;
        }
        if ((data = PunitiveExpeditionManager.getInstance().getDataFor(this.faction)) != null && this.outcome == PunExOutcome.SUCCESS) {
            ++data.numSuccesses;
        }
    }

    @Override
    public String getIcon() {
        return this.faction.getCrest();
    }

    public PunitiveExpeditionManager.PunExGoal getGoal() {
        return this.goal;
    }

    public Industry getTargetIndustry() {
        return this.targetIndustry;
    }

    public PunExOutcome getOutcome() {
        return this.outcome;
    }

    public void setOutcome(PunExOutcome outcome) {
        this.outcome = outcome;
    }

    @Override
    public CampaignFleetAPI spawnFleet(RouteManager.RouteData route) {
        Random random = route.getRandom();
        MarketAPI market = route.getMarket();
        CampaignFleetAPI \u652f\u8230\u961f = this.createFleet(market.getFactionId(), route, market, null, random);
        if (\u652f\u8230\u961f == null || \u652f\u8230\u961f.isEmpty()) {
            return null;
        }
        market.getContainingLocation().addEntity(\u652f\u8230\u961f);
        \u652f\u8230\u961f.setFacing((float)Math.random() * 360.0f);
        \u652f\u8230\u961f.setLocation(market.getPrimaryEntity().getLocation().x, market.getPrimaryEntity().getLocation().x);
        \u652f\u8230\u961f.addScript(this.createAssignmentAI(\u652f\u8230\u961f, route));
        return \u652f\u8230\u961f;
    }

    @Override
    public CampaignFleetAPI createFleet(String factionId, RouteManager.RouteData route, MarketAPI market, Vector2f locInHyper, Random random) {
        if (random == null) {
            random = new Random();
        }
        RouteManager.OptionalFleetData extra = route.getExtra();
        float combat = extra.fp.floatValue();
        float tanker = extra.fp.floatValue() * (0.1f + random.nextFloat() * 0.05f);
        float transport = extra.fp.floatValue() * (0.1f + random.nextFloat() * 0.05f);
        float freighter = 0.0f;
        if (this.goal == PunitiveExpeditionManager.PunExGoal.BOMBARD) {
            tanker += transport;
        } else {
            transport += tanker / 2.0f;
            tanker *= 0.5f;
        }
        combat -= tanker;
        FleetParamsV3 params = new FleetParamsV3(market, locInHyper, factionId, route == null ? null : route.getQualityOverride(), extra.fleetType, combat -= transport, freighter, tanker, transport, 0.0f, 0.0f, 0.0f);
        if (route != null) {
            params.timestamp = route.getTimestamp();
        }
        params.random = random;
        CampaignFleetAPI \u652f\u8230\u961f = FleetFactoryV3.createFleet(params);
        if (\u652f\u8230\u961f == null || \u652f\u8230\u961f.isEmpty()) {
            return null;
        }
        \u652f\u8230\u961f.getMemoryWithoutUpdate().set("$isWarFleet", true);
        \u652f\u8230\u961f.getMemoryWithoutUpdate().set("$isRaider", true);
        if (\u652f\u8230\u961f.getFaction().getCustomBoolean("pirateBehavior")) {
            \u652f\u8230\u961f.getMemoryWithoutUpdate().set("$isPirate", true);
        }
        String postId = Ranks.POST_PATROL_COMMANDER;
        String rankId = Ranks.SPACE_COMMANDER;
        \u652f\u8230\u961f.getCommander().setPostId(postId);
        \u652f\u8230\u961f.getCommander().setRankId(rankId);
        Misc.makeNoRepImpact(\u652f\u8230\u961f, "punex");
        Misc.makeHostile(\u652f\u8230\u961f);
        return \u652f\u8230\u961f;
    }

    @Override
    public void buttonPressConfirmed(Object buttonId, IntelUIAPI ui) {
        if (buttonId == BUTTON_AVERT) {
            ui.showDialog(null, new PEAvertInteractionDialogPluginImpl(this, ui));
        }
    }

    public PunitiveExpeditionManager.PunExReason getBestReason() {
        return this.bestReason;
    }

    public boolean isTerritorial() {
        return this.bestReason != null && this.bestReason.type == PunitiveExpeditionManager.PunExType.TERRITORIAL;
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        if (this.target != null && this.target.isInEconomy() && this.target.getPrimaryEntity() != null) {
            return this.target.getPrimaryEntity();
        }
        return super.getMapLocation(map);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PunExOutcome {
        TASK_FORCE_DEFEATED,
        COLONY_NO_LONGER_EXISTS,
        SUCCESS,
        BOMBARD_FAIL,
        RAID_FAIL,
        AVERTED;

    }
}

