/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.punitive;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.econ.CommodityMarketDataAPI;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.intel.punitive.PunitiveExpeditionIntel;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PunitiveExpeditionManager
implements EveryFrameScript {
    public static final String KEY = "$core_punitiveExpeditionManager";
    public static int MAX_CONCURRENT = Global.getSettings().getInt("punExMaxConcurrent");
    public static float PROB_TIMEOUT_PER_SENT = Global.getSettings().getFloat("punExProbTimeoutPerExpedition");
    public static float MIN_TIMEOUT = Global.getSettings().getFloatFromArray("punExTimeoutDays", 0);
    public static float MAX_TIMEOUT = Global.getSettings().getFloatFromArray("punExTimeoutDays", 1);
    public static int MIN_COLONY_SIZE_FOR_NON_TERRITORIAL = Global.getSettings().getInt("punExMinColonySizeForNonTerritorial");
    public static float TARGET_NUMBER_FOR_FREQUENCY = 5.0f;
    public static float ANGER_BUILDUP_MULT = 0.5f;
    public static int FACTION_MUST_BE_IN_TOP_X_PRODUCERS = 3;
    public static float PLAYER_FRACTION_TO_NOTICE = 0.5f;
    public static float MAX_THRESHOLD = 600.0f;
    protected float timeout = 0.0f;
    protected int numSentSinceTimeout = 0;
    protected LinkedHashMap<FactionAPI, PunExData> data = new LinkedHashMap();
    public static float COMPETITION_PRODUCTION_MULT = 20.0f;
    public static float ILLEGAL_GOODS_MULT = 3.0f;
    public static float FREE_PORT_SIZE_MULT = 5.0f;
    public static float TERRITORIAL_ANGER = 500.0f;

    public static PunitiveExpeditionManager getInstance() {
        Object test = Global.getSector().getMemoryWithoutUpdate().get(KEY);
        return (PunitiveExpeditionManager)test;
    }

    public PunitiveExpeditionManager() {
        Global.getSector().getMemoryWithoutUpdate().set(KEY, this);
    }

    protected Object readResolve() {
        return this;
    }

    public PunExData getDataFor(FactionAPI faction) {
        return this.data.get(faction);
    }

    public LinkedHashMap<FactionAPI, PunExData> getData() {
        return this.data;
    }

    @Override
    public void advance(float amount) {
        float days = Misc.getDays(amount);
        HashSet<FactionAPI> seen = new HashSet<FactionAPI>();
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsInGroup(null)) {
            FactionAPI faction = market.getFaction();
            if (Misc.getCommissionFaction() == faction) continue;
            if (seen.contains(faction) || this.data.containsKey(faction)) {
                seen.add(faction);
                continue;
            }
            JSONObject json = faction.getCustomJSONObject("punitiveExpeditionData");
            if (json == null) continue;
            PunExData curr = new PunExData();
            curr.faction = faction;
            this.data.put(faction, curr);
            seen.add(faction);
        }
        this.data.keySet().retainAll(seen);
        if (this.timeout > 0.0f) {
            this.timeout -= days * (DebugFlags.PUNITIVE_EXPEDITION_DEBUG ? 1000.0f : 1.0f);
            if (this.timeout <= 0.0f) {
                this.timeout = 0.0f;
                this.numSentSinceTimeout = 0;
            }
            return;
        }
        boolean first = true;
        for (PunExData curr : this.data.values()) {
            if (first && DebugFlags.PUNITIVE_EXPEDITION_DEBUG) {
                days *= 1000.0f;
                curr.timeout = 0.0f;
                curr.anger = 1000.0f;
            }
            first = false;
            if (curr.intel != null) {
                if (curr.intel.isEnded()) {
                    PunitiveExpeditionIntel intel;
                    curr.timeout = 100.0f + 100.0f * curr.random.nextFloat();
                    if (curr.intel instanceof PunitiveExpeditionIntel && !(intel = (PunitiveExpeditionIntel)curr.intel).isTerritorial()) {
                        curr.timeout += this.getExtraTimeout(curr);
                    }
                    curr.intel = null;
                }
            } else {
                curr.timeout -= days;
                if (curr.timeout <= 0.0f) {
                    curr.timeout = 0.0f;
                }
            }
            curr.tracker.advance(days);
            if (!curr.tracker.intervalElapsed() || curr.intel != null || !(curr.timeout <= 0.0f)) continue;
            this.checkExpedition(curr);
        }
    }

    public float getExtraTimeout(PunExData d) {
        float total = 0.0f;
        for (PunExData curr : this.data.values()) {
            List<MarketAPI> markets;
            JSONObject json = curr.faction.getCustom().optJSONObject("punitiveExpeditionData");
            if (json == null || (markets = Misc.getFactionMarkets(curr.faction, null)).isEmpty()) continue;
            boolean vsCompetitors = json.optBoolean("vsCompetitors", false);
            boolean vsFreePort = json.optBoolean("vsFreePort", false);
            boolean territorial = json.optBoolean("territorial", false);
            if (!vsCompetitors && !vsFreePort) continue;
            total += 1.0f;
        }
        return Math.min(10.0f, Math.max(0.0f, total - TARGET_NUMBER_FOR_FREQUENCY)) * (MIN_TIMEOUT * 0.9f + MIN_TIMEOUT * 0.9f * d.random.nextFloat());
    }

    public int getOngoing() {
        int ongoing = 0;
        for (PunExData d : this.data.values()) {
            if (d.intel == null) continue;
            ++ongoing;
        }
        return ongoing;
    }

    protected void checkExpedition(PunExData curr) {
        JSONObject json = curr.faction.getCustom().optJSONObject("punitiveExpeditionData");
        if (json == null) {
            return;
        }
        List<PunExReason> reasons = this.getExpeditionReasons(curr);
        float total = 0.0f;
        for (PunExReason reason : reasons) {
            total += reason.weight;
        }
        curr.anger += (total *= ANGER_BUILDUP_MULT) * (0.25f + curr.random.nextFloat() * 0.75f);
        if (curr.anger >= curr.threshold) {
            if (this.getOngoing() >= MAX_CONCURRENT) {
                curr.anger = 0.0f;
            } else {
                this.createExpedition(curr);
            }
        }
    }

    public List<PunExReason> getExpeditionReasons(PunExData curr) {
        ArrayList<PunExReason> result = new ArrayList<PunExReason>();
        JSONObject json = curr.faction.getCustom().optJSONObject("punitiveExpeditionData");
        if (json == null) {
            return result;
        }
        List<MarketAPI> markets = Misc.getFactionMarkets(curr.faction, null);
        if (markets.isEmpty()) {
            return result;
        }
        boolean vsCompetitors = json.optBoolean("vsCompetitors", false);
        boolean vsFreePort = json.optBoolean("vsFreePort", false);
        boolean territorial = json.optBoolean("territorial", false);
        MarketAPI test = markets.get(0);
        FactionAPI player = Global.getSector().getPlayerFaction();
        if (vsCompetitors) {
            for (CommodityOnMarketAPI com : test.getAllCommodities()) {
                CommodityMarketDataAPI cmd;
                if (com.isNonEcon() || curr.faction.isIllegal(com.getId()) || (cmd = com.getCommodityMarketData()).getMarketValue() <= 0.0f) continue;
                Map<FactionAPI, Integer> shares = cmd.getMarketSharePercentPerFaction();
                int numHigher = 0;
                int factionShare = (Integer)shares.get(curr.faction);
                if (factionShare <= 0) continue;
                for (FactionAPI faction : shares.keySet()) {
                    if (curr.faction == faction || (Integer)shares.get(faction) <= factionShare) continue;
                    ++numHigher;
                }
                if (numHigher >= FACTION_MUST_BE_IN_TOP_X_PRODUCERS) continue;
                int playerShare = cmd.getMarketSharePercent(player);
                float threshold = PLAYER_FRACTION_TO_NOTICE;
                if (DebugFlags.PUNITIVE_EXPEDITION_DEBUG) {
                    threshold = 0.1f;
                }
                if ((float)playerShare < (float)factionShare * threshold || playerShare <= 0) continue;
                PunExReason reason = new PunExReason(PunExType.ANTI_COMPETITION);
                reason.weight = (float)playerShare / (float)factionShare * COMPETITION_PRODUCTION_MULT;
                reason.commodityId = com.getId();
                result.add(reason);
            }
        }
        if (vsFreePort) {
            for (MarketAPI market : Global.getSector().getEconomy().getMarketsInGroup(null)) {
                if (!market.isPlayerOwned() || !market.isFreePort() || market.isInHyperspace()) continue;
                for (CommodityOnMarketAPI com : test.getAllCommodities()) {
                    int playerShare;
                    CommodityMarketDataAPI cmd;
                    if (com.isNonEcon() || !curr.faction.isIllegal(com.getId()) || (cmd = com.getCommodityMarketData()).getMarketValue() <= 0.0f || (playerShare = cmd.getMarketSharePercent(player)) <= 0) continue;
                    PunExReason reason = new PunExReason(PunExType.ANTI_FREE_PORT);
                    reason.weight = (float)playerShare * ILLEGAL_GOODS_MULT;
                    reason.commodityId = com.getId();
                    reason.marketId = market.getId();
                    result.add(reason);
                }
                if (!market.isFreePort()) continue;
                PunExReason reason = new PunExReason(PunExType.ANTI_FREE_PORT);
                reason.weight = (float)Math.max(1, market.getSize() - 2) * FREE_PORT_SIZE_MULT;
                reason.marketId = market.getId();
                result.add(reason);
            }
        }
        if (territorial) {
            int maxSize = MarketCMD.getBombardDestroyThreshold();
            for (MarketAPI market : Global.getSector().getEconomy().getMarketsInGroup(null)) {
                FactionAPI claimedBy;
                boolean destroy;
                if (!market.isPlayerOwned() || market.isInHyperspace()) continue;
                boolean bl = destroy = market.getSize() <= maxSize;
                if (!destroy || (claimedBy = Misc.getClaimingFaction(market.getPrimaryEntity())) != curr.faction) continue;
                PunExReason reason = new PunExReason(PunExType.TERRITORIAL);
                reason.weight = TERRITORIAL_ANGER;
                reason.marketId = market.getId();
                result.add(reason);
            }
        }
        return result;
    }

    public void createExpedition(PunExData curr) {
        this.createExpedition(curr, null);
    }

    public void createExpedition(PunExData curr, Integer fpOverride) {
        JSONObject json = curr.faction.getCustom().optJSONObject("punitiveExpeditionData");
        if (json == null) {
            return;
        }
        boolean canBombard = json.optBoolean("canBombard", false);
        List<PunExReason> reasons = this.getExpeditionReasons(curr);
        WeightedRandomPicker<PunExReason> reasonPicker = new WeightedRandomPicker<PunExReason>(curr.random);
        for (PunExReason r : reasons) {
            reasonPicker.add(r, r.weight);
        }
        PunExReason reason = (PunExReason)reasonPicker.pick();
        if (reason == null) {
            return;
        }
        WeightedRandomPicker<MarketAPI> targetPicker = new WeightedRandomPicker<MarketAPI>(curr.random);
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (!market.isPlayerOwned() || market.isInHyperspace()) continue;
            float weight = 0.0f;
            if (reason.type == PunExType.ANTI_COMPETITION && reason.commodityId != null) {
                if (market.getSize() < MIN_COLONY_SIZE_FOR_NON_TERRITORIAL) continue;
                CommodityOnMarketAPI com = market.getCommodityData(reason.commodityId);
                int share = com.getCommodityMarketData().getExportMarketSharePercent(market);
                weight += (float)(share * share);
            } else if (reason.type == PunExType.ANTI_FREE_PORT && market.getId().equals(reason.marketId)) {
                if (market.getSize() < MIN_COLONY_SIZE_FOR_NON_TERRITORIAL) continue;
                weight = 1.0f;
            } else if (reason.type == PunExType.TERRITORIAL && market.getId().equals(reason.marketId)) {
                weight = 1.0f;
            }
            targetPicker.add(market, weight);
        }
        MarketAPI target = (MarketAPI)targetPicker.pick();
        if (target == null) {
            return;
        }
        WeightedRandomPicker<MarketAPI> picker = new WeightedRandomPicker<MarketAPI>(curr.random);
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsInGroup(null)) {
            boolean canSendWithoutMilitaryBase = json.optBoolean("canSendWithoutMilitaryBase", false);
            boolean military = market.getMemoryWithoutUpdate().getBoolean("$military");
            if (market.getFaction() != curr.faction || !military && !canSendWithoutMilitaryBase) continue;
            float w = 1.0f;
            if (military) {
                w *= 10.0f;
            }
            picker.add(market, (float)market.getSize() * w);
        }
        MarketAPI from = (MarketAPI)picker.pick();
        if (from == null) {
            return;
        }
        PunExGoal goal = null;
        Industry industry = null;
        if (reason.type == PunExType.ANTI_FREE_PORT) {
            goal = PunExGoal.RAID_SPACEPORT;
            if (canBombard && curr.numSuccesses >= 2) {
                goal = PunExGoal.BOMBARD;
            }
        } else if (reason.type == PunExType.TERRITORIAL) {
            goal = PunExGoal.BOMBARD;
        } else {
            goal = PunExGoal.RAID_PRODUCTION;
            if (reason.commodityId == null || curr.numSuccesses >= 1) {
                goal = PunExGoal.RAID_SPACEPORT;
            }
            if (canBombard && curr.numSuccesses >= 2) {
                goal = PunExGoal.BOMBARD;
            }
        }
        if (goal == PunExGoal.RAID_SPACEPORT) {
            for (Industry temp : target.getIndustries()) {
                if (temp.getSpec().hasTag("unraidable") || !temp.getSpec().hasTag("spaceport")) continue;
                industry = temp;
                break;
            }
            if (industry == null) {
                return;
            }
        } else if (goal == PunExGoal.RAID_PRODUCTION && reason.commodityId != null) {
            int max = 0;
            for (Industry temp : target.getIndustries()) {
                int prod;
                if (temp.getSpec().hasTag("unraidable") || (prod = temp.getSupply(reason.commodityId).getQuantity().getModifiedInt()) <= max) continue;
                max = prod;
                industry = temp;
            }
            if (industry == null) {
                return;
            }
        }
        float fp = 50.0f + curr.threshold * 0.5f;
        fp = Math.max(50.0f, fp - 50.0f);
        if (fpOverride != null) {
            fp = fpOverride.intValue();
        }
        float totalAttempts = 0.0f;
        for (PunExData d : this.data.values()) {
            totalAttempts += (float)d.numAttempts;
        }
        float extraMult = 0.0f;
        extraMult = totalAttempts <= 2.0f ? 0.0f : (totalAttempts <= 4.0f ? 1.0f : (totalAttempts <= 7.0f ? 2.0f : (totalAttempts <= 10.0f ? 3.0f : 4.0f)));
        float orgDur = 20.0f + extraMult * 10.0f + (10.0f + extraMult * 5.0f) * (float)Math.random();
        curr.intel = new PunitiveExpeditionIntel(from.getFaction(), from, target, fp, orgDur, goal, industry, reason);
        if (curr.intel.isDone()) {
            curr.intel = null;
            this.timeout = orgDur + MIN_TIMEOUT + curr.random.nextFloat() * (MAX_TIMEOUT - MIN_TIMEOUT);
            return;
        }
        if (curr.random.nextFloat() < (float)this.numSentSinceTimeout * PROB_TIMEOUT_PER_SENT) {
            this.timeout = orgDur + MIN_TIMEOUT + curr.random.nextFloat() * (MAX_TIMEOUT - MIN_TIMEOUT);
        }
        ++this.numSentSinceTimeout;
        ++curr.numAttempts;
        curr.anger = 0.0f;
        curr.threshold *= 2.0f;
        if (curr.threshold > MAX_THRESHOLD) {
            curr.threshold = MAX_THRESHOLD;
        }
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }

    public static class PunExData {
        public FactionAPI faction;
        public IntervalUtil tracker = new IntervalUtil(20.0f, 40.0f);
        public float anger = 0.0f;
        public float threshold = 100.0f;
        public float timeout = 0.0f;
        public BaseIntelPlugin intel;
        public Random random = new Random();
        public int numSuccesses = 0;
        public int numAttempts = 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PunExGoal {
        RAID_PRODUCTION,
        RAID_SPACEPORT,
        BOMBARD;

    }

    public static class PunExReason {
        public PunExType type;
        public String commodityId;
        public String marketId;
        public float weight;

        public PunExReason(PunExType type) {
            this.type = type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PunExType {
        ANTI_COMPETITION,
        ANTI_FREE_PORT,
        TERRITORIAL;

    }
}

