/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.raid;

import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.intel.raid.BaseRaidStage;
import com.fs.starfarer.api.impl.campaign.intel.raid.RaidIntel;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class OrganizeStage
extends BaseRaidStage {
    protected MarketAPI market;
    protected IntervalUtil interval = new IntervalUtil(0.1f, 0.2f);
    protected boolean wasMilitary = false;

    public OrganizeStage(RaidIntel raid, MarketAPI market, float durDays) {
        super(raid);
        this.market = market;
        this.maxDays = durDays;
        this.wasMilitary = market.getMemoryWithoutUpdate().getBoolean("$military");
    }

    public void advance(float amount) {
        if (this.status == RaidIntel.RaidStageStatus.ONGOING && (!this.market.isInEconomy() || !this.market.getMemoryWithoutUpdate().getBoolean("$military") && this.wasMilitary)) {
            this.abort();
            return;
        }
        super.advance(amount);
    }

    protected void updateStatus() {
        if (this.maxDays <= this.elapsed) {
            this.status = RaidIntel.RaidStageStatus.SUCCESS;
        }
    }

    public void abort() {
        this.status = RaidIntel.RaidStageStatus.FAILURE;
    }

    public MarketAPI getMarket() {
        return this.market;
    }

    public void showStageInfo(TooltipMakerAPI info) {
        int curr = this.intel.getCurrentStage();
        int index = this.intel.getStageIndex(this);
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        int days = Math.round(this.maxDays - this.elapsed);
        String strDays = RaidIntel.getDaysString(days);
        String timing = String.valueOf(this.getForcesString()) + " \u9884\u8ba1\u9700\u8981\u7684\u7ec4\u5efa\u65f6\u95f4\u4e3a %s " + strDays + ".";
        if (days < 2) {
            timing = String.valueOf(this.getForcesString()) + " \u5e94\u8be5\u5f88\u5feb\u5c31\u4f1a\u5f00\u59cb\u7ec4\u5efa\u3002";
        }
        String raid = this.getRaidString();
        if (this.status == RaidIntel.RaidStageStatus.FAILURE) {
            info.addPara("\u8be5 " + raid + " \u884c\u52a8\u56e0\u5728\u7b79\u5212\u9636\u6bb5\u5c31\u88ab\u8feb\u4e2d\u65ad\uff0c\u6240\u4ee5\u63a5\u4e0b\u6765\u7684\u4efb\u52a1\u4e5f\u5c31\u4e0d\u4e86\u4e86\u4e4b\u3002", opad);
        } else if (curr == index) {
            boolean known;
            boolean bl = known = !this.market.isHidden() || !this.market.getPrimaryEntity().isDiscoverable();
            if (known) {
                info.addPara("\u8be5 " + raid + " \u76ee\u524d\u6b63\u5728\u4ee5\u4e0b\u5730\u70b9\u96c6\u7ed3" + this.market.getOnOrAt() + " " + this.market.getName() + ". " + timing, opad, h, "" + days);
            } else {
                info.addPara("\u8be5 " + raid + " \u76ee\u524d\u6b63\u5904\u4e8e\u7b79\u5212\u9636\u6bb5\u3002" + timing, opad, h, "" + days);
            }
        }
    }

    protected String getForcesString() {
        return "\u7a81\u88ad\u8230\u961f";
    }

    protected String getRaidString() {
        return "raid";
    }
}

