/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.raid;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.command.WarSimScript;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParamsV3;
import com.fs.starfarer.api.impl.campaign.fleets.RouteLocationCalculator;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.intel.raid.ActionStage;
import com.fs.starfarer.api.impl.campaign.intel.raid.AssembleStage;
import com.fs.starfarer.api.impl.campaign.intel.raid.OrganizeStage;
import com.fs.starfarer.api.impl.campaign.intel.raid.RaidAssignmentAI;
import com.fs.starfarer.api.impl.campaign.intel.raid.TravelStage;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseAssignmentAI;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RouteFleetAssignmentAI;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RaidIntel
extends BaseIntelPlugin
implements RouteManager.RouteFleetSpawner {
    public static Object UPDATE_FAILED = new Object();
    public static Object UPDATE_RETURNING = new Object();
    public static Object ENTERED_SYSTEM_UPDATE = new Object();
    protected int currentStage = 0;
    protected int failStage = -1;
    protected List<RaidStage> stages = new ArrayList<RaidStage>();
    protected String id = Misc.genUID();
    protected String sid = "raid_" + this.id;
    protected float extraDays = 60.0f;
    protected StarSystemAPI system;
    protected FactionAPI faction;
    protected float defenderStr = 0.0f;
    protected RaidDelegate delegate;

    public RaidIntel(StarSystemAPI system, FactionAPI faction, RaidDelegate delegate) {
        this.system = system;
        this.faction = faction;
        this.delegate = delegate;
        Global.getSector().addScript(this);
        this.defenderStr = WarSimScript.getEnemyStrength(this.getFaction(), system);
    }

    public void sendEnteredSystemUpdate() {
    }

    public StarSystemAPI getSystem() {
        return this.system;
    }

    public int getCurrentStage() {
        return this.currentStage;
    }

    public int getStageIndex(RaidStage stage) {
        return this.stages.indexOf(stage);
    }

    public int getFailStage() {
        return this.failStage;
    }

    public OrganizeStage getOrganizeStage() {
        for (RaidStage stage : this.stages) {
            if (!(stage instanceof OrganizeStage)) continue;
            return (OrganizeStage)stage;
        }
        return null;
    }

    public AssembleStage getAssembleStage() {
        for (RaidStage stage : this.stages) {
            if (!(stage instanceof AssembleStage)) continue;
            return (AssembleStage)stage;
        }
        return null;
    }

    public ActionStage getActionStage() {
        for (RaidStage stage : this.stages) {
            if (!(stage instanceof ActionStage)) continue;
            return (ActionStage)stage;
        }
        return null;
    }

    public void addStage(RaidStage stage) {
        this.stages.add(stage);
    }

    public String getRouteSourceId() {
        return this.sid;
    }

    public float getExtraDays() {
        return this.extraDays;
    }

    public void setExtraDays(float extraDays) {
        this.extraDays = extraDays;
    }

    @Override
    public boolean canMakeVisibleToPlayer(boolean playerInRelayRange) {
        return super.canMakeVisibleToPlayer(playerInRelayRange);
    }

    public boolean shouldSendUpdate() {
        if (DebugFlags.SEND_UPDATES_WHEN_NO_COMM || Global.getSector().getIntelManager().isPlayerInRangeOfCommRelay()) {
            return true;
        }
        if (this.system != null && this.system == Global.getSector().getCurrentLocation()) {
            return true;
        }
        return this.isPlayerTargeted();
    }

    public boolean isPlayerTargeted() {
        ActionStage action = this.getActionStage();
        return action != null && action.isPlayerTargeted();
    }

    @Override
    public String getCommMessageSound() {
        if (this.isPlayerTargeted() && !this.isSendingUpdate()) {
            return RaidIntel.getSoundColonyThreat();
        }
        if (this.isSendingUpdate()) {
            return RaidIntel.getSoundStandardUpdate();
        }
        return RaidIntel.getSoundMajorPosting();
    }

    @Override
    protected void advanceImpl(float amount) {
        super.advanceImpl(amount);
        if (this.currentStage >= this.stages.size()) {
            this.endAfterDelay();
            if (this.shouldSendUpdate()) {
                this.sendUpdateIfPlayerHasIntel(UPDATE_RETURNING, false);
            }
            return;
        }
        RaidStage stage = this.stages.get(this.currentStage);
        stage.advance(amount);
        RaidStageStatus status = stage.getStatus();
        if (status == RaidStageStatus.SUCCESS) {
            ++this.currentStage;
            this.setExtraDays(Math.max(0.0f, this.getExtraDays() - stage.getExtraDaysUsed()));
            if (this.currentStage < this.stages.size()) {
                this.stages.get(this.currentStage).notifyStarted();
            }
            return;
        }
        if (status == RaidStageStatus.FAILURE) {
            this.failedAtStage(stage);
            this.failStage = this.currentStage;
            this.endAfterDelay();
            if (this.shouldSendUpdate()) {
                this.sendUpdateIfPlayerHasIntel(UPDATE_FAILED, false);
            }
        }
    }

    public void forceFail(boolean withUpdate) {
        int index = this.currentStage;
        if (index >= this.stages.size()) {
            index = this.stages.size() - 1;
        }
        this.failedAtStage(this.stages.get(index));
        this.failStage = this.currentStage;
        this.endAfterDelay();
        if (withUpdate && this.shouldSendUpdate()) {
            this.sendUpdateIfPlayerHasIntel(UPDATE_FAILED, false);
        }
    }

    protected void failedAtStage(RaidStage stage) {
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
        Global.getSector().removeScript(this);
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        if (this.delegate != null) {
            RaidStageStatus status = RaidStageStatus.SUCCESS;
            if (this.failStage >= 0) {
                status = RaidStageStatus.FAILURE;
            }
            this.delegate.notifyRaidEnded(this, status);
        }
    }

    public float getETA() {
        int curr = this.getCurrentStage();
        float eta = 0.0f;
        for (RaidStage stage : this.stages) {
            if (stage instanceof ActionStage) break;
            int index = this.getStageIndex(stage);
            if (index < curr) continue;
            if (stage instanceof OrganizeStage) {
                eta += Math.max(0.0f, stage.getMaxDays() - stage.getElapsed());
                continue;
            }
            if (stage instanceof AssembleStage) {
                eta += Math.max(0.0f, 20.0f - stage.getElapsed());
                continue;
            }
            if (!(stage instanceof TravelStage)) continue;
            float travelDays = RouteLocationCalculator.getTravelDays(this.getAssembleStage().gatheringPoint, this.system.getHyperspaceAnchor());
            eta += Math.max(0.0f, travelDays - stage.getElapsed());
        }
        return eta;
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean isUpdate = this.getListInfoParam() != null;
        float eta = this.getETA();
        info.addPara("\u53d1\u8d77\u65b9\uff1a{" + this.faction.getDisplayName(), initPad, tc, this.faction.getBaseUIColor(), this.faction.getDisplayName());
        initPad = 0.0f;
        int max = 0;
        MarketAPI target = null;
        for (MarketAPI marketAPI : Misc.getMarketsInLocation(this.system)) {
            int size;
            if (!marketAPI.getFaction().isHostileTo(this.faction) || (size = marketAPI.getSize()) <= max && (size != max || !marketAPI.getFaction().isPlayerFaction())) continue;
            max = size;
            target = marketAPI;
        }
        if (target != null) {
            FactionAPI factionAPI = target.getFaction();
            info.addPara("\u76ee\u6807\uff1a" + factionAPI.getDisplayName(), initPad, tc, factionAPI.getBaseUIColor(), factionAPI.getDisplayName());
        }
        if (isUpdate) {
            if (this.getListInfoParam() == ENTERED_SYSTEM_UPDATE) {
                info.addPara("\u5df2\u62b5\u8fbe\u76ee\u6807\u661f\u7cfb", tc, initPad);
            } else if (this.failStage < 0) {
                info.addPara("\u8be5 " + this.system.getNameWithLowercaseType() + " \u5185\u7684\u6b96\u6c11\u5730\u906d\u9047\u7a81\u88ad", tc, initPad);
            } else {
                info.addPara("\u9488\u5bf9 " + this.system.getNameWithLowercaseType() + " \u5185\u7684\u7a81\u88ad\u884c\u52a8\u5931\u8d25\u4e86", tc, initPad);
            }
        } else {
            info.addPara(this.system.getNameWithLowercaseType(), tc, initPad);
        }
        initPad = 0.0f;
        if (eta > 1.0f && this.failStage < 0 && this.getListInfoParam() != ENTERED_SYSTEM_UPDATE) {
            String string = RaidIntel.getDaysString(eta);
            info.addPara("\u9884\u8ba1 %s " + string + " \u540e\u5230\u8fbe", initPad, tc, h, "" + Math.round(eta));
            initPad = 0.0f;
        }
        this.unindent(info);
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color c = this.getTitleColor(mode);
        this.isPlayerTargeted();
        info.setParaFontDefault();
        info.addPara(this.getName(), c, 0.0f);
        info.setParaFontDefault();
        this.addBulletPoints(info, mode);
    }

    protected MarketAPI getFirstSource() {
        AssembleStage as = this.getAssembleStage();
        if (as == null) {
            return null;
        }
        if (as.getSources() == null || as.getSources().isEmpty()) {
            return null;
        }
        return as.getSources().get(0);
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        info.addImage(this.getFactionForUIColors().getLogo(), width, 128.0f, opad);
        FactionAPI faction = this.getFaction();
        String has = faction.getDisplayNameHasOrHave();
        String is = faction.getDisplayNameIsOrAre();
        AssembleStage as = this.getAssembleStage();
        MarketAPI source = this.getFirstSource();
        float raidStr = as.getOrigSpawnFP();
        raidStr = Misc.getAdjustedStrength(raidStr, source);
        String strDesc = this.getRaidStrDesc();
        int numFleets = (int)this.getOrigNumFleets();
        String \u652f\u8230\u961f\u7ec4\u6210 = "\u652f\u8230\u961f\u7ec4\u6210";
        if (numFleets == 1) {
            \u652f\u8230\u961f\u7ec4\u6210 = " large fleet, or several smaller ones";
        }
        LabelAPI label = info.addPara(String.valueOf(Misc.ucFirst(faction.getDisplayNameWithArticle())) + " " + is + "\u8230\u961f\u6b63\u8ba1\u5212\u5bf9 " + this.system.getName() + " \u53d1\u52a8\u4e00\u6b21\u7a81\u88ad\uff0c" + "\u9884\u8ba1\u8fd9\u4e9b\u8230\u961f\u5e94\u8be5 " + strDesc + " \u4e14\u7531 " + numFleets + " " + \u652f\u8230\u961f\u7ec4\u6210 + ".", opad, faction.getBaseUIColor(), faction.getDisplayNameWithArticleWithoutArticle());
        label.setHighlight(faction.getDisplayNameWithArticleWithoutArticle(), strDesc, "" + numFleets);
        label.setHighlightColors(faction.getBaseUIColor(), h, h);
        ArrayList<MarketAPI> targets = new ArrayList<MarketAPI>();
        for (MarketAPI market : Misc.getMarketsInLocation(this.system)) {
            if (!market.getFaction().isHostileTo(faction)) continue;
            targets.add(market);
        }
        this.defenderStr = WarSimScript.getEnemyStrength(this.getFaction(), this.system);
        ArrayList<MarketAPI> safe = new ArrayList<MarketAPI>();
        ArrayList<MarketAPI> unsafe = new ArrayList<MarketAPI>();
        for (MarketAPI market : targets) {
            float defensiveStr = this.defenderStr + WarSimScript.getStationStrength(market.getFaction(), this.system, market.getPrimaryEntity());
            if (defensiveStr > raidStr * 1.25f) {
                safe.add(market);
                continue;
            }
            unsafe.add(market);
        }
        if (!this.isEnding()) {
            if (targets.isEmpty()) {
                info.addPara("\u8be5\u661f\u7cfb\u5185\u6ca1\u6709\u53ef\u4f9b\u7a81\u88ad\u7684\u6b96\u6c11\u5730\u3002", opad);
            } else {
                boolean showSafe = false;
                if (raidStr < this.defenderStr * 0.75f) {
                    info.addPara("\u9884\u8ba1\u7a81\u88ad\u8230\u961f\u5e94\u8be5\u4f1a\u88ab \u4fdd\u536b\u8be5\u661f\u7cfb\u7684\u8230\u961f\u6240\u51fb\u8d25\u3002\u5728\u7f3a\u4e4f\u5176\u4ed6\u56e0\u7d20\u7684\u524d\u63d0\u4e0b\uff0c\u672c\u6b21\u7a81\u88ad\u884c\u52a8\u5e94\u8be5\u4e0d\u4f1a\u6210\u529f\u3002", opad);
                } else if (raidStr < this.defenderStr * 1.25f) {
                    info.addPara("\u9884\u8ba1\u7a81\u88ad\u8230\u961f\u4e0e\u4fdd\u536b\u8be5\u661f\u7cfb\u7684\u8230\u961f\u5e94\u8be5\u52bf\u5747\u529b\u654c", opad);
                    showSafe = true;
                } else {
                    info.addPara("\u9884\u8ba1\u7a81\u88ad\u8230\u961f\u5c06\u6bd4\u4fdd\u536b\u8be5\u661f\u7cfb\u7684\u8230\u961f\u66f4\u5f3a\u3002", opad);
                    showSafe = true;
                }
                if (showSafe) {
                    if (safe.size() == targets.size()) {
                        info.addPara("\u7136\u800c\uff0c\u5f97\u76ca\u4e8e\u8f68\u9053\u9632\u5fa1\u8bbe\u65bd\u7684\u5b58\u5728\uff0c\u8be5\u661f\u7cfb\u5185\u6240\u6709\u6b96\u6c11\u5730\u90fd\u5e94\u8be5\u662f\u5b89\u5168\u7684\u3002", opad);
                    } else {
                        info.addPara("\u8003\u8651\u5230\u6709\u8f68\u9053\u9632\u5fa1\u8bbe\u65bd\u7684\u5b58\u5728 (\u82e5\u6ca1\u6709\u7684\u8bdd)\uff0c\u5219\u4ee5\u4e0b\u6b96\u6c11\u5730\u5c06\u9762\u4e34\u7a81\u88ad\u7684\u5a01\u80c1\uff1a", opad);
                        float initPad = opad;
                        for (MarketAPI market : unsafe) {
                            RaidIntel.addMarketToList(info, market, initPad, tc);
                            initPad = 0.0f;
                        }
                    }
                }
            }
        }
        info.addSectionHeading("\u5f62\u52bf", faction.getBaseUIColor(), faction.getDarkUIColor(), Alignment.MID, opad);
        for (RaidStage stage : this.stages) {
            stage.showStageInfo(info);
            if (this.getStageIndex(stage) == this.failStage) break;
        }
    }

    @Override
    public String getIcon() {
        return this.faction.getCrest();
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Military");
        if (!Misc.getMarketsInLocation(this.system, "player").isEmpty()) {
            tags.add("Colony threats");
        }
        tags.add(this.getFaction().getId());
        return tags;
    }

    @Override
    public String getSortString() {
        return "\u7a81\u88ad";
    }

    @Override
    public String getName() {
        String base = String.valueOf(Misc.ucFirst(this.getFaction().getPersonNamePrefix())) + " \u7a81\u88ad";
        if (this.isEnding()) {
            if (this.isSendingUpdate() && this.failStage >= 0) {
                return String.valueOf(base) + " - \u5931\u8d25";
            }
            for (RaidStage stage : this.stages) {
                if (!(stage instanceof ActionStage) || stage.getStatus() != RaidStageStatus.SUCCESS) continue;
                return String.valueOf(base) + " - \u6210\u529f";
            }
            return String.valueOf(base) + " - \u7ed3\u675f";
        }
        return base;
    }

    public boolean isFailed() {
        return this.failStage >= 0;
    }

    public boolean isSucceeded() {
        for (RaidStage stage : this.stages) {
            if (!(stage instanceof ActionStage) || stage.getStatus() != RaidStageStatus.SUCCESS) continue;
            return true;
        }
        return false;
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return this.getFaction();
    }

    public FactionAPI getFaction() {
        return this.faction;
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return this.system.getHyperspaceAnchor();
    }

    @Override
    public List<IntelInfoPlugin.ArrowData> getArrowData(SectorMapAPI map) {
        SectorEntityToken iconEntity;
        AssembleStage as = this.getAssembleStage();
        if (as == null || !as.isSourceKnown()) {
            return null;
        }
        SectorEntityToken from = as.gatheringPoint;
        if (this.system == null || this.system == from.getContainingLocation()) {
            return null;
        }
        ArrayList<IntelInfoPlugin.ArrowData> result = new ArrayList<IntelInfoPlugin.ArrowData>();
        SectorEntityToken entityFrom = from;
        if (map != null && this.delegate instanceof IntelInfoPlugin && this.delegate != this && (iconEntity = map.getIntelIconEntity((IntelInfoPlugin)((Object)this.delegate))) != null) {
            entityFrom = iconEntity;
        }
        IntelInfoPlugin.ArrowData arrow = new IntelInfoPlugin.ArrowData(entityFrom, this.system.getCenter());
        arrow.color = this.getFactionForUIColors().getBaseUIColor();
        arrow.width = 20.0f;
        result.add(arrow);
        return result;
    }

    @Override
    public boolean shouldCancelRouteAfterDelayCheck(RouteManager.RouteData route) {
        return false;
    }

    @Override
    public boolean shouldRepeat(RouteManager.RouteData route) {
        return false;
    }

    @Override
    public void reportAboutToBeDespawnedByRouteManager(RouteManager.RouteData route) {
    }

    @Override
    public CampaignFleetAPI spawnFleet(RouteManager.RouteData route) {
        Random random = route.getRandom();
        MarketAPI market = route.getMarket();
        CampaignFleetAPI fleet = this.createFleet(market.getFactionId(), route, market, null, random);
        if (fleet == null || fleet.isEmpty()) {
            return null;
        }
        market.getContainingLocation().addEntity(fleet);
        fleet.setFacing((float)Math.random() * 360.0f);
        fleet.setLocation(market.getPrimaryEntity().getLocation().x, market.getPrimaryEntity().getLocation().x);
        fleet.addScript(this.createAssignmentAI(fleet, route));
        return fleet;
    }

    public RouteFleetAssignmentAI createAssignmentAI(CampaignFleetAPI fleet, RouteManager.RouteData route) {
        ActionStage action = this.getActionStage();
        BaseAssignmentAI.FleetActionDelegate delegate = null;
        if (action instanceof BaseAssignmentAI.FleetActionDelegate) {
            delegate = (BaseAssignmentAI.FleetActionDelegate)((Object)action);
        }
        return new RaidAssignmentAI(fleet, route, delegate);
    }

    public CampaignFleetAPI createFleet(String factionId, RouteManager.RouteData route, MarketAPI market, Vector2f locInHyper, Random random) {
        if (random == null) {
            random = new Random();
        }
        RouteManager.OptionalFleetData extra = route.getExtra();
        float combat = extra.fp.floatValue();
        float tanker = extra.fp.floatValue() * (0.1f + random.nextFloat() * 0.05f);
        float transport = extra.fp.floatValue() * (0.1f + random.nextFloat() * 0.05f);
        float freighter = 0.0f;
        combat -= tanker;
        FleetParamsV3 params = new FleetParamsV3(market, locInHyper, factionId, route == null ? null : route.getQualityOverride(), extra.fleetType, combat -= transport, freighter, tanker, transport, 0.0f, 0.0f, 0.0f);
        if (route != null) {
            params.timestamp = route.getTimestamp();
        }
        params.random = random;
        CampaignFleetAPI fleet = FleetFactoryV3.createFleet(params);
        if (fleet == null || fleet.isEmpty()) {
            return null;
        }
        fleet.getMemoryWithoutUpdate().set("$isWarFleet", true);
        fleet.getMemoryWithoutUpdate().set("$isRaider", true);
        if (fleet.getFaction().getCustomBoolean("pirateBehavior")) {
            fleet.getMemoryWithoutUpdate().set("$isPirate", true);
        }
        String postId = Ranks.POST_PATROL_COMMANDER;
        String rankId = Ranks.SPACE_COMMANDER;
        fleet.getCommander().setPostId(postId);
        fleet.getCommander().setRankId(rankId);
        return fleet;
    }

    public float getRaidFPAdjusted() {
        MarketAPI source = this.getFirstSource();
        float raidFP = this.getRaidFP();
        float raidStr = Misc.getAdjustedFP(raidFP, source);
        return raidStr;
    }

    public float getRaidFP() {
        AssembleStage as = this.getAssembleStage();
        float raidStr = 0.0f;
        for (RouteManager.RouteData route : as.getRoutes()) {
            CampaignFleetAPI fleet = route.getActiveFleet();
            if (fleet != null) {
                float mult = Misc.getAdjustedFP(1.0f, route.getMarket());
                if (mult < 1.0f) {
                    mult = 1.0f;
                }
                raidStr += (float)fleet.getFleetPoints() / mult;
                continue;
            }
            raidStr += route.getExtra().fp.floatValue();
        }
        if (raidStr <= 0.0f || as.getSpawnFP() > 0.0f) {
            raidStr = Math.max(as.getOrigSpawnFP(), raidStr);
        }
        float raidFP = raidStr;
        return raidFP;
    }

    public float getNumFleets() {
        AssembleStage as = this.getAssembleStage();
        float num = as.getRoutes().size();
        if (as.getSpawnFP() > 0.0f) {
            num = Math.max(num, as.getOrigSpawnFP() / as.getLargeSize(false));
        }
        if (num < 1.0f) {
            num = 1.0f;
        }
        return num;
    }

    public float getOrigNumFleets() {
        AssembleStage as = this.getAssembleStage();
        float num = (float)Math.ceil(as.getOrigSpawnFP() / as.getLargeSize(false));
        if (num < 1.0f) {
            num = 1.0f;
        }
        return num;
    }

    public float getRaidStr() {
        MarketAPI source = this.getFirstSource();
        float raidFP = this.getRaidFP();
        float raidStr = Misc.getAdjustedStrength(raidFP, source);
        return raidStr;
    }

    protected String getRaidStrDesc() {
        return Misc.getStrengthDesc(this.getRaidStr());
    }

    public void addStandardStrengthComparisons(TooltipMakerAPI info, MarketAPI target, FactionAPI targetFaction, boolean withGround, boolean withBombard, String raid, String raids) {
        Color h = Misc.getHighlightColor();
        float opad = 10.0f;
        float raidFP = this.getRaidFPAdjusted() / this.getNumFleets();
        float raidStr = this.getRaidStr();
        float defenderStr = WarSimScript.getFactionStrength(targetFaction, this.system);
        float defensiveStr = defenderStr + WarSimScript.getStationStrength(targetFaction, this.system, target.getPrimaryEntity());
        float assumedRaidGroundStr = raidFP * Misc.FP_TO_GROUND_RAID_STR_APPROX_MULT;
        float re = MarketCMD.getRaidEffectiveness(target, assumedRaidGroundStr);
        String spaceStr = "";
        String groundStr = "";
        String outcomeDesc = null;
        boolean even = false;
        if (raidStr < defensiveStr * 0.75f) {
            spaceStr = "\u5f31\u4e8e\u5bf9\u65b9";
            if (outcomeDesc == null) {
                outcomeDesc = "\u8be5 " + raid + "\u8230\u961f \u53ef\u80fd\u88ab \u8f68\u9053\u9632\u5fa1 \u8bbe\u65bd\u6240\u51fb\u8d25";
            }
        } else if (raidStr < defensiveStr * 1.25f) {
            spaceStr = "\u52bf\u5747\u529b\u654c";
            if (outcomeDesc == null) {
                outcomeDesc = "\u8be5 " + raids + " \u7ed3\u679c\u5c1a\u4e0d\u660e\u786e";
            }
            even = true;
        } else {
            spaceStr = "\u80dc\u4e8e\u5bf9\u65b9";
            if (!withGround && !withBombard && outcomeDesc == null) {
                outcomeDesc = "\u8be5 " + raid + " \u884c\u52a8\u53ef\u80fd\u6210\u529f";
            }
        }
        if (withGround) {
            if (re < 0.33f) {
                groundStr = "\u5f31\u4e8e\u5bf9\u65b9";
                if (outcomeDesc == null || even) {
                    outcomeDesc = "\u8be5 " + raid + "\u8230\u961f \u53ef\u80fd\u88ab \u5730\u9762\u9632\u5fa1 \u8bbe\u65bd\u6240\u51fb\u9000";
                }
            } else if (re < 0.66f) {
                groundStr = "\u52bf\u5747\u529b\u654c";
                if (outcomeDesc == null) {
                    outcomeDesc = "\u8be5 " + raids + " \u7ed3\u679c\u5c1a\u4e0d\u660e\u786e";
                }
            } else {
                groundStr = "\u80dc\u4e8e\u5bf9\u65b9";
                if (outcomeDesc == null) {
                    outcomeDesc = "\u8be5 " + raid + " \u884c\u52a8\u53ef\u80fd\u6210\u529f";
                }
            }
            info.addPara("\u76f8\u8f83\u4e8e\u76ee\u6807\u9632\u5fa1\u6218\u529b\uff0c" + raids + " \u8230\u961f\u6218\u529b\u5c06 %s " + "\u800c\u5730\u9762\u6218\u529b\u5219 %s." + " " + outcomeDesc + ".", opad, h, spaceStr, groundStr);
        } else if (withBombard) {
            float available;
            float required = MarketCMD.getBombardmentCost(target, null);
            if ((double)required * 0.67 > (double)(available = raidFP * Misc.FP_TO_BOMBARD_COST_APPROX_MULT)) {
                groundStr = "\u5f31\u4e8e\u5bf9\u65b9";
                if (outcomeDesc == null) {
                    outcomeDesc = "\u8f70\u70b8\u884c\u52a8\u53ef\u80fd\u4f1a\u906d\u5230\u5730\u9762\u9632\u5fa1\u8bbe\u65bd\u7684\u53cd\u51fb";
                }
            } else if (required * 1.33f > available) {
                groundStr = "\u52bf\u5747\u529b\u654c";
                if (outcomeDesc == null) {
                    outcomeDesc = "\u8f70\u70b8\u884c\u52a8\u7684\u7ed3\u679c\u76ee\u524d\u5c1a\u4e0d\u660e\u786e";
                }
            } else {
                groundStr = "\u80dc\u4e8e\u5bf9\u65b9";
                if (outcomeDesc == null) {
                    outcomeDesc = "\u8f70\u70b8\u884c\u52a8\u5c06\u5f88\u53ef\u80fd\u6210\u529f";
                }
            }
            info.addPara("\u76f8\u8f83\u4e8e\u76ee\u6807\u9632\u5fa1\u6218\u529b\uff0c" + raids + " \u8230\u961f\u6218\u529b\u5c06 %s}\u3002" + outcomeDesc + ".", opad, h, spaceStr, groundStr);
        } else {
            info.addPara("\u76f8\u8f83\u4e8e\u76ee\u6807\u9632\u5fa1\u6218\u529b\uff0c" + target.getName() + ", " + "\u4ed6\u4eec\u7684 " + raids + " \u8230\u961f\u6218\u529b\u5c06 %s." + " " + outcomeDesc + ".", opad, h, spaceStr, groundStr);
        }
    }

    @Override
    public IntelInfoPlugin.IntelSortTier getSortTier() {
        this.isPlayerTargeted();
        return super.getSortTier();
    }

    public static interface RaidDelegate {
        public void notifyRaidEnded(RaidIntel var1, RaidStageStatus var2);
    }

    public static interface RaidStage {
        public RaidStageStatus getStatus();

        public void advance(float var1);

        public void notifyStarted();

        public float getExtraDaysUsed();

        public void showStageInfo(TooltipMakerAPI var1);

        public float getElapsed();

        public float getMaxDays();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RaidStageStatus {
        ONGOING,
        SUCCESS,
        FAILURE;

    }
}

