/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.People;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithSearch;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ANewHope
extends HubMissionWithSearch {
    protected PersonAPI robed_man;
    protected MarketAPI volturn;
    public static float MISSION_DAYS = 120.0f;
    protected int payment;
    protected int paymentHigh;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        if (!this.setGlobalReference("$anh_ref", "$anh_inProgress")) {
            return false;
        }
        this.setPersonOverride(null);
        this.robed_man = this.getImportantPerson(People.ROBEDMAN);
        if (this.robed_man == null) {
            return false;
        }
        this.volturn = Global.getSector().getEconomy().getMarket("volturn");
        if (this.volturn == null) {
            return false;
        }
        if (!this.volturn.getFactionId().equals("sindrian_diktat")) {
            return false;
        }
        this.setStartingStage((Object)Stage.GO_TO_VOLTURN);
        this.addSuccessStages(new Object[]{Stage.COMPLETED});
        this.setStoryMission();
        this.payment = 10000;
        this.paymentHigh = 17000;
        this.makeImportant(this.volturn, "$anh_tookTheJob", Stage.GO_TO_VOLTURN);
        this.setStageOnGlobalFlag((Object)Stage.COMPLETED, "$anh_completed");
        this.setRepFactionChangesNone();
        this.setRepPersonChangesNone();
        this.beginEnteredLocationTrigger(this.volturn.getStarSystem(), new Object[]{false, Stage.GO_TO_VOLTURN});
        this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.SMALL, HubMissionWithTriggers.FleetQuality.DEFAULT, "sindrian_diktat", "patrolSmall", this.volturn.getStarSystem());
        this.triggerAutoAdjustFleetStrengthMajor();
        this.triggerMakeHostileAndAggressive();
        this.triggerFleetAllowLongPursuit();
        this.triggerSetFleetAlwaysPursue();
        this.triggerPickLocationTowardsPlayer(this.volturn.getPlanetEntity(), 90.0f, ANewHope.getUnits(0.25f));
        this.triggerSpawnFleetAtPickedLocation("$anh_diktatPatrol", null);
        this.triggerSetFleetMissionRef("$ahn_ref");
        this.triggerOrderFleetInterceptPlayer();
        this.triggerFleetMakeImportant(null, Stage.GO_TO_VOLTURN);
        this.endTrigger();
        this.beginStageTrigger(new Object[]{Stage.COMPLETED});
        this.triggerSetGlobalMemoryValue("$anh_missionCompleted", true);
        this.endTrigger();
        return true;
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$anh_stage", this.getCurrentStage());
        this.set("$anh_payment", Misc.getWithDGS(this.payment));
        this.set("$anh_paymentHigh", Misc.getWithDGS(this.paymentHigh));
    }

    @Override
    protected boolean callAction(String action, String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        return super.callAction(action, ruleId, dialog, params, memoryMap);
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        info.addImage(this.robed_man.getPortraitSprite(), width, 128.0f, opad);
        if (this.currentStage == Stage.GO_TO_VOLTURN) {
            info.addPara("\u628a\u795e\u79d8\u8001\u4eba\uff0c\u5c0f\u4f19\u5b50\uff0c\u4ee5\u53ca\u4ed6\u4eec\u7684\u673a\u5668\u4eba\u9001\u5230\u4f4d\u4e8e Askonia \u661f\u7cfb\u7684 Volturn \u884c\u661f\u4e0a\u3002\u907f\u5f00\u5de1\u903b\u961f\uff0c\u4f60\u7684\u4e58\u5ba2\u53ef\u80fd\u5df2\u88ab\u901a\u7f09\u3002", opad);
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GO_TO_VOLTURN) {
            info.addPara("\u524d\u5f80\u4f4d\u4e8e Askonia \u661f\u7cfb\u5185\u7684 Volturn", tc, pad);
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return "Volturn \u4e4b\u65c5";
    }

    @Override
    public String getPostfixForState() {
        if (this.startingStage != null) {
            return "";
        }
        return super.getPostfixForState();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        GO_TO_VOLTURN,
        COMPLETED;

    }
}

